/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.common.util.StringUtils;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.GamaDateInterval;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.compilation.IOperatorValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.units.TimeUnitConstantExpression;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaDateType;
import gama.gaml.types.Types;
import java.time.Duration;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;

public class Dates {
    public static final String ISO_LOCAL_KEY = "ISO_LOCAL_DATE_TIME";
    public static final String ISO_OFFSET_KEY = "ISO_OFFSET_DATE_TIME";
    public static final String ISO_ZONED_KEY = "ISO_ZONED_DATE_TIME";
    public static final String ISO_SIMPLE_KEY = "ISO_SIMPLE";
    public static final String CUSTOM_KEY = "CUSTOM";
    public static String DEFAULT_VALUE = "CUSTOM";
    public static final String DEFAULT_KEY = "DEFAULT";
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_SIMPLE_FORMAT = "yy-MM-dd HH:mm:ss";
    static final DurationFormatter DURATION_FORMATTER = new DurationFormatter();
    public static final HashMap<String, DateTimeFormatter> FORMATTERS = new HashMap<String, DateTimeFormatter>(){
        {
            this.put(Dates.DEFAULT_KEY, DateTimeFormatter.ofPattern(Dates.DEFAULT_FORMAT));
            this.put(Dates.ISO_SIMPLE_KEY, DateTimeFormatter.ofPattern(Dates.ISO_SIMPLE_FORMAT));
            this.put(Dates.ISO_LOCAL_KEY, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            this.put(Dates.ISO_OFFSET_KEY, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            this.put(Dates.ISO_ZONED_KEY, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
    };
    public static final Pref<String> DATES_CUSTOM_FORMATTER = GamaPreferences.create("pref_date_custom_formatter", "Custom date pattern (https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#patterns)", "yyyy-MM-dd HH:mm:ss", 4, true).in("Data and Operators", "Management of dates").onChange(string -> {
        try {
            FORMATTERS.put(CUSTOM_KEY, Dates.getFormatter(StringUtils.toJavaString(string), null));
            if (CUSTOM_KEY.equals(DEFAULT_VALUE)) {
                FORMATTERS.put(DEFAULT_KEY, FORMATTERS.get(CUSTOM_KEY));
            }
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)("Formatter not valid: " + string));
        }
    });
    public static final Pref<String> DATES_DEFAULT_FORMATTER = GamaPreferences.create("pref_date_default_formatter", "Default date pattern for writing dates (i.e. string(date1))", "CUSTOM", 4, true).in("Data and Operators", "Management of dates").among((String[])new String[]{"ISO_LOCAL_DATE_TIME", "ISO_OFFSET_DATE_TIME", "ISO_ZONED_DATE_TIME", "ISO_SIMPLE", "CUSTOM"}).onChange(string -> {
        DEFAULT_VALUE = string;
        FORMATTERS.put(DEFAULT_KEY, FORMATTERS.get(string));
    });
    public static final Pref<GamaDate> DATES_STARTING_DATE = GamaPreferences.create("pref_date_starting_date", "Default starting date of models", GamaDateType.EPOCH, 23, true).in("Data and Operators", "Management of dates");
    public static final Pref<Double> DATES_TIME_STEP = GamaPreferences.create("pref_date_time_step", "Default time step of models", 1.0, 2, true).in("Data and Operators", "Management of dates").between(Double.valueOf(1.0), null);
    public static final String APPROXIMATE_TEMPORAL_QUERY = "internal_function_temporal_query";
    static Pattern model_pattern;

    static {
        FORMATTERS.put(CUSTOM_KEY, DateTimeFormatter.ofPattern(DATES_CUSTOM_FORMATTER.getValue()));
        FORMATTERS.put(DEFAULT_KEY, FORMATTERS.get(CUSTOM_KEY));
        model_pattern = Pattern.compile("%[YMNDEhmsz]");
    }

    public static void initialize() {
    }

    @GamlAnnotations.operator(value={"internal_function_temporal_query"}, doc={@GamlAnnotations.doc(value="For internal use only")}, internal=true)
    public static double approximalQuery(IScope iScope, IExpression iExpression, IExpression iExpression2) {
        Double d = Cast.asFloat(iScope, iExpression.value(iScope));
        if (iExpression2 instanceof TimeUnitConstantExpression) {
            TimeUnitConstantExpression timeUnitConstantExpression = (TimeUnitConstantExpression)iExpression2;
            GamaDate gamaDate = iScope.getClock().getCurrentDate();
            GamaDate gamaDate2 = gamaDate.plus(1L, (TemporalUnit)(timeUnitConstantExpression.getName().startsWith("m") ? ChronoUnit.MONTHS : ChronoUnit.YEARS));
            return d * (double)gamaDate.until(gamaDate2, ChronoUnit.MILLIS) / 1000.0;
        }
        return 0.0;
    }

    @GamlAnnotations.operator(value={"-"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(see={"milliseconds_between"}, usages={@GamlAnnotations.usage(value="if both operands are dates, returns the duration in seconds between date2 and date1. To obtain a more precise duration, in milliseconds, use milliseconds_between(date1, date2)", examples={@GamlAnnotations.example(value="date('2000-01-02') - date('2000-01-01')", equals="86400")})})
    @GamlAnnotations.test(value="date('2000-01-02') - date('2000-01-01') = 86400")
    public static double minusDate(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        Duration duration = Duration.between(gamaDate2, gamaDate);
        return duration.getSeconds();
    }

    @GamlAnnotations.operator(value={"every", "every_cycle"}, category={"System"}, concept={"system", "cycle"})
    @GamlAnnotations.doc(value="true every operand * cycle, false otherwise", comment="the value of the every operator depends on the cycle. It can be used to do something every x cycle.", examples={@GamlAnnotations.example(value="if every(2#cycle) {write \"the cycle number is even\";}", test=false), @GamlAnnotations.example(value="\t     else {write \"the cycle number is odd\";}", test=false)})
    @validator(value=EveryValidator.class)
    public static Boolean every(IScope iScope, Integer n) {
        int n2 = iScope.getClock().getCycle();
        if (n > 0 && (n2 == 0 || n2 >= n) && n2 % n == 0) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"every", "every_cycle"}, category={"System"}, concept={"system", "cycle"})
    @GamlAnnotations.doc(value="returns the first float operand every 2nd operand * cycle, 0.0 otherwise", comment="the value of the every operator depends on the cycle. It can be used to return a value every x cycle. `1000.0 every(10#cycle)` is strictly equivalent to `every(10#cycle) ? 1000.0 : 0.0`", examples={@GamlAnnotations.example(value="if (1000.0 every(2#cycle) != 0) {write \"this is a value\";}", test=false), @GamlAnnotations.example(value="\t     else {write \"this is 0.0\";}", test=false)})
    @validator(value=EveryValidator.class)
    public static Double every(IScope iScope, Double d, Integer n) {
        int n2 = iScope.getClock().getCycle();
        return n > 0 && (n2 == 0 || n2 >= n) && n2 % n == 0 ? d : 0.0;
    }

    @GamlAnnotations.operator(value={"every", "every_cycle"}, category={"System"}, concept={"system", "cycle"})
    @GamlAnnotations.doc(value="returns the first integer operand every 2nd operand * cycle, 0 otherwise", comment="the value of the every operator depends on the cycle. It can be used to return a value every x cycle. `1000 every(10#cycle)` is strictly equivalent to `every(10#cycle) ? 1000 : 0`", examples={@GamlAnnotations.example(value="if (1000 every(2#cycle) != 0) {write \"this is a value\";}", test=false), @GamlAnnotations.example(value="\t     else {write \"this is 0\";}", test=false)})
    @validator(value=EveryValidator.class)
    public static Integer every(IScope iScope, Integer n, Integer n2) {
        int n3 = iScope.getClock().getCycle();
        return n2 > 0 && (n3 == 0 || n3 >= n2) && n3 % n2 == 0 ? n : 0;
    }

    @GamlAnnotations.operator(value={"every", "every_cycle"}, type=-199, category={"System"}, concept={"system", "cycle"})
    @GamlAnnotations.doc(value="returns the first operand every 2nd operand * cycle, nil otherwise", comment="the value of the every operator depends on the cycle. It can be used to return a value every x cycle. `object every(10#cycle)` is strictly equivalent to `every(10#cycle) ? object : nil`", examples={@GamlAnnotations.example(value="if ({2000,2000} every(2#cycle) != nil) {write \"this is a point\";}", test=false), @GamlAnnotations.example(value="\t     else {write \"this is nil\";}", test=false)})
    @validator(value=EveryValidator.class)
    public static Object every(IScope iScope, Object object, Integer n) {
        int n2 = iScope.getClock().getCycle();
        return n > 0 && (n2 == 0 || n2 >= n) && n2 % n == 0 ? object : null;
    }

    @GamlAnnotations.operator(value={"every", "every_cycle"}, type=-199, category={"System"}, concept={"system", "cycle"})
    @GamlAnnotations.doc(value="returns the first bool operand every 2nd operand * cycle, false otherwise", comment="the value of the every operator depends on the cycle. It can be used to return a value every x cycle. `object every(10#cycle)` is strictly equivalent to `every(10#cycle) ? object : false`", examples={@GamlAnnotations.example(value="if (true every(2#cycle) != false) {write \"this is true\";}", test=false), @GamlAnnotations.example(value="\t     else {write \"this is false\";}", test=false)})
    @validator(value=EveryValidator.class)
    public static Boolean every(IScope iScope, Boolean bl, Integer n) {
        int n2 = iScope.getClock().getCycle();
        return n > 0 && (n2 == 0 || n2 >= n) && n2 % n == 0 ? bl : false;
    }

    @GamlAnnotations.operator(value={"every"}, category={"Date-related operators"}, concept={"date", "cycle"})
    @GamlAnnotations.doc(see={"since", "after"}, value="expects a frequency (expressed in seconds of simulated time) as argument. Will return true every time the current_date matches with this frequency", comment="Used to do something at regular intervals of time. Can be used in conjunction with 'since', 'after', 'before', 'until' or 'between', so that this computation only takes place in the temporal segment defined by these operators. In all cases, the starting_date of the model is used as a reference starting point", examples={@GamlAnnotations.example(value="reflex when: every(2#days) since date('2000-01-01') { .. }", isExecutable=false), @GamlAnnotations.example(value="state a { transition to: b when: every(2#mn);} state b { transition to: a when: every(30#s);} // This oscillatory behavior will use the starting_date of the model as its starting point in time", isExecutable=false)})
    @validator(value=EveryValidator.class)
    public static Boolean every(IScope iScope, IExpression iExpression) {
        return iScope.getClock().getStartingDate().isIntervalReachedOptimized(iScope, iExpression);
    }

    @GamlAnnotations.operator(value={"every"}, category={"Date-related operators"}, concept={"date", "cycle"})
    @GamlAnnotations.doc(see={"since", "after"}, value="expects a frequency (expressed in seconds of simulated time) as argument and a bool to use (default) the optimzied version (true) and the old one (false). Will return true every time the current_date matches with this frequency", comment="Used to do something at regular intervals of time. Can be used in conjunction with 'since', 'after', 'before', 'until' or 'between', so that this computation only takes place in the temporal segment defined by these operators. In all cases, the starting_date of the model is used as a reference starting point", examples={@GamlAnnotations.example(value="reflex when: every(2#days, false) since date('2000-01-01') { .. }", isExecutable=false)})
    @validator(value=EveryValidator.class)
    public static Boolean every(IScope iScope, IExpression iExpression, boolean bl) {
        if (bl) {
            return iScope.getClock().getStartingDate().isIntervalReachedOptimized(iScope, iExpression);
        }
        return iScope.getClock().getStartingDate().isIntervalReached(iScope, iExpression);
    }

    @GamlAnnotations.operator(value={"every"}, category={"Date-related operators"}, concept={"date", "cycle"})
    @GamlAnnotations.doc(see={"to"}, value="applies a step to an interval of dates defined by 'date1 to date2'. Beware that using every with #month or #year will produce odd results,as these pseudo-constants are not constant; only the first value will be used to compute the intervals, so, for instance, if current_date is set to February#month will only represent 28 or 29 days. ", comment="", examples={@GamlAnnotations.example(value="(date('2000-01-01') to date('2010-01-01')) every (#day) // builds an interval between these two dates which contains all the days starting from the beginning of the interval", isExecutable=false)})
    @GamlAnnotations.test(value="list((date('2001-01-01') to date('2001-1-02')) every(#day)) collect each = [date ('2001-01-01 00:00:00')]")
    public static IList<GamaDate> every(IScope iScope, GamaDateInterval gamaDateInterval, IExpression iExpression) {
        return gamaDateInterval.step(Cast.asFloat(iScope, iExpression.value(iScope)));
    }

    @GamlAnnotations.operator(value={"to"}, category={"Date-related operators"}, concept={"date", "cycle"})
    @GamlAnnotations.doc(see={"every"}, value="builds an interval between two dates (the first inclusive and the second exclusive, which behaves like a read-only list of dates. The default step between two dates is the step of the model", comment="The default step can be overruled by using the every operator applied to this interval", examples={@GamlAnnotations.example(value="date('2000-01-01') to date('2010-01-01') // builds an interval between these two dates", isExecutable=false), @GamlAnnotations.example(value="(date('2000-01-01') to date('2010-01-01')) every (#day) // builds an interval between these two dates which contains all the days starting from the beginning of the interval. Beware that using every with #month or #year will produce odd results, as these pseudo-constants are not constant; only the first value will be used to compute the intervals (if current_date is set to a month of February, #month will only represent 28 or 29 days depending on whether it is a leap year or not !). If such intervals need to be built, it is recommended to usea generative way, for instance a loop using the 'plus_years' or 'plus_months' operators to build a list of dates", isExecutable=false)})
    @GamlAnnotations.test(value="to_list((date('2001-01-01') to date('2001-01-06')) every(#day)) =\n\t\t[date ('2001-01-01 00:00:00'),date ('2001-01-02 00:00:00'),date ('2001-01-03 00:00:00'),date ('2001-01-04 00:00:00'),date ('2001-01-05 00:00:00')]")
    public static IList<GamaDate> to(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) {
        return GamaDateInterval.of(gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={"since", "from"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the current_date of the model is after (or equal to) the date passed in argument. Synonym of 'current_date >= argument'. Can be used, like 'after', in its composed form with 2 arguments to express the lowest boundary of the computation of a frequency. However, contrary to 'after', there is a subtle difference: the lowest boundary will be tested against the frequency as well ", examples={@GamlAnnotations.example(value="reflex when: since(starting_date) {}  \t// this reflex will always be run", isExecutable=false), @GamlAnnotations.example(value="every(2#days) since (starting_date + 1#day) // the computation will return true 1 day after the starting date and every two days after this reference date", isExecutable=false)})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="starting_date <- date([2019,5,9]);since(date([2019,5,10])) = false"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);since(date([2019,5,9])) = true"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);since(date([2019,5,8])) = true")})
    public static boolean since(IScope iScope, GamaDate gamaDate) {
        return iScope.getSimulation().getCurrentDate().isGreaterThan(gamaDate, false);
    }

    @GamlAnnotations.operator(value={"after"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the current_date of the model is strictly after the date passed in argument. Synonym of 'current_date > argument'. Can be used in its composed form with 2 arguments to express the lower boundary for the computation of a frequency. Note that only dates strictly after this one will be tested against the frequency", examples={@GamlAnnotations.example(value="reflex when: after(starting_date) {} \t// this reflex will always be run after the first step", isExecutable=false), @GamlAnnotations.example(value="reflex when: false after(starting date + #10days) {} \t// This reflex will not be run after this date. Better to use 'until' or 'before' in that case", isExecutable=false), @GamlAnnotations.example(value="every(2#days) after (starting_date + 1#day) \t// the computation will return true every two days (using the starting_date of the model as the starting point) only for the dates strictly after this starting_date + 1#day", isExecutable=false)})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="starting_date <- date([2019,5,9]);after(date([2019,5,10])) = false"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);after(date([2019,5,9])) = false"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);after(date([2019,5,8])) = true")})
    public static boolean after(IScope iScope, GamaDate gamaDate) {
        return iScope.getSimulation().getCurrentDate().isGreaterThan(gamaDate, true);
    }

    @GamlAnnotations.operator(value={"before"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the current_date of the model is strictly before the date passed in argument. Synonym of 'current_date < argument'", examples={@GamlAnnotations.example(value="reflex when: before(starting_date) {} \t// this reflex will never be run", isExecutable=false)})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="starting_date <- date([2019,5,9]);before(date([2019,5,10])) = true"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);before(date([2019,5,9])) = false"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);before(date([2019,5,8])) = false")})
    public static boolean before(IScope iScope, GamaDate gamaDate) {
        return iScope.getSimulation().getCurrentDate().isSmallerThan(gamaDate, true);
    }

    @GamlAnnotations.operator(value={"until", "to"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the current_date of the model is before (or equel to) the date passed in argument. Synonym of 'current_date <= argument'", examples={@GamlAnnotations.example(value="reflex when: until(starting_date) {} \t// This reflex will be run only once at the beginning of the simulation", isExecutable=false)})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="starting_date <- date([2019,5,9]);until(date([2019,5,10])) = true"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);until(date([2019,5,9])) = true"), @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);until(date([2019,5,8])) = false")})
    public static boolean until(IScope iScope, GamaDate gamaDate) {
        return iScope.getSimulation().getCurrentDate().isSmallerThan(gamaDate, false);
    }

    @GamlAnnotations.operator(value={"since", "from"}, category={"Date-related operators"}, doc={@GamlAnnotations.doc(value="Returns true if the first operand is true and the current date is equal to or after the second operand")}, concept={"date"})
    public static boolean since(IScope iScope, IExpression iExpression, GamaDate gamaDate) {
        return Dates.since(iScope, gamaDate) && Cast.asBool(iScope, iExpression.value(iScope)) != false;
    }

    @GamlAnnotations.operator(value={"after"}, doc={@GamlAnnotations.doc(value="Returns true if the first operand is true and the current date is situated strictly after the second operand")}, category={"Date-related operators"}, concept={"date"})
    public static boolean after(IScope iScope, IExpression iExpression, GamaDate gamaDate) {
        return Dates.after(iScope, gamaDate) && Cast.asBool(iScope, iExpression.value(iScope)) != false;
    }

    @GamlAnnotations.operator(value={"before"}, category={"Date-related operators"}, doc={@GamlAnnotations.doc(value="Returns true if the first operand is true and the current date is situated strictly before the second operand")}, concept={"date"})
    public static boolean before(IScope iScope, IExpression iExpression, GamaDate gamaDate) {
        return Dates.before(iScope, gamaDate) && Cast.asBool(iScope, iExpression.value(iScope)) != false;
    }

    @GamlAnnotations.operator(value={"until", "to"}, doc={@GamlAnnotations.doc(value="Returns true if the first operand is true and the current date is equal to or situated before the second operand")}, category={"Date-related operators"}, concept={"date"})
    public static boolean until(IScope iScope, IExpression iExpression, GamaDate gamaDate) {
        return Dates.until(iScope, gamaDate) && Cast.asBool(iScope, iExpression.value(iScope)) != false;
    }

    @GamlAnnotations.operator(value={"between"}, category={"Date-related operators"}, doc={@GamlAnnotations.doc(value="Returns true if the first operand is true and the current date is situated strictly after the second operand and before the third one")}, concept={"date"})
    public static boolean between(IScope iScope, IExpression iExpression, GamaDate gamaDate, GamaDate gamaDate2) {
        return Dates.between(iScope, iScope.getClock().getCurrentDate(), gamaDate, gamaDate2) && (Boolean)iExpression.value(iScope) != false;
    }

    @GamlAnnotations.operator(value={"between"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="returns true if the first operand is between the two dates passed in arguments (both exclusive). Can be combined with 'every' to express a frequency between two dates", examples={@GamlAnnotations.example(value="(date('2016-01-01') between(date('2000-01-01'), date('2020-02-02')))", equals="true"), @GamlAnnotations.example(value="// will return true every new day between these two dates, taking the first one as the starting point", isExecutable=false), @GamlAnnotations.example(value="every(#day between(date('2000-01-01'), date('2020-02-02'))) ", isExecutable=false)})})
    public static boolean between(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2, GamaDate gamaDate3) {
        return gamaDate.isGreaterThan(gamaDate2, true) && gamaDate.isSmallerThan(gamaDate3, true);
    }

    @GamlAnnotations.operator(value={"between"}, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="With only 2 date operands, it returns true if the current_date is between the 2 date  operands.", examples={@GamlAnnotations.example(value="between(date('2000-01-01'), date('2020-02-02'))", equals="false")})})
    @GamlAnnotations.test(value="starting_date <- date([2019,5,9]);between((date([2019,5,8])), (date([2019,5,10]))) = true")
    public static boolean between(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) {
        return iScope.getSimulation().getCurrentDate().isGreaterThan(gamaDate, true) && iScope.getSimulation().getCurrentDate().isSmallerThan(gamaDate2, true);
    }

    @GamlAnnotations.operator(value={"+", "plus_seconds", "add_seconds"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if one of the operands is a date and the other a number, returns a date corresponding to the date plus the given number as duration (in seconds)", examples={@GamlAnnotations.example(value="date('2000-01-01') + 86400", equals="date('2000-01-02')")})})
    @GamlAnnotations.test(value="date('2000-01-01') + 86400 = date('2000-01-02')")
    public static GamaDate plusDuration(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.SECONDS);
    }

    @GamlAnnotations.operator(value={"+"}, content_type=0, category={"Date-related operators"}, concept={"time", "date"})
    @GamlAnnotations.doc(value="Add a duration to a date. The duration is supposed to be in seconds (so that adding 0.5, for instance, will add 500ms)", examples={@GamlAnnotations.example(value="date('2016-01-01 00:00:01') + 86400", equals="date('2016-01-02 00:00:01')")})
    @GamlAnnotations.test(value="date('2016-01-01 00:00:01') + 86400 = date('2016-01-02 00:00:01')")
    public static GamaDate plusDuration(IScope iScope, GamaDate gamaDate, double d) throws GamaRuntimeException {
        return gamaDate.plus(d * 1000.0, (TemporalUnit)ChronoUnit.MILLIS);
    }

    @GamlAnnotations.operator(value={"-", "minus_seconds", "subtract_seconds"}, content_type=0, category={"Date-related operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if one of the operands is a date and the other a number, returns a date corresponding to the date minus the given number as duration (in seconds)", examples={@GamlAnnotations.example(value="date('2000-01-01') - 86400", equals="date('1999-12-31')")})})
    @GamlAnnotations.test(value="date('2000-01-01') - 86400 = date('1999-12-31')")
    public static GamaDate minusDuration(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.SECONDS);
    }

    @GamlAnnotations.operator(value={"-"}, content_type=0, category={"Date-related operators"}, concept={"time", "date"})
    @GamlAnnotations.doc(value="Removes a duration from a date. The duration is expected to be in seconds (so that removing 0.5, for instance, will add 500ms) ", examples={@GamlAnnotations.example(value="date('2000-01-01') - 86400", equals="date('1999-12-31')")})
    @GamlAnnotations.test(value="date('2000-01-01') - 86400 = date('1999-12-31')")
    public static GamaDate minusDuration(IScope iScope, GamaDate gamaDate, double d) throws GamaRuntimeException {
        return gamaDate.plus(-d * 1000.0, (TemporalUnit)ChronoUnit.MILLIS);
    }

    @GamlAnnotations.operator(value={"+"}, content_type=0, category={"Date-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns the resulting string from the addition of a date and a string", examples={@GamlAnnotations.example(value="date('2000-01-01 00:00:00') + '_Test'", equals="'2000-01-01 00:00:00_Test'")})
    @GamlAnnotations.test(value="date('2000-01-01 00:00:00') + '_Test' = '2000-01-01 00:00:00_Test'")
    public static String concatenateDate(IScope iScope, GamaDate gamaDate, String string) throws GamaRuntimeException {
        return gamaDate.toString() + string;
    }

    @GamlAnnotations.operator(value={"plus_years", "add_years"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of years to a date", examples={@GamlAnnotations.example(value="date('2000-01-01') plus_years 15", equals="date('2015-01-01')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_years 15 = date('2015-01-01')")
    public static GamaDate addYears(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.YEARS);
    }

    @GamlAnnotations.operator(value={"plus_months", "add_months"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of months to a date", examples={@GamlAnnotations.example(value="date('2000-01-01') plus_months 5", equals="date('2000-06-01')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_months 5 = date('2000-06-01')")
    public static GamaDate addMonths(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.MONTHS);
    }

    @GamlAnnotations.operator(value={"plus_weeks", "add_weeks"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of weeks to a date", examples={@GamlAnnotations.example(value="date('2000-01-01') plus_weeks 15", equals="date('2000-04-15')")})
    @GamlAnnotations.test(value="is_error(date('2000-15-01'))")
    public static GamaDate addWeeks(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.WEEKS);
    }

    @GamlAnnotations.operator(value={"plus_days", "add_days"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of days to a date", examples={@GamlAnnotations.example(value="date('2000-01-01') plus_days 12", equals="date('2000-01-13')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_days 12 = date('2000-01-13')")
    public static GamaDate addDays(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.DAYS);
    }

    @GamlAnnotations.operator(value={"plus_hours", "add_hours"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of hours to a date", examples={@GamlAnnotations.example(value="// equivalent to date1 + 15 #h", test=false), @GamlAnnotations.example(value="date('2000-01-01') plus_hours 24", equals="date('2000-01-02')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_hours 24  = date('2000-01-02')")
    public static GamaDate addHours(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.HOURS);
    }

    @GamlAnnotations.operator(value={"plus_minutes", "add_minutes"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of minutes to a date", examples={@GamlAnnotations.example(value="// equivalent to date1 + 5 #mn", test=false), @GamlAnnotations.example(value="date('2000-01-01') plus_minutes 5 ", equals="date('2000-01-01 00:05:00')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_minutes 5  = date('2000-01-01 00:05:00')")
    public static GamaDate addMinutes(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.MINUTES);
    }

    @GamlAnnotations.operator(value={"minus_years", "subtract_years"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Subtract a given number of year from a date", examples={@GamlAnnotations.example(value="date('2000-01-01') minus_years 3", equals="date('1997-01-01')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_years 3 = date('1997-01-01')")
    public static GamaDate subtractYears(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.YEARS);
    }

    @GamlAnnotations.operator(value={"minus_months", "subtract_months"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Subtract a given number of months from a date", examples={@GamlAnnotations.example(value="date('2000-01-01') minus_months 5", equals="date('1999-08-01')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_months 5 = date('1999-08-01')")
    public static GamaDate subtractMonths(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.MONTHS);
    }

    @GamlAnnotations.operator(value={"minus_weeks", "subtract_weeks"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Subtract a given number of weeks from a date", examples={@GamlAnnotations.example(value="date('2000-01-01') minus_weeks 15", equals="date('1999-09-18')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_weeks 15 = date('1999-09-18')")
    public static GamaDate subtractWeeks(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.WEEKS);
    }

    @GamlAnnotations.operator(value={"minus_days", "subtract_days"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Subtract a given number of days from a date", examples={@GamlAnnotations.example(value="date('2000-01-01') minus_days 20", equals="date('1999-12-12')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_days 20 = date('1999-12-12')")
    public static GamaDate subtractDays(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.DAYS);
    }

    @GamlAnnotations.operator(value={"minus_hours", "subtract_hours"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Remove a given number of hours from a date", examples={@GamlAnnotations.example(value="// equivalent to date1 - 15 #h", isExecutable=false), @GamlAnnotations.example(value="date('2000-01-01') minus_hours 15 ", equals="date('1999-12-31 09:00:00')")})
    @GamlAnnotations.test(value="(date('2000-01-01') minus_hours 15)  = date('1999-12-31 09:00:00')")
    public static GamaDate subtractHours(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.HOURS);
    }

    @GamlAnnotations.operator(value={"minus_ms", "subtract_ms"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Remove a given number of milliseconds from a date", examples={@GamlAnnotations.example(value="// equivalent to date1 - 15 #ms", isExecutable=false), @GamlAnnotations.example(value="date('2000-01-01') minus_ms 1000 ", equals="date('1999-12-31 23:59:59')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_ms 1000  = date('1999-12-31 23:59:59')")
    public static GamaDate subtractMs(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.MILLIS);
    }

    @GamlAnnotations.operator(value={"plus_ms", "add_ms"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Add a given number of milliseconds to a date", examples={@GamlAnnotations.example(value="// equivalent to date('2000-01-01') + 15 #ms", isExecutable=false), @GamlAnnotations.example(value="date('2000-01-01') plus_ms 1000 ", equals="date('2000-01-01 00:00:01')")})
    @GamlAnnotations.test(value="date('2000-01-01') plus_ms 1000  = date('2000-01-01 00:00:01')")
    public static GamaDate addMs(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(n, (TemporalUnit)ChronoUnit.MILLIS);
    }

    @GamlAnnotations.operator(value={"minus_minutes", "subtract_minutes"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Subtract a given number of minutes from a date", examples={@GamlAnnotations.example(value="// date('2000-01-01') to date1 - 5#mn", isExecutable=false), @GamlAnnotations.example(value="date('2000-01-01') minus_minutes 5 ", equals="date('1999-12-31 23:55:00')")})
    @GamlAnnotations.test(value="date('2000-01-01') minus_minutes 5  = date('1999-12-31 23:55:00')")
    public static GamaDate subtractMinutes(IScope iScope, GamaDate gamaDate, int n) throws GamaRuntimeException {
        return gamaDate.plus(-n, (TemporalUnit)ChronoUnit.MINUTES);
    }

    @GamlAnnotations.operator(value={"years_between"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Provide the exact number of years between two dates. This number can be positive or negative (if the second operand is smaller than the first one)", examples={@GamlAnnotations.example(value="years_between(date('2000-01-01'), date('2010-01-01'))", equals="10")})
    @GamlAnnotations.test(value="years_between(date('2000-01-01'), date('2010-01-01')) = 10")
    public static int years_between(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return (int)ChronoUnit.YEARS.between(gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={"milliseconds_between"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Provide the exact number of milliseconds between two dates. This number can be positive or negative (if the second operand is smaller than the first one)", examples={@GamlAnnotations.example(value="milliseconds_between(date('2000-01-01'), date('2000-02-01'))", equals="2.6784E9")})
    @GamlAnnotations.test(value="milliseconds_between(date('2000-01-01'), date('2000-02-01')) = 2.6784E9")
    public static double milliseconds_between(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return ChronoUnit.MILLIS.between(gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={"months_between"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Provide the exact number of months between two dates. This number can be positive or negative (if the second operand is smaller than the first one)", examples={@GamlAnnotations.example(value="months_between(date('2000-01-01'), date('2000-02-01'))", equals="1")})
    @GamlAnnotations.test(value="months_between(date('2000-01-01'), date('2000-02-01')) = 1")
    public static int months_between(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return (int)ChronoUnit.MONTHS.between(gamaDate, gamaDate2);
    }

    @GamlAnnotations.operator(value={">"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the first date is strictly greater than the second one", examples={@GamlAnnotations.example(value="(#now > (#now minus_hours 1))", equals="true")})
    @GamlAnnotations.test(value="(#now > (#now minus_hours 1)) = true")
    public static boolean greater_than(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return gamaDate.isGreaterThan(gamaDate2, true);
    }

    @GamlAnnotations.operator(value={">="}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the first date is greater than or equal to the second one", examples={@GamlAnnotations.example(value="#now >= #now minus_hours 1", equals="true")})
    @GamlAnnotations.test(value="(#now >= (#now minus_hours 1)) = true")
    public static boolean greater_than_or_equal(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return gamaDate.isGreaterThan(gamaDate2, false);
    }

    @GamlAnnotations.operator(value={"<"}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the first date is strictly smaller than the second one", examples={@GamlAnnotations.example(value="#now < #now minus_hours 1", equals="false")})
    @GamlAnnotations.test(value="(#now < (#now minus_hours 1)) = false")
    public static boolean smaller_than(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return gamaDate.isSmallerThan(gamaDate2, true);
    }

    @GamlAnnotations.operator(value={"<="}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the first date is smaller than or equal to the second one", examples={@GamlAnnotations.example(value="(#now <= (#now minus_hours 1))", equals="false")})
    @GamlAnnotations.test(value="(#now <= (#now minus_hours 1)) = false")
    public static boolean smaller_than_or_equal(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return gamaDate.isSmallerThan(gamaDate2, false);
    }

    @GamlAnnotations.operator(value={"="}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the two dates are equal (i.e.they represent the same instant in time)", examples={@GamlAnnotations.example(value="#now = #now minus_hours 1", equals="false")})
    @GamlAnnotations.test(value="(#now = (#now minus_hours 1)) = false")
    public static boolean equal(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return gamaDate.equals(gamaDate2);
    }

    @GamlAnnotations.operator(value={"!="}, content_type=0, category={"Date-related operators"}, concept={"date"})
    @GamlAnnotations.doc(value="Returns true if the two dates are different  (i.e.they do not represent the same instant in time)", examples={@GamlAnnotations.example(value="#now != #now minus_hours 1", equals="true")})
    @GamlAnnotations.test(value="(#now != (#now minus_hours 1)) = true")
    public static boolean different(IScope iScope, GamaDate gamaDate, GamaDate gamaDate2) throws GamaRuntimeException {
        return !gamaDate.equals(gamaDate2);
    }

    static Locale getLocale(String string) {
        String string2;
        if (string == null) {
            return Locale.getDefault();
        }
        return switch (string2 = string.toLowerCase()) {
            case "us" -> Locale.US;
            case "fr" -> Locale.FRANCE;
            case "en" -> Locale.ENGLISH;
            case "de" -> Locale.GERMAN;
            case "it" -> Locale.ITALIAN;
            case "jp" -> Locale.JAPANESE;
            case "uk" -> Locale.UK;
            default -> new Locale(string2);
        };
    }

    static String getFormatterKey(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    public static DateTimeFormatter getFormatter(String string, String string2) {
        Object object;
        String string3 = string;
        if (FORMATTERS == null || FORMATTERS.isEmpty()) {
            return DateTimeFormatter.ofPattern(DEFAULT_FORMAT);
        }
        if (string3 == null) {
            return FORMATTERS.get(DEFAULT_KEY);
        }
        DateTimeFormatter dateTimeFormatter = FORMATTERS.get(Dates.getFormatterKey(string3, string2));
        if (dateTimeFormatter != null) {
            return dateTimeFormatter;
        }
        if (!string3.contains("%")) {
            try {
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                DateTimeFormatter dateTimeFormatter2 = dateTimeFormatterBuilder.parseCaseInsensitive().appendPattern(string3).toFormatter(Dates.getLocale(string2));
                FORMATTERS.put(Dates.getFormatterKey(string3, string2), dateTimeFormatter2);
                return dateTimeFormatter2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GAMA.reportAndThrowIfNeeded(GAMA.getRuntimeScope(), GamaRuntimeException.create(illegalArgumentException, GAMA.getRuntimeScope()), false);
                return FORMATTERS.get(DEFAULT_KEY);
            }
        }
        DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
        dateTimeFormatterBuilder.parseCaseInsensitive();
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = model_pattern.matcher(string3);
        int n = 0;
        while (matcher.find()) {
            object = matcher.group();
            if (n != matcher.start()) {
                arrayList.add(string3.substring(n, matcher.start()));
            }
            arrayList.add((String)object);
            n = matcher.end();
        }
        if (n != string3.length()) {
            arrayList.add(string3.substring(n));
        }
        n = 0;
        while (n < arrayList.size()) {
            object = (String)arrayList.get(n);
            if (((String)object).charAt(0) == '%' && ((String)object).length() == 2) {
                Character c = Character.valueOf(((String)object).charAt(1));
                switch (c.charValue()) {
                    case 'Y': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.YEAR, 4);
                        break;
                    }
                    case 'M': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.MONTH_OF_YEAR, 2);
                        break;
                    }
                    case 'N': {
                        dateTimeFormatterBuilder.appendText(ChronoField.MONTH_OF_YEAR);
                        break;
                    }
                    case 'D': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.DAY_OF_MONTH, 2);
                        break;
                    }
                    case 'E': {
                        dateTimeFormatterBuilder.appendText(ChronoField.DAY_OF_WEEK);
                        break;
                    }
                    case 'h': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.HOUR_OF_DAY, 2);
                        break;
                    }
                    case 'm': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
                        break;
                    }
                    case 's': {
                        dateTimeFormatterBuilder.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
                        break;
                    }
                    case 'z': {
                        dateTimeFormatterBuilder.appendZoneOrOffsetId();
                        break;
                    }
                    default: {
                        dateTimeFormatterBuilder.appendLiteral((String)object);
                        break;
                    }
                }
            } else {
                dateTimeFormatterBuilder.appendLiteral((String)object);
            }
            ++n;
        }
        object = dateTimeFormatterBuilder.toFormatter(Dates.getLocale(string2));
        FORMATTERS.put(Dates.getFormatterKey(string3, string2), (DateTimeFormatter)object);
        return object;
    }

    public static String asDuration(Temporal temporal, Temporal temporal2) {
        Duration duration = Duration.between(temporal, temporal2);
        return DurationFormatter.format(duration);
    }

    @GamlAnnotations.operator(value={"date"}, can_be_const=true, category={"Strings-related operators", "Time-related operators"}, concept={"string", "cast", "time"})
    @GamlAnnotations.doc(value="converts a string to a date following a custom pattern. The pattern can use \"%Y %M %N %D %E %h %m %s %z\" for outputting years, months, name of month, days, name of days, hours, minutes, seconds and the time-zone. A null or empty pattern will parse the date using one of the ISO date & time formats (similar to date('...') in that case). The pattern can also follow the pattern definition found here, which gives much more control over what will be parsed: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#patterns. Different patterns are available by default as constant: #iso_local, #iso_simple, #iso_offset, #iso_zoned and #custom, which can be changed in the preferences ", masterDoc=true, usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="date den <- date(\"1999-12-30\", 'yyyy-MM-dd');", test=false)})})
    public static GamaDate date(IScope iScope, String string, String string2) {
        return new GamaDate(iScope, string, string2);
    }

    @GamlAnnotations.operator(value={"date"}, can_be_const=true, category={"Strings-related operators", "Time-related operators"}, concept={"string", "cast", "time"})
    @GamlAnnotations.doc(value="converts a string to a date following a custom pattern and a specific locale (e.g. 'fr', 'en'...). The pattern can use \"%Y %M %N %D %E %h %m %s %z\" for parsing years, months, name of month, days, name of days, hours, minutes, seconds and the time-zone. A null or empty pattern will parse the date using one of the ISO date & time formats (similar to date('...') in that case). The pattern can also follow the pattern definition found here, which gives much more control over what will be parsed: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#patterns. Different patterns are available by default as constant: #iso_local, #iso_simple, #iso_offset, #iso_zoned and #custom, which can be changed in the preferences ", usages={@GamlAnnotations.usage(value="In addition to the date and  pattern string operands, a specific locale (e.g. 'fr', 'en'...) can be added.", examples={@GamlAnnotations.example(value="date d <- date(\"1999-january-30\", 'yyyy-MMMM-dd', 'en');", test=false)})})
    @GamlAnnotations.test(value="date('1999-01-30', 'yyyy-MM-dd', 'en') = date('1999-01-30 00:00:00')")
    public static GamaDate date(IScope iScope, String string, String string2, String string3) {
        return new GamaDate(iScope, string, string2, string3);
    }

    @GamlAnnotations.operator(value={"string"}, can_be_const=true, category={"Strings-related operators", "Time-related operators"}, concept={"string", "cast", "time"})
    @GamlAnnotations.doc(value="converts a date to astring following a custom pattern. The pattern can use \"%Y %M %N %D %E %h %m %s %z\" for outputting years, months, name of month, days, name of days, hours, minutes, seconds and the time-zone. A null or empty pattern will return the complete date as defined by the ISO date & time format. The pattern can also follow the pattern definition found here, which gives much more control over the format of the date: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#patterns. Different patterns are available by default as constants: #iso_local, #iso_simple, #iso_offset, #iso_zoned and #custom, which can be changed in the preferences", masterDoc=true, usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="string(#now, 'yyyy-MM-dd')", isExecutable=false)})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="string(date('2000-01-02'),'yyyy-MM-dd') = '2000-01-02'"), @GamlAnnotations.test(value="string(date('2000-01-31'),'yyyy-MM-dd') = '2000-01-31'"), @GamlAnnotations.test(value="string(date('2000-01-02'),'yyyy-MM-dd') = '2000-01-02'")})
    public static String format(GamaDate gamaDate, String string) {
        return Dates.format(gamaDate, string, null);
    }

    @GamlAnnotations.operator(value={"string"}, can_be_const=true, category={"Strings-related operators", "Time-related operators"}, concept={"string", "cast", "time"})
    @GamlAnnotations.doc(value="converts a date to astring following a custom pattern and using a specific locale (e.g.: 'fr', 'en', etc.). The pattern can use \"%Y %M %N %D %E %h %m %s %z\" for outputting years, months, name of month, days, name of days, hours, minutes, seconds and the time-zone. A null or empty pattern will return the complete date as defined by the ISO date & time format. The pattern can also follow the pattern definition found here, which gives much more control over the format of the date: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html#patterns. Different patterns are available by default as constants: #iso_local, #iso_simple, #iso_offset, #iso_zoned and #custom, which can be changed in the preferences", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="string(#now, 'yyyy-MM-dd', 'en')", isExecutable=false)})})
    @GamlAnnotations.test(value="string(date('2000-01-02'),'yyyy-MMMM-dd','en') = '2000-January-02'")
    public static String format(GamaDate gamaDate, String string, String string2) {
        return gamaDate.toString(string, string2);
    }

    static class DurationFormatter
    implements TemporalAccessor {
        private static final DateTimeFormatter YMDHMS = DateTimeFormatter.ofPattern("u'y' M'm' d'd' HH:mm:ss");
        private static final DateTimeFormatter MDHMS = DateTimeFormatter.ofPattern("M' months' d 'days' HH:mm:ss");
        private static final DateTimeFormatter M1DHMS = DateTimeFormatter.ofPattern("M' month' d 'days' HH:mm:ss");
        private static final DateTimeFormatter M1D1HMS = DateTimeFormatter.ofPattern("M' month' d 'day' HH:mm:ss");
        private static final DateTimeFormatter DHMS = DateTimeFormatter.ofPattern("d 'days' HH:mm:ss");
        private static final DateTimeFormatter D1HMS = DateTimeFormatter.ofPattern("d 'day' HH:mm:ss");
        private static final DateTimeFormatter HMS = DateTimeFormatter.ofPattern("HH:mm:ss");
        private Temporal temporal;

        DurationFormatter() {
        }

        static String format(Duration duration) {
            return DURATION_FORMATTER.toString(duration);
        }

        private String toString(Duration duration) {
            this.temporal = duration.addTo(DATES_STARTING_DATE.getValue()).minus(GamaDateType.DEFAULT_OFFSET_IN_SECONDS.getTotalSeconds(), ChronoUnit.SECONDS);
            return this.toString();
        }

        private DateTimeFormatter getFormatter() {
            if (this.getLong(ChronoField.YEAR) > 0L) {
                return YMDHMS;
            }
            long l = this.getLong(ChronoField.MONTH_OF_YEAR);
            long l2 = this.getLong(ChronoField.DAY_OF_MONTH);
            if (l > 0L) {
                if (l >= 2L) {
                    return MDHMS;
                }
                if (l2 < 2L) {
                    return M1D1HMS;
                }
                return M1DHMS;
            }
            if (l2 > 0L) {
                if (l2 < 2L) {
                    return D1HMS;
                }
                return DHMS;
            }
            return HMS;
        }

        @Override
        public boolean isSupported(TemporalField temporalField) {
            return this.temporal.isSupported(temporalField);
        }

        @Override
        public long getLong(TemporalField temporalField) {
            if (temporalField == ChronoField.SECOND_OF_MINUTE) {
                return this.temporal.getLong(ChronoField.SECOND_OF_MINUTE);
            }
            if (temporalField == ChronoField.MINUTE_OF_HOUR) {
                return this.temporal.getLong(ChronoField.MINUTE_OF_HOUR);
            }
            if (temporalField == ChronoField.HOUR_OF_DAY) {
                return this.temporal.getLong(ChronoField.HOUR_OF_DAY);
            }
            if (temporalField == ChronoField.DAY_OF_MONTH) {
                return this.temporal.getLong(ChronoField.DAY_OF_MONTH) - 1L;
            }
            if (temporalField == ChronoField.MONTH_OF_YEAR) {
                return this.temporal.getLong(ChronoField.MONTH_OF_YEAR) - 1L;
            }
            if (temporalField == ChronoField.YEAR) {
                return this.temporal.getLong(ChronoField.YEAR) - DATES_STARTING_DATE.getValue().getLong(ChronoField.YEAR);
            }
            return 0L;
        }

        public String toString() {
            return this.getFormatter().format(this);
        }

        @Override
        public <R> R query(TemporalQuery<R> temporalQuery) {
            if (temporalQuery == TemporalQueries.precision()) {
                return (R)ChronoUnit.SECONDS;
            }
            if (temporalQuery == TemporalQueries.chronology()) {
                return (R)IsoChronology.INSTANCE;
            }
            if (temporalQuery == TemporalQueries.zone() || temporalQuery == TemporalQueries.zoneId()) {
                return null;
            }
            return temporalQuery.queryFrom(this);
        }
    }

    public static class EveryValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            if (iExpressionArray == null || iExpressionArray.length == 0) {
                return false;
            }
            IExpression iExpression = iExpressionArray[iExpressionArray.length - 1];
            if (iExpression instanceof ConstantExpression && iExpression.getGamlType() == Types.INT) {
                iDescription.warning("No unit provided. If this frequency concerns cycles, please use the #cycle unit. Otherwise use one of the temporal unit (#ms, #s, #mn, #h, #day, #week, #month, #year)", "gaml.deprecated.code.issue", eObject, new String[0]);
            }
            return true;
        }
    }
}

