/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.FluentIterable;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.statements.IStatement;

public class AbstractStatementSequence
extends AbstractStatement {
    protected IStatement[] commands;
    final boolean isTopLevel;

    public AbstractStatementSequence(IDescription iDescription) {
        super(iDescription);
        this.isTopLevel = iDescription != null && iDescription.getMeta().isTopLevel();
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.commands = (IStatement[])FluentIterable.from(iterable).filter(IStatement.class).toArray(IStatement.class);
    }

    public boolean isEmpty() {
        return this.commands.length == 0;
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        this.enterScope(iScope);
        try {
            Object object = super.executeOn(iScope);
            return object;
        }
        finally {
            this.leaveScope(iScope);
        }
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = null;
        IStatement[] iStatementArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            IStatement iStatement = iStatementArray[n2];
            ExecutionResult executionResult = iScope.execute(iStatement);
            if (!executionResult.passed()) {
                return object;
            }
            object = executionResult.getValue();
            ++n2;
        }
        return object;
    }

    public void leaveScope(IScope iScope) {
        if (this.isTopLevel) {
            iScope.getAndClearReturnStatus();
        }
        iScope.pop(this);
    }

    public void enterScope(IScope iScope) {
        iScope.push(this);
    }

    public IStatement[] getCommands() {
        return this.commands;
    }

    @Override
    public void dispose() {
        if (this.commands != null) {
            IStatement[] iStatementArray = this.commands;
            int n = this.commands.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement iStatement = iStatementArray[n2];
                iStatement.dispose();
                ++n2;
            }
            this.commands = null;
        }
        super.dispose();
    }
}

