/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.Types;
import java.util.ArrayList;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(doc={@GamlAnnotations.doc(value="an expression that is evaluated as an agent or a list of the agent to be captured")}, name="target", type={11, 16}, of=11, optional=false), @GamlAnnotations.facet(name="as", type={14}, optional=true, doc={@GamlAnnotations.doc(value="the species that the captured agent(s) will become, this is a micro-species of the calling agent's species")}), @GamlAnnotations.facet(name="returns", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="a list of the newly captured agent(s)")})}, omissible="target")
@GamlAnnotations.doc(value="Allows an agent to capture other agent(s) as its micro-agent(s).", usages={@GamlAnnotations.usage(value="The preliminary for an agent A to capture an agent B as its micro-agent is that the A's species must defined a micro-species which is a sub-species of B's species (cf. [Species161#Nesting_species Nesting species]).", examples={@GamlAnnotations.example(value="species A {", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="species B {", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="   species C parent: A {", isExecutable=false), @GamlAnnotations.example(value="   ...", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="...", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="To capture all \"A\" agents as \"C\" agents, we can ask an \"B\" agent to execute the following statement:", examples={@GamlAnnotations.example(value="capture list(B) as: C;", isExecutable=false)}), @GamlAnnotations.usage(value="Deprecated writing:", examples={@GamlAnnotations.example(value="capture target: list (B) as: C;", isExecutable=false)})}, see={"release"})
@validator(value=CaptureValidator.class)
public class CaptureStatement
extends AbstractStatementSequence {
    private IExpression target = this.getFacet("target");
    private final String returnString;
    private String microSpeciesName = this.getLiteral("as");
    private RemoteSequence sequence = null;

    public CaptureStatement(IDescription iDescription) {
        super(iDescription);
        this.returnString = this.getLiteral("returns");
        if (this.hasFacet("target")) {
            this.setName("capture " + this.getFacet("target").serializeToGaml(false));
        }
    }

    @Override
    public void enterScope(IScope iScope) {
        if (this.returnString != null) {
            iScope.addVarWithValue(this.returnString, null);
        }
        super.enterScope(iScope);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object;
        IList<Object> iList32;
        IList<IAgent> iList2 = GamaListFactory.create(Types.AGENT);
        IMacroAgent iMacroAgent = (IMacroAgent)iScope.getAgent();
        ISpecies iSpecies = iMacroAgent.getSpecies();
        Object object2 = this.target.value(iScope);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof IContainer) {
            for (IList<Object> iList32 : ((IContainer)object2).iterable(iScope)) {
                if (!(iList32 instanceof IAgent)) continue;
                iList2.add((IAgent)((Object)iList32));
            }
        } else if (object2 instanceof IAgent) {
            iList2.add((IAgent)object2);
        }
        iList32 = GamaListFactory.create(Types.AGENT);
        IList<IAgent> iList4 = GamaListFactory.create();
        if (!iList2.isEmpty()) {
            if (this.microSpeciesName != null) {
                object = iSpecies.getMicroSpecies(this.microSpeciesName);
                if (object == null) {
                    throw GamaRuntimeException.error(this.name + " can't capture other agents as members of " + this.microSpeciesName + " population because the " + this.microSpeciesName + " population is not visible or doesn't exist.", iScope);
                }
                addressable = iMacroAgent.getPopulationFor((ISpecies)object);
                if (addressable == null) {
                    throw GamaRuntimeException.error(this.name + " can't capture other agents as members of " + this.microSpeciesName + " population because the " + this.microSpeciesName + " population is not visible or doesn't exist.", iScope);
                }
                for (IAgent object3 : iList2) {
                    if (iMacroAgent.canCapture(object3, (ISpecies)object)) continue;
                    iList32.add(object3);
                }
                if (!iList32.isEmpty()) {
                    iList2.removeAll(iList32);
                }
                if (!iList2.isEmpty()) {
                    iList4 = iMacroAgent.captureMicroAgents(iScope, (ISpecies)object, iList2);
                    iList2.clear();
                    if (!iList4.isEmpty() && this.sequence != null && !this.sequence.isEmpty()) {
                        for (IAgent iAgent : iList4) {
                            if (iScope.execute(this.sequence, iAgent, null).passed()) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else {
                for (IAgent iAgent : iList2) {
                    object = iSpecies.getMicroSpecies(iAgent.getSpeciesName());
                    if (object != null) {
                        addressable = iMacroAgent.captureMicroAgent(iScope, (ISpecies)object, iAgent);
                        if (this.sequence != null && !this.sequence.isEmpty()) {
                            iScope.execute(this.sequence, (IAgent)addressable, null);
                            if (iScope.interrupted() || iScope.getAndClearBreakStatus() == FlowStatus.BREAK) break;
                        }
                        iList4.add((IAgent)addressable);
                        continue;
                    }
                    iList32.add(iAgent);
                }
            }
        }
        if (this.returnString != null) {
            iScope.setVarValue(this.returnString, iList4);
        }
        if (!iList32.isEmpty()) {
            object = new ArrayList();
            for (IContainer.Addressable addressable : iList32) {
                object.add(addressable.getName());
                object.add(", ");
            }
            object.remove(object.size() - 1);
            if (this.microSpeciesName != null) {
                throw GamaRuntimeException.error(iMacroAgent.getName() + " can't capture " + object.toString() + " as " + this.microSpeciesName + " agent", iScope);
            }
            throw GamaRuntimeException.error(iMacroAgent.getName() + " can't capture " + object.toString() + " as micro-agents because no appropriate micro-population is found to welcome these agents.", iScope);
        }
        return iList4;
    }

    @Override
    public void dispose() {
        this.target = null;
        this.microSpeciesName = null;
        super.dispose();
    }

    public static class CaptureValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            SpeciesDescription speciesDescription;
            SpeciesDescription speciesDescription2;
            String string = statementDescription.getLitteral("as");
            if (string != null && (speciesDescription2 = (speciesDescription = statementDescription.getSpeciesContext()).getMicroSpecies(string)) == null) {
                statementDescription.error(speciesDescription.getName() + " species doesn't contain " + string + " as micro-species", "gaml.unknown.species.issue", "as", string);
            }
        }
    }
}

