/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="message", type={4}, optional=false, doc={@GamlAnnotations.doc(value="the message to display in the error.")})}, omissible="message")
@GamlAnnotations.doc(value="The statement makes the agent output an error dialog (if the simulation contains a user interface). Otherwise displays the error in the console.", usages={@GamlAnnotations.usage(value="Throwing an error", examples={@GamlAnnotations.example(value="error 'This is an error raised by ' + self;")})})
public class ErrorStatement
extends AbstractStatement {
    final IExpression message = this.getFacet("message");

    public ErrorStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        String string = null;
        if (iAgent != null && !iAgent.dead()) {
            string = Cast.asString(iScope, this.message.value(iScope));
            throw GamaRuntimeException.error(string, iScope);
        }
        return string;
    }
}

