/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.gaml.operators.Colors;
import gama.gaml.statements.draw.IMeshColorProvider;

public class GradientBasedMeshColorProvider
implements IMeshColorProvider {
    final double[] components;
    final int size;

    static {
        DEBUG.OFF();
    }

    public GradientBasedMeshColorProvider(Colors.GamaGradient gamaGradient) {
        this.size = gamaGradient.size();
        this.components = new double[this.size * 5];
        int n = 0;
        for (GamaColor gamaColor : gamaGradient.keySet()) {
            this.components[n * 4] = (double)gamaColor.getRed() / 255.0;
            this.components[n * 4 + 1] = (double)gamaColor.getGreen() / 255.0;
            this.components[n * 4 + 2] = (double)gamaColor.getBlue() / 255.0;
            this.components[n * 4 + 3] = (double)gamaColor.getAlpha() / 255.0;
            this.components[n * 4 + 4] = (Double)gamaGradient.get(gamaColor);
            ++n;
        }
    }

    @Override
    public double[] getColor(int n, double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = dArray;
        if (dArray2 == null) {
            dArray2 = this.newArray();
        }
        if (d <= d2 || d3 <= d2) {
            return this.components;
        }
        double d4 = (d - d2) / (d3 - d2);
        int n2 = 0;
        while (n2 < this.size - 1) {
            double d5 = this.components[n2 * 4 + 4];
            double d6 = this.components[(n2 + 1) * 4 + 4];
            if (d4 <= d5) {
                dArray2[0] = this.components[4 * n2];
                dArray2[1] = this.components[4 * n2 + 1];
                dArray2[2] = this.components[4 * n2 + 2];
                dArray2[3] = this.components[4 * n2 + 3];
                return dArray2;
            }
            if (d4 < d6) {
                double d7 = (d4 - d5) / (d6 - d5);
                double d8 = 1.0 - d7;
                dArray2[0] = this.components[n2 * 4] * d8 + this.components[(n2 + 1) * 4] * d7;
                dArray2[1] = this.components[n2 * 4 + 1] * d8 + this.components[(n2 + 1) * 4 + 1] * d7;
                dArray2[2] = this.components[n2 * 4 + 2] * d8 + this.components[(n2 + 1) * 4 + 2] * d7;
                dArray2[3] = 1.0;
                return dArray2;
            }
            ++n2;
        }
        dArray2[0] = this.components[4 * (this.size - 1)];
        dArray2[1] = this.components[4 * (this.size - 1) + 1];
        dArray2[2] = this.components[4 * (this.size - 1) + 2];
        dArray2[3] = 1.0;
        return dArray2;
    }
}

