/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="gaml_type", id=28, wraps={IType.class}, doc={@GamlAnnotations.doc(value="Metatype of all types in GAML")})
public class GamaMetaType
extends GamaType<IType<?>> {
    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    @GamlAnnotations.doc(value="The type of all types")
    public IType<?> cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        if (object instanceof IType) {
            IType iType = (IType)object;
            return iType;
        }
        if (object instanceof String) {
            String string = (String)object;
            return iScope.getTypes().decodeType(string);
        }
        return GamaMetaType.staticCast(object);
    }

    public static IType<?> staticCast(Object object) {
        return GamaType.of(object);
    }

    @Override
    public IType<?> getDefault() {
        return Types.NO_TYPE;
    }

    @GamlAnnotations.operator(value={"type_of"}, can_be_const=true, doc={@GamlAnnotations.doc(value="Returns the GAML type of the operand")})
    @GamlAnnotations.doc(value="Returns the GAML type of the operand", examples={@GamlAnnotations.example(value="string(type_of(\"a string\"))", equals="\"string\"", returnType="string"), @GamlAnnotations.example(value="string(type_of([1,2,3,4,5]))", equals="\"list<int>\"", returnType="string"), @GamlAnnotations.example(value="geometry g0 <- to_GAMA_CRS({121,14}, \"EPSG:4326\"); "), @GamlAnnotations.example(value="string(type_of(g0))", equals="\"point\"", returnType="string")})
    public static IType<?> typeOf(IScope iScope, Object object) {
        return GamaMetaType.staticCast(object);
    }

    @Override
    public IType<?> deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        if (!iMap.containsKey("name")) {
            return this.getDefault();
        }
        IType iType = iScope.getType(Cast.asString(iScope, iMap.get("name")));
        if (iType instanceof IContainerType) {
            IContainerType iContainerType = (IContainerType)iType;
            if (iMap.size() > 1) {
                return iContainerType.of(iScope.getType(Cast.asString(iScope, iMap.get("key"))), iScope.getType(Cast.asString(iScope, iMap.get("content"))));
            }
        }
        return iType;
    }
}

