/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.StoppingCriterion;
import gama.core.kernel.batch.StoppingCriterionMaxIt;
import gama.core.kernel.batch.optimization.ALocalSearchAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.Hashtable;
import java.util.List;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="iter_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of iterations. this number corresponds to the number of \"moves\" in the parameter space. For each move, the algorithm will test the whole neighborhood of the current solution, each neighbor corresponding to a particular set of parameters and thus to a run. Thus, there can be several runs per iteration (maximum: 2^(number of parameters)).")}), @GamlAnnotations.facet(name="init_solution", type={10}, optional=true, doc={@GamlAnnotations.doc(value="init solution: key: name of the variable, value: value of the variable")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max", "avr"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm is an implementation of the Hill Climbing algorithm. See the wikipedia article and [batch161 the batch dedicated page].", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the `hill_climbing` statement uses `method hill_climbing` instead of the expected `hill_climbing name: id` : ", examples={@GamlAnnotations.example(value="method hill_climbing [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method hill_climbing iter_max: 50 maximize : food_gathered; ", isExecutable=false)})})
public class HillClimbing
extends ALocalSearchAlgorithm {
    protected static final String ITER_MAX = "iter_max";
    StoppingCriterion stoppingCriterion = null;
    int maxIt;

    public HillClimbing(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    public boolean keepSol(ParametersSet parametersSet, Double d) {
        if (this.isMaximize() && d > this.getBestFitness() || !this.isMaximize() && d < this.getBestFitness()) {
            this.setBestFitness(d);
            return true;
        }
        return false;
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        this.setBestSolution(this.solutionInit);
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return this.getBestSolution();
        }
        double d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(this.getBestSolution()));
        this.initializeTestedSolutions();
        this.testedSolutions.put(this.getBestSolution(), d);
        int n = 0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Iteration", n);
        while (this.stoppingCriterion == null || !this.stoppingCriterion.stopSearchProcess(hashtable)) {
            List<ParametersSet> list = this.neighborhood.neighbor(iScope, this.getBestSolution());
            if (list.isEmpty()) break;
            this.setBestFitness(d);
            ParametersSet parametersSet = null;
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
                ParametersSet parametersSet2 = this.testSolutions(list);
                if (parametersSet2.containsKey(this.bestSolution)) {
                    parametersSet = this.bestSolution;
                }
            } else {
                for (ParametersSet parametersSet2 : list) {
                    if (parametersSet2 == null) continue;
                    Double d2 = (Double)this.testedSolutions.get(parametersSet2);
                    if (d2 == null) {
                        d2 = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet2));
                    }
                    this.testedSolutions.put(parametersSet2, d2);
                    if (!parametersSet2.equals(this.bestSolution)) continue;
                    parametersSet = parametersSet2;
                }
            }
            if (parametersSet == null) break;
            this.setBestSolution(parametersSet);
            d = this.getBestFitness();
            hashtable.put("Iteration", ++n);
        }
        return this.getBestSolution();
    }

    @Override
    protected void initParams(IScope iScope) {
        IExpression iExpression = this.getFacet(ITER_MAX);
        if (iExpression != null) {
            this.maxIt = Cast.asInt(iScope, iExpression.value(iScope));
            this.stoppingCriterion = new StoppingCriterionMaxIt(this.maxIt);
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Maximum number of iterations", "Calibration experiment", 1){

            @Override
            public Object value() {
                return HillClimbing.this.maxIt;
            }
        });
    }
}

