/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology;

import com.google.common.collect.Ordering;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.RootTopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.PathFactory;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;

public abstract class AbstractTopology
implements ITopology {
    protected IShape environment;
    protected RootTopology root;
    protected IContainer<?, IShape> places;
    private double[][] adjustedXYVector = null;
    private final PreparedGeometryFactory pgFact = new PreparedGeometryFactory();

    @Override
    public IType<?> getGamlType() {
        return Types.TOPOLOGY;
    }

    public AbstractTopology(IScope iScope, IShape iShape, RootTopology rootTopology) {
        this.setRoot(iScope, rootTopology);
        this.environment = iShape;
    }

    @Override
    public void setRoot(IScope iScope, RootTopology rootTopology) {
        this.root = rootTopology == null ? iScope.getSimulation().getTopology() : rootTopology;
    }

    @Override
    public List<Geometry> listToroidalGeometries(Geometry geometry) {
        Geometry geometry2 = geometry.copy();
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        AffineTransformation affineTransformation = new AffineTransformation();
        arrayList.add(geometry2);
        int n = 0;
        while (n < 8) {
            affineTransformation.setToTranslation(this.getAdjustedXYVector()[n][0], this.getAdjustedXYVector()[n][1]);
            arrayList.add(affineTransformation.transform(geometry2));
            ++n;
        }
        return arrayList;
    }

    public Geometry returnToroidalGeom(GamaPoint gamaPoint) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint);
        AffineTransformation affineTransformation = new AffineTransformation();
        arrayList.add(point);
        int n = 0;
        while (n < 8) {
            affineTransformation.setToTranslation(this.getAdjustedXYVector()[n][0], this.getAdjustedXYVector()[n][1]);
            arrayList.add(affineTransformation.transform((Geometry)point));
            ++n;
        }
        return GeometryUtils.GEOMETRY_FACTORY.buildGeometry(arrayList);
    }

    public Geometry returnToroidalGeom(IShape iShape) {
        if (iShape.isPoint()) {
            return this.returnToroidalGeom(iShape.getLocation());
        }
        return GeometryUtils.GEOMETRY_FACTORY.buildGeometry(this.listToroidalGeometries(iShape.getInnerGeometry()));
    }

    public Map<Geometry, IAgent> toroidalGeoms(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        IMap iMap = GamaMapFactory.create();
        for (IShape iShape : iContainer.iterable(iScope)) {
            IAgent iAgent = iShape.getAgent();
            if (iAgent == null) continue;
            iMap.put(GeometryUtils.GEOMETRY_FACTORY.buildGeometry(this.listToroidalGeometries(iAgent.getGeometry().getInnerGeometry())), iAgent);
        }
        return iMap;
    }

    protected void createVirtualEnvironments() {
        this.adjustedXYVector = new double[8][2];
        Envelope3D envelope3D = this.environment.getEnvelope();
        double d = envelope3D.getWidth();
        double d2 = envelope3D.getHeight();
        this.adjustedXYVector[0][0] = 0.0;
        this.adjustedXYVector[0][1] = d2;
        this.adjustedXYVector[1][0] = d;
        this.adjustedXYVector[1][1] = d2;
        this.adjustedXYVector[2][0] = d;
        this.adjustedXYVector[2][1] = 0.0;
        this.adjustedXYVector[3][0] = d;
        this.adjustedXYVector[3][1] = -d2;
        this.adjustedXYVector[4][0] = 0.0;
        this.adjustedXYVector[4][1] = -d2;
        this.adjustedXYVector[5][0] = -d;
        this.adjustedXYVector[5][1] = -d2;
        this.adjustedXYVector[6][0] = -d;
        this.adjustedXYVector[6][1] = 0.0;
        this.adjustedXYVector[7][0] = -d;
        this.adjustedXYVector[7][1] = d2;
    }

    protected boolean canCreateAgents() {
        return false;
    }

    @Override
    public void initialize(IScope iScope, IPopulation<? extends IAgent> iPopulation) throws GamaRuntimeException {
        if (!this.canCreateAgents()) {
            return;
        }
        iPopulation.createAgents(iScope, this.places);
    }

    @Override
    public void removeAgent(IAgent iAgent) {
        this.getSpatialIndex().remove(iAgent.getEnvelope(), iAgent);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        return PathFactory.newInstance(iScope, this, GamaListFactory.create(iScope, (IType)Types.POINT, iShape.getLocation(), iShape2.getLocation()), 0.0);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) throws GamaRuntimeException {
        return PathFactory.newInstance(iScope, this, GamaListFactory.wrap((IType)Types.POINT, gamaPoint, gamaPoint2), 0.0);
    }

    @Override
    public IList<GamaSpatialPath> kPathsBetween(IScope iScope, IShape iShape, IShape iShape2, int n) {
        IList<GamaSpatialPath> iList = GamaListFactory.create(Types.PATH);
        iList.add(this.pathBetween(iScope, iShape, iShape2));
        return iList;
    }

    @Override
    public IList<GamaSpatialPath> kPathsBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, int n) {
        IList<GamaSpatialPath> iList = GamaListFactory.create(Types.PATH);
        iList.add(this.pathBetween(iScope, gamaPoint, gamaPoint2));
        return iList;
    }

    @Override
    public void updateAgent(Envelope3D envelope3D, IAgent iAgent) {
        if (envelope3D != null && !envelope3D.isNull()) {
            this.getSpatialIndex().remove(envelope3D, iAgent);
        }
        this.getSpatialIndex().insert(iAgent);
    }

    @Override
    public IShape getEnvironment() {
        return this.environment;
    }

    @Override
    public GamaPoint normalizeLocation(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        boolean bl2 = this.environment.getGeometry().covers(gamaPoint);
        if (bl2) {
            return gamaPoint;
        }
        if (!this.isTorus()) {
            if (bl) {
                return null;
            }
            return gamaPoint;
        }
        GamaPoint gamaPoint2 = new GamaPoint();
        int n = 0;
        while (n < 8) {
            gamaPoint2.setLocation(gamaPoint).add(this.getAdjustedXYVector()[n][0], this.getAdjustedXYVector()[n][1], 0.0);
            if (this.environment.getGeometry().covers(gamaPoint2)) {
                return gamaPoint2;
            }
            ++n;
        }
        return bl ? null : gamaPoint;
    }

    @Override
    public GamaPoint getDestination(IScope iScope, GamaPoint gamaPoint, double d, double d2, boolean bl) {
        double d3 = d2 * Maths.cos(d);
        double d4 = d2 * Maths.sin(d);
        GamaPoint gamaPoint2 = gamaPoint.plus(d3, d4, 0.0);
        return this.normalizeLocation(iScope, gamaPoint2, bl);
    }

    @Override
    public GamaPoint getDestination3D(IScope iScope, GamaPoint gamaPoint, double d, double d2, double d3, boolean bl) throws GamaRuntimeException {
        double d4 = d3 * Maths.cos(d2) * Maths.cos(d);
        double d5 = d3 * Maths.cos(d2) * Maths.sin(d);
        double d6 = d3 * Maths.sin(d2);
        return this.normalizeLocation3D(iScope, new GamaPoint(gamaPoint.getX() + d4, gamaPoint.getY() + d5, gamaPoint.getZ() + d6), bl);
    }

    public GamaPoint normalizeLocation3D(IScope iScope, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        GamaPoint gamaPoint2 = this.normalizeLocation(iScope, gamaPoint, bl);
        if (gamaPoint2 == null) {
            return null;
        }
        double d = gamaPoint2.getZ();
        if (d < 0.0) {
            return null;
        }
        if (((GamaShape)this.environment.getGeometry()).getDepth() != null) {
            if (d > ((GamaShape)this.environment.getGeometry()).getDepth()) {
                return null;
            }
            return gamaPoint;
        }
        throw GamaRuntimeException.error("The environment must be a 3D environment (e.g shape <- cube(100)).", iScope);
    }

    @Override
    public ITopology copy(IScope iScope) throws GamaRuntimeException {
        return this._copy(iScope);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this._toGaml(bl);
    }

    protected abstract String _toGaml(boolean var1);

    protected abstract ITopology _copy(IScope var1) throws GamaRuntimeException;

    @Override
    public GamaPoint getRandomLocation(IScope iScope) {
        return GeometryUtils.pointInGeom(iScope, this.environment);
    }

    @Override
    public IContainer<?, IShape> getPlaces() {
        return this.places;
    }

    @Override
    public Collection<IAgent> getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, int n) {
        if (!this.isTorus()) {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Collector.AsList<IAgent> asList = Collector.getList();){
                return this.getSpatialIndex().firstAtDistance(iScope, iShape, 0.0, iAgentFilter, n, asList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Geometry geometry = this.returnToroidalGeom(iShape.getGeometry());
        Map<Geometry, IAgent> map = this.getTororoidalAgents(iShape, iScope, iAgentFilter);
        map.remove(geometry);
        if (map.size() <= n) {
            return map.values();
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>(map.keySet());
        iScope.getRandom().shuffleInPlace(arrayList);
        Ordering ordering = Ordering.natural().onResultOf(geometry2 -> Double.valueOf(geometry.distance(geometry2)));
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        for (Geometry geometry3 : ordering.leastOf(arrayList, n)) {
            iList.add(map.get(geometry3));
        }
        return iList;
    }

    @Override
    public IAgent getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        if (!this.isTorus()) {
            return this.getSpatialIndex().firstAtDistance(iScope, iShape, 0.0, iAgentFilter);
        }
        IAgent iAgent = null;
        Geometry geometry = this.returnToroidalGeom(iShape.getGeometry());
        Map<Geometry, IAgent> map = this.getTororoidalAgents(iShape, iScope, iAgentFilter);
        double d = Double.MAX_VALUE;
        for (Geometry geometry2 : map.keySet()) {
            double d2;
            IAgent iAgent2 = map.get(geometry2);
            if (iShape.getAgent() != null && iAgent2 == iShape.getAgent() || !((d2 = geometry.distance(geometry2)) < d)) continue;
            d = d2;
            iAgent = iAgent2;
        }
        return iAgent;
    }

    @Override
    public IAgent getAgentFarthestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        if (!this.isTorus()) {
            IAgent iAgent = null;
            double d = Double.MIN_VALUE;
            IContainer<?, IShape> iContainer = AbstractTopology.getFilteredAgents(iShape, iScope, iAgentFilter);
            for (IShape iShape2 : iContainer.iterable(iScope)) {
                double d2;
                if (!(iShape2 instanceof IAgent) || !((d2 = this.distanceBetween(iScope, iShape, iShape2).doubleValue()) > d)) continue;
                iAgent = (IAgent)iShape2;
                d = d2;
            }
            return iAgent;
        }
        IAgent iAgent = null;
        Geometry geometry = this.returnToroidalGeom(iShape);
        Map<Geometry, IAgent> map = this.getTororoidalAgents(iShape, iScope, iAgentFilter);
        double d = Double.MIN_VALUE;
        for (Geometry geometry2 : map.keySet()) {
            double d3;
            IAgent iAgent2 = map.get(geometry2);
            if (iShape.getAgent() != null && iAgent2 == iShape.getAgent() || !((d3 = geometry.distance(geometry2)) > d)) continue;
            d = d3;
            iAgent = iAgent2;
        }
        return iAgent;
    }

    public Map<Geometry, IAgent> getTororoidalAgents(IShape iShape, IScope iScope, IAgentFilter iAgentFilter) {
        return this.toroidalGeoms(iScope, AbstractTopology.getFilteredAgents(iShape, iScope, iAgentFilter));
    }

    public static IContainer<?, ? extends IShape> getFilteredAgents(IShape iShape, IScope iScope, IAgentFilter iAgentFilter) {
        IContainer<Integer, Object> iContainer;
        if (iAgentFilter != null) {
            if (iAgentFilter.hasAgentList()) {
                iContainer = iAgentFilter.getAgents(iScope);
            } else {
                iContainer = iScope.getSimulation().getAgents(iScope);
                iAgentFilter.filter(iScope, iShape, (Collection<? extends IShape>)((Object)iContainer));
            }
        } else {
            iContainer = iScope.getSimulation().getAgents(iScope);
        }
        return iContainer;
    }

    @Override
    public Collection<IAgent> getNeighborsOf(IScope iScope, IShape iShape, Double d, IAgentFilter iAgentFilter) throws GamaRuntimeException {
        if (!this.isTorus()) {
            return this.getSpatialIndex().allAtDistance(iScope, iShape, d, iAgentFilter);
        }
        Geometry geometry = this.returnToroidalGeom(iShape.getGeometry());
        Throwable throwable = null;
        Object var7_8 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            Map<Geometry, IAgent> map = this.getTororoidalAgents(iShape, iScope, iAgentFilter);
            IAgent iAgent = iShape.getAgent();
            for (Geometry geometry2 : map.keySet()) {
                double d2;
                IAgent iAgent2 = map.get(geometry2);
                if (iAgent != null && iAgent2 == iAgent || !((d2 = geometry.distance(geometry2)) <= d)) continue;
                asOrderedSet.add(iAgent2);
            }
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public double getWidth() {
        return this.environment.getEnvelope().getWidth();
    }

    @Override
    public double getHeight() {
        return this.environment.getEnvelope().getHeight();
    }

    @Override
    public void dispose() {
    }

    public static final boolean accept(PreparedGeometry preparedGeometry, Geometry geometry, ITopology.SpatialRelation spatialRelation) {
        if (spatialRelation == ITopology.SpatialRelation.OVERLAP) {
            return preparedGeometry.intersects(geometry);
        }
        if (spatialRelation == ITopology.SpatialRelation.INSIDE) {
            return preparedGeometry.covers(geometry);
        }
        if (spatialRelation == ITopology.SpatialRelation.COVER) {
            return preparedGeometry.coveredBy(geometry);
        }
        if (spatialRelation == ITopology.SpatialRelation.CROSS) {
            return preparedGeometry.crosses(geometry);
        }
        if (spatialRelation == ITopology.SpatialRelation.PARTIALLY_OVERLAP) {
            return preparedGeometry.overlaps(geometry);
        }
        return preparedGeometry.touches(geometry);
    }

    @Override
    public Collection<IAgent> getAgentsIn(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, ITopology.SpatialRelation spatialRelation) {
        boolean bl;
        if (iShape == null) {
            return Collections.EMPTY_SET;
        }
        boolean bl2 = bl = spatialRelation == ITopology.SpatialRelation.INSIDE;
        if (!this.isTorus()) {
            Envelope3D envelope3D = iShape.getEnvelope().intersection(this.environment.getEnvelope());
            try {
                Collection<IAgent> collection = this.getSpatialIndex().allInEnvelope(iScope, iShape, envelope3D, iAgentFilter, bl);
                PreparedGeometry preparedGeometry = this.pgFact.create(iShape.getInnerGeometry());
                collection.removeIf(iAgent -> {
                    if (iAgent.dead()) {
                        return true;
                    }
                    Geometry geometry = iAgent.getInnerGeometry();
                    return !AbstractTopology.accept(preparedGeometry, geometry, spatialRelation);
                });
                Collection<IAgent> collection2 = collection;
                return collection2;
            }
            finally {
                envelope3D.dispose();
            }
        }
        Throwable throwable = null;
        Object var7_10 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            for (IShape iShape2 : iShape.getGeometries()) {
                Geometry geometry = this.returnToroidalGeom(iShape2);
                PreparedGeometry preparedGeometry = this.pgFact.create(geometry);
                Map<Geometry, IAgent> map = this.getTororoidalAgents(iShape, iScope, iAgentFilter);
                for (Geometry geometry2 : map.keySet()) {
                    Geometry geometry3;
                    IAgent iAgent2 = map.get(geometry2);
                    if (iAgent2 == null || iAgent2.dead() || iShape.getAgent() != null && iAgent2 == iShape.getAgent() || !AbstractTopology.accept(preparedGeometry, geometry3 = iAgent2.getInnerGeometry(), spatialRelation)) continue;
                    asOrderedSet.add(iAgent2);
                }
            }
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ISpatialIndex getSpatialIndex() {
        return this.root.getSpatialIndex();
    }

    @Override
    public boolean isTorus() {
        return this.root.isTorus();
    }

    protected double[][] getAdjustedXYVector() {
        if (this.adjustedXYVector == null) {
            this.createVirtualEnvironments();
        }
        return this.adjustedXYVector;
    }
}

