/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.common.interfaces.ItemList;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.outputs.AbstractValuedDisplayOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.file.csv.CsvWriter;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Files;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.List;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="identifier of the monitor")}), @GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the (possibly dynamic) color of this output (default is a light gray)")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the condition under which this output should be refreshed (default is true)")}), @GamlAnnotations.facet(name="value", type={0}, optional=false, doc={@GamlAnnotations.doc(value="expression that will be evaluated to be displayed in the monitor")})}, omissible="name")
@GamlAnnotations.inside(symbols={"output", "permanent"})
@GamlAnnotations.doc(value="A monitor allows to follow the value of an arbitrary expression in GAML.", usages={@GamlAnnotations.usage(value="An example of use is:", examples={@GamlAnnotations.example(value="monitor \"nb preys\" value: length(prey as list) refresh_every: 5;  ", isExecutable=false)})})
public class MonitorOutput
extends AbstractValuedDisplayOutput
implements IExperimentDisplayable {
    private static String monitorFolder = "monitors";
    protected IExpression colorExpression = null;
    protected GamaColor color = null;
    protected GamaColor constantColor = null;
    protected List<Object> history;
    protected boolean shouldBeInitialized;

    public MonitorOutput(IDescription iDescription) {
        super(iDescription);
        this.setColor(this.getFacet("color"));
    }

    private void setColor(IExpression iExpression) {
        this.colorExpression = iExpression;
        if (iExpression != null && iExpression.isConst()) {
            this.constantColor = Types.COLOR.cast(null, iExpression.getConstValue(), null, false);
            return;
        }
        if (this.colorExpression == null) {
            SimulationAgent simulationAgent = GAMA.getSimulation();
            this.constantColor = simulationAgent != null ? simulationAgent.getColor() : GamaColor.get(Color.gray);
        }
    }

    public void setColor(GamaColor gamaColor) {
        this.color = gamaColor;
        this.constantColor = gamaColor;
        this.colorExpression = GAML.getExpressionFactory().createConst(gamaColor, Types.COLOR);
    }

    public MonitorOutput(IScope iScope, String string, String string2) {
        super(DescriptionFactory.create("monitor", "value", string2 == null ? "" : string2, "name", string == null ? string2 : string));
        this.shouldBeInitialized = true;
        this.setScope(iScope.copy("in monitor '" + string + "'"));
        this.setNewExpressionText(string2);
        if (this.getScope().init(this).passed()) {
            this.getScope().getSimulation().addOutput(this);
            this.setPaused(false);
            this.open();
        }
    }

    public boolean shouldBeInitialized() {
        return this.shouldBeInitialized;
    }

    public void shouldNotBeInitialized() {
        this.shouldBeInitialized = false;
    }

    @Override
    protected boolean shouldOpenView() {
        return GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue() == false;
    }

    @Override
    public String getViewId() {
        return "gama.ui.application.view.MonitorView";
    }

    @Override
    public String getId() {
        return this.getViewId() + ":" + this.getName();
    }

    @Override
    public boolean step(IScope iScope) {
        try {
            this.getScope().setCurrentSymbol(this);
            if (this.getScope().interrupted()) {
                return false;
            }
            if (this.getValue() != null) {
                try {
                    this.lastValue = this.getValue().value(this.getScope());
                    if (this.history != null) {
                        this.history.add(this.lastValue);
                    }
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    this.lastValue = String.valueOf(ItemList.ERROR_CODE) + gamaRuntimeException.getMessage();
                }
            } else {
                this.lastValue = null;
            }
            if (this.constantColor == null && this.colorExpression != null) {
                this.color = Cast.asColor(iScope, this.colorExpression.value(iScope));
            }
        }
        finally {
            iScope.setCurrentSymbol(null);
        }
        return true;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        return this.constantColor == null ? this.color : this.constantColor;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getName() {
        String string = super.getName();
        if (string == null) {
            string = this.getExpressionText();
        }
        return string;
    }

    @Override
    protected void setValue(IExpression iExpression) {
        IType<?> iType;
        if (this.history != null) {
            this.history.clear();
            this.history = null;
        }
        super.setValue(iExpression);
        if (iExpression != null && ((iType = iExpression.getGamlType()).isNumber() || iType.isContainer() && iType.getContentType().isNumber())) {
            this.history = GamaListFactory.create(iType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveHistory() {
        if (this.getScope() == null || this.history == null || this.history.isEmpty()) {
            return;
        }
        Files.newFolder(this.getScope(), monitorFolder);
        Object object = monitorFolder + "/monitor_" + this.getName() + "_cycle_" + this.getScope().getClock().getCycle() + ".csv";
        object = FileUtils.constructAbsoluteFilePath(this.getScope(), (String)object, false);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)object));
                try {
                    try (CsvWriter csvWriter = new CsvWriter(bufferedWriter);){
                        for (Object object2 : this.history) {
                            String[] stringArray = null;
                            if (object2 instanceof Number) {
                                stringArray = new String[]{object2.toString()};
                            } else if (object2 instanceof List) {
                                List list = (List)object2;
                                stringArray = new String[list.size()];
                                int n = 0;
                                while (n < stringArray.length) {
                                    stringArray[n] = list.get(n).toString();
                                    ++n;
                                }
                            }
                            csvWriter.writeRecord(stringArray);
                        }
                    }
                    if (bufferedWriter == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bufferedWriter == null) throw throwable;
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedWriter.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.getName()).append(": ");
        Object object = this.getLastValue();
        stringBuilder.append(object == null ? "nil" : (object instanceof IValue ? ((IValue)object).serializeToGaml(true) : object.toString()));
        if (this.isPaused()) {
            stringBuilder.append(" (paused)");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return null;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return false;
    }

    @Override
    public String getCategory() {
        return "Monitors";
    }
}

