/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IEventLayerDelegate;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.runtime.IScope;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MouseEventLayerDelegate
implements IEventLayerDelegate {
    @GamlAnnotations.constant(value="mouse_down", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the mouse button")})
    public static final String MOUSE_DOWN = "mouse_down";
    @GamlAnnotations.constant(value="mouse_up", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user releases the mouse button")})
    public static final String MOUSE_UP = "mouse_up";
    @GamlAnnotations.constant(value="mouse_move", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user moves the mouse")})
    public static final String MOUSE_MOVED = "mouse_move";
    @GamlAnnotations.constant(value="mouse_click", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses and releases the mouse button immediately")})
    public static final String MOUSE_CLICKED = "mouse_click";
    @GamlAnnotations.constant(value="mouse_enter", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the mouse enters the display")})
    public static final String MOUSE_ENTERED = "mouse_enter";
    @GamlAnnotations.constant(value="mouse_exit", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the mouse leaves the display")})
    public static final String MOUSE_EXITED = "mouse_exit";
    @GamlAnnotations.constant(value="mouse_menu", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user invokes the contextual menu")})
    public static final String MOUSE_MENU = "mouse_menu";
    @GamlAnnotations.constant(value="mouse_drag", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user drags the mouse, i.e. when he moves it with a button pressed.")})
    public static final String MOUSE_DRAGGED = "mouse_drag";
    public static final Set<String> EVENTS = new HashSet<String>(Arrays.asList("mouse_up", "mouse_down", "mouse_move", "mouse_enter", "mouse_exit", "mouse_menu", "mouse_drag"));

    @Override
    public boolean acceptSource(IScope iScope, Object object) {
        return Objects.equals(object, "default");
    }

    @Override
    public boolean createFrom(IScope iScope, Object object, EventLayerStatement eventLayerStatement) {
        return true;
    }

    @Override
    public Set<String> getEvents() {
        return EVENTS;
    }
}

