/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.server.CommandExecutor;
import gama.core.runtime.server.GamaServerConsoleListener;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.ISocketCommand;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.dev.DEBUG;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public abstract class GamaWebSocketServer
extends WebSocketServer {
    static final String SOCKET_ID = "socket_id";
    public static final int DEFAULT_PING_INTERVAL = 10000;
    protected final CommandExecutor cmdHelper = new CommandExecutor(this);
    public final boolean canPing;
    public final int pingInterval;
    protected final Map<WebSocket, Timer> pingTimers = new HashMap<WebSocket, Timer>();
    protected Json jsonErr = Json.getNew();
    protected final IConsoleListener console = new GamaServerConsoleListener();

    protected GamaWebSocketServer(int n, int n2) {
        super(new InetSocketAddress(n));
        this.setReuseAddr(true);
        this.canPing = n2 >= 0;
        this.pingInterval = n2;
        this.configureErrorStream();
    }

    private void configureErrorStream() {
        PrintStream printStream = new PrintStream(System.err){

            @Override
            public void println(String string) {
                super.println(string);
                GamaWebSocketServer.this.broadcast(GamaWebSocketServer.this.jsonErr.valueOf(new GamaServerMessage(GamaServerMessage.Type.GamaServerError, string)).toString());
            }
        };
        System.setErr(printStream);
    }

    public static String getSocketId(WebSocket webSocket) {
        return String.valueOf(webSocket.hashCode());
    }

    public void onStart() {
        DEBUG.BANNER((String)"GAMA", (String)"Server started", (String)"at port", (String)("" + this.getPort()));
    }

    public void onOpen(final WebSocket webSocket, ClientHandshake clientHandshake) {
        webSocket.send(Json.getNew().valueOf(new GamaServerMessage(GamaServerMessage.Type.ConnectionSuccessful, String.valueOf(webSocket.hashCode()))).toString());
        if (this.canPing) {
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (webSocket.isOpen()) {
                        webSocket.sendPing();
                    }
                }
            }, 0L, (long)this.pingInterval);
            this.pingTimers.put(webSocket, timer);
        }
    }

    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        Timer timer = this.pingTimers.remove(webSocket);
        if (timer != null) {
            timer.cancel();
        }
        DEBUG.OUT((Object)(String.valueOf(webSocket) + " has left the room!"));
    }

    public IMap<String, Object> extractParam(WebSocket webSocket, String string) {
        IMap iMap = null;
        try {
            Object object = Json.getNew().parse(string).toGamlValue(GAMA.getRuntimeScope());
            if (object instanceof IMap) {
                iMap = (IMap)object;
            } else {
                iMap = GamaMapFactory.create();
                iMap.put("contents", object);
            }
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception.toString());
            webSocket.send(this.jsonErr.valueOf(new GamaServerMessage(GamaServerMessage.Type.MalformedRequest, exception)).toString());
        }
        return iMap;
    }

    public void onMessage(WebSocket webSocket, String string) {
        try {
            ExperimentAgent experimentAgent;
            IMap<String, Object> iMap = this.extractParam(webSocket, string);
            iMap.put("server", (Object)this);
            DEBUG.OUT(iMap.get("type"));
            DEBUG.OUT(iMap.get("expr"));
            String string2 = iMap.get("exp_id") != null ? iMap.get("exp_id").toString() : "";
            String string3 = iMap.get(SOCKET_ID) != null ? iMap.get(SOCKET_ID).toString() : GamaWebSocketServer.getSocketId(webSocket);
            IExperimentPlan iExperimentPlan = this.getExperiment(string3, string2);
            if (iExperimentPlan != null && (experimentAgent = iExperimentPlan.getAgent()) != null && !iExperimentPlan.getController().isPaused()) {
                experimentAgent.postOneShotAction(iScope -> {
                    this.cmdHelper.process(webSocket, iMap);
                    return null;
                });
                return;
            }
            this.cmdHelper.process(webSocket, iMap);
        }
        catch (Exception exception) {
            DEBUG.OUT((Object)exception);
            webSocket.send(this.jsonErr.valueOf(new GamaServerMessage(GamaServerMessage.Type.GamaServerError, exception)).toString());
        }
    }

    public void onError(WebSocket webSocket, Exception exception) {
        exception.printStackTrace();
    }

    public abstract IExperimentPlan getExperiment(String var1, String var2);

    public abstract void execute(Runnable var1);

    public abstract void addExperiment(String var1, String var2, IExperimentPlan var3);

    public abstract GamaServerExperimentConfiguration obtainGuiServerConfiguration();

    public abstract IExperimentPlan retrieveExperimentPlan(WebSocket var1, IMap<String, Object> var2) throws ISocketCommand.CommandException;
}

