/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.file.json.IJsonConstants;
import gama.core.util.file.json.JsonArray;
import gama.core.util.file.json.JsonFloat;
import gama.core.util.file.json.JsonGamaContentsObject;
import gama.core.util.file.json.JsonGamaHandler;
import gama.core.util.file.json.JsonGamlAgent;
import gama.core.util.file.json.JsonGamlObject;
import gama.core.util.file.json.JsonInt;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonParser;
import gama.core.util.file.json.JsonReferenceObject;
import gama.core.util.file.json.JsonString;
import gama.core.util.file.json.JsonValue;
import gama.gaml.interfaces.IJsonable;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public final class Json
implements IJsonConstants {
    boolean firstPass = true;
    JsonObject agentReferences = new JsonObject(this);

    public static Json getNew() {
        return new Json();
    }

    public JsonValue valueOf(Object object) {
        boolean bl = this.firstPass;
        this.firstPass = false;
        JsonValue jsonValue = NULL;
        try {
            if (object == null) {
                jsonValue = NULL;
            } else if (object instanceof JsonValue) {
                JsonValue jsonValue2;
                jsonValue = jsonValue2 = (JsonValue)object;
            } else if (object instanceof IJsonable) {
                IJsonable iJsonable = (IJsonable)object;
                jsonValue = iJsonable.serializeToJson(this);
            } else if (object instanceof String) {
                String string = (String)object;
                jsonValue = this.valueOf(string);
            } else if (object instanceof Character) {
                Character c = (Character)object;
                jsonValue = this.valueOf(c);
            } else if (object instanceof Double) {
                Double d = (Double)object;
                jsonValue = this.valueOf(d);
            } else if (object instanceof Float) {
                Float f = (Float)object;
                jsonValue = this.valueOf(f.doubleValue());
            } else if (object instanceof Integer) {
                Integer n = (Integer)object;
                jsonValue = this.valueOf(n);
            } else if (object instanceof Long) {
                Long l = (Long)object;
                jsonValue = this.valueOf((int)l.longValue());
            } else if (object instanceof Boolean) {
                Boolean bl2 = (Boolean)object;
                jsonValue = this.valueOf(bl2);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                jsonValue = GamaListFactory.wrap(Types.NO_TYPE, collection).serializeToJson(this);
            } else if (object instanceof Map) {
                Map map = (Map)object;
                jsonValue = GamaMapFactory.wrap(map).serializeToJson(this);
            } else if (object instanceof Exception) {
                Exception exception = (Exception)object;
                jsonValue = this.object("exception", exception.getClass().getName(), "message", exception.getMessage(), "stack", this.array(Arrays.asList(exception.getStackTrace())));
            } else {
                jsonValue = this.valueOf(object.toString());
            }
        }
        finally {
            if (bl) {
                if (!this.agentReferences.isEmpty()) {
                    jsonValue = this.contents(jsonValue, this.agentReferences);
                }
                this.firstPass = true;
            }
        }
        return jsonValue;
    }

    public JsonGamaContentsObject contents(JsonValue jsonValue, JsonObject jsonObject) {
        return new JsonGamaContentsObject(jsonValue, jsonObject, this);
    }

    public JsonValue valueOf(int n) {
        return new JsonInt(Integer.toString(n, 10));
    }

    public JsonValue valueOf(long l) {
        return new JsonInt(Integer.toString((int)l));
    }

    public JsonValue valueOf(float f) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            return NULL;
        }
        return new JsonFloat(f);
    }

    public JsonValue valueOf(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return NULL;
        }
        return new JsonFloat(d);
    }

    public JsonValue valueOf(String string) {
        return string == null ? NULL : new JsonString(string);
    }

    public JsonValue valueOf(Character c) {
        return c == null ? NULL : new JsonString(c.toString());
    }

    public JsonValue valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public JsonArray array() {
        return new JsonArray(this);
    }

    public JsonArray array(int ... nArray) {
        if (nArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray(this);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            jsonArray.add(n3);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(long ... lArray) {
        if (lArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray(this);
        long[] lArray2 = lArray;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray2[n2];
            jsonArray.add(l);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(float ... fArray) {
        if (fArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray(this);
        float[] fArray2 = fArray;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray2[n2];
            jsonArray.add(f);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(double ... dArray) {
        if (dArray == null) {
            throw new NullPointerException("values is null");
        }
        JsonArray jsonArray = new JsonArray(this);
        double[] dArray2 = dArray;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray2[n2];
            jsonArray.add(d);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(boolean ... blArray) {
        JsonArray jsonArray = new JsonArray(this);
        boolean[] blArray2 = blArray;
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bl = blArray2[n2];
            jsonArray.add(bl);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(String ... stringArray) {
        JsonArray jsonArray = new JsonArray(this);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            jsonArray.add(string);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(Object[] objectArray) {
        JsonArray jsonArray = new JsonArray(this);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            jsonArray.add(object);
            ++n2;
        }
        return jsonArray;
    }

    public JsonArray array(Collection collection) {
        JsonArray jsonArray = new JsonArray(this);
        for (Object e : collection) {
            jsonArray.add(e);
        }
        return jsonArray;
    }

    public JsonReferenceObject reference(String string) {
        return new JsonReferenceObject(string, this);
    }

    public JsonObject object() {
        return new JsonObject(this);
    }

    public JsonObject object(String string, Object object) {
        return (JsonObject)this.object().add(string, object);
    }

    public JsonObject object(String string, Object object, String string2, Object object2) {
        return (JsonObject)this.object(string, object).add(string2, object2);
    }

    public JsonObject object(String string, Object object, String string2, Object object2, String string3, Object object3) {
        return (JsonObject)this.object(string, object, string2, object2).add(string3, object3);
    }

    public JsonObject object(String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) {
        return (JsonObject)this.object(string, object, string2, object2, string3, object3).add(string4, object4);
    }

    public JsonGamlObject typedObject(IType iType) {
        return new JsonGamlObject(iType.getName(), this);
    }

    public JsonGamlObject typedObject(IType iType, String string, Object object) {
        return (JsonGamlObject)this.typedObject(iType).add(string, object);
    }

    public JsonGamlObject typedObject(IType iType, String string, Object object, String string2, Object object2) {
        return (JsonGamlObject)this.typedObject(iType, string, object).add(string2, object2);
    }

    public JsonGamlObject typedObject(IType iType, String string, Object object, String string2, Object object2, String string3, Object object3) {
        return (JsonGamlObject)this.typedObject(iType, string, object, string2, object2).add(string3, object3);
    }

    public JsonGamlObject typedObject(IType iType, String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4) {
        return (JsonGamlObject)this.typedObject(iType, string, object, string2, object2, string3, object3).add(string4, object4);
    }

    public JsonGamlAgent agent(String string, int n) {
        JsonGamlAgent jsonGamlAgent = new JsonGamlAgent(string, n, this);
        return jsonGamlAgent;
    }

    public JsonValue parse(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        JsonGamaHandler jsonGamaHandler = new JsonGamaHandler(this);
        new JsonParser(jsonGamaHandler).parse(string);
        return jsonGamaHandler.getValue();
    }

    public JsonValue parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        JsonGamaHandler jsonGamaHandler = new JsonGamaHandler(this);
        new JsonParser(jsonGamaHandler).parse(reader);
        return jsonGamaHandler.getValue();
    }

    private String cutOffPointZero(String string) {
        if (string.endsWith(".0")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public void addRef(String string, Supplier<SerialisedAgent> supplier) {
        if (this.agentReferences.contains(string)) {
            return;
        }
        this.agentReferences.add(string, (Object)null);
        JsonValue jsonValue = this.valueOf(supplier.get());
        this.agentReferences.set(string, jsonValue);
    }
}

