/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.file.json.JsonValue;
import gama.core.util.file.json.JsonWriter;
import gama.gaml.operators.Cast;
import java.io.IOException;

class JsonFloat
extends JsonValue {
    private static final int DEFAULT_NUMBER_OF_DIGITS = 8;
    private final String string;

    JsonFloat(double d) {
        this(JsonFloat.formatOrdinate(d, 8));
    }

    JsonFloat(String string) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        this.string = string;
    }

    public static String formatOrdinate(double d, int n) {
        double d2 = Math.pow(10.0, n);
        if (Math.abs(d) >= Math.pow(10.0, -3.0) && d < Math.pow(10.0, 7.0)) {
            d = Math.floor(d * d2 + 0.5) / d2;
        }
        return Double.toString(d);
    }

    @Override
    public String toString() {
        return this.string;
    }

    @Override
    void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeNumber(this.string);
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public int asInt() {
        return (int)this.asDouble();
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.string, 10);
    }

    @Override
    public float asFloat() {
        return (float)this.asDouble();
    }

    @Override
    public double asDouble() {
        return Cast.asFloat(null, this.string);
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JsonFloat jsonFloat = (JsonFloat)object;
        return this.string.equals(jsonFloat.string);
    }

    @Override
    public Number toGamlValue(IScope iScope) {
        return this.asDouble();
    }
}

