/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.UniqueCoordinateSequence;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonAbstractObject;
import gama.core.util.file.json.JsonArray;
import gama.core.util.file.json.JsonGamlObject;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.Types;
import java.util.ArrayList;
import one.util.streamex.StreamEx;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JsonGeometryObject
extends JsonGamlObject {
    public static final String EPSG_PREFIX = "EPSG:";

    public JsonGeometryObject(Geometry geometry, Json json) {
        this(JsonGeometryObject.toGeoJsonObject(geometry, json), json);
        try {
            int n = CRS.lookupEpsgCode((CoordinateReferenceSystem)ProjectionFactory.getTargetCRSOrDefault(GAMA.getRuntimeScope()), (boolean)true);
            this.add("crs", json.object("type", "name", "properties", json.object("name", EPSG_PREFIX + n)));
        }
        catch (FactoryException factoryException) {}
    }

    public JsonGeometryObject(JsonAbstractObject jsonAbstractObject, Json json) {
        super(Types.GEOMETRY.getName(), jsonAbstractObject, json);
    }

    private static JsonAbstractObject toGeoJsonObject(Geometry geometry, Json json) {
        JsonObject jsonObject = new JsonObject(json);
        jsonObject.add("type", geometry.getGeometryType());
        JsonArray jsonArray = json.array();
        String string = "coordinates";
        if (geometry instanceof Point || geometry instanceof LineString) {
            jsonArray = (JsonArray)json.valueOf(GeometryUtils.getContourCoordinates(geometry));
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            jsonArray = JsonGeometryObject.toJsonArray(polygon, json);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            jsonArray = JsonGeometryObject.toJsonArray((GeometryCollection)multiPoint, json);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            jsonArray = JsonGeometryObject.toJsonArray((GeometryCollection)multiLineString, json);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            jsonArray = JsonGeometryObject.toJsonArray((GeometryCollection)multiPolygon, json);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                jsonArray.add(JsonGeometryObject.toGeoJsonObject(geometryCollection.getGeometryN(n), json));
                ++n;
            }
            string = "geometries";
        } else {
            throw new IllegalArgumentException("Unable to encode geometry " + geometry.getGeometryType());
        }
        jsonObject.add(string, jsonArray);
        return jsonObject;
    }

    private static JsonArray toJsonArray(Polygon polygon, Json json) {
        JsonArray jsonArray = json.array();
        jsonArray.add(json.valueOf(GeometryUtils.getContourCoordinates(polygon)));
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            jsonArray.add(json.valueOf(GeometryUtils.getContourCoordinates((LineString)polygon.getInteriorRingN(n))));
            ++n;
        }
        return jsonArray;
    }

    private static JsonArray toJsonArray(GeometryCollection geometryCollection, Json json) {
        JsonArray jsonArray = json.array();
        int n = 0;
        while (n < geometryCollection.getNumGeometries()) {
            Geometry geometry = geometryCollection.getGeometryN(n);
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                jsonArray.add(JsonGeometryObject.toJsonArray(polygon, json));
            } else if (geometry instanceof LineString || geometry instanceof Point) {
                jsonArray.add(json.valueOf(GeometryUtils.getContourCoordinates(geometry)));
            }
            ++n;
        }
        return jsonArray;
    }

    @Override
    public IShape toGamlValue(IScope iScope) {
        Geometry geometry = JsonGeometryObject.fromGeoJsonObject(this);
        GamaShape gamaShape = GamaShapeFactory.createFrom(geometry);
        gamaShape.setGeometricalType(IShape.Type.valueOf(this.get("inner_type").asString()));
        if (this.contains("depth")) {
            gamaShape.setDepth(this.get("depth").asDouble());
        }
        return gamaShape;
    }

    private static Geometry fromGeoJsonObject(JsonGeometryObject jsonGeometryObject) {
        return switch (jsonGeometryObject.get("type").asString()) {
            case "Point" -> JsonGeometryObject.buildPoint(jsonGeometryObject);
            case "LineString" -> JsonGeometryObject.buildLineString(jsonGeometryObject);
            case "Polygon" -> JsonGeometryObject.buildPolygon(jsonGeometryObject);
            case "MultiPoint" -> JsonGeometryObject.buildMultiPoint(jsonGeometryObject);
            case "MultiLineString" -> JsonGeometryObject.buildMultiLineString(jsonGeometryObject);
            case "MultiPolygon" -> JsonGeometryObject.buildMultiPolygon(jsonGeometryObject);
            case "GeometryCollection" -> JsonGeometryObject.buildGeometryCollection(jsonGeometryObject);
            case "Feature" -> JsonGeometryObject.manageFeature(jsonGeometryObject);
            case "FeatureCollection" -> JsonGeometryObject.manageFeatureCollection(jsonGeometryObject);
            default -> throw new RuntimeException("Unexpected value for type");
        };
    }

    private static Geometry manageFeatureCollection(JsonGeometryObject jsonGeometryObject) {
        return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection((Geometry[])StreamEx.of((Object)jsonGeometryObject.get("features").asArray()).select(JsonGeometryObject.class).map(JsonGeometryObject::manageFeature).toArray(Geometry.class));
    }

    private static Geometry manageFeature(JsonGeometryObject jsonGeometryObject) {
        return JsonGeometryObject.fromGeoJsonObject((JsonGeometryObject)jsonGeometryObject.get("geometry"));
    }

    private static Geometry buildGeometryCollection(JsonGeometryObject jsonGeometryObject) {
        return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection((Geometry[])StreamEx.of((Object)jsonGeometryObject.get("geometries").asArray()).select(JsonGeometryObject.class).map(JsonGeometryObject::fromGeoJsonObject).toArray(Geometry.class));
    }

    private static Geometry buildMultiPolygon(JsonGeometryObject jsonGeometryObject) {
        MultiPolygon multiPolygon = null;
        JsonArray jsonArray = jsonGeometryObject.get("coordinates").asArray();
        Polygon[] polygonArray = new Polygon[jsonArray.size()];
        int n = 0;
        for (JsonValue jsonValue : jsonArray) {
            JsonValue jsonValue22;
            ArrayList<CoordinateSequence> arrayList = new ArrayList<CoordinateSequence>();
            for (JsonValue jsonValue22 : jsonValue.asArray()) {
                arrayList.add(JsonGeometryObject.createCoordinateSequence(jsonValue22.asArray()));
            }
            if (arrayList.isEmpty()) continue;
            jsonValue22 = GeometryUtils.GEOMETRY_FACTORY.createLinearRing((CoordinateSequence)arrayList.get(0));
            LinearRing[] linearRingArray = null;
            if (arrayList.size() > 1) {
                linearRingArray = new LinearRing[arrayList.size() - 1];
                int n2 = 1;
                while (n2 < arrayList.size()) {
                    linearRingArray[n2 - 1] = GeometryUtils.GEOMETRY_FACTORY.createLinearRing((CoordinateSequence)arrayList.get(n2));
                    ++n2;
                }
            }
            polygonArray[n] = GeometryUtils.GEOMETRY_FACTORY.createPolygon((LinearRing)jsonValue22, linearRingArray);
            ++n;
        }
        multiPolygon = GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
        return multiPolygon;
    }

    private static Geometry buildMultiLineString(JsonGeometryObject jsonGeometryObject) {
        return GeometryUtils.GEOMETRY_FACTORY.createMultiLineString((LineString[])StreamEx.of((Object)jsonGeometryObject.get("coordinates").asArray()).map(jsonArray -> GeometryUtils.GEOMETRY_FACTORY.createLineString(JsonGeometryObject.createCoordinateSequence(jsonArray.asArray()))).toArray(LineString.class));
    }

    private static Geometry buildMultiPoint(JsonGeometryObject jsonGeometryObject) {
        return GeometryUtils.GEOMETRY_FACTORY.createMultiPoint(JsonGeometryObject.createCoordinateSequence(jsonGeometryObject.get("coordinates").asArray()));
    }

    private static Geometry buildPolygon(JsonGeometryObject jsonGeometryObject) {
        JsonValue jsonValue2;
        Polygon polygon = null;
        JsonArray jsonArray = jsonGeometryObject.get("coordinates").asArray();
        if (jsonArray.isEmpty()) {
            return GeometryUtils.GEOMETRY_FACTORY.createPolygon();
        }
        ArrayList<CoordinateSequence> arrayList = new ArrayList<CoordinateSequence>();
        for (JsonValue jsonValue2 : jsonArray) {
            arrayList.add(JsonGeometryObject.createCoordinateSequence(jsonValue2.asArray()));
        }
        jsonValue2 = GeometryUtils.GEOMETRY_FACTORY.createLinearRing((CoordinateSequence)arrayList.get(0));
        LinearRing[] linearRingArray = null;
        if (arrayList.size() > 1) {
            linearRingArray = new LinearRing[arrayList.size() - 1];
            int n = 1;
            while (n < arrayList.size()) {
                linearRingArray[n - 1] = GeometryUtils.GEOMETRY_FACTORY.createLinearRing((CoordinateSequence)arrayList.get(n));
                ++n;
            }
        }
        polygon = GeometryUtils.GEOMETRY_FACTORY.createPolygon((LinearRing)jsonValue2, linearRingArray);
        return polygon;
    }

    private static Geometry buildLineString(JsonGeometryObject jsonGeometryObject) {
        return GeometryUtils.GEOMETRY_FACTORY.createLineString(JsonGeometryObject.createCoordinateSequence(jsonGeometryObject.get("coordinates").asArray()));
    }

    private static Geometry buildPoint(JsonGeometryObject jsonGeometryObject) {
        JsonArray jsonArray = jsonGeometryObject.get("coordinates").asArray();
        if (jsonArray.isEmpty()) {
            return null;
        }
        jsonArray = jsonArray.get(0).asArray();
        UniqueCoordinateSequence uniqueCoordinateSequence = new UniqueCoordinateSequence(jsonArray.get(0).asDouble(), jsonArray.get(1).asDouble(), jsonArray.get(2).asDouble());
        return GeometryUtils.GEOMETRY_FACTORY.createPoint(uniqueCoordinateSequence);
    }

    private static CoordinateSequence createCoordinateSequence(JsonArray jsonArray) {
        ICoordinates iCoordinates = ICoordinates.ofLength(jsonArray.size());
        int n = 0;
        for (JsonValue jsonValue : jsonArray) {
            JsonArray jsonArray2 = jsonValue.asArray();
            if (jsonArray2.size() > 0) {
                iCoordinates.setOrdinate(n, 0, jsonArray2.get(0).asDouble());
            }
            if (jsonArray2.size() > 1) {
                iCoordinates.setOrdinate(n, 1, jsonArray2.get(1).asDouble());
            }
            if (jsonArray2.size() <= 2) continue;
            iCoordinates.setOrdinate(n++, 2, jsonArray2.get(2).asDouble());
        }
        return iCoordinates;
    }

    private static int readSRID(JsonGeometryObject jsonGeometryObject) {
        JsonObject jsonObject = jsonGeometryObject.get("crs").asObject();
        if (jsonObject != null) {
            JsonObject jsonObject2 = jsonObject.get("properties").asObject();
            String string = jsonObject2.get("name").asString();
            String[] stringArray = string.split(":");
            String string2 = stringArray[1];
            return Integer.parseInt(string2);
        }
        return 4326;
    }
}

