/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import gama.core.common.util.StringUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.gaml.descriptions.BasicExpressionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Set;

public class LabelExpressionDescription
extends BasicExpressionDescription
implements IExpression {
    final String value;

    public static IExpressionDescription create(String string) {
        return new LabelExpressionDescription(string);
    }

    @Override
    public IType<?> getDenotedType(IDescription iDescription) {
        return iDescription.getTypeNamed(this.value);
    }

    private LabelExpressionDescription(String string) {
        super((IExpression)null);
        this.value = StringUtils.unescapeJava(string);
    }

    @Override
    public IExpressionDescription cleanCopy() {
        return this;
    }

    @Override
    public IExpressionDescription compileAsLabel() {
        return this;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.value;
    }

    @Override
    public IExpression getExpression() {
        if (this.expression == null) {
            this.expression = this;
        }
        return this.expression;
    }

    @Override
    public IExpression compile(IDescription iDescription) {
        return this.getExpression();
    }

    @Override
    public boolean equalsString(String string) {
        return this.value.equals(string);
    }

    public Set<String> getStrings(IDescription iDescription, boolean bl) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Collector.AsSet asSet = Collector.getSet();){
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = this.value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                switch (c) {
                    case ' ': 
                    case '[': {
                        break;
                    }
                    case ',': 
                    case ']': {
                        asSet.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
                ++n2;
            }
            return asSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return new IGamlDescription.ConstantDoc("Constant string: " + this.getName());
    }

    @Override
    public String getTitle() {
        return "constant string '" + this.getName() + "'";
    }

    @Override
    public String getDefiningPlugin() {
        return null;
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public void setName(String string) {
    }

    public IType<String> getGamlType() {
        return Types.STRING;
    }

    @Override
    public Object value(IScope iScope) throws GamaRuntimeException {
        return this.value;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public String literalValue() {
        return this.value;
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this;
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }
}

