/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import gama.core.common.interfaces.ITyped;
import gama.dev.COUNTER;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementWithChildrenDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.operators.Strings;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.DoStatement;
import gama.gaml.statements.Facets;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;

public class StatementDescription
extends SymbolDescription {
    protected final Arguments passedArgs;

    static {
        DEBUG.ON();
    }

    public StatementDescription(String string, IDescription iDescription, boolean bl, EObject eObject, Facets facets2, Arguments arguments) {
        super(string, iDescription, eObject, facets2);
        this.setIf(IDescription.Flag.IsInvocation, "do".equals(string) || "invoke".equals(string));
        this.setIf(IDescription.Flag.IsSuperInvocation, "invoke".equals(string));
        this.passedArgs = arguments != null ? arguments : (bl ? this.createArgs() : null);
    }

    @Override
    protected SymbolSerializer<? extends SymbolDescription> createSerializer() {
        return STATEMENT_SERIALIZER;
    }

    @Override
    public void dispose() {
        if (this.isBuiltIn()) {
            return;
        }
        super.dispose();
        if (this.passedArgs != null) {
            this.passedArgs.dispose();
        }
    }

    private Arguments createArgs() {
        if (!this.hasFacets()) {
            return null;
        }
        if (this.hasFacet("with")) {
            Arguments arguments;
            try {
                arguments = GAML.getExpressionFactory().createArgumentMap(this.getAction(), this.getFacet("with"), this);
            }
            catch (Throwable throwable) {
                this.removeFacets("with");
                throw throwable;
            }
            this.removeFacets("with");
            return arguments;
        }
        if (!this.isInvocation() || !this.hasFacetsNotIn(DoStatement.DO_FACETS)) {
            return null;
        }
        Arguments arguments = new Arguments();
        this.visitFacets((string, iExpressionDescription) -> {
            if (!DoStatement.DO_FACETS.contains(string)) {
                arguments.put((String)string, (IExpressionDescription)iExpressionDescription);
            }
            return true;
        });
        return arguments;
    }

    public boolean isSuperInvocation() {
        return this.isSet(IDescription.Flag.IsSuperInvocation);
    }

    private ActionDescription getAction() {
        String string = this.getLitteral("action");
        if (string == null) {
            return null;
        }
        TypeDescription typeDescription = (TypeDescription)this.getDescriptionDeclaringAction(string, this.isSuperInvocation());
        ActionDescription actionDescription = null;
        if (typeDescription != null) {
            actionDescription = typeDescription.getAction(string);
        }
        return actionDescription;
    }

    @Override
    public StatementDescription copy(IDescription iDescription) {
        StatementDescription statementDescription = new StatementDescription(this.getKeyword(), iDescription, false, this.element, this.getFacetsCopy(), this.passedArgs == null ? null : this.passedArgs.cleanCopy());
        statementDescription.originName = this.getOriginName();
        return statementDescription;
    }

    @Override
    public boolean manipulatesVar(String string) {
        if ("equation".equals(this.getKeyword())) {
            Iterable<IDescription> iterable = this.getChildrenWithKeyword("=");
            for (IDescription iDescription : iterable) {
                IOperator iOperator;
                IExpressionDescription iExpressionDescription = iDescription.getFacet("left");
                iExpressionDescription.compile(iDescription);
                IExpression iExpression = iExpressionDescription.getExpression();
                if (!(iExpression instanceof IOperator) || !(iOperator = (IOperator)iExpression).arg(0).getName().equals(string) && (iOperator.arg(1) == null || !iOperator.arg(1).getName().equals(string))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean verifyArgs(Arguments arguments) {
        ActionDescription actionDescription = this.getAction();
        if (actionDescription == null) {
            return false;
        }
        return actionDescription.verifyArgs(this, arguments);
    }

    public Iterable<IDescription> getFormalArgs() {
        return this.getChildrenWithKeyword("arg");
    }

    public Arguments getPassedArgs() {
        return this.passedArgs == null ? Arguments.NULL : this.passedArgs;
    }

    @Override
    public String getName() {
        Object object = super.getName();
        if (object == null) {
            if ("aspect".equals(this.getKeyword())) {
                object = "default";
            } else {
                if ("reflex".equals(this.getKeyword())) {
                    this.warning("Reflexes should be named", "gaml.missing.name.issue", this.getUnderlyingElement(), new String[0]);
                }
                object = "_internal_" + this.getKeyword() + String.valueOf(COUNTER.GET_UNIQUE());
            }
            this.setName((String)object);
        }
        return object;
    }

    public String toString() {
        return this.getKeyword() + " " + this.getName();
    }

    @Override
    public String getTitle() {
        String string = this.getKeyword();
        string = "let".equals(string) ? "Declaration of temporary variable " : Strings.capitalize(null, string);
        String string2 = this.getName();
        if (string2.contains("_internal_") && (string2 = this.getLitteral("action")) == null) {
            string2 = "statement";
        }
        Object object = "";
        if (this.getMeta().isTopLevel()) {
            IDescription iDescription = this.getEnclosingDescription();
            object = iDescription == null ? " defined in " + this.getOriginName() : " of " + iDescription.getTitle();
        }
        return string + " " + string2 + " " + (String)object;
    }

    @Override
    public IDescription validate() {
        if (this.isSet(IDescription.Flag.Validated)) {
            return this;
        }
        IDescription iDescription = super.validate();
        if (this.passedArgs != null) {
            this.validatePassedArgs();
        }
        return iDescription;
    }

    public Arguments validatePassedArgs() {
        IDescription iDescription = this.getEnclosingDescription();
        this.passedArgs.forEachFacet((string, iExpressionDescription) -> {
            if (iExpressionDescription != null) {
                iExpressionDescription.compile(iDescription);
            }
            return true;
        });
        if (this.isInvocation()) {
            this.verifyArgs(this.passedArgs);
        } else if ("create".equals(this.keyword) || "restore".equals(this.keyword)) {
            this.verifyInits(this.passedArgs);
        }
        return this.passedArgs;
    }

    private void verifyInits(Arguments arguments) {
        SpeciesDescription speciesDescription = this.getGamlType().getDenotedSpecies();
        if (speciesDescription == null) {
            if (!arguments.isEmpty()) {
                this.warning("Impossible to verify the validity of the arguments. Use them at your own risk.", "gaml.unknonw.argument.issue");
            }
            return;
        }
        arguments.forEachFacet((string, iExpressionDescription) -> {
            if (!speciesDescription.hasAttribute((String)string) && speciesDescription instanceof ExperimentDescription && !speciesDescription.getModelDescription().hasAttribute((String)string)) {
                this.error("Attribute " + string + " does not exist in species " + speciesDescription.getName(), "gaml.unknonw.argument.issue", iExpressionDescription.getTarget(), null);
                return false;
            }
            IType<?> iType = Types.NO_TYPE;
            IType<?> iType2 = Types.NO_TYPE;
            VariableDescription variableDescription = speciesDescription.getAttribute((String)string);
            if (variableDescription != null) {
                iType2 = variableDescription.getGamlType();
            }
            if (iExpressionDescription != null) {
                IExpression iExpression = iExpressionDescription.getExpression();
                if (iExpression != null) {
                    iType = iExpression.getGamlType();
                }
                if (iType2 != Types.NO_TYPE && !iType.isTranslatableInto(iType2)) {
                    if ("create".equals(this.getKeyword()) || "restore".equals(this.getKeyword())) {
                        boolean bl;
                        boolean bl2 = bl = this.getFacet("from") != null && this.getFacet("from").getExpression().getGamlType().isAssignableFrom(Types.LIST);
                        if (bl && iType.equals(Types.STRING)) {
                            return true;
                        }
                    }
                    this.warning("The type of attribute " + string + " should be " + String.valueOf(iType2), "gaml.casting.issue", iExpressionDescription.getTarget(), iType2.toString());
                }
            }
            return true;
        });
    }

    @Override
    protected IExpression createVarWithTypes(String string) {
        IExpression iExpression;
        ITyped iTyped;
        this.compileTypeProviderFacets();
        IType<Object> iType = super.getGamlType();
        String string2 = this.getKeyword();
        IType<?> iType2 = iType.getContentType();
        if ("restore".equals(string2) || "create".equals(string2) || "capture".equals(string2) || "release".equals(string2)) {
            iType2 = iType;
            iType = Types.LIST;
        } else if (iType == Types.NO_TYPE) {
            if (this.hasFacet("value")) {
                iTyped = this.getFacetExpr("value");
                if (iTyped != null) {
                    iType = iTyped.getGamlType();
                }
            } else if (this.hasFacet("over")) {
                iTyped = this.getFacetExpr("over");
                if (iTyped != null) {
                    iType = Types.PAIR.isAssignableFrom(iTyped.getGamlType()) ? GamaType.findCommonType(iTyped.getGamlType().getContentType(), iTyped.getGamlType().getKeyType()) : iTyped.getGamlType().getContentType();
                }
            } else if (this.hasFacet("from") && this.hasFacet("to") && (iTyped = this.getFacetExpr("from")) != null) {
                iType = iTyped.getGamlType();
            }
        }
        iTyped = iType.getKeyType();
        if (this.hasFacet("as")) {
            iType2 = this.getTypeDenotedByFacet("as");
        } else if (this.hasFacet("species") && (iExpression = this.getFacetExpr("species")) != null) {
            iType2 = iExpression.getGamlType().getContentType();
            iTyped = iExpression.getGamlType().getKeyType();
        }
        return this.addNewTempIfNecessary(string, GamaType.from(iType, iTyped, iType2));
    }

    public IVarExpression addNewTempIfNecessary(String string, IType iType) {
        String string2 = this.getLitteral(string);
        IDescription iDescription = this.getEnclosingDescription();
        if (!(iDescription instanceof StatementWithChildrenDescription)) {
            this.error("Impossible to return " + string2, "gaml.general.issue");
            return null;
        }
        StatementWithChildrenDescription statementWithChildrenDescription = (StatementWithChildrenDescription)iDescription;
        return (IVarExpression)statementWithChildrenDescription.addTemp(this, string2, iType);
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        return true;
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        return true;
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        return Collections.EMPTY_LIST;
    }

    public Arguments createCompiledArgs() {
        return this.passedArgs;
    }
}

