/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.ICreateDelegate;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.SpeciesConstantExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="species", type={14, 11}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a species, the species of the agents to be created. In the case of simulations, the name 'simulation', which represents the current instance of simulation, can also be used as a proxy to their species")}), @GamlAnnotations.facet(name="returns", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="a new temporary variable name containing the list of created agents (a list, even if only one agent has been created)")}), @GamlAnnotations.facet(name="from", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a localized entity, a list of localized entities, a string (the path of a file), a file (shapefile, a .csv, a .asc or a OSM file) or a container returned by a request to a database")}), @GamlAnnotations.facet(name="number", type={1}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to an int, the number of created agents")}), @GamlAnnotations.facet(name="as", type={14}, optional=true, internal=true, doc={@GamlAnnotations.doc(value="optionally indicates a species into which to cast the created agents.")}), @GamlAnnotations.facet(name="with", type={10}, of=0, index=4, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a map, for each pair the key is a species attribute and the value the assigned value")})}, omissible="species")
@GamlAnnotations.doc(value="Allows an agent to create `number` agents of species `species`, to create agents of species `species` from a shapefile or to create agents of species `species` from one or several localized entities (discretization of the localized entity geometries).", usages={@GamlAnnotations.usage(value="Its simple syntax to create `an_int` agents of species `a_species` is:", examples={@GamlAnnotations.example(value="create a_species number: an_int;", isExecutable=false), @GamlAnnotations.example(value="create species_of(self) number: 5 returns: list5Agents;", isTestOnly=false)}), @GamlAnnotations.usage(value="If `number` equals 0 or species is not a species, the statement is ignored."), @GamlAnnotations.usage(value="In GAML modelers can create agents of species `a_species` (with two attributes `type` and `nature` with types corresponding to the types of the shapefile attributes) from a shapefile `the_shapefile` while reading attributes 'TYPE_OCC' and 'NATURE' of the shapefile. One agent will be created by object contained in the shapefile:", examples={@GamlAnnotations.example(value="create a_species from: the_shapefile with: [type:: read('TYPE_OCC'), nature::read('NATURE')];", isExecutable=false)}), @GamlAnnotations.usage(value="In order to create agents from a .csv file, facet `header` can be used to specified whether we can use columns header:", examples={@GamlAnnotations.example(value="create toto from: \"toto.csv\" header: true with:[att1::read(\"NAME\"), att2::read(\"TYPE\")];", isExecutable=false), @GamlAnnotations.example(value="or", isExecutable=false), @GamlAnnotations.example(value="create toto from: \"toto.csv\" with:[att1::read(0), att2::read(1)]; //with read(int), the index of the column", isExecutable=false)}), @GamlAnnotations.usage(value="Similarly to the creation from shapefile, modelers can create agents from a set of geometries. In this case, one agent per geometry will be created (with the geometry as shape)", examples={@GamlAnnotations.example(value="create species_of(self) from: [square(4), circle(4)]; \t// 2 agents have been created, with shapes respectively square(4) and circle(4)"), @GamlAnnotations.example(value="create species_of(self) from: [square(4), circle(4)] returns: new_agt;", isTestOnly=true), @GamlAnnotations.example(value="new_agt[0].shape", equals="square(4)", returnType="geometry", isTestOnly=true), @GamlAnnotations.example(value="new_agt[1].shape", equals="circle(4)", returnType="geometry", isTestOnly=true)}), @GamlAnnotations.usage(value="Created agents are initialized following the rules of their species. If one wants to refer to them after the statement is executed, the returns keyword has to be defined: the agents created will then be referred to by the temporary variable it declares. For instance, the following statement creates 0 to 4 agents of the same species as the sender, and puts them in the temporary variable children for later use.", examples={@GamlAnnotations.example(value="create species (self) number: rnd (4) returns: children;", test=false), @GamlAnnotations.example(value="ask children {", test=true), @GamlAnnotations.example(value="        // ...", test=false), @GamlAnnotations.example(value="}", test=false)}), @GamlAnnotations.usage(value="If one wants to specify a special initialization sequence for the agents created, create provides the same possibilities as ask. This extended syntax is:", examples={@GamlAnnotations.example(value="create a_species number: an_int {", isExecutable=false), @GamlAnnotations.example(value="     [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="The same rules as in ask apply. The only difference is that, for the agents created, the assignments of variables will bypass the initialization defined in species. For instance:", examples={@GamlAnnotations.example(value="create species(self) number: rnd (4) returns: children {", isExecutable=false), @GamlAnnotations.example(value="     set location <- myself.location + {rnd (2), rnd (2)}; // tells the children to be initially located close to me", isExecutable=false), @GamlAnnotations.example(value="     set parent <- myself; // tells the children that their parent is me (provided the variable parent is declared in this species) ", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Deprecated uses: ", examples={@GamlAnnotations.example(value="// Simple syntax", isExecutable=false), @GamlAnnotations.example(value="create species: a_species number: an_int;", isExecutable=false)})})
@validator(value=CreateValidator.class)
@serializer(value=CreateSerializer.class)
public class CreateStatement
extends AbstractStatementSequence
implements IStatement.WithArgs {
    private Arguments init;
    private final IExpression from;
    private final IExpression number;
    private final IExpression species;
    private final IExpression header;
    private final String returns = this.getLiteral("returns");
    private final RemoteSequence sequence;
    static List<ICreateDelegate> DELEGATES = new ArrayList<ICreateDelegate>();
    static List<IType> DELEGATE_TYPES = new ArrayList<IType>();

    public static void addDelegate(ICreateDelegate iCreateDelegate) {
        DELEGATES.add(iCreateDelegate);
        IType<?> iType = iCreateDelegate.fromFacetType();
        if (iType != null && iType != Types.NO_TYPE) {
            DELEGATE_TYPES.add(iCreateDelegate.fromFacetType());
        }
    }

    public static void removeDelegate(ICreateDelegate iCreateDelegate) {
        DELEGATES.remove(iCreateDelegate);
    }

    public CreateStatement(IDescription iDescription) {
        super(iDescription);
        this.from = this.getFacet("from");
        this.number = this.getFacet("number");
        this.species = this.getFacet("species");
        this.header = this.getFacet("header");
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of create ");
        this.setName("create");
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence.setChildren(iterable);
    }

    @Override
    public void enterScope(IScope iScope) {
        if (this.returns != null) {
            iScope.addVarWithValue(this.returns, null);
        }
        super.enterScope(iScope);
    }

    protected IPopulation findPopulation(IScope iScope) {
        IPopulation<? extends IAgent> iPopulation;
        IAgent iAgent = iScope.getAgent();
        if (this.species == null) {
            return iAgent.getPopulationFor(this.description.getSpeciesContext().getName());
        }
        ISpecies iSpecies = Cast.asSpecies(iScope, this.species.value(iScope));
        if (iSpecies == null && (iPopulation = this.species.getDenotedType().getSpeciesName()) != null) {
            iSpecies = iScope.getModel().getSpecies((String)((Object)iPopulation));
        }
        if (iSpecies == null) {
            throw GamaRuntimeException.error("No population of " + this.species.serializeToGaml(false) + " is accessible in the context of " + String.valueOf(iAgent) + ".", iScope);
        }
        iPopulation = iAgent.getPopulationFor(iSpecies);
        if (iPopulation == null && iSpecies instanceof ExperimentPlan) {
            ExperimentPlan experimentPlan = (ExperimentPlan)iSpecies;
            if (iAgent instanceof IMacroAgent) {
                ExperimentPlan experimentPlan2 = experimentPlan;
                experimentPlan2.getClass();
                iPopulation = new ExperimentPlan.ExperimentPopulation(experimentPlan2, iSpecies);
                IScope iScope2 = experimentPlan.getExperimentScope();
                iPopulation.initializeFor(iScope2);
                ((IMacroAgent)iAgent).addExternMicroPopulation(iSpecies.getDescription().getModelDescription().getAlias() + "." + iSpecies.getName(), iPopulation);
            }
        }
        return iPopulation;
    }

    @Override
    public IList<? extends IAgent> privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Integer n;
        Integer n2 = n = this.number == null ? null : Cast.asInt(iScope, this.number.value(iScope));
        if (this.from == null && n != null && n <= 0) {
            return GamaListFactory.EMPTY_LIST;
        }
        IPopulation iPopulation = this.findPopulation(iScope);
        if (iPopulation == null || iPopulation.getSpecies() == null) {
            throw GamaRuntimeException.error("Impossible to determine the species of the agents to create", iScope);
        }
        this.checkPopulationValidity(iPopulation, iScope);
        IList<Map<String, Object>> iList = GamaListFactory.create((IType)Types.MAP, n == null ? 10 : n);
        Object object = this.getSource(iScope);
        IList<? extends IAgent> iList2 = null;
        for (ICreateDelegate iCreateDelegate : DELEGATES) {
            if (!iCreateDelegate.acceptSource(iScope, object)) continue;
            iCreateDelegate.createFrom(iScope, iList, n, object, this.init, this);
            if (!iCreateDelegate.handlesCreation()) break;
            iList2 = iCreateDelegate.createAgents(iScope, iPopulation, iList, this, this.sequence);
            break;
        }
        if (iList2 == null) {
            iList2 = this.createAgents(iScope, iPopulation, iList);
        }
        if (this.returns != null) {
            iScope.setVarValue(this.returns, iList2);
        }
        return iList2;
    }

    protected void checkPopulationValidity(IPopulation iPopulation, IScope iScope) throws GamaRuntimeException {
        String string;
        if (iPopulation instanceof SimulationPopulation && !(iScope.getAgent() instanceof ExperimentAgent)) {
            throw GamaRuntimeException.error("Simulations can only be created within experiments", iScope);
        }
        SpeciesDescription speciesDescription = iPopulation.getSpecies().getDescription();
        String string2 = speciesDescription.isAbstract() ? "abstract" : (speciesDescription.isMirror() ? "a mirror" : (speciesDescription.isBuiltIn() ? "built-in" : (string = speciesDescription.isGrid() ? "a grid" : null)));
        if (string != null) {
            throw GamaRuntimeException.error(speciesDescription.getName() + "is " + string + " and cannot be instantiated.", iScope);
        }
    }

    private Object getSource(IScope iScope) {
        IList<IShape> iList;
        IList<IShape> iList2 = iList = this.from == null ? null : this.from.value(iScope);
        if (iList instanceof IShape) {
            iList = GamaListFactory.wrap((IType)Types.GEOMETRY, (IShape)((Object)iList));
        }
        return iList;
    }

    public IList<? extends IAgent> createAgents(IScope iScope, IPopulation<? extends IAgent> iPopulation, List<Map<String, Object>> list) {
        IContainer.Addressable<String, Object> addressable;
        if (iPopulation == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        boolean bl = false;
        if (iPopulation.getHost() instanceof ExperimentAgent && (addressable = (ExperimentAgent)iPopulation.getHost()).isScheduled()) {
            bl = true;
        }
        addressable = iPopulation.createAgents(iScope, list.size(), list, false, bl, this.sequence);
        if (iPopulation instanceof ExperimentPlan.ExperimentPopulation) {
            iPopulation.setHost(iScope.getExperiment());
            for (IAgent iAgent : iPopulation) {
                ((ExperimentAgent)iAgent)._init_(iScope);
                SimulationAgent simulationAgent = ((ExperimentAgent)iAgent).getSimulation();
                simulationAgent.adoptTopologyOf(iScope.getSimulation());
                if (!simulationAgent.getScheduled().booleanValue()) {
                    simulationAgent._init_(simulationAgent.getScope());
                }
                if (simulationAgent.getOutputManager() == null) continue;
                simulationAgent.getOutputManager().init(simulationAgent.getScope());
            }
        }
        return addressable;
    }

    public void fillWithUserInit(IScope iScope, Map map) {
        if (this.init == null) {
            return;
        }
        iScope.pushReadAttributes(map);
        try {
            this.init.forEachFacet((string, iExpressionDescription) -> {
                map.put(string, iExpressionDescription.getExpression().value(iScope));
                return true;
            });
        }
        finally {
            iScope.popReadAttributes();
        }
    }

    @Override
    public void setFormalArgs(Arguments arguments) {
        this.init = arguments;
    }

    @Override
    public void setRuntimeArgs(IScope iScope, Arguments arguments) {
    }

    public IExpression getHeader() {
        return this.header;
    }

    @Override
    public void dispose() {
        if (this.init != null) {
            this.init.dispose();
        }
        this.init = null;
        this.sequence.dispose();
        super.dispose();
    }

    public static class CreateSerializer
    extends SymbolSerializer.StatementSerializer {
        @Override
        protected void serializeArgs(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            StatementDescription statementDescription = (StatementDescription)symbolDescription;
            Arguments arguments = statementDescription.getPassedArgs();
            if (arguments == null || arguments.isEmpty()) {
                return;
            }
            stringBuilder.append("with: [");
            arguments.forEachFacet((string, iExpressionDescription) -> {
                stringBuilder.append((String)string).append("::").append(iExpressionDescription.serializeToGaml(false));
                stringBuilder.append(", ");
                return true;
            });
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append("]");
        }
    }

    public static class CreateValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            IExpression iExpression = statementDescription.getFacetExpr("species");
            if (iExpression == null) {
                statementDescription.error("The species to instantiate cannot be determined", "gaml.unknown.species.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription = iExpression.getGamlType().getDenotedSpecies();
            if (speciesDescription == null) {
                statementDescription.error("The species to instantiate cannot be determined", "gaml.unknown.species.issue", "species", new String[0]);
                return;
            }
            if (iExpression instanceof SpeciesConstantExpression) {
                boolean bl = speciesDescription.isAbstract();
                boolean bl2 = speciesDescription.isMirror();
                boolean bl3 = speciesDescription.isGrid();
                boolean bl4 = speciesDescription.isBuiltIn();
                if (bl || bl2 || bl3 || bl4) {
                    String string2 = bl ? "abstract" : (bl2 ? "a mirror" : (bl3 ? "a grid" : (bl4 ? "built-in" : "")));
                    statementDescription.error(speciesDescription.getName() + " is " + string2 + " and cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
                    return;
                }
            } else if (!(speciesDescription instanceof ModelDescription)) {
                statementDescription.info("The actual species will be determined at runtime. This can lead to errors if it cannot be instantiated", "gaml.wrong.type.issue", "species", new String[0]);
            }
            if (speciesDescription instanceof ModelDescription && !(statementDescription.getSpeciesContext() instanceof ExperimentDescription)) {
                statementDescription.error("Simulations can only be created within experiments", "gaml.wrong.context.issue", "species", new String[0]);
                return;
            }
            SpeciesDescription speciesDescription2 = statementDescription.getSpeciesContext();
            SpeciesDescription speciesDescription3 = speciesDescription.getMacroSpecies();
            if (speciesDescription3 == null) {
                statementDescription.error("The macro-species of " + String.valueOf(iExpression) + " cannot be determined");
                return;
            }
            if (!(speciesDescription3 instanceof ModelDescription && speciesDescription2 instanceof ModelDescription || speciesDescription2 == speciesDescription3 || speciesDescription2.hasMacroSpecies(speciesDescription3) || speciesDescription2.hasParent(speciesDescription3))) {
                statementDescription.error("No instance of " + speciesDescription3.getName() + " available for creating instances of " + speciesDescription.getName());
                return;
            }
            IExpression iExpression2 = statementDescription.getFacetExpr("from");
            if (iExpression2 != null) {
                IType<?> iType = iExpression2.getGamlType();
                boolean bl = false;
                for (IType iType2 : DELEGATE_TYPES) {
                    bl = iType2.isAssignableFrom(iType);
                    if (bl) break;
                }
                if (!bl) {
                    statementDescription.warning("Facet 'from' expects an expression with one of the following types: " + String.valueOf(DELEGATE_TYPES), "gaml.wrong.type.issue", "from", new String[0]);
                }
            }
            Arguments arguments = statementDescription.getPassedArgs();
            arguments.forEachFacet((string, iExpressionDescription) -> {
                boolean bl;
                boolean bl2 = bl = !speciesDescription.isExperiment() && !speciesDescription.hasAttribute((String)string);
                if (bl) {
                    statementDescription.error("Attribute " + string + " is not defined in species " + iExpression.getName(), "gaml.unknown.var.issue");
                }
                return !bl;
            });
        }
    }
}

