/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={0}, optional=false, doc={@GamlAnnotations.doc(value="The agent, list of agents, geometry to focus on")})}, omissible="value")
@GamlAnnotations.doc(value="Allows to focus on the passed parameter in all available displays. Passing 'nil' for the parameter will make all screens return to their normal zoom", usages={@GamlAnnotations.usage(value="Focuses on an agent, a geometry, a set of agents, etc...", examples={@GamlAnnotations.example(value="focus_on my_species(0);")})})
public class FocusStatement
extends AbstractStatement {
    final IExpression value = this.getFacet("value");

    @Override
    public String getTrace(IScope iScope) {
        return "";
    }

    public FocusStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        if (iAgent != null && !iAgent.dead()) {
            IShape iShape = Cast.asGeometry(iScope, this.value.value(iScope));
            GAMA.getGui().setFocusOn(iShape);
        }
        return this.value.value(iScope);
    }
}

