/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.graph.IGraph;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractContainerStatement;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="item", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the right member of the removal assignment ('cont >> expr;') is an expression expr that evaluates to the element(s) to be removed from the container")}), @GamlAnnotations.facet(name="from", type={16, 14, 11, 13}, optional=false, doc={@GamlAnnotations.doc(value="the left member of the removal assignment ('cont >> expr;') is an expression cont that evaluates to a container (list, map, graph) ")}), @GamlAnnotations.facet(name="index", type={0}, optional=true, doc={@GamlAnnotations.doc(value="any expression, the key at which to remove the element from the container ")}), @GamlAnnotations.facet(name="key", type={0}, optional=true, doc={@GamlAnnotations.doc(value="If a key/index is to be removed (instead of a value), it must be indicated by using `container[]` instead of `container`")}), @GamlAnnotations.facet(name="all", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the symbol '>>-' allows to pass a container as item so as to remove all of its elements from the receiving container. If the item is not a container, all of its occurrences are removed")})}, omissible="item")
@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@GamlAnnotations.doc(value="A statement used to remove items from containers. It can be written using the classic syntax (`remove ... from: ...`) or a compact one, which is now preferred.\n- To remove an element from a container (other than a matrix), use `container >> element;` or `container >- element;` (classic form: `remove element from: container;`) \n- To remove an index/key from a container (other than a matrix) use `container[] >> index` or `container[] >- index` (classic form: `remove key: index from: container;`)\n- To remove all the elements contained in another container, use `container >>- elements;` (classic form: `remove all: elements from: container;`)\n- To remove all the indexes contained in another container, use `container[] >>- indices;` (classic form: `remove key: indices all: true from: container;`)\n- To remove all the occurences of an element in the container, use `container >>- element;` (classic form: `remove element from: container all: true;`)", usages={@GamlAnnotations.usage(value="This statement should be used in the following ways, depending on the kind of container used and the expected action on it:", examples={@GamlAnnotations.example(value="expr_container >> expr (or expr_container >- expr) to remove an element", isExecutable=false), @GamlAnnotations.example(value="expr_container[] >> expr (or expr_container[] >- expr) to remove an index or a key;", isExecutable=false), @GamlAnnotations.example(value="expr_container >>- expr (to remove all occurences of expr), expr_container >>- container_of_expr (to remove all the elements in the passed argument), expr_container[] >>- container_of_expr (to remove all the index/keys in the passed argument)", isExecutable=false)}), @GamlAnnotations.usage(value="In the case of list, `>-` of `>>` is used to remove the first occurence of a given expression, whereas `>>-` is used to remove all its occurrences. Indices can also be removed in the same way", examples={@GamlAnnotations.example(value="list<int> removeList <- [3,2,1,2,3];"), @GamlAnnotations.example(value="removeList >- 2;", var="removeList", equals="[3,1,2,3]", returnType="null"), @GamlAnnotations.example(value="removeList >>- 3;", var="removeList", equals="[1,2]", returnType="null"), @GamlAnnotations.example(value="removeList[] >- 1;", var="removeList", equals="[1]", returnType="null")}), @GamlAnnotations.usage(value="In the case of map, to remove the pair identified by a given key, we have to specify that we are working on the keys. Same for lists", examples={@GamlAnnotations.example(value="map<string,int> removeMap <- [\"x\"::5, \"y\"::7, \"z\"::7];"), @GamlAnnotations.example(value="removeMap[] >- \"x\";", var="removeMap", equals="[\"y\"::7, \"z\"::7]", returnType="null"), @GamlAnnotations.example(value="removeMap[] >>- removeMap.keys;", var="removeMap", equals="map([])", returnType="null")}), @GamlAnnotations.usage(value="A map can be managed as a list of pairs: remove then operates on the values by default", examples={@GamlAnnotations.example(value="map<string,int> removeMapList <- [\"x\"::5, \"y\"::7, \"z\"::7, \"t\"::5];"), @GamlAnnotations.example(value="removeMapList >> 7;", var="removeMapList", equals="[\"x\"::5, \"z\"::7, \"t\"::5]", returnType="null"), @GamlAnnotations.example(value="removeMapList >>- [5,7];", var="removeMapList", equals="[\"t\"::5]", returnType="null"), @GamlAnnotations.example(value="removeMapList[] >- \"t\";", var="removeMapList", equals="map([])", returnType="null")}), @GamlAnnotations.usage(value="In the case of a graph, if a node is removed, all edges to and from this node are also removed. Note that the use of edge()/node()/edges()/nodes() operators is necessary", examples={@GamlAnnotations.example(value="graph removeGraph <- as_edge_graph([{1,2}::{3,4},{3,4}::{5,6}]);"), @GamlAnnotations.example(value="removeGraph >> node(1,2);"), @GamlAnnotations.example(value="removeGraph.vertices", returnType="list", equals="[{3,4},{5,6}]"), @GamlAnnotations.example(value="removeGraph.edges", returnType="list", equals="[polyline({3,4}::{5,6})]"), @GamlAnnotations.example(value="removeGraph >> edge({3,4},{5,6});"), @GamlAnnotations.example(value="removeGraph.vertices", returnType="list", equals="[{3,4},{5,6}]"), @GamlAnnotations.example(value="removeGraph.edges", returnType="list", equals="[]")}), @GamlAnnotations.usage(value="In the case of an agent or a shape, `remove` allows to remove an attribute from the attributes map of the receiver. However, for agents, it will only remove attributes that have been added dynamically, not the ones defined in the species or in its built-in parent.", examples={@GamlAnnotations.example(value="global {", isExecutable=false), @GamlAnnotations.example(value="   init {", isExecutable=false), @GamlAnnotations.example(value="      create speciesRemove;", isExecutable=false), @GamlAnnotations.example(value="      speciesRemove sR <- speciesRemove(0);", isExecutable=false), @GamlAnnotations.example(value="      sR['a'] <- 100; \t// sR.a now equals 100", isExecutable=false), @GamlAnnotations.example(value="      sR[] >> \"a\"; \t// sR.a does not exist anymore", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false)}), @GamlAnnotations.usage(value="This statement can not be used on *matrix*.")}, see={"add", "put"})
@serializer(value=RemoveSerializer.class)
@validator(value=AbstractContainerStatement.ContainerValidator.class)
public class RemoveStatement
extends AbstractContainerStatement {
    public RemoveStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("remove from " + this.list.serializeToGaml(false));
    }

    @Override
    protected void apply(IScope iScope, Object object, Object object2, IContainer.Modifiable modifiable) throws GamaRuntimeException {
        if (object2 == null) {
            if (this.asAll) {
                if (this.asAllValues) {
                    modifiable.removeValues(iScope, (IContainer)object);
                } else {
                    modifiable.removeAllOccurrencesOfValue(iScope, object);
                }
            } else {
                modifiable.removeValue(iScope, object);
            }
        } else if (this.asAllIndexes) {
            modifiable.removeIndexes(iScope, (IContainer)object2);
        } else {
            modifiable.removeIndex(iScope, object2);
        }
    }

    @Override
    protected Object buildValue(IScope iScope, IGraph iGraph) {
        return this.item.value(iScope);
    }

    @Override
    protected Object buildIndex(IScope iScope, IGraph iGraph) {
        return this.index.value(iScope);
    }

    public static class RemoveSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            IExpression iExpression = symbolDescription.getFacetExpr("item");
            IExpression iExpression2 = symbolDescription.getFacetExpr("to");
            IExpression iExpression3 = symbolDescription.getFacetExpr("all");
            IExpression iExpression4 = symbolDescription.getFacetExpr("at");
            boolean bl2 = iExpression3 != null && iExpression3.isConst() && "true".equals(iExpression3.literalValue());
            stringBuilder.append(iExpression2.serializeToGaml(bl));
            if (iExpression4 != null) {
                stringBuilder.append('[');
                stringBuilder.append(']');
            }
            stringBuilder.append(bl2 ? " >>- " : " >- ");
            stringBuilder.append(iExpression4 == null ? iExpression.serializeToGaml(bl) : iExpression4.serializeToGaml(bl)).append(';');
        }
    }
}

