/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.test;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaAssertException;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.species.GamlSpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.test.AssertStatement;
import gama.gaml.statements.test.IndividualTestSummary;
import gama.gaml.statements.test.SetUpStatement;
import gama.gaml.statements.test.TestState;
import gama.gaml.statements.test.WithTestSummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@GamlAnnotations.inside(kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="identifier of the test")})}, omissible="name")
@GamlAnnotations.doc(value="The test statement allows modeler to define a set of assertions that will be tested. Before the execution of the embedded set of instructions, if a setup is defined in the species, model or experiment, it is executed. In a test, if one assertion fails, the evaluation of other assertions continue.", usages={@GamlAnnotations.usage(value="An example of use:", examples={@GamlAnnotations.example(value="species Tester {", isExecutable=false), @GamlAnnotations.example(value="    // set of attributes that will be used in test", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="    setup {", isExecutable=false), @GamlAnnotations.example(value="        // [set of instructions... in particular initializations]", isExecutable=false), @GamlAnnotations.example(value="    }", isExecutable=false), @GamlAnnotations.example(value="", isExecutable=false), @GamlAnnotations.example(value="    test t1 {", isExecutable=false), @GamlAnnotations.example(value="       // [set of instructions, including asserts]", isExecutable=false), @GamlAnnotations.example(value="    }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"setup", "assert"})
public class TestStatement
extends AbstractStatementSequence
implements WithTestSummary<IndividualTestSummary> {
    SetUpStatement setup = null;
    List<AssertStatement> assertions = new ArrayList<AssertStatement>();
    IndividualTestSummary summary;

    public TestStatement(IDescription iDescription) {
        super(iDescription);
        if (this.hasFacet("name")) {
            this.setName("test " + this.getLiteral("name"));
        }
    }

    @Override
    public IndividualTestSummary getSummary() {
        if (this.summary == null) {
            this.summary = new IndividualTestSummary(this);
        }
        return this.summary;
    }

    @Override
    public void setEnclosing(ISymbol iSymbol) {
        super.setEnclosing(iSymbol);
        this.setup = ((GamlSpecies)iSymbol).getBehaviors().stream().filter(iStatement -> iStatement instanceof SetUpStatement).findAny().orElse(null);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        super.setChildren(iterable);
        iterable.forEach(iSymbol -> {
            if (iSymbol instanceof AssertStatement) {
                this.assertions.add((AssertStatement)iSymbol);
            }
        });
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        this.getSummary().reset();
        if (this.setup != null) {
            this.setup.setup(iScope);
        }
        Object object = null;
        try {
            iScope.enableTryMode();
            IStatement[] iStatementArray = this.commands;
            int n = this.commands.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    IStatement iStatement = iStatementArray[n2];
                    try {
                        object = iStatement.executeOn(iScope);
                    }
                    catch (GamaAssertException gamaAssertException) {
                    }
                    catch (GamaRuntimeException gamaRuntimeException) {
                        if (iStatement instanceof AssertStatement) break block8;
                        this.getSummary().setState(TestState.ABORTED);
                        this.getSummary().setError(gamaRuntimeException.getMessage());
                        break;
                    }
                }
                ++n2;
            }
        }
        finally {
            iScope.disableTryMode();
        }
        return object;
    }

    @Override
    public String getTitleForSummary() {
        return "Test " + this.getName();
    }

    @Override
    public Collection<? extends WithTestSummary<?>> getSubElements() {
        return this.assertions;
    }
}

