/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import com.google.common.collect.Iterators;
import gama.core.runtime.IScope;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public record Signature(IType[] list) implements Iterable<IType>
{
    static IType[] EMPTY_TYPES = new IType[0];

    public static Signature varArgFrom(Signature signature) {
        return new Signature(Types.LIST.of(GamaType.findCommonType(signature.list)));
    }

    public static Signature createSimplified(IExpression ... iExpressionArray) {
        IType[] iTypeArray = new IType[iExpressionArray.length];
        int n = 0;
        while (n < iExpressionArray.length) {
            iTypeArray[n] = iExpressionArray[n].getGamlType().getGamlType();
            ++n;
        }
        return new Signature(iTypeArray);
    }

    public Signature(Executable executable) {
        this(Signature.extractTypesFrom(executable));
    }

    public Signature(IType iType) {
        this(new IType[]{iType});
    }

    private static IType[] extractTypesFrom(Executable executable) {
        if (executable == null) {
            return EMPTY_TYPES;
        }
        ArrayList arrayList = new ArrayList();
        Class<?>[] classArray = executable.getParameterTypes();
        boolean bl = Modifier.isStatic(executable.getModifiers());
        boolean bl2 = executable instanceof Constructor;
        if (!bl && !bl2) {
            arrayList.add(Types.get(executable.getDeclaringClass()));
        }
        Class<?>[] classArray2 = classArray;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray2[n2];
            if (clazz != IScope.class) {
                arrayList.add(Types.get(clazz));
            }
            ++n2;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    public Signature(int[] nArray) {
        this(new IType[nArray.length]);
        int n = 0;
        while (n < this.list.length) {
            this.list[n] = Types.get(nArray[n]);
            ++n;
        }
    }

    public Signature(IExpression ... iExpressionArray) {
        this(new IType[iExpressionArray.length]);
        int n = 0;
        while (n < this.list.length) {
            IExpression iExpression = iExpressionArray[n];
            this.list[n] = iExpression == null ? Types.NO_TYPE : iExpression.getGamlType();
            ++n;
        }
    }

    public Signature(List<IExpression> list) {
        this(new IType[list.size()]);
        int n = 0;
        while (n < this.list.length) {
            IExpression iExpression = list.get(n);
            this.list[n] = iExpression == null ? Types.NO_TYPE : iExpression.getGamlType();
            ++n;
        }
    }

    public Signature(Class ... classArray) {
        this(new IType[classArray.length]);
        int n = 0;
        while (n < this.list.length) {
            this.list[n] = Types.get(classArray[n]);
            ++n;
        }
    }

    public Signature simplified() {
        IType[] iTypeArray = Arrays.copyOf(this.list, this.list.length);
        int n = 0;
        while (n < iTypeArray.length) {
            iTypeArray[n] = iTypeArray[n].getGamlType();
            ++n;
        }
        return new Signature(iTypeArray);
    }

    public boolean matchesDesiredSignature(Signature signature) {
        return this.matchesDesiredSignature(signature.list);
    }

    public int distanceTo(IType ... iTypeArray) {
        if (iTypeArray.length != this.list.length) {
            return Integer.MAX_VALUE;
        }
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < this.list.length) {
            int n4 = iTypeArray[n3].distanceTo(this.list[n3]);
            if (n < n4) {
                n = n4;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            ++n3;
        }
        return n2 + n;
    }

    public boolean matchesDesiredSignature(IType ... iTypeArray) {
        if (iTypeArray.length != this.list.length) {
            return false;
        }
        int n = 0;
        while (n < this.list.length) {
            IType iType = this.list[n];
            IType iType2 = iTypeArray[n];
            if (!(Types.intFloatCase(iType, iType2) || iType2.isAssignableFrom(iType) || !iType2.isNumber() && iType == Types.NO_TYPE)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int distanceTo(Signature signature) {
        return this.distanceTo(signature.list);
    }

    public boolean equals(Signature signature) {
        if (signature.list.length != this.list.length) {
            return false;
        }
        int n = 0;
        while (n < this.list.length) {
            if (signature.list[n] != this.list[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Signature)) {
            return false;
        }
        return this.equals((Signature)object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.list);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.list.length < 2 ? "type " : "types [");
        int n = 0;
        while (n < this.list.length) {
            stringBuilder.append(this.list[n]);
            if (n != this.list.length - 1) {
                stringBuilder.append(", ");
            }
            ++n;
        }
        if (this.list.length >= 2) {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public IType get(int n) {
        return this.list[n];
    }

    public IType[] coerce(Signature signature, IDescription iDescription) {
        IType[] iTypeArray = new IType[this.list.length];
        int n = 0;
        while (n < this.list.length) {
            iTypeArray[n] = this.list[n].coerce(signature.get(n), iDescription);
            ++n;
        }
        return iTypeArray;
    }

    public boolean isUnary() {
        return this.list.length == 1;
    }

    public int size() {
        return this.list.length;
    }

    public String asPattern(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.list.length) {
            stringBuilder.append(bl ? this.list[n].asPattern() : this.list[n].serializeToGaml(true));
            if (n < this.list.length - 1) {
                stringBuilder.append(',');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean mightNeedCoercionWith(Signature signature) {
        int n = 0;
        while (n < this.list.length) {
            if (Types.intFloatCase(this.list[n], signature.list[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public Iterator<IType> iterator() {
        return Iterators.forArray((Object[])this.list);
    }
}

