/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sampling;

import gama.core.kernel.batch.exploration.sampling.SamplingUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class RandomSampling
extends SamplingUtils {
    public static List<ParametersSet> uniformSampling(IScope iScope, int n, List<IParameter.Batch> list) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n2 = 0;
        while (n2++ < n) {
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            for (IParameter.Batch batch : list) {
                hashMap.put(batch.getName(), iScope.getRandom().next());
            }
            arrayList.add(hashMap);
        }
        return RandomSampling.buildParametersSetfromSample(iScope, list, arrayList);
    }

    public static List<ParametersSet> factorialUniformSampling(IScope iScope, int[] nArray, List<IParameter.Batch> list) {
        HashMap<IParameter.Batch, List<Double>> hashMap = new HashMap<IParameter.Batch, List<Double>>();
        for (IParameter.Batch object2 : list) {
            hashMap.put(object2, IntStream.range(0, nArray[list.indexOf(object2)]).mapToDouble(n -> iScope.getRandom().next()).boxed().toList());
        }
        List<Map<String, Double>> list2 = RandomSampling.buildFactorialDesign(list, hashMap, new ArrayList<Map<String, Double>>(), 0);
        return RandomSampling.buildParametersSetfromSample(iScope, list, list2);
    }

    public static List<ParametersSet> factorialUniformSampling(IScope iScope, int n, List<IParameter.Batch> list) {
        int n2 = (int)Math.round(Math.pow(n, 1.0 / (double)list.size()));
        n2 = n2 < 1 ? 1 : n2;
        int[] nArray = new int[list.size()];
        Arrays.fill(nArray, n2);
        return RandomSampling.factorialUniformSampling(iScope, nArray, list);
    }

    private static List<Map<String, Double>> buildFactorialDesign(List<IParameter.Batch> list, Map<IParameter.Batch, List<Double>> map, List<Map<String, Double>> list2, int n) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        if (list2.isEmpty()) {
            list2.add(new HashMap());
        }
        IParameter.Batch batch = list.get(n);
        for (Map<String, Double> map2 : list2) {
            for (Double d : map.get(batch)) {
                HashMap<String, Double> hashMap = new HashMap<String, Double>(map2);
                hashMap.put(batch.getName(), d);
                arrayList.add(hashMap);
            }
        }
        if (n == list.size() - 1) {
            return arrayList;
        }
        return RandomSampling.buildFactorialDesign(list, map, arrayList, n + 1);
    }
}

