/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.simulation;

import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.model.IModel;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.dev.THREADS;
import gama.gaml.operators.Dates;
import java.time.DateTimeException;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimulationClock {
    private volatile AtomicInteger cycle = new AtomicInteger(0);
    private double step = Dates.DATES_TIME_STEP.getValue();
    protected long duration = 0L;
    protected long totalDuration = 0L;
    private long start = 0L;
    protected GamaDate startingDate = null;
    protected GamaDate currentDate = null;
    private final boolean outputAsDuration;
    private final IScope clockScope;

    public SimulationClock(IScope iScope) {
        IModel iModel = iScope.getModel();
        this.outputAsDuration = iModel == null ? true : !iModel.getDescription().isStartingDateDefined();
        this.clockScope = iScope;
    }

    public void setCycle(int n) throws GamaRuntimeException {
        if (n < 0) {
            throw GamaRuntimeException.error("The current cycle of a simulation cannot be negative", this.clockScope);
        }
        int n2 = this.cycle.get();
        if (n < n2) {
            throw GamaRuntimeException.error("The current cycle of a simulation cannot be set backwards", this.clockScope);
        }
        this.cycle.set(n);
        this.setCurrentDate(this.getCurrentDate().plus(this.getStepInMillis(), n - n2, ChronoUnit.MILLIS));
    }

    public void setCycleNoCheck(int n) throws GamaRuntimeException {
        if (n < 0) {
            throw GamaRuntimeException.error("The current cycle of a simulation cannot be negative", this.clockScope);
        }
        int n2 = this.cycle.get();
        this.cycle.set(n);
        this.setCurrentDate(this.getCurrentDate().plus(this.getStepInMillis(), n - n2, ChronoUnit.MILLIS));
    }

    public void incrementCycle() {
        this.cycle.incrementAndGet();
        this.setCurrentDate(this.getCurrentDate().plusMillis(this.getStepInMillis()));
    }

    public void resetCycles() {
        this.cycle.set(0);
        this.startingDate = null;
        this.currentDate = null;
    }

    public int getCycle() {
        return this.cycle.get();
    }

    public double getTimeElapsedInSeconds() {
        return (double)this.getStartingDate().until(this.getCurrentDate(), ChronoUnit.MILLIS) / 1000.0;
    }

    public void setStep(double d) throws GamaRuntimeException {
        if (d <= 0.0) {
            throw GamaRuntimeException.error("The interval between two cycles of a simulation cannot be negative or null", this.clockScope);
        }
        this.step = d;
    }

    public double getStepInSeconds() {
        return this.step;
    }

    public long getStepInMillis() {
        return (long)(this.step * 1000.0);
    }

    public void resetDuration() {
        this.start = System.currentTimeMillis();
    }

    public void resetTotalDuration() {
        this.resetDuration();
        this.duration = 0L;
        this.totalDuration = 0L;
    }

    private void computeDuration() {
        this.duration = System.currentTimeMillis() - this.start;
        this.totalDuration += this.duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getAverageDuration() {
        if (this.cycle.get() == 0) {
            return 0.0;
        }
        return (double)this.totalDuration / (double)this.cycle.get();
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public void step() {
        this.incrementCycle();
        this.computeDuration();
        this.waitDelay();
    }

    public void waitDelay() {
        double d = this.getDelayInMilliseconds();
        if (d == 0.0 || (double)this.duration >= d) {
            return;
        }
        THREADS.WAIT((long)((long)d - this.duration), (String[])new String[0]);
    }

    public void reset() throws GamaRuntimeException {
        this.resetCycles();
        this.resetTotalDuration();
    }

    public void beginCycle() {
        this.resetDuration();
    }

    public StringBuilder getInfo(StringBuilder stringBuilder) {
        int n = this.getCycle();
        ITopLevelAgent iTopLevelAgent = this.clockScope.getRoot();
        if (iTopLevelAgent != null) {
            stringBuilder.append(iTopLevelAgent.getName()).append(": ").append(n).append(n <= 1 ? " cycle " : " cycles ").append("elapsed ");
            try {
                GamaDate gamaDate = this.getCurrentDate();
                String string = this.outputAsDuration ? Dates.asDuration(this.getStartingDate(), gamaDate) : gamaDate.toString("yyyy-MM-dd HH:mm:ss", "en");
                stringBuilder.append("[").append(string).append("]");
            }
            catch (DateTimeException dateTimeException) {}
        }
        return stringBuilder;
    }

    public double getDelayInMilliseconds() {
        IExperimentAgent iExperimentAgent = this.clockScope.getExperiment();
        return iExperimentAgent == null ? 0.0 : iExperimentAgent.getMinimumDuration() * 1000.0;
    }

    public GamaDate getCurrentDate() {
        if (this.currentDate == null) {
            this.currentDate = this.getStartingDate();
        }
        return this.currentDate;
    }

    public GamaDate getStartingDate() {
        if (this.startingDate == null) {
            this.setStartingDate(Dates.DATES_STARTING_DATE.getValue());
        }
        return this.startingDate;
    }

    public void setStartingDate(GamaDate gamaDate) {
        this.startingDate = gamaDate;
        this.currentDate = gamaDate;
        this.cycle.set(0);
    }

    public void setCurrentDate(GamaDate gamaDate) {
        this.currentDate = gamaDate;
    }
}

