/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.concurrent.ISimulationRunner;
import gama.dev.DEBUG;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SimulationRunner
implements ISimulationRunner {
    final Map<SimulationAgent, Thread> runnables;
    final Object lock = new Object();
    final GeneralSynchronizer simulationsSemaphore = GeneralSynchronizer.withInitialPermits(0);
    final GeneralSynchronizer experimentSemaphore = GeneralSynchronizer.withInitialPermits(0);
    final int concurrency;
    volatile boolean shutdown = false;

    static {
        DEBUG.OFF();
    }

    public static SimulationRunner of(SimulationPopulation simulationPopulation) {
        int n = 0;
        IExperimentPlan iExperimentPlan = simulationPopulation.getHost().getSpecies();
        n = iExperimentPlan.isHeadless() && !iExperimentPlan.isBatch() ? 1 : GamaExecutorService.getParallelism(simulationPopulation.getHost().getScope(), iExperimentPlan.getConcurrency(), GamaExecutorService.Caller.SIMULATION);
        return new SimulationRunner(n < 0 ? 1 : n);
    }

    private SimulationRunner(int n) {
        this.concurrency = n;
        this.runnables = new LinkedHashMap<SimulationAgent, Thread>();
    }

    @Override
    public void remove(SimulationAgent simulationAgent) {
        this.runnables.remove(simulationAgent);
    }

    @Override
    public void add(final SimulationAgent simulationAgent) {
        Thread thread = new Thread("Thread of " + simulationAgent.getName()){

            @Override
            public void run() {
                while (!SimulationRunner.this.shutdown && !simulationAgent.dead()) {
                    SimulationRunner.this.simulationsSemaphore.acquire();
                    try {
                        simulationAgent.step();
                        SimulationRunner.this.experimentSemaphore.release();
                    }
                    catch (Throwable throwable) {
                        GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable);
                    }
                }
            }
        };
        thread.start();
        this.runnables.put(simulationAgent, thread);
    }

    @Override
    public void step() {
        int n = this.getActiveThreads();
        this.simulationsSemaphore.release(n);
        this.experimentSemaphore.acquire(n);
    }

    @Override
    public void dispose() {
        this.shutdown = true;
        int n = this.runnables.size();
        this.runnables.clear();
        this.experimentSemaphore.release(n);
        this.simulationsSemaphore.release(n);
    }

    @Override
    public Set<SimulationAgent> getStepable() {
        return this.runnables.keySet();
    }

    @Override
    public int getActiveThreads() {
        return this.runnables.size();
    }

    @Override
    public boolean hasSimulations() {
        return this.runnables.size() > 0;
    }
}

