/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.collect.Iterators;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Dates;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class GamaDateInterval
implements IList<GamaDate> {
    final GamaDate start;
    final GamaDate end;
    final Duration step;
    final Integer size;

    public static GamaDateInterval of(GamaDate gamaDate, GamaDate gamaDate2) {
        return new GamaDateInterval(gamaDate, gamaDate2);
    }

    private GamaDateInterval(GamaDate gamaDate, GamaDate gamaDate2) {
        this(gamaDate, gamaDate2, Duration.of(Dates.DATES_TIME_STEP.getValue().longValue(), ChronoUnit.SECONDS));
    }

    public GamaDateInterval(GamaDate gamaDate, GamaDate gamaDate2, Duration duration) {
        this.start = gamaDate;
        this.end = gamaDate2;
        this.step = this.start.isAfter(this.end) ? duration.abs().negated() : duration;
        this.size = this.size();
    }

    public GamaDate getStart() {
        return this.start;
    }

    public GamaDate getEnd() {
        return this.end;
    }

    @Override
    public boolean isEmpty() {
        return this.start.equals(this.end);
    }

    public boolean contains(GamaDate gamaDate) {
        return this.start.compareTo(gamaDate) <= 0 && gamaDate.compareTo(this.end) < 0;
    }

    public Duration toDuration() {
        return Duration.between(this.start, this.end);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GamaDateInterval) {
            GamaDateInterval gamaDateInterval = (GamaDateInterval)object;
            return this.start.equals(gamaDateInterval.start) && this.end.equals(gamaDateInterval.end);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start.toString() + "/" + this.end.toString();
    }

    @Override
    public IContainerType<?> getGamlType() {
        return Types.LIST.of(Types.DATE);
    }

    @Override
    public IList<GamaDate> listValue(IScope iScope, IType iType, boolean bl) {
        if (bl) {
            return GamaListFactory.createWithoutCasting(Types.DATE, this);
        }
        return this;
    }

    @Override
    public Iterable<? extends GamaDate> iterable(IScope iScope) {
        return this;
    }

    @Override
    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        return this.contains(object);
    }

    @Override
    public GamaDate firstValue(IScope iScope) throws GamaRuntimeException {
        return this.start;
    }

    @Override
    public GamaDate lastValue(IScope iScope) throws GamaRuntimeException {
        return this.end;
    }

    @Override
    public int length(IScope iScope) {
        return this.size();
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        return this.isEmpty();
    }

    @Override
    public GamaDate anyValue(IScope iScope) {
        int n = iScope.getRandom().between(0, this.size());
        return this.get(n);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    @Override
    public GamaDateInterval copy(IScope iScope) throws GamaRuntimeException {
        return new GamaDateInterval(this.start, this.end, this.step);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "(" + this.start.serializeToGaml(bl) + " to " + this.end.serializeToGaml(bl) + ") every (" + (double)this.step.get(ChronoUnit.SECONDS) + ")";
    }

    @Override
    public void addValue(IScope iScope, GamaDate gamaDate) {
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, GamaDate gamaDate) {
    }

    @Override
    public void setValueAtIndex(IScope iScope, Object object, GamaDate gamaDate) {
    }

    @Override
    public void addValues(IScope iScope, IContainer iContainer) {
    }

    @Override
    public void setAllValues(IScope iScope, GamaDate gamaDate) {
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
    }

    @Override
    public void removeIndex(IScope iScope, Object object) {
    }

    @Override
    public void removeIndexes(IScope iScope, IContainer<?, ?> iContainer) {
    }

    @Override
    public void removeValues(IScope iScope, IContainer iContainer) {
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
    }

    @Override
    public GamaDate get(IScope iScope, Integer n) throws GamaRuntimeException {
        return this.get(n);
    }

    @Override
    public GamaDate getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        return this.get(iScope, (Integer)iList.get(0));
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size;
        }
        return Iterators.size(this.iterator());
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof GamaDate)) {
            return false;
        }
        return this.contains((GamaDate)object);
    }

    @Override
    public Iterator<GamaDate> iterator() {
        return new Iterator<GamaDate>(){
            GamaDate current = null;

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    return !GamaDateInterval.this.isEmpty();
                }
                return this.current.plus(GamaDateInterval.this.step).isBefore(GamaDateInterval.this.end);
            }

            @Override
            public GamaDate next() {
                if (this.current == null) {
                    this.current = GamaDateInterval.this.start;
                } else {
                    this.current = this.current.plus(GamaDateInterval.this.step);
                    if (this.current.isGreaterThan(GamaDateInterval.this.end, false)) {
                        throw new NoSuchElementException();
                    }
                }
                return this.current;
            }
        };
    }

    public GamaDate[] toArray() {
        return (GamaDate[])Iterators.toArray(this.iterator(), GamaDate.class);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return Iterators.toArray(this.iterator(), Object.class);
    }

    @Override
    public boolean add(GamaDate gamaDate) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends GamaDate> collection) {
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends GamaDate> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public GamaDate get(int n) {
        return this.start.plus(this.step.get(ChronoUnit.SECONDS), n, ChronoUnit.SECONDS);
    }

    @Override
    public GamaDate set(int n, GamaDate gamaDate) {
        return null;
    }

    @Override
    public void add(int n, GamaDate gamaDate) {
    }

    @Override
    public GamaDate remove(int n) {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        for (GamaDate gamaDate : this) {
            if (gamaDate.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public ListIterator<GamaDate> listIterator() {
        return new ArrayList<GamaDate>(this).listIterator();
    }

    @Override
    public ListIterator<GamaDate> listIterator(int n) {
        return new ArrayList<GamaDate>(this).listIterator(n);
    }

    public GamaDateInterval subList(int n, int n2) {
        return new GamaDateInterval(this.get(n), this.get(n2), this.step);
    }

    public GamaDateInterval reverse(IScope iScope) {
        return new GamaDateInterval(this.end, this.start, this.step);
    }

    @Override
    public IMatrix<GamaDate> matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) {
        return GamaListFactory.wrap(Types.DATE, this).matrixValue(iScope, iType, bl);
    }

    @Override
    public IMatrix<GamaDate> matrixValue(IScope iScope, IType iType, boolean bl) {
        return GamaListFactory.wrap(Types.DATE, this).matrixValue(iScope, iType, bl);
    }

    public IList<GamaDate> step(Double d) {
        return new GamaDateInterval(this.start, this.end, Duration.of(d.longValue(), ChronoUnit.SECONDS));
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IMap iMap = GamaMapFactory.create(Types.DATE, Types.DATE, this.size());
        for (GamaDate gamaDate : this) {
            iMap.put(gamaDate, gamaDate);
        }
        return iMap;
    }
}

