/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.metamodel.shape.GamaGisGeometry;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.file.ProgressCounter;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public abstract class GamaGisFile
extends GamaGeometryFile {
    public static final int ALREADY_PROJECTED_CODE = 0;
    static CoordinateFilter ZERO_Z = coordinate -> coordinate.setZ(0.0);
    public IProjection gis;
    protected Integer initialCRSCode = null;
    protected String initialCRSCodeStr = null;
    protected boolean with3D = false;
    static Cache<String, CoordinateReferenceSystem> CRSCache = CacheBuilder.newBuilder().concurrencyLevel(10).expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES)).build();

    protected final CoordinateReferenceSystem getExistingCRS(IScope iScope) {
        try {
            return (CoordinateReferenceSystem)CRSCache.get((Object)this.getPath(iScope), () -> {
                if (this.initialCRSCode != null) {
                    try {
                        return iScope.getSimulation().getProjectionFactory().getCRS(iScope, this.initialCRSCode);
                    }
                    catch (GamaRuntimeException gamaRuntimeException) {
                        throw GamaRuntimeException.error("The code " + String.valueOf(this.initialCRSCode) + " does not correspond to a known EPSG code. GAMA is unable to load " + this.getPath(iScope), iScope);
                    }
                }
                if (this.initialCRSCodeStr != null) {
                    try {
                        return iScope.getSimulation().getProjectionFactory().getCRS(iScope, this.initialCRSCodeStr);
                    }
                    catch (GamaRuntimeException gamaRuntimeException) {
                        throw GamaRuntimeException.error("The code " + this.initialCRSCodeStr + " does not correspond to a known CRS code. GAMA is unable to load " + this.getPath(iScope), iScope);
                    }
                }
                CoordinateReferenceSystem coordinateReferenceSystem = this.getOwnCRS(iScope);
                if (coordinateReferenceSystem == null && iScope != null) {
                    coordinateReferenceSystem = iScope.getSimulation().getProjectionFactory().getDefaultInitialCRS(iScope);
                }
                return coordinateReferenceSystem;
            });
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return iScope.getSimulation().getProjectionFactory().getDefaultInitialCRS(iScope);
        }
    }

    protected CoordinateReferenceSystem getOwnCRS(IScope iScope) {
        try {
            URL uRL = this.getFile(iScope).toURI().toURL();
            CoordinateReferenceSystem coordinateReferenceSystem = ((SimpleFeatureType)this.getFeatureCollection(iScope).getSchema()).getCoordinateReferenceSystem();
            if (coordinateReferenceSystem == null) {
                coordinateReferenceSystem = ProjectionFactory.manageGoogleCRS(uRL);
            }
            return coordinateReferenceSystem;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected abstract SimpleFeatureCollection getFeatureCollection(IScope var1);

    protected void readShapes(IScope iScope) {
        ProgressCounter progressCounter = new ProgressCounter(iScope, "Reading " + this.getName(iScope));
        SimpleFeatureCollection simpleFeatureCollection = this.getFeatureCollection(iScope);
        this.computeEnvelope(iScope);
        try {
            simpleFeatureCollection.accepts(feature -> {
                Geometry geometry = (Geometry)feature.getDefaultGeometryProperty().getValue();
                if (geometry != null && !geometry.isEmpty()) {
                    GamaGisGeometry gamaGisGeometry;
                    if (!this.with3D && !geometry.isValid()) {
                        geometry = GeometryUtils.cleanGeometry(geometry);
                    }
                    geometry = this.gis.transform(geometry);
                    if (!this.with3D) {
                        geometry.apply(ZERO_Z);
                        geometry.geometryChanged();
                    }
                    if ((gamaGisGeometry = new GamaGisGeometry(geometry = this.multiPolygonManagement(geometry), feature)).getInnerGeometry() != null) {
                        ((IList)this.getBuffer()).add(gamaGisGeometry);
                    }
                } else if (geometry == null) {
                    GAMA.reportError(iScope, GamaRuntimeException.warning("geometry could not be added as it is nil: " + String.valueOf(feature.getIdentifier()), iScope), false);
                }
            }, (ProgressListener)progressCounter);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    protected void computeProjection(IScope iScope, Envelope3D envelope3D) {
        if (iScope == null) {
            return;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = this.getExistingCRS(iScope);
        ProjectionFactory projectionFactory = iScope.getSimulation().isMicroSimulation() ? ((IExperimentAgent)iScope.getExperiment().getPopulation().getHost()).getSimulation().getProjectionFactory() : (iScope.getSimulation() == null ? new ProjectionFactory() : iScope.getSimulation().getProjectionFactory());
        this.gis = projectionFactory.fromCRS(iScope, coordinateReferenceSystem, envelope3D);
    }

    protected Geometry multiPolygonManagement(Geometry geometry) {
        if (!(geometry instanceof MultiPolygon)) {
            return geometry;
        }
        Polygon[] polygonArray = new Polygon[geometry.getNumGeometries()];
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Polygon polygon = (Polygon)geometry.getGeometryN(n);
            ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(polygon);
            LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(iCoordinates.toCoordinateArray());
            Throwable throwable = null;
            Object var8_9 = null;
            try (Collector.AsList asList = Collector.getList();){
                int n2 = 0;
                while (n2 < polygon.getNumInteriorRing()) {
                    LinearRing linearRing2 = polygon.getInteriorRingN(n2);
                    if (!GamaGisFile.hasNullElements(linearRing2.getCoordinates())) {
                        asList.add(linearRing2);
                    }
                    ++n2;
                }
                LinearRing[] linearRingArray = new LinearRing[asList.size()];
                linearRingArray = asList.items().toArray(linearRingArray);
                polygonArray[n] = GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, linearRingArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n;
        }
        return GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
    }

    protected static boolean hasNullElements(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public GamaGisFile(IScope iScope, String string, Integer n, boolean bl) {
        super(iScope, string);
        this.initialCRSCode = n;
        this.with3D = bl;
    }

    public GamaGisFile(IScope iScope, String string, Integer n) {
        super(iScope, string);
        this.initialCRSCode = n;
    }

    public GamaGisFile(IScope iScope, String string, String string2) {
        super(iScope, string);
        this.initialCRSCodeStr = string2;
    }

    public GamaGisFile(IScope iScope, String string, String string2, boolean bl) {
        super(iScope, string);
        this.initialCRSCodeStr = string2;
        this.with3D = bl;
    }

    public GamaGisFile(IScope iScope, String string, boolean bl) {
        super(iScope, string, bl);
    }

    public IProjection getGis(IScope iScope) {
        if (this.gis == null) {
            this.fillBuffer(iScope);
        }
        return this.gis;
    }

    @Override
    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry(iScope, this.getBuffer());
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
        this.readShapes(iScope);
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        if (this.gis == null) {
            SimpleFeatureCollection simpleFeatureCollection = this.getFeatureCollection(iScope);
            if (simpleFeatureCollection == null) {
                return Envelope3D.EMPTY;
            }
            Envelope3D envelope3D = Envelope3D.of((Envelope)simpleFeatureCollection.getBounds());
            this.computeProjection(iScope, envelope3D);
        }
        return this.gis.getProjectedEnvelope();
    }

    @Override
    public void invalidateContents() {
        super.invalidateContents();
        this.gis = null;
        this.initialCRSCode = null;
        this.initialCRSCodeStr = null;
    }
}

