/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.csv;

import gama.core.util.file.csv.AbstractCSVManipulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class CsvReader
extends AbstractCSVManipulator {
    private Reader inputStream = null;
    private final DataBuffer dataBuffer = new DataBuffer();
    private char[] columnBuffer = new char[50];
    private int columnBufferPosition = 0;
    HeadersHolder headersHolder;
    boolean startedColumn = false;
    boolean hasMoreData = true;
    boolean hasReadNextLine = false;
    public int columnsCount = 0;
    public long currentRecord = 0L;
    String[] values = new String[10];

    public CsvReader(String string, char c) throws FileNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("Parameter fileName can not be null.");
        }
        if (!new File(string).exists()) {
            throw new FileNotFoundException("File " + string + " does not exist.");
        }
        this.fileName = string;
        this.delimiter = c;
    }

    public CsvReader(String string) throws FileNotFoundException {
        this(string, CsvReader.getDefaultDelimiter());
    }

    public CsvReader(Reader reader, char c) {
        this.inputStream = reader;
        this.delimiter = c;
    }

    public CsvReader(Reader reader) {
        this(reader, CsvReader.getDefaultDelimiter());
    }

    public long getCurrentRecord() {
        return this.currentRecord - 1L;
    }

    public int getHeaderCount() {
        return this.headersHolder == null ? 0 : this.headersHolder.names.length;
    }

    public String[] getHeaders() {
        if (this.headersHolder == null || this.headersHolder.names() == null) {
            return null;
        }
        String[] stringArray = new String[this.headersHolder.names.length];
        System.arraycopy(this.headersHolder.names, 0, stringArray, 0, this.headersHolder.names.length);
        return stringArray;
    }

    public String[] getValues() {
        String[] stringArray = new String[this.columnsCount];
        System.arraycopy(this.values, 0, stringArray, 0, this.columnsCount);
        return stringArray;
    }

    public boolean readRecord() throws IOException {
        this.columnsCount = 0;
        this.hasReadNextLine = false;
        boolean bl = false;
        char c = '\u0000';
        if (this.hasMoreData) {
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                bl = false;
                char c2 = this.dataBuffer.buffer[this.dataBuffer.position];
                if (this.textQualifier != null && c2 == this.textQualifier.charValue()) {
                    c = c2;
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                    bl = true;
                    var4_4 = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ++this.dataBuffer.position;
                    do {
                        if (this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        c2 = this.dataBuffer.buffer[this.dataBuffer.position];
                        if (bl2) {
                            this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            if (c2 == this.delimiter) {
                                this.endColumn(bl);
                            } else if (c2 == '\r' || c2 == '\n') {
                                this.endColumn(bl);
                                this.endRecord();
                            }
                        } else if (c2 == this.textQualifier.charValue()) {
                            if (bl3) {
                                bl3 = false;
                                var4_4 = false;
                            } else {
                                this.updateCurrentValue();
                                bl3 = true;
                                var4_4 = true;
                            }
                        } else if (var4_4) {
                            if (c2 == this.delimiter) {
                                this.endColumn(bl);
                            } else if (c2 == '\r' || c2 == '\n') {
                                this.endColumn(bl);
                                this.endRecord();
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                bl2 = true;
                            }
                            var4_4 = false;
                        }
                        c = c2;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                    } while (this.hasMoreData && this.startedColumn);
                } else if (c2 == this.delimiter) {
                    c = c2;
                    this.endColumn(bl);
                } else if (c2 == '\r' || c2 == '\n') {
                    if (this.startedColumn || this.columnsCount > 0) {
                        this.endColumn(bl);
                        this.endRecord();
                    }
                    c = c2;
                } else if (c2 == ' ' || c2 == '\t') {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position;
                    var4_4 = true;
                    do {
                        if (!var4_4 && this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (!var4_4) {
                            c2 = this.dataBuffer.buffer[this.dataBuffer.position];
                        }
                        if (c2 == this.delimiter) {
                            this.endColumn(bl);
                        } else if (c2 == '\r' || c2 == '\n') {
                            this.endColumn(bl);
                            this.endRecord();
                        }
                        c = c2;
                        var4_4 = false;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || c == this.delimiter) {
                this.endColumn(bl);
                this.endRecord();
            }
        }
        return this.hasReadNextLine;
    }

    private void checkDataLength() throws IOException {
        if (this.inputStream == null && this.fileName != null) {
            this.inputStream = new BufferedReader(new InputStreamReader(Files.newInputStream(new File(this.fileName).toPath(), new OpenOption[0]), Charset.forName("UTF-8")), 4096);
        }
        this.updateCurrentValue();
        try {
            this.dataBuffer.count = this.inputStream.read(this.dataBuffer.buffer, 0, this.dataBuffer.buffer.length);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (this.dataBuffer.count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.position = 0;
        this.dataBuffer.columnStart = 0;
    }

    public boolean readHeaders() throws IOException {
        boolean bl = this.readRecord();
        String[] stringArray = new String[this.columnsCount];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        while (n < this.columnsCount) {
            String string;
            stringArray[n] = string = this.values[n];
            hashMap.put(string, n);
            ++n;
        }
        this.headersHolder = new HeadersHolder(stringArray, hashMap);
        if (bl) {
            --this.currentRecord;
        }
        this.columnsCount = 0;
        return bl;
    }

    private void endColumn(boolean bl) {
        int n;
        String string = "";
        if (this.startedColumn) {
            if (this.columnBufferPosition == 0) {
                if (this.dataBuffer.columnStart < this.dataBuffer.position) {
                    n = this.dataBuffer.position - 1;
                    if (!bl) {
                        while (n >= this.dataBuffer.columnStart && (this.dataBuffer.buffer[n] == ' ' || this.dataBuffer.buffer[n] == '\t')) {
                            --n;
                        }
                    }
                    string = new String(this.dataBuffer.buffer, this.dataBuffer.columnStart, n - this.dataBuffer.columnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                n = this.columnBufferPosition - 1;
                if (!bl) {
                    while (n >= 0 && (this.columnBuffer[n] == ' ' || this.columnBuffer[n] == '\t')) {
                        --n;
                    }
                }
                string = new String(this.columnBuffer, 0, n + 1);
            }
        }
        this.columnBufferPosition = 0;
        this.startedColumn = false;
        if (this.columnsCount == this.values.length) {
            n = this.values.length * 2;
            String[] stringArray = new String[n];
            System.arraycopy(this.values, 0, stringArray, 0, this.values.length);
            this.values = stringArray;
        }
        this.values[this.columnsCount] = StringUtils.trimToEmpty((String)string);
        string = "";
        ++this.columnsCount;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.columnStart < this.dataBuffer.position) {
            if (this.columnBuffer.length - this.columnBufferPosition < this.dataBuffer.position - this.dataBuffer.columnStart) {
                int n = this.columnBuffer.length + Math.max(this.dataBuffer.position - this.dataBuffer.columnStart, this.columnBuffer.length);
                char[] cArray = new char[n];
                System.arraycopy(this.columnBuffer, 0, cArray, 0, this.columnBufferPosition);
                this.columnBuffer = cArray;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.columnStart, this.columnBuffer, this.columnBufferPosition, this.dataBuffer.position - this.dataBuffer.columnStart);
            this.columnBufferPosition += this.dataBuffer.position - this.dataBuffer.columnStart;
        }
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    @Override
    public void endRecord() {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    public int getIndex(String string) throws IOException {
        if (this.headersHolder == null) {
            return -1;
        }
        Integer n = this.headersHolder.indexes.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public String skipLine() throws IOException {
        this.columnsCount = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasMoreData) {
            boolean bl = false;
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                char c = this.dataBuffer.buffer[this.dataBuffer.position];
                if (c == '\r' || c == '\n') {
                    bl = true;
                }
                if (bl) continue;
                stringBuilder.append(c);
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !bl);
            this.columnBufferPosition = 0;
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            this.dataBuffer.buffer = null;
            this.columnBuffer = null;
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (Exception exception) {}
            this.inputStream = null;
        }
    }

    private static class DataBuffer {
        public char[] buffer = new char[1024];
        public int position;
        public int count;
        public int columnStart;

        private DataBuffer() {
        }
    }

    private record HeadersHolder(String[] names, HashMap<String, Integer> indexes) {
    }
}

