/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.RandomUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaList;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.IOperatorValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.types.GamaColorType;
import gama.gaml.types.Types;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;

public class Colors {
    static final ColorBrewer BREWER = ColorBrewer.instance();
    static final LoadingCache<String, GamaPalette> BREWER_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, GamaPalette>(){

        public GamaPalette load(String string) throws Exception {
            IList<GamaColor> iList = GamaListFactory.create(Types.COLOR);
            BrewerPalette brewerPalette = BREWER.getPalette(string);
            Color[] colorArray = brewerPalette.getColors();
            int n = colorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                if (color != null) {
                    iList.add(GamaColor.get(color));
                }
                ++n2;
            }
            return new GamaPalette(iList);
        }
    });

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="A new color resulting from the sum of the two operands, component by component. The alpha is the one of the left rgb color.", usages={@GamlAnnotations.usage(value="if both operands are colors, returns a new color resulting from the sum of the two operands, component by component", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) + rgb('red')", equals="rgb([255,128,32])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) + rgb('red') = rgb([255,128,32])")
    public static GamaColor add(GamaColor gamaColor, GamaColor gamaColor2) {
        return GamaColor.get(gamaColor.getRed() + gamaColor2.getRed(), gamaColor.getGreen() + gamaColor2.getGreen(), gamaColor.getBlue() + gamaColor2.getBlue(), (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="A new color resulting from the sum of each component of the color with the right int operand. This value is directly added to the 0-255 values of r, g and b. The alpha component remains untouched", usages={@GamlAnnotations.usage(value="if one operand is a color and the other an integer, returns a new color resulting from the sum of each component of the color with the right operand", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) + 3", equals="rgb([255,131,35])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) + 3 = rgb([255,131,35]) ")
    public static GamaColor add(GamaColor gamaColor, Integer n) {
        return GamaColor.get(gamaColor.getRed() + n, gamaColor.getGreen() + n, gamaColor.getBlue() + n, (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="a new color resulting from the subtraction of each component of the color with the right operand", usages={@GamlAnnotations.usage(value="if one operand is a color and the other an integer, returns a new color resulting from the subtraction of each component of the color with the right operand", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) - 3", equals="rgb([252,125,29])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) - 3 = rgb([252,125,29]) ")
    public static GamaColor subtract(GamaColor gamaColor, Integer n) {
        return GamaColor.get(gamaColor.getRed() - n, gamaColor.getGreen() - n, gamaColor.getBlue() - n, (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="a new color resulting from the subtraction of the two operands, component by component", usages={@GamlAnnotations.usage(value="if both operands are colors, returns a new color resulting from the subtraction of the two operands, component by component", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) - rgb('red')", equals="rgb([0,128,32])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) - rgb('red') = rgb([0,128,32])")
    public static GamaColor subtract(GamaColor gamaColor, GamaColor gamaColor2) {
        return GamaColor.get(gamaColor.getRed() - gamaColor2.getRed(), gamaColor.getGreen() - gamaColor2.getGreen(), gamaColor.getBlue() - gamaColor2.getBlue(), (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="a new color resulting from the product of each component of the color with the right operand", usages={@GamlAnnotations.usage(value="if one operand is a color and the other an integer, returns a new color resulting from the product of each component of the color with the right operand (with a maximum value at 255)", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) * 2", equals="rgb([255,255,64])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) * 2 = rgb([255,255,64])")
    public static GamaColor multiply(GamaColor gamaColor, Integer n) {
        return GamaColor.get(gamaColor.getRed() * n, gamaColor.getGreen() * n, gamaColor.getBlue() * n, (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="a new color resulting from the product of each component of the color with the right operand", usages={@GamlAnnotations.usage(value="if one operand is a color and the other a float, returns a new color resulting from the product of each component of the color with the right operand (with a maximum value at 255)", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) * 2.0", equals="rgb([255,255,64])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) * 2.0 = rgb([255,255,64])")
    public static GamaColor multiply(GamaColor gamaColor, Double d) {
        return GamaColor.get((int)((double)gamaColor.getRed() * d), (int)((double)gamaColor.getGreen() * d), (int)((double)gamaColor.getBlue() * d), (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="a new color resulting from the division of each component of the color by the right operand", usages={@GamlAnnotations.usage(value="if one operand is a color and the other an integer, returns a new color resulting from the division of each component of the color by the right operand", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) / 2", equals="rgb([127,64,16])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) / 2 = rgb([127,64,16])")
    public static GamaColor divide(GamaColor gamaColor, Integer n) {
        return GamaColor.get(gamaColor.getRed() / n, gamaColor.getGreen() / n, gamaColor.getBlue() / n, (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="a new color resulting from the division of each component of the color by the right operand. The result on each component is then truncated.", usages={@GamlAnnotations.usage(value="if one operand is a color and the other a double, returns a new color resulting from the division of each component of the color by the right operand. The result on each component is then truncated.", examples={@GamlAnnotations.example(value="rgb([255, 128, 32]) / 2.5", equals="rgb([102,51,13])")})})
    @GamlAnnotations.test(value="rgb([255, 128, 32]) / 2.5 = rgb([102,51,13])")
    public static GamaColor divide(GamaColor gamaColor, Double d) {
        return GamaColor.get(Maths.round((double)gamaColor.getRed() / d), (int)Maths.round((double)gamaColor.getGreen() / d), (int)Maths.round((double)gamaColor.getBlue() / d), (int)gamaColor.alpha());
    }

    @GamlAnnotations.operator(value={"hsb"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Converts hsb (h=hue, s=saturation, b=brightness) value to Gama color", masterDoc=true, comment="h,s and b components should be floating-point values between 0.0 and 1.0 and when used alpha should be an integer (between 0 and 255) or a float (between 0 and 1) . Examples: Red=(0.0,1.0,1.0), Yellow=(0.16,1.0,1.0), Green=(0.33,1.0,1.0), Cyan=(0.5,1.0,1.0), Blue=(0.66,1.0,1.0), Magenta=(0.83,1.0,1.0)", examples={@GamlAnnotations.example(value="hsb (0.0,1.0,1.0)", equals="rgb(\"red\")")}, see={"rgb"})
    @GamlAnnotations.test(value="hsb (0.0,1.0,1.0) = rgb('red') ")
    public static GamaColor hsb(Double d, Double d2, Double d3) {
        return GamaColor.get(Color.getHSBColor(d.floatValue(), d2.floatValue(), d3.floatValue()));
    }

    @GamlAnnotations.operator(value={"hsb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Converts hsb (h=hue, s=saturation, b=brightness) value to Gama color", examples={@GamlAnnotations.example(value="hsb (0.5,1.0,1.0,0.0)", equals="rgb(\"cyan\",0)")})
    @GamlAnnotations.test(value="hsb (0.5,1.0,1.0,0.0) = rgb('cyan',0) ")
    public static GamaColor hsb(Double d, Double d2, Double d3, Double d4) {
        return GamaColor.get(Color.getHSBColor(d.floatValue(), d2.floatValue(), d3.floatValue()), d4);
    }

    @GamlAnnotations.operator(value={"to_hsb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Converts a Gama color to hsb (h=hue, s=saturation, b=brightness) value", examples={@GamlAnnotations.example(value="to_hsb (#cyan)", equals="[0.5,1.0,1.0]")})
    @GamlAnnotations.test(value="[0.5,1.0,1.0] = to_hsb(rgb('cyan',0)) ")
    public static IList<Double> toHSB(GamaColor gamaColor) {
        IList<Double> iList = GamaListFactory.create();
        float[] fArray = Color.RGBtoHSB(gamaColor.getRed(), gamaColor.getBlue(), gamaColor.getGreen(), null);
        iList.add(Float.valueOf(fArray[0]).doubleValue());
        iList.add(Float.valueOf(fArray[1]).doubleValue());
        iList.add(Float.valueOf(fArray[2]).doubleValue());
        return iList;
    }

    @GamlAnnotations.operator(value={"hsb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Converts hsb (h=hue, s=saturation, b=brightness) value to Gama color")
    @GamlAnnotations.test(value="int(hsb(200,40, 90)) = -526409")
    public static GamaColor hsb(Double d, Double d2, Double d3, Integer n) {
        return GamaColor.get(Color.getHSBColor(d.floatValue(), d2.floatValue(), d3.floatValue()), (int)n);
    }

    @GamlAnnotations.operator(value={"rgb"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Returns a color defined by red, green, blue components and an alpha blending value.", masterDoc=true, usages={@GamlAnnotations.usage(value="It can be used with r=red, g=green, b=blue, each between 0 and 255")}, examples={@GamlAnnotations.example(value="rgb (255,0,0)", equals="#red")}, see={"hsb"})
    @GamlAnnotations.test(value="rgb (255,0,0) = #red")
    public static GamaColor rgb(int n, int n2, int n3) {
        return GamaColor.get(n, n2, n3, 255);
    }

    @GamlAnnotations.operator(value={"rgb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="rgb color", usages={@GamlAnnotations.usage(value="It can be used with r=red, g=green, b=blue (each between 0 and 255), a=alpha (between 0 and 255)")}, examples={@GamlAnnotations.example(value="rgb (255,0,0,125)", equals="a light red color", test=false)}, see={"hsb"})
    @GamlAnnotations.test(value="rgb (255,0,0,125).alpha = 125")
    public static GamaColor rgb(int n, int n2, int n3, int n4) {
        return GamaColor.get(n, n2, n3, n4);
    }

    @GamlAnnotations.operator(value={"rgb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="rgb color", usages={@GamlAnnotations.usage(value="It can be used with r=red, g=green, b=blue (each between 0 and 255), a=alpha (between 0.0 and 1.0)")}, examples={@GamlAnnotations.example(value="rgb (255,0,0,0.5)", equals="a light red color", test=false)}, see={"hsb"})
    @GamlAnnotations.test(value=" int(rgb (255,0,0,0.5)) = 2147418112")
    public static GamaColor rgb(int n, int n2, int n3, double d) {
        return GamaColor.getWithDoubleAlpha(n, n2, n3, d);
    }

    @GamlAnnotations.operator(value={"rgb"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="rgb named color", usages={@GamlAnnotations.usage(value="It can be used with a name of color and alpha (between 0 and 255)")}, examples={@GamlAnnotations.example(value="rgb (\"red\")", equals="rgb(255,0,0)")}, see={"hsb"})
    @GamlAnnotations.test(value="rgb ('red') = rgb(255,0,0) ")
    public static GamaColor rgb(IScope iScope, String string, int n) {
        return GamaColorType.staticCast(iScope, string, n, false);
    }

    @GamlAnnotations.operator(value={"rgb", "with_alpha"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="rgb color", usages={@GamlAnnotations.usage(value="It can be used with a color and an alpha between 0 and 255")}, examples={@GamlAnnotations.example(value="rgb(rgb(255,0,0),125)", equals="a light red color", test=false)}, see={"hsb"})
    @GamlAnnotations.test(value="int(rgb(rgb(255,0,0),125)) = 2113863680")
    public static GamaColor rgb(IScope iScope, GamaColor gamaColor, int n) {
        return GamaColorType.staticCast(iScope, gamaColor, n, false);
    }

    @GamlAnnotations.operator(value={"rgb", "with_alpha"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="rgb color", usages={@GamlAnnotations.usage(value="It can be used with a color and an alpha between 0 and 1")}, examples={@GamlAnnotations.example(value="rgb(rgb(255,0,0),0.5)", equals="a light red color", test=false)}, see={"hsb"})
    @GamlAnnotations.test(value="int(rgb(rgb(255,0,0),0.5)) = 2147418112")
    public static GamaColor rgb(IScope iScope, GamaColor gamaColor, double d) {
        return GamaColor.get((Color)gamaColor, d);
    }

    @GamlAnnotations.operator(value={"grayscale"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Converts rgb color to grayscale value", comment="r=red, g=green, b=blue. Between 0 and 255 and gray = 0.299 `*` red + 0.587 `*` green + 0.114 `*` blue (Photoshop value)", examples={@GamlAnnotations.example(value="grayscale (rgb(255,0,0))", equals="to a dark grey", isExecutable=false)}, see={"rgb", "hsb"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="int(grayscale (rgb(255,0,0))) = -11776948"), @GamlAnnotations.test(value="grayscale (rgb(255,0,0)) = rgb(76,76,76)")})
    public static GamaColor grayscale(GamaColor gamaColor) {
        int n = (int)(0.299 * (double)gamaColor.getRed() + 0.587 * (double)gamaColor.getGreen() + 0.114 * (double)gamaColor.getBlue());
        return GamaColor.get(n, n, n, gamaColor.getAlpha());
    }

    @GamlAnnotations.operator(value={"rnd_color"}, category={"Color-related operators"}, concept={"color", "random"})
    @GamlAnnotations.doc(value="rgb color", comment="Return a random color equivalent to rgb(rnd(operand),rnd(operand),rnd(operand))", examples={@GamlAnnotations.example(value="rnd_color(255)", equals="a random color, equivalent to rgb(rnd(255),rnd(255),rnd(255))", test=false)}, see={"rgb", "hsb"})
    @GamlAnnotations.test(value="seed <- 1.0; int(rnd_color(255)) = -3749758")
    public static GamaColor random_color(IScope iScope, Integer n) {
        RandomUtils randomUtils = iScope.getRandom();
        int n2 = Math.max(0, Math.min(n, 255));
        return GamaColor.get(randomUtils.between(0, n2), randomUtils.between(0, n2), randomUtils.between(0, n2), 255);
    }

    @GamlAnnotations.operator(value={"rnd_color"}, category={"Color-related operators"}, concept={"color", "random"})
    @GamlAnnotations.doc(value="Return a random color equivalent to rgb(rnd(first_op, last_op),rnd(first_op, last_op),rnd(first_op, last_op))", comment="", examples={@GamlAnnotations.example(value="rnd_color(100, 200)", equals="a random color, equivalent to rgb(rnd(100, 200),rnd(100, 200),rnd(100, 200))", test=false)}, see={"rgb", "hsb"})
    @GamlAnnotations.test(value="seed <- 1.0; int(rnd_color(100, 200)) = -5065833")
    public static GamaColor random_color(IScope iScope, Integer n, Integer n2) {
        RandomUtils randomUtils = iScope.getRandom();
        int n3 = Math.max(0, Math.min(n2, 255));
        int n4 = Math.max(0, Math.min(n, n3));
        return GamaColor.get(randomUtils.between(n4, n3), randomUtils.between(n4, n3), randomUtils.between(n4, n3), 255);
    }

    @GamlAnnotations.operator(value={"blend"}, can_be_const=true, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Blend two colors with an optional ratio (c1 `*` r + c2 `*` (1 - r)) between 0 and 1", masterDoc=true, examples={@GamlAnnotations.example(value="blend(#red, #blue, 0.3)", equals="to a color between the purple and the blue", isExecutable=false)}, see={"rgb", "hsb"})
    @GamlAnnotations.test(value="blend(#red, #blue, 0.3) = rgb(76,0,178)")
    public static GamaColor blend(GamaColor gamaColor, GamaColor gamaColor2, double d) {
        double d2 = 1.0 - d;
        return GamaColor.get((int)((double)gamaColor.getRed() * d + (double)gamaColor2.getRed() * d2), (int)((double)gamaColor.getGreen() * d + (double)gamaColor2.getGreen() * d2), (int)((double)gamaColor.getBlue() * d + (double)gamaColor2.getBlue() * d2), (int)((double)gamaColor.getAlpha() * d + (double)gamaColor2.getAlpha() * d2));
    }

    @GamlAnnotations.operator(value={"blend"}, can_be_const=true, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Blend two colors with an optional ratio (c1 `*` r + c2 `*` (1 - r)) between 0 and 1. If the ratio is omitted, an even blend is done", usages={@GamlAnnotations.usage(value="If the ratio is omitted, an even blend is done", examples={@GamlAnnotations.example(value="blend(#red, #blue)", equals="to a color very close to the purple", isExecutable=false)})}, see={"rgb", "hsb"})
    @GamlAnnotations.test(value="blend(#red, #blue) = rgb(127,0,127)")
    public static GamaColor blend(GamaColor gamaColor, GamaColor gamaColor2) {
        return Colors.blend(gamaColor, gamaColor2, 0.5);
    }

    @validator(value=BrewerValidator.class)
    @GamlAnnotations.operator(value={"brewer_colors"}, type=5, content_type=6, can_be_const=false, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Build a list of colors of a given type (see website http://colorbrewer2.org/). The list of palettes can be obtained by calling brewer_palettes. This list can be safely modified afterwards (adding or removing colors)", examples={@GamlAnnotations.example(value="list<rgb> colors <- brewer_colors(\"OrRd\")", equals="a list of 6 blue colors", isExecutable=false)}, see={"brewer_palettes"})
    public static GamaPalette brewerPaletteColors(IScope iScope, String string) {
        if (!BREWER.hasPalette(string)) {
            throw GamaRuntimeException.error(string + " does not exist", iScope);
        }
        try {
            return new GamaPalette((IList)BREWER_CACHE.get((Object)string));
        }
        catch (ExecutionException executionException) {
            throw GamaRuntimeException.error(string + " cannot be retrieved", iScope);
        }
    }

    @validator(value=BrewerValidator.class)
    @GamlAnnotations.operator(value={"brewer_colors"}, can_be_const=false, type=5, content_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Build a list of colors of a given type (see website http://colorbrewer2.org/) with a given number of classes", examples={@GamlAnnotations.example(value="list<rgb> colors <- brewer_colors(\"Pastel1\", 5)", equals="a list of 5 sequential colors in the palette named 'Pastel1'. The list of palettes can be obtained by calling brewer_palettes", isExecutable=false)}, see={"brewer_palettes"})
    public static GamaPalette brewerPaletteColors(IScope iScope, String string, int n) {
        GamaPalette gamaPalette = Colors.brewerPaletteColors(iScope, string);
        if (gamaPalette.size() < n) {
            throw GamaRuntimeException.error(string + " has less than " + n + " colors", iScope);
        }
        IList<GamaColor> iList = GamaListFactory.create(Types.COLOR);
        int n2 = 0;
        while (n2 < n) {
            iList.add((GamaColor)gamaPalette.get(n2));
            ++n2;
        }
        return new GamaPalette(iList);
    }

    @GamlAnnotations.operator(value={"brewer_palettes"}, can_be_const=false, content_type=6, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="Returns the list of palettes with a given min number of classes and max number of classes)", examples={@GamlAnnotations.example(value="list<string> palettes <- brewer_palettes(5,10)", equals="a list of palettes that are composed of a min of 5 colors and a max of 10 colors", isExecutable=false)}, see={"brewer_colors"})
    public static IList<String> brewerPaletteNames(int n, int n2) {
        IList<String> iList = GamaListFactory.create(Types.STRING);
        BrewerPalette[] brewerPaletteArray = BREWER.getPalettes();
        int n3 = brewerPaletteArray.length;
        int n4 = 0;
        while (n4 < n3) {
            BrewerPalette brewerPalette = brewerPaletteArray[n4];
            if (brewerPalette.getCount() >= n && brewerPalette.getCount() <= n2) {
                iList.add(brewerPalette.getName());
            }
            ++n4;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"brewer_palettes"}, can_be_const=false, content_type=4, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="Returns the list of palettes with a given min number of classes)", examples={@GamlAnnotations.example(value="list<string> palettes <- brewer_palettes(3)", equals="a list of palettes that are composed of a min of 3 colors", isExecutable=false)}, see={"brewer_colors"})
    public static IList<String> brewerPaletteNames(int n) {
        IList<String> iList = GamaListFactory.create(Types.STRING);
        BrewerPalette[] brewerPaletteArray = BREWER.getPalettes();
        int n2 = brewerPaletteArray.length;
        int n3 = 0;
        while (n3 < n2) {
            BrewerPalette brewerPalette = brewerPaletteArray[n3];
            if (brewerPalette.getCount() >= n) {
                iList.add(brewerPalette.getName());
            }
            ++n3;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"gradient"}, can_be_const=true, type=10, content_type=2, index_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns the definition of a linear gradient between two colors, represented internally as a color map [start::0.0,stop::1.0]")
    public static GamaGradient gradient(GamaColor gamaColor, GamaColor gamaColor2) {
        GamaGradient gamaGradient = new GamaGradient();
        gamaGradient.put(gamaColor, 0.0);
        gamaGradient.put(gamaColor2, 1.0);
        return gamaGradient;
    }

    @GamlAnnotations.operator(value={"gradient"}, can_be_const=true, type=10, content_type=2, index_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns the definition of a linear gradient between two colors, with a ratio (between 0 and 1, otherwise clamped) represented internally as a color map [start::0.0,(start*r+stop*(1-r))::r, stop::1.0]")
    public static GamaGradient gradient(GamaColor gamaColor, GamaColor gamaColor2, Double d) {
        double d2 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        GamaGradient gamaGradient = new GamaGradient();
        gamaGradient.put(gamaColor, 0.0);
        gamaGradient.put(Colors.blend(gamaColor, gamaColor2, d2), d2);
        gamaGradient.put(gamaColor2, 1.0);
        return gamaGradient;
    }

    @GamlAnnotations.operator(value={"gradient"}, can_be_const=true, type=10, content_type=2, index_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns the definition of a linear gradient between n colors, represented internally as a color map [c1::0,c2::1/n-1, ... cn::n-1/n-1]")
    public static GamaGradient gradient(IScope iScope, IList<GamaColor> iList) {
        GamaGradient gamaGradient = new GamaGradient();
        if (iList.size() < 2) {
            throw GamaRuntimeException.error("A gradient must at least propose 2 colors", iScope);
        }
        int n = iList.size();
        int n2 = 1;
        for (GamaColor gamaColor : iList) {
            gamaGradient.put(gamaColor, (double)n2++ - 1.0 / (double)n - 1.0);
        }
        return gamaGradient;
    }

    @GamlAnnotations.operator(value={"gradient"}, can_be_const=true, type=10, expected_content_type={2}, content_type=2, index_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns the definition of a linear gradient between n colors provided with their positions on a scale between 0 and 1. A similar color map is returned, in the same color order, with all the positions normalized (so that they are shifted and scaled to fit between 0 and 1). Throws an error if the number of colors is less than 2 or if the positions are not strictly ordered")
    public static GamaGradient gradient(IScope iScope, IMap<GamaColor, Number> iMap) {
        double d;
        if (iMap.size() < 2) {
            throw GamaRuntimeException.error("A gradient must at least propose 2 colors", iScope);
        }
        GamaGradient gamaGradient = new GamaGradient();
        Double d2 = Double.MAX_VALUE;
        Double d3 = Double.MIN_VALUE;
        double d4 = -4.9E-324;
        for (Number number2 : iMap.values()) {
            d = number2.doubleValue();
            if (d <= d4) {
                throw GamaRuntimeException.error("The positions of the colors in the gradient must be provided in a stricly increasing order", iScope);
            }
            if (d < d2) {
                d2 = d;
                continue;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        double d5 = d2;
        d = d3 - d2;
        iMap.forEach((gamaColor, number) -> {
            Double d3 = gamaGradient.put(gamaColor, (number.doubleValue() + d5) / d);
        });
        return gamaGradient;
    }

    @GamlAnnotations.operator(value={"scale"}, can_be_const=true, type=10, content_type=2, index_type=6, category={"Color-related operators"}, concept={})
    @GamlAnnotations.doc(see={"gradient"}, value="Similar to gradient(map<rgb, float>) but reorders the colors based on their weight and does not normalize them, so as to effectively represent a color scale (i.e. a correspondance between a range of value and a color that implicitly begins with the lowest value). For instance scale([#red::10, #green::0, #blue::30]) would produce the reverse map and associate #green to the interval 0-10, #red to 10-30, and #blue above 30. The main difference in usages is that, for instance in the definition of a mesh to display, a gradient will produce interpolated colors to accomodate for the intermediary values, while a scale will stick to the colors defined.")
    public static GamaScale scale(IScope iScope, IMap<GamaColor, Object> iMap) {
        IMap iMap2 = GamaMapFactory.createOrdered();
        iMap.forEach((gamaColor, object) -> {
            GamaColor gamaColor2 = iMap2.put(Cast.asFloat(iScope, object), gamaColor);
        });
        return new GamaScale(iScope, iMap2);
    }

    @GamlAnnotations.operator(value={"scale"}, can_be_const=true, type=10, content_type=6, index_type=2, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(see={"gradient"}, value="Expects a gradient, i.e. a map<rgb,float>, where values represent the different stops of the colors. First normalizes the passed gradient, and then applies the resulting weights to the interval represented by min and max, so as to return a scale (i.e. absolute values instead of the stops)")
    public static GamaScale scale(IScope iScope, IMap<GamaColor, Object> iMap, double d, double d2) {
        double d3 = 0.0;
        for (Map.Entry entry : iMap.entrySet()) {
            double d4 = Cast.asFloat(iScope, entry.getValue());
            entry.setValue(d4);
            d3 += d4;
        }
        double d5 = d3;
        IMap iMap2 = GamaMapFactory.createOrdered();
        iMap.forEach((gamaColor, object) -> {
            GamaColor gamaColor2 = iMap2.put(d + (d2 - d) * Cast.asFloat(iScope, object) / d5, gamaColor);
        });
        return new GamaScale(iScope, iMap2);
    }

    @GamlAnnotations.operator(value={"palette"}, can_be_const=true, type=5, expected_content_type={6}, content_type=6, category={"Color-related operators"}, concept={"color"})
    @GamlAnnotations.doc(value="transforms a list of n colors into a palette (necessary for some layers)")
    public static GamaPalette palette(IScope iScope, IList<GamaColor> iList) {
        return new GamaPalette(iList);
    }

    public static class BrewerValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            Object object;
            if (iExpressionArray[0].isConst() && (object = iExpressionArray[0].getConstValue()) instanceof String) {
                BrewerPalette brewerPalette;
                Object object2;
                IExpression iExpression;
                String string = (String)object;
                if (!BREWER.hasPalette(string)) {
                    iDescription.error("Palette " + string + " does not exist. Available palette names are: " + Arrays.toString(BREWER.getPaletteNames()), "gaml.unknonw.argument.issue", this.getArg(eObject, 1), new String[0]);
                    return false;
                }
                if (iExpressionArray.length > 1 && (iExpression = iExpressionArray[1]).isConst() && (object2 = iExpression.getConstValue()) instanceof Integer && (brewerPalette = BREWER.getPalette(string)).getCount() < (Integer)object2) {
                    iDescription.warning("Palette " + string + " has only " + brewerPalette.getCount() + " colors.", "gaml.wrong.value", this.getArg(eObject, 1), String.valueOf(brewerPalette.getCount()));
                }
            }
            return true;
        }
    }

    public static class GamaGradient
    extends GamaMap<GamaColor, Double> {
        protected GamaGradient() {
            super(5, Types.COLOR, Types.FLOAT);
        }

        public void set(IScope iScope, IMap<Object, Object> iMap) {
            for (Map.Entry entry : iMap.entrySet()) {
                this.put(Cast.asColor(iScope, entry.getKey()), Cast.asFloat(iScope, entry.getValue()));
            }
        }
    }

    public static class GamaPalette
    extends GamaList<GamaColor> {
        GamaPalette(IList<GamaColor> iList) {
            super(100, Types.COLOR);
            this.addAll(iList);
        }
    }

    public static class GamaScale
    extends GamaMap<Double, GamaColor> {
        public GamaScale(IScope iScope, IMap<Double, GamaColor> iMap) {
            super(iMap.size(), Types.FLOAT, Types.COLOR);
            this.sort(iMap);
        }

        void sort(Map<Double, GamaColor> map) {
            ArrayList<Map.Entry<Double, GamaColor>> arrayList = new ArrayList<Map.Entry<Double, GamaColor>>(map.entrySet());
            Collections.sort(arrayList, (entry, entry2) -> ((Double)entry.getKey()).compareTo((Double)entry2.getKey()));
            for (Map.Entry entry3 : arrayList) {
                this.put((Double)entry3.getKey(), (GamaColor)entry3.getValue());
            }
        }
    }
}

