/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.test;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaAssertException;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.statements.test.AssertionSummary;
import gama.gaml.statements.test.TestState;
import gama.gaml.statements.test.WithTestSummary;
import java.util.Collection;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="value", type={3}, optional=false, doc={@GamlAnnotations.doc(value="a boolean expression. If its evaluation is true, the assertion is successful. Otherwise, an error (or a warning) is raised.")}), @GamlAnnotations.facet(name="label", type={4}, optional=true, doc={@GamlAnnotations.doc(value="a string displayed instead of the failed expression in order to customize the error or warning if the assertion is false")}), @GamlAnnotations.facet(name="warning", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if set to true, makes the assertion emit a warning instead of an error")})}, omissible="value")
@GamlAnnotations.inside(symbols={"test", "action"}, kinds={11, 3, 11})
@GamlAnnotations.doc(value="Allows to check if the evaluation of a given expression returns true. If not, an error (or a warning) is raised. If the statement is used inside a test, the error is not propagagated but invalidates the test (in case of a warning, it partially invalidates it). Otherwise, it is normally propagated", usages={@GamlAnnotations.usage(value="Any boolean expression can be used", examples={@GamlAnnotations.example(value="assert (2+2) = 4;"), @GamlAnnotations.example(value="assert self != nil;"), @GamlAnnotations.example(value="int t <- 0; assert is_error(3/t);"), @GamlAnnotations.example(value="(1 / 2) is float")}), @GamlAnnotations.usage(value="if the 'warn:' facet is set to true, the statement emits a warning (instead of an error) in case the expression is false", examples={@GamlAnnotations.example(value="assert 'abc' is string warning: true")})}, see={"test", "setup", "is_error", "is_warning"})
public class AssertStatement
extends AbstractStatement
implements WithTestSummary<AssertionSummary> {
    final IExpression value = this.getFacet("value");
    final IExpression warn = this.getFacet("warning");
    final IExpression label = this.getFacet("label");
    final AssertionSummary summary = new AssertionSummary(this);

    public AssertStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        boolean bl;
        this.summary.reset();
        try {
            bl = Cast.asBool(iScope, this.value.value(iScope));
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            this.summary.setError(gamaRuntimeException.getMessage());
            this.summary.setState(TestState.ABORTED);
            throw gamaRuntimeException;
        }
        if (!bl) {
            TestState testState = this.isWarning(iScope) ? TestState.WARNING : TestState.FAILED;
            this.summary.setState(testState);
            throw new GamaAssertException(iScope, "Assert failed: " + (this.label == null ? this.getTitleForSummary() : Cast.asString(iScope, this.label.value(iScope))), this.isWarning(iScope));
        }
        this.summary.setState(TestState.PASSED);
        return bl;
    }

    public boolean isWarning(IScope iScope) {
        return this.warn != null && Cast.asBool(iScope, this.warn.value(iScope)) != false;
    }

    @Override
    public AssertionSummary getSummary() {
        return this.summary;
    }

    @Override
    public String getTitleForSummary() {
        return this.value.serializeToGaml(true);
    }

    @Override
    public Collection<? extends WithTestSummary<?>> getSubElements() {
        return null;
    }
}

