/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.util;

import com.google.common.collect.Iterables;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.model.IModel;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dependencies.webb.Webb;
import gama.dependencies.webb.WebbException;
import gama.dev.DEBUG;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class FileUtils {
    public static final ThreadLocal<Webb> WEB = ThreadLocal.withInitial(Webb::create);
    public static final String URL_SEPARATOR_REPLACEMENT = "+_+";
    public static final String COPY_OF = "copy of ";
    public static final String HOME = "~";
    public static final String SEPARATOR = "/";
    public static final IPath CACHE_FOLDER_PATH = new Path(".cache");
    public static final IPath EXTERNAL_FOLDER_PATH = new Path("external");
    static IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    static IFileSystem FILE_SYSTEM = EFS.getLocalFileSystem();
    static String USER_HOME = System.getProperty("user.home");
    static final URI WORKSPACE_URI = URI.createURI((String)ROOT.getLocationURI().toString(), (boolean)false);
    public static final File CACHE;

    static {
        DEBUG.OFF();
        CACHE = new File(ROOT.getLocation().toFile().getAbsolutePath() + SEPARATOR + CACHE_FOLDER_PATH.toString());
        if (!CACHE.exists()) {
            CACHE.mkdirs();
        }
        try {
            ROOT.getPathVariableManager().setValue("CACHE_LOC", ROOT.getLocation().append(CACHE_FOLDER_PATH));
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    static boolean isAbsolutePath(String string) {
        return Paths.get(string, new String[0]).isAbsolute();
    }

    public static String constructAbsoluteFilePath(IScope iScope, String string, boolean bl) {
        IExperimentAgent iExperimentAgent;
        String string2 = string.startsWith(HOME) ? string.replaceFirst(HOME, USER_HOME) : string;
        if (FileUtils.isAbsolutePath(string2)) {
            String string3;
            IModel object;
            iExperimentAgent = null;
            if (iScope != null && (object = iScope.getModel()) != null) {
                iExperimentAgent = object.getURI();
            }
            if ((string3 = FileUtils.findOutsideWorkspace(string2, (URI)iExperimentAgent, bl)) != null) {
                return string3;
            }
        }
        if (iScope != null) {
            iExperimentAgent = iScope.getExperiment();
            if (iExperimentAgent == null) {
                return string2;
            }
            if (!iExperimentAgent.isHeadless()) {
                for (String string4 : iExperimentAgent.getWorkingPaths()) {
                    IContainer[] iContainerArray;
                    IContainer[] iContainerArray2 = iContainerArray = ROOT.findContainersForLocation((IPath)new Path(string4));
                    int n = iContainerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer iContainer = iContainerArray2[n2];
                        String string5 = FileUtils.findInWorkspace(string2, iContainer, bl);
                        if (string5 != null) {
                            DEBUG.OUT((Object)("Hit with workspace-based search: " + string5));
                            return string5;
                        }
                        ++n2;
                    }
                }
            }
        }
        DEBUG.OUT((Object)"Falling back to the old JavaIO based search");
        return FileUtils.constructAbsoluteFilePathAlternate(iScope, string2, bl);
    }

    public static String constructAbsoluteFilePathAlternate(IScope iScope, String string2, boolean bl) throws GamaRuntimeException.GamaRuntimeFileException {
        if (iScope == null) {
            return string2;
        }
        String string3 = null;
        Iterable iterable = null;
        IExperimentAgent iExperimentAgent = iScope.getExperiment();
        try {
            iterable = Iterables.transform(iExperimentAgent.getWorkingPaths(), string -> {
                try {
                    String string2 = URLDecoder.decode(string, "UTF-8");
                    return string2.endsWith(SEPARATOR) ? string2 : string2 + SEPARATOR;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return string;
                }
            });
            string3 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = string2;
        }
        GamaRuntimeException.GamaRuntimeFileException gamaRuntimeFileException = new GamaRuntimeException.GamaRuntimeFileException(iScope, "File denoted by " + string3 + " not found.");
        File file2 = null;
        if (FileUtils.isAbsolutePath(string3)) {
            file2 = new File(string3);
            if (file2.exists() || !bl) {
                try {
                    return file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return file2.getAbsolutePath();
                }
            }
            File[] fileArray = File.listRoots();
            for (String string4 : iterable) {
                Object object;
                File[] fileArray2 = fileArray;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = fileArray2[n2];
                    if (string3.startsWith(((File)object).getAbsolutePath())) {
                        string3 = string3.substring(((File)object).getAbsolutePath().length());
                    }
                    ++n2;
                }
                object = string4 + string3;
                file2 = new File((String)object);
                if (file2.exists()) {
                    try {
                        return file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return file2.getAbsolutePath();
                    }
                }
                gamaRuntimeFileException.addContext(file2.getAbsolutePath());
            }
        } else {
            for (String string5 : iterable) {
                file2 = new File(string5 + string3);
                if (file2.exists()) {
                    try {
                        if (iScope.getExperiment().isHeadless()) {
                            return file2.getAbsolutePath();
                        }
                        return file2.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        return file2.getAbsolutePath();
                    }
                }
                gamaRuntimeFileException.addContext(file2.getAbsolutePath());
            }
            if (!bl) {
                try {
                    return new File((String)Iterables.get((Iterable)iterable, (int)0) + string3).getCanonicalPath();
                }
                catch (IOException iOException) {}
            }
        }
        throw gamaRuntimeFileException;
    }

    private static String findInWorkspace(String string, IContainer iContainer, boolean bl) {
        IPath iPath = iContainer.getFullPath().append(string);
        IFile iFile = ROOT.getFile(iPath);
        if (!iFile.exists()) {
            iFile = ROOT.getFolder(iPath);
        }
        if (!iFile.exists() && bl) {
            return null;
        }
        IPath iPath2 = iFile.getLocation();
        if (iPath2 == null) {
            return string;
        }
        return iPath2.toString();
    }

    private static String findOutsideWorkspace(String string, URI uRI, boolean bl) {
        if (!bl) {
            return string;
        }
        IFileStore iFileStore = FILE_SYSTEM.getStore((IPath)new Path(string));
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        if (iFileInfo.exists()) {
            IFile iFile = FileUtils.createLinkToExternalFile(string, uRI);
            if (iFile == null) {
                return string;
            }
            return iFile.getLocation().toFile().getAbsolutePath();
        }
        return null;
    }

    public static IFile createLinkToExternalFile(String string, URI uRI) {
        Path path = new Path(string);
        IFile[] iFileArray = ROOT.findFilesForLocation((IPath)path);
        if (iFileArray.length > 0) {
            return iFileArray[0];
        }
        IFolder iFolder = FileUtils.createExternalFolder(uRI);
        if (iFolder == null) {
            return null;
        }
        IFile iFile = FileUtils.findExistingLinkedFile(iFolder, string);
        if (iFile != null) {
            return iFile;
        }
        String string2 = new Path(string).lastSegment();
        if (string2 != null) {
            int n = string2.lastIndexOf(URL_SEPARATOR_REPLACEMENT);
            if (n > -1) {
                string2 = string2.substring(n + URL_SEPARATOR_REPLACEMENT.length());
            }
            iFile = FileUtils.correctlyNamedFile(iFolder, string2);
        }
        return FileUtils.createLinkedFile(string, iFile);
    }

    public static IContainer createLinkToExternalFolder(String string, URI uRI) {
        Path path = new Path(string);
        IContainer[] iContainerArray = ROOT.findContainersForLocation((IPath)path);
        if (iContainerArray.length > 0) {
            return iContainerArray[0];
        }
        IFolder iFolder = FileUtils.createExternalFolder(uRI);
        if (iFolder == null) {
            return null;
        }
        IFolder iFolder2 = FileUtils.findExistingLinkedFolder(iFolder, string);
        if (iFolder2 != null) {
            return iFolder2;
        }
        String string2 = new Path(string).lastSegment();
        int n = string2.lastIndexOf(URL_SEPARATOR_REPLACEMENT);
        if (n > -1) {
            string2 = string2.substring(n + URL_SEPARATOR_REPLACEMENT.length());
        }
        iFolder2 = FileUtils.correctlyNamedFolder(iFolder, string2);
        return FileUtils.createLinkedFolder(string, iFolder2);
    }

    public static URI getURI(String string, URI uRI) {
        if (string == null) {
            return null;
        }
        try {
            URI uRI2;
            IPath iPath = Path.fromOSString((String)string);
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
            IFileInfo iFileInfo = iFileStore.fetchInfo();
            if (iFileInfo.exists()) {
                return URI.createFileURI((String)string);
            }
            URI uRI3 = URI.createURI((String)string, (boolean)false);
            URI uRI4 = !uRI.isPlatformResource() ? URI.createPlatformResourceURI((String)uRI.toString(), (boolean)false) : uRI;
            if (uRI4 == null) {
                uRI4 = WORKSPACE_URI;
            }
            if (FileUtils.isFileExistingInWorkspace(uRI2 = uRI3.resolve(uRI4))) {
                return uRI2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String escapeFilePath(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static boolean isFileExistingInWorkspace(URI uRI) {
        if (uRI == null) {
            return false;
        }
        IFile iFile = FileUtils.getWorkspaceFile(uRI);
        if (iFile != null) {
            return iFile.exists();
        }
        return false;
    }

    public static IFile getFile(String string, URI uRI, boolean bl) {
        URI uRI2 = FileUtils.getURI(string, uRI);
        if (uRI2 != null) {
            if (uRI2.isPlatformResource()) {
                return FileUtils.getWorkspaceFile(uRI2);
            }
            return FileUtils.createLinkToExternalFile(string, uRI);
        }
        return null;
    }

    public static IContainer getFolder(String string, URI uRI, boolean bl) {
        URI uRI2 = FileUtils.getURI(string, uRI);
        if (uRI2 != null) {
            if (uRI2.isPlatformResource()) {
                return FileUtils.getWorkspaceFolder(uRI2);
            }
            return FileUtils.createLinkToExternalFolder(string, uRI);
        }
        return null;
    }

    private static IFile createLinkedFile(String string, IFile iFile) {
        if (iFile == null) {
            return null;
        }
        java.net.URI uRI = null;
        java.net.URI uRI2 = URIUtil.toURI((String)string);
        try {
            uRI = ROOT.getPathVariableManager().convertToRelative(uRI2, true, null);
        }
        catch (CoreException coreException) {
            uRI = uRI2;
        }
        try {
            iFile.createLink(uRI, 0, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return iFile;
    }

    private static IFolder createLinkedFolder(String string, IFolder iFolder) {
        java.net.URI uRI = null;
        java.net.URI uRI2 = URIUtil.toURI((String)string);
        try {
            uRI = ROOT.getPathVariableManager().convertToRelative(uRI2, true, null);
        }
        catch (CoreException coreException) {
            uRI = uRI2;
        }
        try {
            iFolder.createLink(uRI, 0, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return null;
        }
        return iFolder;
    }

    private static IFile correctlyNamedFile(IFolder iFolder, String string) {
        IFile iFile;
        Object object = string;
        do {
            iFile = iFolder.getFile((String)object);
            object = COPY_OF + (String)object;
        } while (iFile.exists());
        return iFile;
    }

    private static IFolder correctlyNamedFolder(IFolder iFolder, String string) {
        IFolder iFolder2;
        Object object = string;
        do {
            iFolder2 = iFolder.getFolder((String)object);
            object = COPY_OF + (String)object;
        } while (iFolder2.exists());
        return iFolder2;
    }

    private static IFile findExistingLinkedFile(IFolder iFolder, String string) {
        IFile[] iFileArray = new IFile[1];
        try {
            iFolder.accept(iResource -> {
                String string2;
                if (iResource.isLinked() && (string2 = iResource.getLocation().toString()).equals(string)) {
                    iFileArray[0] = (IFile)iResource;
                    return false;
                }
                return true;
            }, 2, 1);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFileArray[0];
    }

    private static IFolder findExistingLinkedFolder(IFolder iFolder, String string) {
        IFolder[] iFolderArray = new IFolder[1];
        try {
            iFolder.accept(iResource -> {
                String string2;
                if (iResource.isLinked() && (string2 = iResource.getLocation().toString()).equals(string)) {
                    iFolderArray[0] = (IFolder)iResource;
                    return false;
                }
                return true;
            }, 2, 2);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFolderArray[0];
    }

    private static IFolder createExternalFolder(URI uRI) {
        if (uRI == null || !FileUtils.isFileExistingInWorkspace(uRI)) {
            return null;
        }
        IFile iFile = FileUtils.getWorkspaceFile(uRI);
        IProject iProject = iFile.getProject();
        if (!iProject.exists()) {
            return null;
        }
        IFolder iFolder = iProject.getFolder(EXTERNAL_FOLDER_PATH);
        if (!iFolder.exists()) {
            try {
                iFolder.create(true, true, null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return null;
            }
        }
        return iFolder;
    }

    public static IFile getWorkspaceFile(URI uRI) {
        Path path;
        IFile iFile;
        Path path2 = new Path(URI.decode((String)uRI.toString()));
        try {
            iFile = ROOT.getFile((IPath)path2);
        }
        catch (Exception exception) {
            return null;
        }
        if (iFile != null && iFile.exists()) {
            return iFile;
        }
        String string = uRI.toPlatformString(true);
        Path path3 = path = string != null ? new Path(string) : null;
        if (path == null) {
            return null;
        }
        try {
            iFile = ROOT.getFile((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        if (iFile != null && iFile.exists()) {
            return iFile;
        }
        return null;
    }

    public static IFolder getWorkspaceFolder(URI uRI) {
        Path path;
        IFolder iFolder;
        Path path2 = new Path(URI.decode((String)uRI.toString()));
        try {
            iFolder = ROOT.getFolder((IPath)path2);
        }
        catch (Exception exception) {
            return null;
        }
        if (iFolder != null && iFolder.exists()) {
            return iFolder;
        }
        String string = uRI.toPlatformString(true);
        Path path3 = path = string != null ? new Path(string) : null;
        if (path == null) {
            return null;
        }
        try {
            iFolder = ROOT.getFolder((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        if (iFolder != null && iFolder.exists()) {
            return iFolder;
        }
        return null;
    }

    public static String constructAbsoluteTempFilePath(IScope iScope, URL uRL) {
        Object object = uRL.getQuery();
        if (object != null) {
            object = "?" + (String)object;
        }
        return CACHE.getAbsolutePath() + SEPARATOR + uRL.getHost() + URL_SEPARATOR_REPLACEMENT + uRL.getPath().replace(SEPARATOR, URL_SEPARATOR_REPLACEMENT) + FileUtils.checkSum((String)object);
    }

    private static String constructRelativeTempFilePath(IScope iScope, URL uRL) {
        String string = uRL.getQuery();
        long l = FileUtils.checkSum(string);
        String string2 = l == 0L ? "" : String.valueOf(l);
        return "CACHE_LOC/" + uRL.getHost() + URL_SEPARATOR_REPLACEMENT + uRL.getPath().replace(SEPARATOR, URL_SEPARATOR_REPLACEMENT) + string2;
    }

    private static long checkSum(String string) {
        if (string == null) {
            return 0L;
        }
        long l = 1125899906842597L;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            l = 31L * l + (long)string.charAt(n2);
            ++n2;
        }
        return l;
    }

    public static void cleanCache() {
        File[] fileArray;
        if (GamaPreferences.External.CORE_HTTP_EMPTY_CACHE.getValue().booleanValue() && (fileArray = CACHE.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                if (!file2.isDirectory()) {
                    try {
                        file2.delete();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    public static boolean isDirectoryOrNullExternalFile(String string) {
        IFileStore iFileStore = FILE_SYSTEM.getStore((IPath)new Path(string));
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        return iFileInfo.isDirectory() || !iFileInfo.exists();
    }

    public static String fetchToTempFile(IScope iScope, URL uRL) {
        String string = FileUtils.constructRelativeTempFilePath(iScope, uRL);
        String string2 = uRL.toExternalForm();
        String string3 = "Downloading file " + string2.substring(string2.lastIndexOf(SEPARATOR));
        iScope.getGui().getStatus().beginSubStatus(iScope, string3);
        Webb webb = WEB.get();
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream inputStream = (InputStream)webb.get(string2).ensureSuccess().connectTimeout(GamaPreferences.External.CORE_HTTP_CONNECT_TIMEOUT.getValue().intValue()).readTimeout(GamaPreferences.External.CORE_HTTP_READ_TIMEOUT.getValue().intValue()).retry(GamaPreferences.External.CORE_HTTP_RETRY_NUMBER.getValue().intValue(), false).asStream().getBody();){
                    string = ROOT.getPathVariableManager().resolvePath((IPath)new Path(string)).toOSString();
                    java.nio.file.Path path = new File(string).toPath();
                    if (Files.exists(path, new LinkOption[0])) {
                        Files.delete(path);
                    }
                    Files.copy(inputStream, path, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (WebbException | IOException throwable) {
                throw GamaRuntimeException.create(throwable, iScope);
            }
        }
        finally {
            iScope.getGui().getStatus().endSubStatus(iScope, string3);
        }
        return string;
    }
}

