/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.batch.BatchOutput;
import gama.core.kernel.batch.IExploration;
import gama.core.kernel.batch.exploration.Exploration;
import gama.core.kernel.experiment.DefaultExperimentController;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.ExperimentParameter;
import gama.core.kernel.experiment.HeadlessExperimentController;
import gama.core.kernel.experiment.ICategory;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.TextStatement;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.population.GamaPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.topology.continuous.AmorphousTopology;
import gama.core.outputs.ExperimentOutputManager;
import gama.core.outputs.IOutputManager;
import gama.core.outputs.LayoutStatement;
import gama.core.outputs.SimulationOutputManager;
import gama.core.runtime.ExecutionScope;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.GamlSpecies;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@GamlAnnotations.doc(value="Declaration of a particular type of agent that can manage simulations. If the experiment directly imports a model using the 'model:' facet, this facet *must* be the first one after the name of the experiment. Any experiment attached to a model is a species (introduced by the keyword 'experiment' which directly or indirectly inherits from an abstract species called 'experiment' itself. This abstract species (sub-species of 'agent') defines several attributes and actions that can then be used in any experiment. Experiments also define several attributes, which, in addition to the attributes inherited from agent, form the minimal set of knowledge any experiment will have access to.")
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="identifier of the experiment")}), @GamlAnnotations.facet(name="title", type={4}, optional=false, doc={@GamlAnnotations.doc(value="")}, internal=true), @GamlAnnotations.facet(name="benchmark", type={3}, optional=true, doc={@GamlAnnotations.doc(value="If true, make GAMA record the number of invocations and running time of the statements and operators of the simulations launched in this experiment. The results are automatically saved in a csv file in a folder called 'benchmarks' when the experiment is closed")}, internal=false), @GamlAnnotations.facet(name="parent", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the parent experiment (in case of inheritance between experiments)")}), @GamlAnnotations.facet(name="skills", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the skills attached to the experiment")}, internal=true), @GamlAnnotations.facet(name="control", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the control architecture used for defining the behavior of the experiment")}, internal=true), @GamlAnnotations.facet(name="keep_seed", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Allows to keep the same seed between simulations. Mainly useful for batch experiments")}), @GamlAnnotations.facet(name="keep_simulations", type={3}, optional=true, doc={@GamlAnnotations.doc(value="In the case of a batch experiment, specifies whether or not the simulations should be kept in memory for further analysis or immediately discarded with only their fitness kept in memory")}), @GamlAnnotations.facet(name="repeat", type={1}, optional=true, doc={@GamlAnnotations.doc(value="In the case of a batch experiment, expresses hom many times the simulations must be repeated")}), @GamlAnnotations.facet(name="until", type={3}, optional=true, doc={@GamlAnnotations.doc(value="In the case of a batch experiment, an expression that will be evaluated to know when a simulation should be terminated")}), @GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="When set to true, use multiple threads to run its simulations. Setting it to n will set the numbers of threads to use")}), @GamlAnnotations.facet(name="type", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="The type of the experiment: `gui`, `batch`, `test`, etc.")}), @GamlAnnotations.facet(name="virtual", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the experiment is virtual (cannot be instantiated, but only used as a parent, false by default)")}), @GamlAnnotations.facet(name="schedules", type={16}, of=11, optional=true, internal=true, doc={@GamlAnnotations.doc(value="A container of agents (a species, a dynamic list, or a combination of species and containers) , which represents which agents will be actually scheduled when the population is scheduled for execution. For instance, 'species a schedules: (10 among a)' will result in a population that schedules only 10 of its own agents every cycle. 'species b schedules: []' will prevent the agents of 'b' to be scheduled. Note that the scope of agents covered here can be larger than the population, which allows to build complex scheduling controls; for instance, defining 'global schedules: [] {...} species b schedules: []; species c schedules: b + world; ' allows to simulate a model where the agents of b are scheduled first, followed by the world, without even having to create an instance of c.")}), @GamlAnnotations.facet(name="record", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Cannot be used in batch experiments. Whether the simulations run by this experiment are recorded so that they be run backward. Boolean expression expected, which will be evaluated by simulations at each cycle, so that the recording can occur based on specific conditions (for instance 'every(10#cycles)'). A value of 'true' will record each step.")}), @GamlAnnotations.facet(name="autorun", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether this experiment should be run automatically when launched (false by default)")})}, omissible="name")
@GamlAnnotations.inside(kinds={1})
@validator(value=BatchValidator.class)
public class ExperimentPlan
extends GamlSpecies
implements IExperimentPlan {
    protected IExperimentController controller;
    protected SimulationOutputManager originalSimulationOutputs;
    protected ExperimentOutputManager experimentOutputs;
    protected final Map<String, IParameter> parameters = GamaMapFactory.create();
    protected final Map<String, IParameter.Batch> explorableParameters = GamaMapFactory.create();
    protected ExperimentAgent agent;
    protected final Scope myScope = new Scope("in ExperimentPlan");
    protected IModel model;
    protected IExploration exploration;
    private boolean isHeadless;
    private final boolean keepSeed;
    private final boolean keepSimulations;
    private final String experimentType;
    private final boolean autorun;
    private final boolean benchmarkable;
    private final IExpression shouldRecord;
    private final List<IExperimentDisplayable> displayables = new ArrayList<IExperimentDisplayable>();
    private IExpression stopCondition;
    private volatile boolean reloading;

    @Override
    public boolean isHeadless() {
        return GAMA.isInHeadLessMode() || this.isHeadless;
    }

    @Override
    public void setHeadless(boolean bl) {
        this.isHeadless = bl;
    }

    @Override
    public ExperimentAgent getAgent() {
        return this.agent;
    }

    public ExperimentPlan(IDescription iDescription) {
        super(iDescription);
        IExpression iExpression;
        this.setName(iDescription.getName());
        this.experimentType = iDescription.getLitteral("type");
        if ("batch".equals(this.experimentType) || "test".equals(this.experimentType)) {
            this.exploration = new Exploration(null);
        }
        this.keepSeed = (iExpression = this.getFacet("keep_seed")) != null && iExpression.isConst() ? Cast.asBool(this.myScope, iExpression.value(this.myScope)) : false;
        IExpression iExpression2 = this.getFacet("keep_simulations");
        this.keepSimulations = iExpression2 != null && iExpression2.isConst() && "batch".equals(this.experimentType) ? Cast.asBool(this.myScope, iExpression2.value(this.myScope)) : true;
        IExpression iExpression3 = this.getFacet("autorun");
        this.autorun = iExpression3 == null ? GamaPreferences.Runtime.CORE_AUTO_RUN.getValue().booleanValue() : Cast.asBool(this.myScope, iExpression3.value(this.myScope)).booleanValue();
        IExpression iExpression4 = this.getFacet("benchmark");
        this.benchmarkable = iExpression4 != null && Cast.asBool(this.myScope, iExpression4.value(this.myScope)) != false;
        this.shouldRecord = this.getFacet("record");
        this.stopCondition = this.getFacet("until");
    }

    @Override
    public IExpression getStopCondition() {
        return this.stopCondition;
    }

    @Override
    public void setStopCondition(IExpression iExpression) {
        this.stopCondition = iExpression;
    }

    @Override
    public boolean isAutorun() {
        return this.autorun;
    }

    @Override
    public boolean keepsSeed() {
        return this.keepSeed;
    }

    @Override
    public boolean keepsSimulations() {
        return this.keepSimulations;
    }

    @Override
    public void dispose() {
        GAMA.getPlatformAgent().restorePrefs();
        if (this.controller != null) {
            this.controller.dispose();
        }
        if (this.agent != null) {
            this.agent.dispose();
            this.agent = null;
        }
        if (this.originalSimulationOutputs != null) {
            this.originalSimulationOutputs.dispose();
            this.originalSimulationOutputs = null;
        }
        if (this.experimentOutputs != null) {
            this.experimentOutputs.dispose();
            this.experimentOutputs = null;
        }
        this.parameters.clear();
        this.displayables.clear();
        GAMA.releaseScope(this.myScope);
        super.dispose();
    }

    public void createAgent(Double d) {
        ExperimentPopulation experimentPopulation = new ExperimentPopulation((ISpecies)this);
        IScope iScope = this.getExperimentScope();
        experimentPopulation.initializeFor(iScope);
        List<1> list = d == null ? Collections.EMPTY_LIST : Collections.singletonList(new HashMap<String, Object>(d){
            {
                this.put("seed", d);
            }
        });
        this.agent = (ExperimentAgent)experimentPopulation.createAgents(iScope, 1, list, false, true).get(0);
        this.addDefaultParameters();
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(IModel iModel) {
        this.model = iModel;
        if (!this.isBatch()) {
            ExperimentParameter experimentParameter;
            Object object;
            boolean bl;
            for (IVariable iVariable : this.getVars()) {
                if (!iVariable.isParameter() || (bl = this.parameters.containsKey(object = "(Experiment) " + (experimentParameter = new ExperimentParameter(this.myScope, iVariable)).getName()))) continue;
                this.parameters.put((String)object, experimentParameter);
                this.displayables.add(experimentParameter);
            }
            for (IVariable iVariable : iModel.getVars()) {
                if (!iVariable.isParameter() || (bl = this.parameters.containsKey(object = (experimentParameter = new ExperimentParameter(this.myScope, iVariable)).getName()))) continue;
                this.parameters.put((String)object, experimentParameter);
                this.displayables.add(experimentParameter);
            }
        }
    }

    protected void addDefaultParameters() {
        for (IParameter.Batch batch : this.agent.getDefaultParameters()) {
            this.addParameter(batch);
        }
    }

    @Override
    public final IOutputManager getExperimentOutputs() {
        return this.experimentOutputs;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        super.setChildren(iterable);
        BatchOutput batchOutput = null;
        LayoutStatement layoutStatement = null;
        for (ISymbol iSymbol : iterable) {
            Object object;
            if (iSymbol instanceof ICategory) {
                ICategory iCategory = (ICategory)((Object)iSymbol);
                this.displayables.add(iCategory);
                continue;
            }
            if (iSymbol instanceof TextStatement) {
                TextStatement textStatement = (TextStatement)iSymbol;
                this.displayables.add(textStatement);
                continue;
            }
            if (iSymbol instanceof LayoutStatement) {
                layoutStatement = (LayoutStatement)iSymbol;
                continue;
            }
            if (iSymbol instanceof IExploration) {
                this.exploration = (IExploration)iSymbol;
                continue;
            }
            if (iSymbol instanceof BatchOutput) {
                batchOutput = (BatchOutput)iSymbol;
                continue;
            }
            if (iSymbol instanceof SimulationOutputManager) {
                SimulationOutputManager simulationOutputManager = (SimulationOutputManager)iSymbol;
                if (this.originalSimulationOutputs != null) {
                    this.originalSimulationOutputs.setChildren(simulationOutputManager);
                    continue;
                }
                this.originalSimulationOutputs = simulationOutputManager;
                continue;
            }
            if (iSymbol instanceof IParameter.Batch) {
                IParameter.Batch batch = (IParameter.Batch)((Object)iSymbol);
                if (this.isBatch() && batch.canBeExplored()) {
                    batch.setEditable(false);
                    this.addExplorableParameter(batch);
                    this.displayables.add(batch);
                    continue;
                }
                object = batch.getName();
                boolean bl = this.parameters.containsKey(object);
                if (bl) continue;
                this.displayables.add(batch);
                this.parameters.put((String)object, batch);
                continue;
            }
            if (!(iSymbol instanceof ExperimentOutputManager)) continue;
            object = (ExperimentOutputManager)iSymbol;
            if (this.experimentOutputs != null) {
                this.experimentOutputs.setChildren((Iterable<? extends ISymbol>)object);
                continue;
            }
            this.experimentOutputs = object;
        }
        if (this.originalSimulationOutputs == null) {
            this.originalSimulationOutputs = SimulationOutputManager.createEmpty();
        }
        if (this.experimentOutputs == null) {
            this.experimentOutputs = ExperimentOutputManager.createEmpty();
        }
        if (this.experimentOutputs.getLayout() == null) {
            if (layoutStatement != null) {
                this.experimentOutputs.setLayout(layoutStatement);
            } else if (this.originalSimulationOutputs.getLayout() != null) {
                this.experimentOutputs.setLayout(this.originalSimulationOutputs.getLayout());
            }
        }
        if (batchOutput != null) {
            this.createOutput(batchOutput);
        }
        this.displayables.addAll(this.getUserCommands());
    }

    private void createOutput(BatchOutput batchOutput) throws GamaRuntimeException {
        if (batchOutput == null) {
            return;
        }
        IExpression iExpression = batchOutput.getFacet("data");
        if (iExpression == null) {
            iExpression = this.exploration.getOutputs();
        }
        if (iExpression != null) {
            iExpression.serializeToGaml(false);
        }
    }

    public synchronized void open(Double d) {
        this.createAgent(d);
        this.agent.getParameterValues().forEach((string, object) -> {
            if (this.hasVar((String)string)) {
                this.agent.setDirectVarValue(this.myScope, (String)string, object);
            }
        });
        this.myScope.push(this.agent);
        this.prepareGui();
        IScope iScope = this.agent.getScope();
        this.agent.schedule(iScope);
        if (this.isBatch()) {
            this.myScope.getGui().getStatus().informStatus(iScope, this.isTest() ? "Tests ready. Click run to begin." : " Batch ready. Click run to begin.");
            GAMA.updateExperimentState(this);
        }
    }

    private void showParameters() {
        ExperimentOutputManager experimentOutputManager = (ExperimentOutputManager)this.agent.getOutputManager();
        Symbol symbol2 = experimentOutputManager.getLayout() == null ? experimentOutputManager : experimentOutputManager.getLayout();
        Boolean bl = symbol2.getFacetValue(this.myScope, "parameters", null);
        if (bl != null && !bl.booleanValue()) {
            this.myScope.getGui().hideParameters();
        } else {
            this.myScope.getGui().updateParameters();
        }
    }

    void prepareGui() {
        ExperimentOutputManager experimentOutputManager = (ExperimentOutputManager)this.agent.getOutputManager();
        Symbol symbol2 = experimentOutputManager.getLayout() == null ? experimentOutputManager : experimentOutputManager.getLayout();
        Boolean bl = symbol2.getFacetValue(this.myScope, "tabs", true);
        Boolean bl2 = symbol2.getFacetValue(this.myScope, "toolbars", null);
        Boolean bl3 = symbol2.getFacetValue(this.myScope, "consoles", null);
        Boolean bl4 = symbol2.getFacetValue(this.myScope, "navigator", false);
        Boolean bl5 = symbol2.getFacetValue(this.myScope, "controls", null);
        Boolean bl6 = symbol2.getFacetValue(this.myScope, "parameters", null);
        Boolean bl7 = symbol2.getFacetValue(this.myScope, "tray", false);
        Boolean bl8 = symbol2.hasFacet("editors") ? symbol2.getFacetValue(this.myScope, "editors", false) : Boolean.valueOf(GamaPreferences.Modeling.EDITOR_PERSPECTIVE_HIDE.getValue() == false);
        Supplier<GamaColor> supplier = () -> symbol2.getFacetValue(this.myScope, "background", null);
        this.myScope.getGui().arrangeExperimentViews(this.myScope, this, bl, bl2, bl3, bl6, bl4, bl5, bl7, supplier, bl8);
    }

    @Override
    public synchronized void open() {
        Double d = null;
        if (this.isHeadless()) {
            try {
                d = this.getAgent().getSeed();
            }
            catch (Exception exception) {
                d = null;
            }
        }
        this.open(d);
    }

    @Override
    public void reload() {
        try {
            this.reloading = true;
            this.agent.dispose();
        }
        finally {
            this.reloading = false;
        }
        this.open();
    }

    @Override
    public boolean isReloading() {
        return this.reloading;
    }

    @Override
    public boolean hasParametersOrUserCommands() {
        return !this.displayables.isEmpty() || GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue() != false && (this.experimentOutputs.hasMonitors() || this.originalSimulationOutputs.hasMonitors());
    }

    @Override
    public boolean isBatch() {
        return this.exploration != null;
    }

    @Override
    public boolean isTest() {
        return "test".equals(this.getExperimentType());
    }

    @Override
    public boolean isMemorize() {
        return this.getDescription().hasFacet("record");
    }

    @Override
    public IScope getExperimentScope() {
        return this.myScope;
    }

    public void setParameterValue(IScope iScope, String string, Object object) throws GamaRuntimeException {
        this.checkGetParameter(string).setValue(iScope, object);
    }

    public void setParameterValueByTitle(IScope iScope, String string, Object object) throws GamaRuntimeException {
        this.checkGetParameterByTitle(string).setValue(iScope, object);
    }

    public Object getParameterValue(String string) throws GamaRuntimeException {
        return this.checkGetParameter(string).value(this.myScope);
    }

    @Override
    public boolean hasParameter(String string) {
        return this.getParameter(string) != null;
    }

    public IParameter.Batch getParameterByTitle(String string) {
        for (IParameter iParameter : this.parameters.values()) {
            if (!iParameter.getTitle().equals(string) || !(iParameter instanceof IParameter.Batch)) continue;
            return (IParameter.Batch)iParameter;
        }
        return null;
    }

    public IParameter.Batch getParameter(String string) {
        IParameter iParameter = this.parameters.get(string);
        if (iParameter instanceof IParameter.Batch) {
            return (IParameter.Batch)iParameter;
        }
        return null;
    }

    public void addParameter(IParameter iParameter) {
        String string = iParameter.getName();
        IParameter iParameter2 = this.parameters.get(string);
        if (iParameter2 != null) {
            iParameter.setValue(this.myScope, iParameter2.getInitialValue(this.myScope));
        }
        this.parameters.put(string, iParameter);
        this.displayables.add(iParameter);
    }

    protected IParameter.Batch checkGetParameterByTitle(String string) throws GamaRuntimeException {
        IParameter.Batch batch = this.getParameterByTitle(string);
        if (batch == null) {
            throw GamaRuntimeException.error("No parameter named " + string + " in experiment " + this.getName(), this.getExperimentScope());
        }
        return batch;
    }

    protected IParameter.Batch checkGetParameter(String string) throws GamaRuntimeException {
        IParameter.Batch batch = this.getParameter(string);
        if (batch == null) {
            throw GamaRuntimeException.error("No parameter named " + string + " in experiment " + this.getName(), this.getExperimentScope());
        }
        return batch;
    }

    @Override
    public Map<String, IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public SimulationAgent getCurrentSimulation() {
        if (this.agent == null) {
            return null;
        }
        return this.agent.getSimulation();
    }

    @Override
    public IExploration getExplorationAlgorithm() {
        return this.exploration;
    }

    public void addExplorableParameter(IParameter.Batch batch) {
        batch.setCategory("Parameters to explore");
        batch.setUnitLabel(null);
        this.explorableParameters.put(batch.getName(), batch);
    }

    @Override
    public Map<String, IParameter.Batch> getExplorableParameters() {
        return this.explorableParameters;
    }

    @Override
    public IExperimentController getController() {
        if (this.controller == null) {
            this.controller = this.isHeadless ? new HeadlessExperimentController(this) : new DefaultExperimentController(this);
        }
        return this.controller;
    }

    @Override
    public void setController(IExperimentController iExperimentController) {
        if (this.controller != null && this.controller.equals(iExperimentController)) {
            this.controller.close();
            this.controller.dispose();
        }
        this.controller = iExperimentController;
    }

    @Override
    public void refreshAllOutputs() {
        for (IOutputManager iOutputManager : this.getActiveOutputManagers()) {
            iOutputManager.forceUpdateOutputs();
        }
    }

    @Override
    public void pauseAllOutputs() {
        for (IOutputManager iOutputManager : this.getActiveOutputManagers()) {
            iOutputManager.pause();
        }
    }

    @Override
    public void resumeAllOutputs() {
        for (IOutputManager iOutputManager : this.getActiveOutputManagers()) {
            iOutputManager.resume();
        }
    }

    @Override
    public void closeAllOutputs() {
        for (IOutputManager iOutputManager : this.getActiveOutputManagers()) {
            iOutputManager.close();
        }
    }

    @Override
    public void recomputeAndRefreshAllOutputs() {
        for (IOutputManager iOutputManager : this.getActiveOutputManagers()) {
            iOutputManager.step(this.getExperimentScope());
        }
    }

    @Override
    public IOutputManager getOriginalSimulationOutputs() {
        return this.originalSimulationOutputs;
    }

    @Override
    public String getExperimentType() {
        return this.experimentType;
    }

    @Override
    public Iterable<IOutputManager> getActiveOutputManagers() {
        if (this.agent == null) {
            return Collections.EMPTY_LIST;
        }
        return Iterables.concat(this.agent.getAllSimulationOutputs(), Collections.singletonList(this.experimentOutputs));
    }

    @Override
    public ExperimentDescription getDescription() {
        return (ExperimentDescription)super.getDescription();
    }

    @Override
    public boolean shouldBeBenchmarked() {
        return this.benchmarkable;
    }

    @Override
    public List<IExperimentDisplayable> getDisplayables() {
        return this.displayables;
    }

    @Override
    public void setConcurrency(IExpression iExpression) {
        this.concurrency = iExpression;
    }

    @Override
    public IExpression shouldRecord() {
        return this.shouldRecord;
    }

    @Override
    public void setParameterValues(IList iList) {
        if (iList != null) {
            for (Object e : iList.listValue((IScope)null, (IType)Types.MAP, false)) {
                IParameter.Batch batch;
                IMap iMap = (IMap)e;
                String string = iMap.get("type") != null ? iMap.get("type").toString() : "";
                Object object = iMap.get("value");
                if ("int".equals(string)) {
                    object = Integer.valueOf(String.valueOf(iMap.get("value")));
                }
                if ("float".equals(string)) {
                    object = Double.valueOf(String.valueOf(iMap.get("value")));
                }
                if ((batch = this.getParameterByTitle(iMap.get("name").toString())) != null) {
                    this.setParameterValueByTitle(this.getExperimentScope(), iMap.get("name").toString(), object);
                    continue;
                }
                if (this.getParameter(iMap.get("name").toString()) == null) continue;
                this.setParameterValue(this.getExperimentScope(), iMap.get("name").toString(), object);
            }
        }
    }

    public static class BatchValidator
    implements IDescriptionValidator {
        public void validate(IDescription iDescription) {
            String string;
            block36: {
                IDescription iDescription2;
                string = iDescription.getLitteral("type");
                if (!GamaMetaModel.INSTANCE.getExperimentTypes().contains(string)) {
                    iDescription.error("The type of the experiment must belong to " + String.valueOf(GamaMetaModel.INSTANCE.getExperimentTypes()));
                    return;
                }
                if (!"batch".equals(string) && iDescription.getChildWithKeyword("method") != null) {
                    iDescription.error(string + " experiments cannot define exploration methods", "gaml.conflicting.facets", "method", new String[0]);
                }
                if ("batch".equals(string) && iDescription.hasFacet("record")) {
                    iDescription.warning("Batch experiments cannot be recorded and played backwards. 'record' will be ignored", "gaml.conflicting.facets", "ignoredrecord", new String[0]);
                    iDescription.setFacetExprDescription("ignoredrecord", iDescription.getFacet("record"));
                    iDescription.removeFacets("record");
                }
                if (iDescription.getChildWithKeyword("exploration") == null || !(iDescription2 = iDescription.getChildWithKeyword("exploration")).hasFacet("sampling")) break block36;
                switch (iDescription2.getLitteral("sampling")) {
                    case "morris": {
                        int n;
                        if (!iDescription2.hasFacet("levels")) {
                            iDescription2.warning("levels not defined for Morris sampling, will be 4 by default", "gaml.missing.facet.issue");
                        } else {
                            n = Integer.parseInt(iDescription2.getLitteral("levels"));
                            System.out.println(n);
                            if (n <= 0) {
                                iDescription2.error("Levels should be positive");
                            }
                        }
                        if (!iDescription2.hasFacet("sample")) {
                            iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                            break;
                        }
                        n = Integer.parseInt(iDescription2.getLitteral("sample"));
                        System.out.println(n);
                        if (n % 2 == 0) break;
                        iDescription2.error("The sample size should be even");
                        break;
                    }
                    case "saltelli": {
                        if (!iDescription2.hasFacet("sample")) {
                            iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                        }
                        if (!iDescription2.hasFacet("levels")) break;
                        iDescription2.warning("Saltelli sampling doesn't need the levels facet", "gaml.missing.facet.issue");
                        break;
                    }
                    case "latinhypercube": {
                        if (iDescription2.hasFacet("sample")) break;
                        iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                        break;
                    }
                    case "orthogonal": {
                        if (!iDescription2.hasFacet("sample")) {
                            iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                        }
                        if (iDescription2.hasFacet("iterations")) break;
                        iDescription2.warning("Number of Iterations not defined, will be 5 by default", "gaml.missing.facet.issue");
                        break;
                    }
                    case "sobol": {
                        iDescription2.warning("The sampling " + iDescription2.getLitteral("sampling") + " doesn't exist yet, do you perhaps mean 'saltelli' ?", "gaml.missing.facet.issue");
                        break;
                    }
                    case "uniform": {
                        if (iDescription2.hasFacet("sample")) break;
                        iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                        break;
                    }
                    case "factorial": {
                        if (!iDescription2.hasFacet("sample")) {
                            iDescription2.warning("Sample size not defined, will be 132 by default", "gaml.missing.facet.issue");
                        }
                        if (iDescription2.hasFacet("factorial")) break;
                        iDescription2.warning("If no factorial design is defined, it will be approximated according to sample size and equi-distribution of values per parameters", "gaml.missing.facet.issue");
                        break;
                    }
                    default: {
                        iDescription2.error("The sampling " + iDescription2.getLitteral("sampling") + " doesn't exist yet", "gaml.missing.facet.issue");
                    }
                }
            }
            if ("batch".equals(string) && !iDescription.hasFacet("until")) {
                iDescription.warning("No stopping condition have been defined (facet 'until:'). This may result in an endless run of the " + string + " experiment", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "until", "true");
            }
        }
    }

    public class ExperimentPopulation
    extends GamaPopulation<ExperimentAgent> {
        public ExperimentPopulation(ISpecies iSpecies) {
            super(null, iSpecies);
        }

        @Override
        public IList<ExperimentAgent> createAgents(IScope iScope, int n, List<? extends Map<String, Object>> list, boolean bl, boolean bl2, RemoteSequence remoteSequence) throws GamaRuntimeException {
            boolean bl3 = list == null || list.isEmpty();
            Map<String, Object> map = Collections.EMPTY_MAP;
            int n2 = 0;
            while (n2 < n) {
                ExperimentPlan.this.agent = GamaMetaModel.INSTANCE.createExperimentAgent(ExperimentPlan.this.getExperimentType(), this, this.currentAgentIndex++);
                this.add(ExperimentPlan.this.agent);
                iScope.push(ExperimentPlan.this.agent);
                if (!bl3) {
                    map = list.get(n2);
                }
                ArrayList arrayList = new ArrayList(map.keySet());
                IVariable[] iVariableArray = this.orderedVars;
                int n3 = this.orderedVars.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = iVariableArray[n4];
                    String string = object.getName();
                    Object object2 = bl3 ? null : map.get(string);
                    object.initializeWith(iScope, ExperimentPlan.this.agent, object2);
                    arrayList.remove(string);
                    ++n4;
                }
                for (Object object : arrayList) {
                    Object object3 = bl3 ? null : map.get(object);
                    ExperimentPlan.this.agent.getScope().setAgentVarValue(ExperimentPlan.this.agent, (String)object, object3);
                }
                if (remoteSequence != null && !remoteSequence.isEmpty()) {
                    iScope.execute(remoteSequence, ExperimentPlan.this.agent, null);
                }
                iScope.pop(ExperimentPlan.this.agent);
                ++n2;
            }
            return this;
        }

        @Override
        protected boolean stepAgents(IScope iScope) {
            return iScope.step(ExperimentPlan.this.agent).passed();
        }

        @Override
        public ExperimentAgent getAgent(IScope iScope, GamaPoint gamaPoint) {
            return ExperimentPlan.this.agent;
        }

        @Override
        public void computeTopology(IScope iScope) throws GamaRuntimeException {
            this.topology = new AmorphousTopology();
        }
    }

    private class Scope
    extends ExecutionScope {
        public Scope(String string) {
            super(null, string);
        }

        @Override
        public void setGlobalVarValue(String string, Object object) throws GamaRuntimeException {
            if (ExperimentPlan.this.hasParameter(string)) {
                ExperimentPlan.this.setParameterValue(this, string, object);
            }
        }

        @Override
        public Object getGlobalVarValue(String string) throws GamaRuntimeException {
            if (ExperimentPlan.this.hasParameter(string)) {
                return ExperimentPlan.this.getParameterValue(string);
            }
            return null;
        }
    }
}

