/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.projection;

import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.topology.projection.Projection;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.IScope;
import javax.measure.UnitConverter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WorldProjection
extends Projection {
    public UnitConverter unitConverter;
    public UnitConverter inverseUnitConverter;

    public WorldProjection(IScope iScope, CoordinateReferenceSystem coordinateReferenceSystem, Envelope3D envelope3D, ProjectionFactory projectionFactory) {
        super(iScope, null, coordinateReferenceSystem, envelope3D, projectionFactory);
    }

    @Override
    public void translate(Geometry geometry) {
        if (this.projectedEnv != null) {
            geometry.apply(coordinate -> {
                coordinate.x -= this.projectedEnv.getMinX();
                coordinate.y = -coordinate.y + this.projectedEnv.getHeight() + this.projectedEnv.getMinY();
            });
            geometry.geometryChanged();
        }
    }

    @Override
    public void inverseTranslate(Geometry geometry) {
        if (this.projectedEnv != null) {
            geometry.apply(coordinate -> {
                coordinate.x += this.projectedEnv.getMinX();
                coordinate.y = -coordinate.y + this.projectedEnv.getHeight() + this.projectedEnv.getMinY();
            });
            geometry.geometryChanged();
        }
    }

    @Override
    public void convertUnit(Geometry geometry) {
        if (this.unitConverter != null) {
            geometry.apply(coordinate -> {
                coordinate.x = this.unitConverter.convert(coordinate.x);
                coordinate.y = this.unitConverter.convert(coordinate.y);
                coordinate.z = this.unitConverter.convert(coordinate.z);
            });
            geometry.geometryChanged();
        }
    }

    @Override
    public void inverseConvertUnit(Geometry geometry) {
        if (this.inverseUnitConverter != null) {
            geometry.apply(coordinate -> {
                coordinate.x = this.inverseUnitConverter.convert(coordinate.x);
                coordinate.y = this.inverseUnitConverter.convert(coordinate.y);
                coordinate.z = this.inverseUnitConverter.convert(coordinate.z);
            });
            geometry.geometryChanged();
        }
    }

    public void updateTranslations(Envelope3D envelope3D) {
        if (envelope3D != null) {
            this.projectedEnv = envelope3D;
        }
    }

    public void updateUnit(UnitConverter unitConverter) {
        if (unitConverter != null) {
            this.unitConverter = unitConverter;
            this.inverseUnitConverter = unitConverter.inverse();
        }
    }
}

