/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.outputs.AbstractValuedDisplayOutput;
import gama.core.outputs.ValuedDisplayOutputFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.dev.COUNTER;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.SymbolTracer;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={3, 11}, symbols={"output", "permanent"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the inspector")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates the condition under which this output should be refreshed (default is true)")}), @GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the set of agents to inspect, could be a species, a list of agents or an agent")}), @GamlAnnotations.facet(name="attributes", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the list of attributes to inspect. A list that can contain strings or pair<string,type>, or a mix of them. These can be variables of the species, but also attributes present in the attributes table of the agent. The type is necessary in that case")}), @GamlAnnotations.facet(name="type", type={-201}, values={"agent", "table"}, optional=true, doc={@GamlAnnotations.doc(value="the way to inspect agents: in a table, or a set of inspectors")})}, omissible="name")
@GamlAnnotations.doc(value="`inspect` (and `browse`) statements allows modeler to inspect a set of agents, in a table with agents and all their attributes or an agent inspector per agent, depending on the type: chosen. Modeler can choose which attributes to display. When `browse` is used, type: default value is table, whereas when`inspect` is used, type: default value is agent.", usages={@GamlAnnotations.usage(value="An example of syntax is:", examples={@GamlAnnotations.example(value="inspect \"my_inspector\" value: ant attributes: [\"name\", \"location\"];", isExecutable=false)})})
public class InspectDisplayOutput
extends AbstractValuedDisplayOutput
implements IStatement {
    public static final short INSPECT_AGENT = 0;
    public static final short INSPECT_TABLE = 3;
    static final List<String> types = Arrays.asList("agent", "dynamic", "species", "table");
    String type;
    IExpression attributes;
    private Map<String, String> listOfAttributes;
    IMacroAgent rootAgent;
    static final IAgent[] EMPTY = new IAgent[0];

    public InspectDisplayOutput(IDescription iDescription) {
        super(iDescription);
        if (this.getValue() == null) {
            this.value = this.getFacet("name");
            this.expressionText = this.getValue() == null ? "" : this.getValue().serializeToGaml(false);
        }
        this.type = this.getLiteral("type");
        if (this.type == null) {
            this.type = "browse".equals(this.getKeyword()) ? "table" : "agent";
        }
        this.attributes = this.getFacet("attributes");
    }

    @Override
    public boolean init(IScope iScope) {
        super.init(iScope);
        if ("agent".equals(this.type) && this.getValue() != null) {
            this.lastValue = this.getValue().value(this.getScope());
        }
        if (this.attributes != null) {
            this.listOfAttributes = (Map)Types.MAP.of(Types.STRING, Types.STRING).cast(this.getScope(), this.attributes.value(this.getScope()), null, true);
        }
        if (this.rootAgent == null || this.rootAgent.dead()) {
            this.rootAgent = this.getScope().getRoot();
        }
        return true;
    }

    public static InspectDisplayOutput inspect(IAgent iAgent, IExpression iExpression) {
        IDescription iDescription = DescriptionFactory.create("inspect", "name", StringUtils.toGamlString("Inspect: "), "type", types.get(0)).validate();
        iDescription.setFacet("value", GAML.getExpressionFactory().createConst(iAgent, iAgent.getGamlType()));
        iDescription.validate();
        if (iExpression != null) {
            iDescription.setFacet("attributes", iExpression);
        }
        InspectDisplayOutput inspectDisplayOutput = new InspectDisplayOutput(iDescription);
        inspectDisplayOutput.lastValue = iAgent;
        return inspectDisplayOutput;
    }

    public static InspectDisplayOutput inspect(IExperimentAgent iExperimentAgent, IExpression iExpression) {
        IDescription iDescription = DescriptionFactory.create("inspect", "name", StringUtils.toGamlString("Inspect: "), "type", types.get(3)).validate();
        SimulationPopulation simulationPopulation = iExperimentAgent.getSimulationPopulation();
        iDescription.setFacet("value", GAML.getExpressionFactory().createConst(simulationPopulation, simulationPopulation.getGamlType()));
        if (iExpression != null) {
            iDescription.setFacet("attributes", iExpression);
        }
        InspectDisplayOutput inspectDisplayOutput = new InspectDisplayOutput(iDescription);
        inspectDisplayOutput.lastValue = simulationPopulation;
        inspectDisplayOutput.rootAgent = iExperimentAgent;
        return inspectDisplayOutput;
    }

    public static InspectDisplayOutput browse(IMacroAgent iMacroAgent, ISpecies iSpecies, IExpression iExpression) {
        IDescription iDescription = DescriptionFactory.create("inspect", (IDescription)GAML.getExperimentContext(iMacroAgent), "name", StringUtils.toGamlString("Browse(" + String.valueOf(COUNTER.COUNT()) + ")"), "value", iSpecies == null ? "nil" : iSpecies.getName(), "type", types.get(3)).validate();
        if (iExpression != null) {
            iDescription.setFacet("attributes", iExpression);
        }
        InspectDisplayOutput inspectDisplayOutput = new InspectDisplayOutput(iDescription);
        inspectDisplayOutput.rootAgent = iMacroAgent;
        return inspectDisplayOutput;
    }

    public static InspectDisplayOutput browse(IMacroAgent iMacroAgent, Collection<? extends IAgent> collection, IExpression iExpression) {
        IDescription iDescription = DescriptionFactory.create("inspect", (IDescription)GAML.getExperimentContext(iMacroAgent), "name", StringUtils.toGamlString("Browse(" + String.valueOf(COUNTER.COUNT()) + ")"), "value", StringUtils.toGaml(collection, false), "type", types.get(3)).validate();
        if (iExpression != null) {
            iDescription.setFacet("attributes", iExpression);
        }
        InspectDisplayOutput inspectDisplayOutput = new InspectDisplayOutput(iDescription);
        inspectDisplayOutput.lastValue = collection;
        inspectDisplayOutput.rootAgent = iMacroAgent;
        return inspectDisplayOutput;
    }

    public static InspectDisplayOutput browse(IMacroAgent iMacroAgent, IExpression iExpression, IExpression iExpression2) {
        IDescription iDescription = DescriptionFactory.create("inspect", (IDescription)GAML.getExperimentContext(iMacroAgent), "name", StringUtils.toGamlString("Browse(" + String.valueOf(COUNTER.COUNT()) + ")"), "type", types.get(3)).validate();
        iDescription.setFacet("value", iExpression);
        if (iExpression2 != null) {
            iDescription.setFacet("attributes", iExpression2);
        }
        InspectDisplayOutput inspectDisplayOutput = new InspectDisplayOutput(iDescription);
        inspectDisplayOutput.rootAgent = iMacroAgent;
        return inspectDisplayOutput;
    }

    public void launch(IScope iScope) throws GamaRuntimeException {
        if (!iScope.init(this).passed()) {
            return;
        }
        if (iScope.getSimulation() != null) {
            iScope.getSimulation().addOutput(this);
        } else if (iScope.getExperiment() != null) {
            iScope.getExperiment().getSpecies().getExperimentOutputs().add(this);
        }
        this.setPaused(false);
        this.open();
        this.step(iScope);
        this.update();
    }

    @Override
    public boolean step(IScope iScope) {
        if ("table".equals(this.type)) {
            if (this.rootAgent == null || this.rootAgent.dead()) {
                return false;
            }
            if (this.getValue() == null) {
                return true;
            }
            if (this.getScope().interrupted()) {
                return false;
            }
            try {
                this.getScope().setCurrentSymbol(this);
                this.lastValue = this.getScope().evaluate(this.getValue(), this.rootAgent).getValue();
            }
            finally {
                iScope.setCurrentSymbol(null);
            }
        }
        return true;
    }

    @Override
    public boolean isUnique() {
        return !"table".equals(this.type);
    }

    @Override
    public String getId() {
        return this.isUnique() ? this.getViewId() : this.getViewId() + this.getName();
    }

    @Override
    public String getViewId() {
        if ("table".equals(this.type)) {
            return "gama.ui.application.view.TableAgentInspectView";
        }
        return "gama.ui.application.view.AgentInspectView";
    }

    public IAgent[] getLastValue() {
        if ("table".equals(this.type) && (this.rootAgent == null || this.rootAgent.dead())) {
            return EMPTY;
        }
        Object object = this.lastValue;
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            return new IAgent[]{iAgent};
        }
        Object object2 = this.lastValue;
        if (object2 instanceof ISpecies) {
            ISpecies iSpecies = (ISpecies)object2;
            if (this.rootAgent != null) {
                IPopulation<? extends IAgent> iPopulation = this.rootAgent.getMicroPopulation(iSpecies);
                return iPopulation.toArray();
            }
        }
        if (this.lastValue instanceof IContainer) {
            return ((IContainer)this.lastValue).listValue(this.getScope(), Types.NO_TYPE, false).toArray(new IAgent[0]);
        }
        return EMPTY;
    }

    public SpeciesDescription getSpeciesDescription() {
        IExpression iExpression = this.getValue();
        if (iExpression == null) {
            return null;
        }
        IType<?> iType = iExpression.getGamlType().getContentType();
        if (iType == Types.get("model")) {
            return this.getScope().getModel().getDescription();
        }
        SpeciesDescription speciesDescription = iType.getSpecies();
        if (speciesDescription == null) {
            return Types.AGENT.getDenotedSpecies();
        }
        String string = speciesDescription.getName();
        if (string == null) {
            return Types.AGENT.getDenotedSpecies();
        }
        return this.rootAgent.getSpecies().getDescription().getMicroSpecies(string);
    }

    public Map<String, String> getAttributes() {
        return this.listOfAttributes;
    }

    public IMacroAgent getRootAgent() {
        return this.rootAgent;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.rootAgent = null;
        this.attributes = null;
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        IType<?> iType = this.value.getGamlType();
        if (iType.isAgentType()) {
            GAMA.getGui().setSelectedAgent((IAgent)this.value.value(iScope));
        } else if (iType.isContainer()) {
            ValuedDisplayOutputFactory.browse(iScope.getRoot(), this.value, this.attributes);
        }
        return this.value.value(iScope);
    }

    @Override
    public String getTrace(IScope iScope) {
        return new SymbolTracer().trace(iScope, this);
    }
}

