/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.GamaGisFile;
import gama.dependencies.osmosis.Bound;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityContainer;
import gama.dependencies.osmosis.Node;
import gama.dependencies.osmosis.OsmHandler;
import gama.dependencies.osmosis.OsmosisReader;
import gama.dependencies.osmosis.Relation;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.Way;
import gama.dependencies.osmosis.WayNode;
import gama.dev.DEBUG;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.DefaultHandler;

@GamlAnnotations.file(name="osm", extensions={"osm", "pbf", "bz2", "gz"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"osm", "file"}, doc={@GamlAnnotations.doc(value="Represents files that contain OSM GIS information. The internal representation is a list of geometries. See https://en.wikipedia.org/wiki/OpenStreetMap for more information")})
public class GamaOsmFile
extends GamaGisFile {
    final ReferencedEnvelope env = new ReferencedEnvelope();
    IMap<String, IList> filteringOptions;
    Map<String, String> attributes = new HashMap<String, String>();
    final IMap<String, List<IShape>> layers = GamaMapFactory.create(Types.STRING, Types.LIST);
    static final List<String> featureTypes = Arrays.asList("aerialway", "aeroway", "amenity", "barrier", "boundary", "building", "craft", "emergency", "geological", "highway", "historic", "landuse", "leisure", "man_made", "military", "natural", "office", "place", "power", "public_transport", "railway", "route", "shop", "sport", "tourism", "waterway");
    int nbObjects;

    @GamlAnnotations.doc(value="This file constructor allows to read a osm (.osm, .pbf, .bz2, .gz) file (using WGS84 coordinate system for the data)", examples={@GamlAnnotations.example(value="file f <- osm_file(\"file\");", isExecutable=false)})
    public GamaOsmFile(IScope iScope, String string) {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an osm (.osm, .pbf, .bz2, .gz) file (using WGS84 coordinate system for the data)The map is used to filter the objects in the file according their attributes: for each key (string) of the map, only the objects that have a value for the  attribute contained in the value set are kept. For an exhaustive list of the attibute of OSM data, see: http://wiki.openstreetmap.org/wiki/Map_Features", examples={@GamlAnnotations.example(value="file f <- osm_file(\"file\", map([\"highway\"::[\"primary\", \"secondary\"], \"building\"::[\"yes\"], \"amenity\"::[]]));", equals="f will contain all the objects of file that have the attibute 'highway' with the value 'primary' or 'secondary', and the objects that have the attribute 'building' with the value 'yes', and all the objects that have the attribute 'aminity' (whatever the value).", isExecutable=false)})
    public GamaOsmFile(IScope iScope, String string, IMap<String, IList> iMap) {
        super(iScope, string, (Integer)null);
        this.filteringOptions = iMap;
    }

    @Override
    protected String fetchFromURL(IScope iScope) {
        String string = super.fetchFromURL(iScope);
        if (string.endsWith(".osm.xml")) {
            string = string.replace(".xml", "");
        }
        return string;
    }

    public void getFeatureIterator(final IScope iScope, final boolean bl) {
        final HashMap<Long, GamaShape> hashMap = new HashMap<Long, GamaShape>();
        final HashMap<Long, Node> hashMap2 = new HashMap<Long, Node>();
        final LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        final ArrayList<Way> arrayList = new ArrayList<Way>();
        final ArrayList<Relation> arrayList2 = new ArrayList<Relation>();
        final LinkedHashSet<Long> linkedHashSet2 = new LinkedHashSet<Long>();
        final LinkedHashSet linkedHashSet3 = new LinkedHashSet();
        Sink sink = new Sink(){

            public void process(EntityContainer entityContainer) {
                boolean bl6;
                Entity entity = entityContainer.getEntity();
                boolean bl2 = bl6 = GamaOsmFile.this.filteringOptions != null && !GamaOsmFile.this.filteringOptions.isEmpty();
                if (entity instanceof Bound) {
                    Bound bound = (Bound)entity;
                    Envelope3D envelope3D = Envelope3D.of(bound.getLeft(), bound.getRight(), bound.getBottom(), bound.getTop(), 0.0, 0.0);
                    GamaOsmFile.this.computeProjection(iScope, envelope3D);
                } else if (bl) {
                    if (entity instanceof Node) {
                        Node node = (Node)entity;
                        Geometry geometry = GamaOsmFile.this.gis == null ? new GamaPoint(node.getLongitude(), node.getLatitude()).getInnerGeometry() : GamaOsmFile.this.gis.transform(new GamaPoint(node.getLongitude(), node.getLatitude()).getInnerGeometry());
                        hashMap.put(node.getId(), GamaShapeFactory.createFrom(geometry));
                        hashMap2.put(node.getId(), node);
                        boolean bl3 = GamaOsmFile.this.keepEntity(bl6, entity);
                        if (!bl3) {
                            return;
                        }
                        linkedHashSet.add(node);
                    } else if (entity instanceof Way) {
                        boolean bl4 = GamaOsmFile.this.keepEntity(bl6, entity);
                        if (!bl4) {
                            return;
                        }
                        GamaOsmFile.this.registerHighway((Way)entity, linkedHashSet3, linkedHashSet2);
                        arrayList.add((Way)entity);
                    } else if (entity instanceof Relation) {
                        boolean bl5 = GamaOsmFile.this.keepEntity(bl6, entity);
                        if (!bl5) {
                            return;
                        }
                        arrayList2.add((Relation)entity);
                    }
                }
            }

            public void complete() {
            }

            public void initialize(Map<String, Object> map) {
            }
        };
        this.readFile(iScope, sink, this.getFile(iScope));
        if (bl) {
            this.setBuffer(this.buildGeometries(iScope, linkedHashSet, arrayList, arrayList2, linkedHashSet2, hashMap, hashMap2));
        }
    }

    boolean keepEntity(boolean bl, Entity entity) {
        if (bl) {
            boolean bl2 = false;
            block0: for (String string : this.filteringOptions.getKeys()) {
                IList iList = (IList)this.filteringOptions.get(string);
                for (Tag tag : entity.getTags()) {
                    if (!string.equals(tag.getKey()) || iList != null && !iList.isEmpty() && !iList.contains(tag.getValue())) continue;
                    bl2 = true;
                    continue block0;
                }
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    private void addAttribute(Map<String, String> map, String string, Object object) {
        String string2 = map.get(string);
        if ("string".equals(string2)) {
            return;
        }
        String string3 = "int";
        try {
            Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(object.toString());
            }
            catch (Exception exception2) {
                string3 = "string";
            }
        }
        if (string2 == null || "string".equals(string3)) {
            map.put(string, string3);
        }
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
        this.getFeatureIterator(iScope, true);
    }

    public IList<IShape> buildGeometries(IScope iScope, Set<Node> set, List<Way> list, List<Relation> list2, Set<Long> set2, Map<Long, GamaShape> map, Map<Long, Node> map2) {
        List<Object> list3;
        Object object;
        Object object2;
        List<Object> list4;
        Object object32;
        int n;
        IValue iValue;
        Way way2;
        for (Way way2 : list) {
            for (WayNode wayNode : way2.getWayNodes()) {
                set.add(map2.get(wayNode.getNodeId()));
            }
        }
        way2 = GamaListFactory.create(Types.GEOMETRY);
        if (this.gis == null) {
            this.computeProjection(iScope, Envelope3D.of((Envelope)this.env));
            if (this.gis != null) {
                for (Long l : map.keySet()) {
                    GamaShape gamaShape = GamaShapeFactory.createFrom(this.gis.transform(map.get(l).getInnerGeometry()));
                    map.put(l, gamaShape);
                }
            }
        }
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        for (Node node : set) {
            hashMap.put(node.getId(), node);
            iValue = map.get(node.getId());
            n = node.getTags().isEmpty() ? 0 : 1;
            Object object4 = new HashMap();
            if (iValue == null) continue;
            this.env.expandToInclude((Coordinate)((GamaShape)iValue).getLocation());
            object32 = node.getTags().iterator();
            while (object32.hasNext()) {
                list4 = (Tag)object32.next();
                object2 = list4.getKey();
                object = list4.getValue();
                if (object != null) {
                    this.addAttribute((Map<String, String>)object4, (String)object2, object);
                }
                iValue.setAttribute((String)object2, object);
                if (!"highway".equals(object2)) continue;
                set2.add(node.getId());
            }
            if (n == 0) continue;
            way2.add(iValue);
            iValue.forEachAttribute((arg_0, arg_1) -> this.lambda$0((GamaShape)iValue, (Map)object4, arg_0, arg_1));
        }
        block5: for (Way way3 : list) {
            boolean bl;
            hashMap.put(way3.getId(), way3);
            iValue = GamaMapFactory.create();
            IMap iMap = GamaMapFactory.createUnordered();
            for (Object object4 : way3.getTags()) {
                object32 = object4.getKey();
                object2 = object4.getValue();
                if (object2 != null) {
                    this.addAttribute(iMap, (String)object32, object2);
                }
                iValue.put(object32, object4.getValue());
            }
            iValue.put("osm_id", way3.getId());
            boolean bl2 = bl = iValue.containsKey("highway") || ((WayNode)way3.getWayNodes().get(0)).getNodeId() != ((WayNode)way3.getWayNodes().get(way3.getWayNodes().size() - 1)).getNodeId();
            if (bl) {
                list4 = this.createSplitRoad(way3.getWayNodes(), (Map<String, Object>)((Object)iValue), set2, map);
                way2.addAll(list4);
                if (list4.isEmpty()) continue;
                for (Object object32 : iValue.keySet()) {
                    object = String.valueOf(object32) + " (line)";
                    if (!featureTypes.contains(object32)) continue;
                    list3 = (List)this.layers.get(object);
                    if (list3 == null) {
                        list3 = GamaListFactory.create(Types.GEOMETRY);
                        this.layers.put((String)object, list3);
                    }
                    list3.addAll(list4);
                    for (String string : iMap.keySet()) {
                        String string2 = (String)object + ";" + string;
                        this.attributes.put(string2, (String)iMap.get(string));
                    }
                    continue block5;
                }
                continue;
            }
            list4 = GamaListFactory.create(Types.GEOMETRY);
            for (Object object32 : way3.getWayNodes()) {
                object = map.get(object32.getNodeId());
                if (object == null) continue;
                list4.add(object);
            }
            if (list4.size() < 3 || (object32 = GamaGeometryType.buildPolygon(list4)) == null || object32.getInnerGeometry() == null || object32.getInnerGeometry().isEmpty() || !(object32.getInnerGeometry().getArea() > 0.0)) continue;
            iValue.forEach((arg_0, arg_1) -> GamaOsmFile.lambda$1((IShape)object32, arg_0, arg_1));
            way2.add(object32);
            object32.forEachAttribute((arg_0, arg_1) -> this.lambda$2((IShape)object32, iMap, arg_0, arg_1));
        }
        for (Relation relation : list2) {
            iValue = GamaMapFactory.create();
            for (Tag tag : relation.getTags()) {
                list4 = tag.getKey();
                iValue.put(list4, tag.getValue());
            }
            n = 0;
            for (Object object4 : relation.getMembers()) {
                object32 = (Entity)hashMap.get(object4.getMemberId());
                if (object32 instanceof Way) {
                    object2 = ((Way)object32).getWayNodes();
                    object = GamaMapFactory.create();
                    object.put("entity_order", n++);
                    object.put("gama_bus_line", iValue.get("name"));
                    object.put("osm_way_id", ((Way)object32).getId());
                    if (object2.size() <= 0) continue;
                    list3 = this.createSplitRoad((List<WayNode>)object2, (Map<String, Object>)object, set2, map);
                    way2.addAll(list3);
                    continue;
                }
                if (!(object32 instanceof Node)) continue;
                object2 = map.get(((Node)object32).getId());
                object = ((GamaShape)object2).copy(iScope);
                list3 = GamaListFactory.create(Types.GEOMETRY);
                list3.add(object);
                object.setAttribute("gama_bus_line", iValue.get("name"));
                way2.add(object);
            }
        }
        this.nbObjects = way2 == null ? 0 : way2.size();
        return way2;
    }

    public List<IShape> createSplitRoad(List<WayNode> list, Map<String, Object> map, Set<Long> set, Map<Long, GamaShape> map2) {
        Object object;
        IList<Object> iList = GamaListFactory.create(Types.LIST.of(Types.GEOMETRY));
        IList iList2 = GamaListFactory.create(Types.GEOMETRY);
        IList<IShape> iList3 = GamaListFactory.create(Types.GEOMETRY);
        WayNode wayNode = list.get(list.size() - 1);
        for (WayNode wayNode2 : list) {
            Long l = wayNode2.getNodeId();
            object = map2.get(l);
            if (object == null) continue;
            iList2.add(object);
            if (!set.contains(l) && wayNode2 != wayNode) continue;
            if (iList2.size() > 1) {
                iList.add(iList2);
            }
            iList2 = GamaListFactory.create(Types.GEOMETRY);
            iList2.add(object);
        }
        int n = 0;
        for (Object object2 : iList) {
            object = new HashMap<String, Object>(map);
            object.put("way_order", n++);
            IShape iShape = this.createRoad((List<IShape>)object2, (Map<String, Object>)object);
            if (iShape == null) continue;
            iList3.add(iShape);
        }
        return iList3;
    }

    private IShape createRoad(List<IShape> list, Map<String, Object> map) {
        if (list.size() < 2) {
            return null;
        }
        IShape iShape = GamaGeometryType.buildPolyline(list);
        if (iShape != null && iShape.getInnerGeometry() != null && !iShape.getInnerGeometry().isEmpty() && iShape.getInnerGeometry().isSimple() && iShape.getPerimeter() > 0.0) {
            for (String string : map.keySet()) {
                iShape.setAttribute(string, map.get(string));
            }
            return iShape;
        }
        return null;
    }

    void registerHighway(Way way, Set<Long> set, Set<Long> set2) {
        for (Tag tag : way.getTags()) {
            String string = tag.getKey();
            if (!"highway".equals(string)) continue;
            List list = way.getWayNodes();
            for (WayNode wayNode : list) {
                long l = wayNode.getNodeId();
                if (set.contains(l)) {
                    set2.add(l);
                    continue;
                }
                set.add(l);
            }
            if (list.size() <= 2 || list.get(0) != list.get(list.size() - 1)) continue;
            set2.add(((WayNode)list.get(list.size() / 2)).getNodeId());
        }
    }

    private void readFile(IScope iScope, Sink sink, File file2) {
        String string = this.getExtension(iScope);
        OsmosisReader osmosisReader = null;
        switch (string) {
            case "pbf": {
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
                        osmosisReader = new OsmosisReader(inputStream);
                        osmosisReader.setSink(sink);
                        osmosisReader.run();
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw GamaRuntimeException.create(iOException, iScope);
                }
            }
            default: {
                this.readXML(iScope, sink);
            }
        }
    }

    private void readXML(IScope iScope, Sink sink) throws GamaRuntimeException {
        try {
            String string;
            InputStream inputStream = Files.newInputStream(this.getFile(iScope).toPath(), new OpenOption[0]);
            switch (string = this.getExtension(iScope)) {
                case "gz": {
                    inputStream = new GZIPInputStream(inputStream);
                    break;
                }
                case "bz2": {
                    inputStream = new BZip2CompressorInputStream(inputStream);
                }
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream inputStream2 = inputStream;){
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream2, (DefaultHandler)new OsmHandler(sink, false));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("Unable to parse xml file " + this.getName(iScope) + ": " + exception.getMessage(), iScope);
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        if (this.gis == null) {
            this.getFeatureIterator(iScope, false);
        }
        if (this.gis == null) {
            return Envelope3D.of((Envelope)this.env);
        }
        return this.gis.getProjectedEnvelope();
    }

    @Override
    protected CoordinateReferenceSystem getOwnCRS(IScope iScope) {
        return DefaultGeographicCRS.WGS84;
    }

    public Map<String, String> getOSMAttributes(IScope iScope) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
            this.getFeatureIterator(iScope, true);
        }
        return this.attributes;
    }

    public Map<String, List<IShape>> getLayers() {
        return this.layers;
    }

    public List<String> getFeatureTypes() {
        return featureTypes;
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        return null;
    }

    private /* synthetic */ boolean lambda$0(GamaShape gamaShape, Map map, String string, Object object) {
        if (featureTypes.contains(string)) {
            String string2 = string + " (point)";
            IList iList = (IList)this.layers.get(string2);
            if (iList == null) {
                iList = GamaListFactory.create(Types.GEOMETRY);
                this.layers.put(string2, iList);
            }
            iList.add(gamaShape);
            for (String string3 : map.keySet()) {
                String string4 = string2 + ";" + string3;
                this.attributes.put(string4, (String)map.get(string3));
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$1(IShape iShape, String string, Object object) {
        iShape.setAttribute(string, object);
    }

    private /* synthetic */ boolean lambda$2(IShape iShape, Map map, String string, Object object) {
        String string2 = string + " (polygon)";
        if (featureTypes.contains(string)) {
            IList iList = (IList)this.layers.get(string2);
            if (iList == null) {
                iList = GamaListFactory.create(Types.GEOMETRY);
                this.layers.put(string2, iList);
            }
            iList.add(iShape);
            for (String string3 : map.keySet()) {
                String string4 = string2 + ";" + string3;
                this.attributes.put(string4, (String)map.get(string3));
            }
            return false;
        }
        return true;
    }

    public static class OSMInfo
    extends GamaFileMetaData {
        int itemNumber;
        CoordinateReferenceSystem crs;
        final double width;
        final double height;
        final Map<String, String> attributes;

        public OSMInfo(URL uRL, long l) {
            block6: {
                super(l);
                this.attributes = new LinkedHashMap<String, String>();
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
                int n = 0;
                try {
                    try {
                        IShape iShape2;
                        File file2 = new File(uRL.toURI());
                        GamaOsmFile gamaOsmFile = new GamaOsmFile(null, file2.getAbsolutePath());
                        this.attributes.putAll(gamaOsmFile.getOSMAttributes(GAMA.getRuntimeScope()));
                        SimpleFeatureType simpleFeatureType = DataUtilities.createType((String)"geometries", (String)"geom:LineString");
                        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
                        for (IShape iShape2 : gamaOsmFile.iterable(null)) {
                            arrayList.add(SimpleFeatureBuilder.build((SimpleFeatureType)simpleFeatureType, (Object[])new Object[]{iShape2.getInnerGeometry()}, null));
                        }
                        iShape2 = new ListFeatureCollection(simpleFeatureType, arrayList);
                        SimpleFeatureSource simpleFeatureSource = DataUtilities.source((FeatureCollection)iShape2);
                        referencedEnvelope = simpleFeatureSource.getBounds();
                        n = gamaOsmFile.nbObjects;
                        coordinateReferenceSystem = gamaOsmFile.getOwnCRS(null);
                    }
                    catch (Exception exception) {
                        DEBUG.ERR((Object)("Error in reading metadata of " + String.valueOf(uRL)));
                        this.hasFailed = true;
                        this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                        this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                        this.itemNumber = n;
                        this.crs = coordinateReferenceSystem;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                    this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                    this.itemNumber = n;
                    this.crs = coordinateReferenceSystem;
                    throw throwable;
                }
                this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                this.itemNumber = n;
                this.crs = coordinateReferenceSystem;
            }
        }

        public CoordinateReferenceSystem getCRS() {
            return this.crs;
        }

        public OSMInfo(String string) throws NoSuchAuthorityCodeException, FactoryException {
            super(string);
            this.attributes = new LinkedHashMap<String, String>();
            if (!this.hasFailed) {
                String[] stringArray = this.split(string);
                this.itemNumber = Integer.parseInt(stringArray[1]);
                String string2 = stringArray[2];
                this.crs = "null".equals(string2) ? null : CRS.parseWKT((String)string2);
                this.width = Double.parseDouble(stringArray[3]);
                this.height = Double.parseDouble(stringArray[4]);
                if (stringArray.length > 5) {
                    String[] stringArray2 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[5], (String)"@%@");
                    String[] stringArray3 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[6], (String)"@%@");
                    int n = 0;
                    while (n < stringArray2.length) {
                        this.attributes.put(stringArray2[n], stringArray3[n]);
                        ++n;
                    }
                }
            } else {
                this.itemNumber = 0;
                this.width = 0.0;
                this.height = 0.0;
                this.crs = null;
            }
        }

        @Override
        public String getSuffix() {
            return this.hasFailed ? "error: decompress the file to a .osm file" : this.itemNumber + " objects | " + Math.round(this.width) + "m x " + Math.round(this.height) + "m";
        }

        @Override
        public void appendSuffix(StringBuilder stringBuilder) {
            if (this.hasFailed) {
                stringBuilder.append("error: decompress the file to a .osm file");
                return;
            }
            stringBuilder.append(this.itemNumber).append(" object");
            if (this.itemNumber > 1) {
                stringBuilder.append("s");
            }
            stringBuilder.append(" | ");
            stringBuilder.append(Math.round(this.width)).append("m x ");
            stringBuilder.append(Math.round(this.height)).append("m");
        }

        @Override
        public String getDocumentation() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.hasFailed) {
                stringBuilder.append("Unreadable OSM file").append(Strings.LN).append("Decompress the file to an .osm file and retry");
            } else {
                stringBuilder.append("OSM file").append(Strings.LN);
                stringBuilder.append(this.itemNumber).append(" objects").append(Strings.LN);
                stringBuilder.append("Dimensions: ").append(Math.round(this.width) + "m x " + Math.round(this.height) + "m").append(Strings.LN);
                stringBuilder.append("Coordinate Reference System: ").append(this.crs == null ? "No CRS" : this.crs.getName().getCode()).append(Strings.LN);
                if (!this.attributes.isEmpty()) {
                    stringBuilder.append("Attributes: ").append(Strings.LN);
                    this.attributes.forEach((string, string2) -> {
                        StringBuilder stringBuilder2 = stringBuilder.append("<li>").append((String)string).append(" (" + string2 + ")").append("</li>");
                    });
                }
            }
            return stringBuilder.toString();
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String toPropertyString() {
            String string = String.join((CharSequence)"@%@", this.attributes.keySet());
            String string2 = String.join((CharSequence)"@%@", this.attributes.values());
            CharSequence[] charSequenceArray = new String[]{super.toPropertyString(), String.valueOf(this.itemNumber), this.crs == null ? "null" : this.crs.toWKT(), String.valueOf(this.width), String.valueOf(this.height), string, string2};
            return String.join((CharSequence)"_!_", charSequenceArray);
        }
    }
}

