/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.csv;

import gama.core.common.preferences.GamaPreferences;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractCSVManipulator
implements Closeable {
    public static final Map<Character, Character> REPLACEMENTS = Map.of(Character.valueOf(';'), Character.valueOf(','), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(' '), Character.valueOf(';'), Character.valueOf('|'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('\t'), Character.valueOf(';'));
    public static final int MAX_BUFFER_SIZE = 1024;
    public static final int MAX_FILE_BUFFER_SIZE = 4096;
    public static final int INITIAL_COLUMN_COUNT = 10;
    public static final int INITIAL_COLUMN_BUFFER_SIZE = 50;
    protected boolean firstColumn = true;
    protected String fileName = null;
    public Character textQualifier = Character.valueOf(AbstractCSVManipulator.getDefaultQualifier());
    public char delimiter = AbstractCSVManipulator.getDefaultDelimiter();

    public static char getDefaultDelimiter() {
        String string = GamaPreferences.External.CSV_SEPARATOR.getValue();
        if (string == null || string.isEmpty()) {
            return ',';
        }
        return string.charAt(0);
    }

    public static char getDefaultQualifier() {
        String string = GamaPreferences.External.CSV_STRING_QUALIFIER.getValue();
        if (string == null || string.isEmpty()) {
            return '\"';
        }
        return string.charAt(0);
    }

    @Override
    public abstract void close() throws IOException;

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public void setTextQualifier(Character c) {
        this.textQualifier = c;
    }

    public abstract void endRecord() throws IOException;

    public static class Letters {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char QUOTE = '\"';
        public static final char COMMA = ',';
        public static final char SPACE = ' ';
        public static final char TAB = '\t';
        public static final char POUND = '#';
        public static final char BACKSLASH = '\\';
        public static final char NULL = '\u0000';
        public static final char BACKSPACE = '\b';
        public static final char FORM_FEED = '\f';
        public static final char ESCAPE = '\u001b';
        public static final char VERTICAL_TAB = '\u000b';
        public static final char ALERT = '\u0007';
        public static final char PIPE = '|';
        public static final char SEMICOLUMN = ';';
        public static final char COLUMN = ':';
        public static final char SLASH = '/';
    }
}

