/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.rule_based;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.architecture.reflex.ReflexArchitecture;
import gama.gaml.architecture.rule_based.RuleStatement;
import gama.gaml.statements.IStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

@GamlAnnotations.skill(name="rules", concept={"architecture", "behavior"})
@GamlAnnotations.doc(value="A control architecture based on the concept of rules. Allows to declare simple rules with the keyword `do_rule` and to execute them given with respect to their conditions and priority")
public class RuleBasedArchitecture
extends ReflexArchitecture {
    public static final String RULES = "rules";
    List<RuleStatement> rules = new ArrayList<RuleStatement>();

    @Override
    protected void clearBehaviors() {
        super.clearBehaviors();
        this.rules.clear();
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        super.executeOn(iScope);
        Map map = StreamEx.of(this.rules).toMap(ruleStatement -> ruleStatement.computePriority(iScope));
        List list = ((StreamEx)((StreamEx)StreamEx.of(this.rules).filter(ruleStatement -> ruleStatement.computeCondition(iScope))).reverseSorted((ruleStatement, ruleStatement2) -> ((Double)map.get(ruleStatement)).compareTo((Double)map.get(ruleStatement2)))).toList();
        Object object = null;
        for (RuleStatement ruleStatement3 : list) {
            ExecutionResult executionResult = iScope.execute(ruleStatement3);
            if (!executionResult.passed()) {
                return object;
            }
            object = executionResult.getValue();
        }
        return object;
    }

    @Override
    public void addBehavior(IStatement iStatement) {
        if (iStatement instanceof RuleStatement) {
            this.rules.add((RuleStatement)iStatement);
        } else {
            super.addBehavior(iStatement);
        }
    }
}

