/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.model.IModel;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.IMatrix;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaBoolType;
import gama.gaml.types.GamaColorType;
import gama.gaml.types.GamaFloatType;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.GamaGraphType;
import gama.gaml.types.GamaIntegerType;
import gama.gaml.types.GamaListType;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.GamaPairType;
import gama.gaml.types.GamaPointType;
import gama.gaml.types.GamaStringType;
import gama.gaml.types.GamaTopologyType;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class Cast {
    @GamlAnnotations.operator(value={"is"}, category={"Casting operators"}, concept={"cast", "type"})
    @GamlAnnotations.doc(value="returns true if the left operand is of the right operand type, false otherwise", examples={@GamlAnnotations.example(value="0 is int", equals="true"), @GamlAnnotations.example(value="an_agent is node", equals="true", isExecutable=false), @GamlAnnotations.example(value="1 is float", equals="false")})
    public static Boolean isA(IScope iScope, Object object, IExpression iExpression) throws GamaRuntimeException {
        IType iType = Cast.asType(iScope, iExpression);
        if (iType.isAgentType()) {
            ISpecies iSpecies = iScope.getModel().getSpecies(iType.getSpeciesName());
            if (object instanceof IAgent) {
                return ((IAgent)object).isInstanceOf(iSpecies, false);
            }
            return false;
        }
        return iType.isAssignableFrom(GamaType.of(object));
    }

    @GamlAnnotations.operator(value={"is_skill"}, category={"Casting operators"}, concept={"cast", "skill"})
    @GamlAnnotations.doc(value="returns true if the left operand is an agent whose species implements the right-hand skill name", examples={@GamlAnnotations.example(value="agentA is_skill 'moving'", equals="true", isExecutable=false)})
    @GamlAnnotations.test(value="simulation is_skill 'moving' = false")
    public static Boolean isSkill(IScope iScope, Object object, String string) {
        if (!(object instanceof IAgent)) {
            return false;
        }
        ISpecies iSpecies = ((IAgent)object).getSpecies();
        return iSpecies.implementsSkill(string);
    }

    public static IType asType(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        Object object = iExpression.value(iScope);
        if (object instanceof String) {
            IModel iModel = iScope.getModel();
            return iModel.getDescription().getTypeNamed((String)object);
        }
        if (object instanceof ISpecies) {
            return ((ISpecies)object).getDescription().getGamlType();
        }
        return iExpression.getGamlType();
    }

    public static IGraph asGraph(IScope iScope, Object object) {
        return GamaGraphType.staticCast(iScope, object, null, false);
    }

    public static ITopology asTopology(IScope iScope, Object object) throws GamaRuntimeException {
        return GamaTopologyType.staticCast(iScope, object, false);
    }

    public static IAgent asAgent(IScope iScope, Object object) throws GamaRuntimeException {
        return (IAgent)Types.AGENT.cast(iScope, object, null, false);
    }

    @GamlAnnotations.operator(value={"as"}, type=-32, can_be_const=true, category={"Casting operators"}, concept={"cast"})
    @GamlAnnotations.doc(value="Casting of the first argument into a given type", comment="It is equivalent to the application of the type operator on the left operand.", examples={@GamlAnnotations.example(value="3.5 as int", returnType="int", equals="int(3.5)")})
    @GamlAnnotations.test(value="int(4.2) = (4.2 as int)")
    public static Object as(IScope iScope, Object object, IType iType) {
        return iType.cast(iScope, object, null, false);
    }

    public static Boolean asBool(IScope iScope, Object object, boolean bl) {
        return GamaBoolType.staticCast(iScope, object, null, false);
    }

    public static Boolean asBool(IScope iScope, Object object) {
        return Cast.asBool(iScope, object, false);
    }

    public static GamaColor asColor(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        return GamaColorType.staticCast(iScope, object, null, false);
    }

    public static GamaColor asColor(IScope iScope, Object object) {
        return Cast.asColor(iScope, object, false);
    }

    public static Double asFloat(IScope iScope, Object object) {
        return GamaFloatType.staticCast(iScope, object, null, false);
    }

    public static IShape asGeometry(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        return GamaGeometryType.staticCast(iScope, object, null, bl);
    }

    public static IShape asGeometry(IScope iScope, Object object) throws GamaRuntimeException {
        return Cast.asGeometry(iScope, object, false);
    }

    public static Integer asInt(IScope iScope, Object object) {
        return GamaIntegerType.staticCast(iScope, object, null, false);
    }

    public static GamaPair asPair(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        return GamaPairType.staticCast(iScope, object, Types.NO_TYPE, Types.NO_TYPE, bl);
    }

    public static String asString(IScope iScope, Object object) throws GamaRuntimeException {
        return GamaStringType.staticCast(iScope, object, false);
    }

    public static GamaPoint asPoint(IScope iScope, Object object, boolean bl) {
        GamaPoint gamaPoint = GamaPointType.staticCast(iScope, object, bl);
        return gamaPoint == null ? null : gamaPoint;
    }

    public static GamaPoint asPoint(IScope iScope, Object object) {
        return Cast.asPoint(iScope, object, false);
    }

    public static IMap asMap(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        return (IMap)Types.MAP.cast(iScope, object, null, bl);
    }

    @GamlAnnotations.operator(value={"as_int"}, can_be_const=true, category={"Casting operators"}, concept={"cast"})
    @GamlAnnotations.doc(value="parses the string argument as a signed integer in the radix specified by the second argument.", usages={@GamlAnnotations.usage(value="if the left operand is nil or empty, as_int returns 0"), @GamlAnnotations.usage(value="if the left operand does not represent an integer in the specified radix, as_int throws an exception ")}, examples={@GamlAnnotations.example(value="'20' as_int 10", equals="20"), @GamlAnnotations.example(value="'20' as_int 8", equals="16"), @GamlAnnotations.example(value="'20' as_int 16", equals="32"), @GamlAnnotations.example(value="'1F' as_int 16", equals="31"), @GamlAnnotations.example(value="'hello' as_int 32", equals="18306744")}, see={"int"})
    public static Integer asInt(IScope iScope, String string, Integer n) throws GamaRuntimeException {
        if (string == null || string.isEmpty()) {
            return 0;
        }
        return GamaIntegerType.staticCast(iScope, string, n, false);
    }

    public static IList asList(IScope iScope, Object object) throws GamaRuntimeException {
        return GamaListType.staticCast(iScope, object, null, false);
    }

    @GamlAnnotations.operator(value={"to_list"}, content_type=-299, can_be_const=true, concept={"cast", "container"})
    @GamlAnnotations.doc(value="casts the operand to a list, making an explicit copy if it is already a list or a subtype of list (interval, population, etc.)", see={"list"})
    public static IList toList(IScope iScope, Object object) throws GamaRuntimeException {
        return GamaListType.staticCast(iScope, object, null, true);
    }

    @GamlAnnotations.operator(value={"list_with"}, content_type=-198, can_be_const=false, concept={"cast", "container"})
    @GamlAnnotations.doc(value="creates a list with a size provided by the first operand, and filled with the second operand", comment="Note that the first operand  should be positive, and that the second one is evaluated for each position  in the list.", see={"list"}, examples={@GamlAnnotations.example(value="list_with(5,2)", equals="[2,2,2,2,2]")})
    @GamlAnnotations.test(value="list_with(5,2) = [2,2,2,2,2]")
    public static IList list_with(IScope iScope, Integer n, IExpression iExpression) {
        return GamaListFactory.create(iScope, iExpression, n, false);
    }

    public static IMatrix asMatrix(IScope iScope, Object object) throws GamaRuntimeException {
        return Cast.asMatrix(iScope, object, null);
    }

    @GamlAnnotations.operator(value={"matrix_with"}, content_type=-25, can_be_const=true, category={"Casting operators"}, concept={"cast", "container"})
    @GamlAnnotations.doc(value="creates a matrix with a size provided by the first operand, and filled with the second operand. The given expression, unless constant, is evaluated for each cell ", comment="Note that both components of the right operand point should be positive, otherwise an exception is raised.", see={"matrix", "as_matrix"})
    @GamlAnnotations.test(value="{2,2} matrix_with (1) = matrix([1,1],[1,1])")
    public static IMatrix matrix_with(IScope iScope, GamaPoint gamaPoint, IExpression iExpression) {
        if (gamaPoint == null) {
            throw GamaRuntimeException.error("A nil size is not allowed for matrices", iScope);
        }
        return GamaMatrixType.with(iScope, iExpression, gamaPoint, false);
    }

    @GamlAnnotations.operator(value={"as_matrix"}, content_type=-26, can_be_const=true, category={"Casting operators"}, concept={"cast", "container"})
    @GamlAnnotations.doc(value="casts the left operand into a matrix with right operand as preferred size", comment="This operator is very useful to cast a file containing raster data into a matrix.Note that both components of the right operand point should be positive, otherwise an exception is raised.The operator as_matrix creates a matrix of preferred size. It fills in it with elements of the left operand until the matrix is full If the size is to short, some elements will be omitted. Matrix remaining elements will be filled in by nil.", usages={@GamlAnnotations.usage(value="if the right operand is nil, as_matrix is equivalent to the matrix operator")}, see={"matrix"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="as_matrix('a', {2,3}) = matrix(['a','a','a'],['a','a','a'])"), @GamlAnnotations.test(value="as_matrix(1.0, {2,2}) = matrix([1.0,1.0],[1.0,1.0])")})
    public static IMatrix asMatrix(IScope iScope, Object object, GamaPoint gamaPoint) throws GamaRuntimeException {
        return GamaMatrixType.staticCast(iScope, object, gamaPoint, Types.NO_TYPE, false);
    }

    @GamlAnnotations.operator(value={"species_of"}, content_type=-199, category={"Casting operators"}, concept={"cast", "species"})
    @GamlAnnotations.doc(value="casting of the operand to a species.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns nil;"), @GamlAnnotations.usage(value="if the operand is an agent, returns its species;"), @GamlAnnotations.usage(value="if the operand is a string, returns the species with this name (nil if not found);"), @GamlAnnotations.usage(value="otherwise, returns nil")}, examples={@GamlAnnotations.example(value="species(self)", equals="the species of the current agent", isExecutable=false), @GamlAnnotations.example(value="species('node')", equals="node", isExecutable=false), @GamlAnnotations.example(value="species([1,5,9,3])", equals="nil", isExecutable=false), @GamlAnnotations.example(value="species(node1)", equals="node", isExecutable=false)})
    @GamlAnnotations.test(value="species([1,5,9,3]) = nil")
    public static ISpecies asSpecies(IScope iScope, Object object) throws GamaRuntimeException {
        return (ISpecies)Types.SPECIES.cast(iScope, object, null, false);
    }
}

