/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.GraphTopology;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.metamodel.topology.grid.GridTopology;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.IModifiableContainer;
import gama.core.util.graph.IGraph;
import gama.core.util.path.GamaPath;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.IPath;
import gama.core.util.path.PathFactory;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.operators.Random;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialRelations;
import gama.gaml.skills.Skill;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;

@GamlAnnotations.doc(value="The moving skill is intended to define the minimal set of behaviours required for agents that are able to move on different topologies")
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="location", type=7, depends_on={"shape"}, doc={@GamlAnnotations.doc(value="Represents the current position of the agent")}), @GamlAnnotations.variable(name="speed", type=2, init="1.0", doc={@GamlAnnotations.doc(value="Represents the speed of the agent (in meter/second)")}), @GamlAnnotations.variable(name="heading", type=2, init="rnd(360.0)", doc={@GamlAnnotations.doc(value="Represents the absolute heading of the agent in degrees.")}), @GamlAnnotations.variable(name="current_path", type=17, init="nil", doc={@GamlAnnotations.doc(value="Represents the path on which the agent is moving on (goto action on a graph)")}), @GamlAnnotations.variable(name="current_edge", type=13, init="nil", doc={@GamlAnnotations.doc(value="Represents the agent/geometry on which the agent is located (only used with a graph)")}), @GamlAnnotations.variable(name="real_speed", type=2, init="0.0", doc={@GamlAnnotations.doc(value="Represents the actual speed of the agent (in meter/second)")})})
@GamlAnnotations.skill(name="moving", concept={"skill", "agent_movement"})
public class MovingSkill
extends Skill {
    @GamlAnnotations.getter(value="heading")
    public Double getHeading(IAgent iAgent) {
        Double d = (Double)iAgent.getAttribute("heading");
        if (d == null) {
            d = iAgent.getScope().getRandom().next() * 360.0;
            this.setHeading(iAgent, d);
        }
        return Maths.checkHeading(d);
    }

    @GamlAnnotations.setter(value="heading")
    public void setHeading(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        double d2 = d % 360.0;
        Double d3 = (Double)iAgent.getAttribute("heading");
        if (d3 == null || d3 != d2) {
            iAgent.setAttribute("heading", d2);
            iAgent.notifyVarValueChange("heading", d2);
        }
    }

    @GamlAnnotations.getter(value="destination")
    public GamaPoint getDestination(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeDistance(iAgent.getScope(), iAgent);
        ITopology iTopology = this.getTopology(iAgent);
        return iTopology.getDestination(iAgent.getScope(), gamaPoint, this.getHeading(iAgent), d, false);
    }

    @GamlAnnotations.setter(value="destination")
    public void setDestination(IAgent iAgent, GamaPoint gamaPoint) {
    }

    @GamlAnnotations.getter(value="speed")
    public static double getSpeed(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("speed");
    }

    @GamlAnnotations.getter(value="real_speed")
    public static double getRealSpeed(IAgent iAgent) {
        if (iAgent == null) {
            return 0.0;
        }
        return (Double)iAgent.getAttribute("real_speed");
    }

    @GamlAnnotations.setter(value="speed")
    public static void setSpeed(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        Double d2 = (Double)iAgent.getAttribute("speed");
        if (d2 == null || d2 != d) {
            iAgent.setAttribute("speed", d);
            iAgent.notifyVarValueChange("speed", d);
        }
    }

    @GamlAnnotations.setter(value="real_speed")
    public static void setRealSpeed(IAgent iAgent, double d) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute("real_speed", d);
    }

    @GamlAnnotations.getter(value="location", initializer=true)
    public GamaPoint getLocation(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return iAgent.getLocation();
    }

    @GamlAnnotations.setter(value="location")
    public void setLocation(IAgent iAgent, GamaPoint gamaPoint) {
        Double d;
        if (iAgent == null) {
            return;
        }
        ITopology iTopology = this.getTopology(iAgent);
        GamaPoint gamaPoint2 = iAgent.getLocation();
        Coordinate coordinate = new Coordinate(gamaPoint2.getX(), gamaPoint2.getY(), gamaPoint2.getZ());
        if (!iTopology.isTorus() && gamaPoint != null && !gamaPoint.equalsWithTolerance(coordinate, 0.01) && (d = iTopology.directionInDegreesTo(iAgent.getScope(), gamaPoint2, gamaPoint)) != null) {
            this.setHeading(iAgent, d);
        }
        iAgent.setLocation(gamaPoint);
    }

    @GamlAnnotations.setter(value="current_path")
    public static void setCurrentPath(IAgent iAgent, IPath iPath) {
    }

    @GamlAnnotations.getter(value="current_path")
    public static IPath getCurrentPath(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (IPath)iAgent.getAttribute("current_path");
    }

    @GamlAnnotations.setter(value="current_edge")
    public void setCurrentEdge(IAgent iAgent, IShape iShape) {
    }

    @GamlAnnotations.getter(value="current_edge")
    public IShape getCurrentEdge(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (IShape)iAgent.getAttribute("current_edge");
    }

    public void setCurrentEdge(IAgent iAgent, IPath iPath) {
        Integer n;
        if (iPath != null && (n = (Integer)iAgent.getAttribute("index_on_path")) < iPath.getEdgeList().size()) {
            iAgent.setAttribute("current_edge", iPath.getEdgeList().get(n));
        }
    }

    public void setCurrentEdge(IAgent iAgent, IGraph iGraph) {
        Integer n;
        if (iGraph != null && (n = (Integer)iAgent.getAttribute("index_on_path")) < iGraph.getEdges().size()) {
            iAgent.setAttribute("current_edge", iGraph.getEdges().get(n));
        }
    }

    protected double computeHeadingFromAmplitude(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        double d = iScope.hasArg("amplitude") ? iScope.getFloatArg("amplitude") : 359.0;
        this.setHeading(iAgent, this.getHeading(iAgent) + iScope.getRandom().between(-d / 2.0, d / 2.0));
        return this.getHeading(iAgent);
    }

    protected double computeHeading(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        Double d;
        Double d2 = d = iScope.hasArg("heading") ? iScope.getFloatArg("heading") : null;
        if (d != null) {
            this.setHeading(iAgent, d);
        }
        return this.getHeading(iAgent);
    }

    protected double computeDistance(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        Double d = iScope.hasArg("speed") ? iScope.getFloatArg("speed") : MovingSkill.getSpeed(iAgent);
        return d * iScope.getClock().getStepInSeconds();
    }

    protected IShape computeTarget(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        Object object = iScope.getArg("target", 0);
        IShape iShape = null;
        if (object instanceof IShape) {
            iShape = (IShape)object;
        }
        return iShape;
    }

    protected ITopology computeTopology(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        Object object = iScope.getArg("on", 0);
        ITopology iTopology = Cast.asTopology(iScope, object);
        if (iTopology == null) {
            return iScope.getTopology();
        }
        return iTopology;
    }

    protected Map computeMoveWeights(IScope iScope) throws GamaRuntimeException {
        return iScope.hasArg("move_weights") ? (Map)iScope.getArg("move_weights", 10) : null;
    }

    @GamlAnnotations.action(name="wander", args={@GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="amplitude", type=2, optional=true, doc={@GamlAnnotations.doc(value="a restriction placed on the random heading choice. The new heading is chosen in the range (heading - amplitude/2, heading+amplitude/2)")}), @GamlAnnotations.arg(name="bounds", type=13, optional=true, doc={@GamlAnnotations.doc(value="the geometry (the localized entity geometry) that restrains this move (the agent moves inside this geometry)")}), @GamlAnnotations.arg(name="on", type=15, optional=true, doc={@GamlAnnotations.doc(value="the graph that restrains this move (the agent moves on the graph")}), @GamlAnnotations.arg(name="proba_edges", type=10, optional=true, doc={@GamlAnnotations.doc(value="When the agent moves on a graph, the probability to choose another edge. If not defined, each edge has the same probability to be chosen")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do wander speed: speed - 10 amplitude: 120 bounds: agentA;")}, value="Moves the agent towards a random location at the maximum distance (with respect to its speed). The heading of the agent is chosen randomly if no amplitude is specified. This action changes the value of heading.")})
    public boolean primMoveRandomly(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeHeadingFromAmplitude(iScope, iAgent);
        double d2 = this.computeDistance(iScope, iAgent);
        GamaPoint iShape = iScope.getTopology().getDestination(iScope, gamaPoint, d, d2, true);
        if (iShape == null) {
            this.setHeading(iAgent, d - 180.0);
        } else {
            Object object = iScope.getArg("on", 15);
            Double d3 = null;
            if (object instanceof GamaSpatialGraph) {
                GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)object;
                IMap iMap = null;
                if (iScope.hasArg("proba_edges")) {
                    iMap = (IMap)iScope.getVarValue("proba_edges");
                }
                this.moveToNextLocAlongPathSimplified(iScope, iAgent, gamaSpatialGraph, d2, iMap);
                return true;
            }
            Object object2 = iScope.getArg("bounds", 0);
            if (object2 != null) {
                GamaPoint gamaPoint2;
                IShape iShape3 = GamaGeometryType.staticCast(iScope, object2, null, false);
                if (iShape3.getGeometries().size() > 1) {
                    for (IShape iShape22 : iShape3.getGeometries()) {
                        if (!(iShape22.euclidianDistanceTo(gamaPoint) < 0.01)) continue;
                        iShape3 = iShape22;
                        break;
                    }
                }
                if (iShape3.getInnerGeometry() != null && !(gamaPoint2 = this.computeLocationForward(iScope, d2, iShape, iShape3)).equals(iShape)) {
                    d3 = d - 180.0;
                    iShape = gamaPoint2;
                }
            }
            iShape.z = iAgent.getLocation().getZ();
            iAgent.setAttribute("real_speed", iShape.euclidianDistanceTo(gamaPoint) / iScope.getClock().getStepInSeconds());
            this.setLocation(iAgent, iShape);
            if (d3 != null) {
                this.setHeading(iAgent, d3);
            }
        }
        return true;
    }

    @GamlAnnotations.action(name="move", args={@GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="heading", type=2, optional=true, doc={@GamlAnnotations.doc(value="the angle (in degree) of the target direction.")}), @GamlAnnotations.arg(name="bounds", type=13, optional=true, doc={@GamlAnnotations.doc(value="the geometry (the localized entity geometry) that restrains this move (the agent moves inside this geometry")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do move speed: speed - 10 heading: heading + rnd (30) bounds: agentA;")}, value="moves the agent forward, the distance being computed with respect to its speed and heading. The value of the corresponding variables are used unless arguments are passed.")})
    public IPath primMoveForward(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation();
        double d = this.computeDistance(iScope, iAgent);
        double d2 = this.computeHeading(iScope, iAgent);
        GamaPoint gamaPoint2 = iScope.getTopology().getDestination(iScope, gamaPoint, d2, d, true);
        if (gamaPoint2 == null) {
            this.setHeading(iAgent, d2 - 180.0);
        } else {
            IShape iShape;
            Object object = iScope.getArg("bounds", 0);
            if (object != null && (iShape = GamaGeometryType.staticCast(iScope, object, null, false)) != null && iShape.getInnerGeometry() != null) {
                gamaPoint2 = this.computeLocationForward(iScope, d, gamaPoint2, iShape);
            }
            this.setLocation(iAgent, gamaPoint2);
        }
        if (gamaPoint2 != null) {
            iAgent.setAttribute("real_speed", gamaPoint2.euclidianDistanceTo(gamaPoint) / iScope.getClock().getStepInSeconds());
        } else {
            iAgent.setAttribute("real_speed", 0.0);
        }
        return null;
    }

    @GamlAnnotations.action(name="follow", args={@GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="path", type=17, optional=false, doc={@GamlAnnotations.doc(value="a path to be followed.")}), @GamlAnnotations.arg(name="move_weights", type=10, optional=true, doc={@GamlAnnotations.doc(value="Weights used for the moving.")}), @GamlAnnotations.arg(name="return_path", type=3, optional=true, doc={@GamlAnnotations.doc(value="if true, return the path followed (by default: false)")})}, doc={@GamlAnnotations.doc(value="moves the agent along a given path passed in the arguments.", returns="optional: the path followed by the agent.", examples={@GamlAnnotations.example(value="do follow speed: speed * 2 path: road_path;")})})
    public IPath primFollow(IScope iScope) throws GamaRuntimeException {
        GamaPath gamaPath;
        IAgent iAgent = this.getCurrentAgent(iScope);
        double d = this.computeDistance(iScope, iAgent);
        Boolean bl = iScope.getBoolArg("return_path");
        IMap iMap = (IMap)this.computeMoveWeights(iScope);
        GamaPath gamaPath2 = gamaPath = iScope.hasArg("path") ? (GamaPath)iScope.getArg("path", 17) : null;
        if (gamaPath != null && !gamaPath.getEdgeList().isEmpty()) {
            if (bl != null && bl.booleanValue()) {
                IPath iPath = this.moveToNextLocAlongPath(iScope, iAgent, gamaPath, d, iMap);
                if (iPath == null) {
                    this.notMoving(iAgent);
                    return null;
                }
                return iPath;
            }
            this.moveToNextLocAlongPathSimplified(iScope, iAgent, gamaPath, d, iMap);
            return null;
        }
        this.notMoving(iAgent);
        return null;
    }

    @GamlAnnotations.action(name="goto", args={@GamlAnnotations.arg(name="target", type=13, optional=false, doc={@GamlAnnotations.doc(value="the location or entity towards which to move.")}), @GamlAnnotations.arg(name="speed", type=2, optional=true, doc={@GamlAnnotations.doc(value="the speed to use for this move (replaces the current value of speed)")}), @GamlAnnotations.arg(name="on", type=0, optional=true, doc={@GamlAnnotations.doc(value="graph, topology, list of geometries or map of geometries that restrain this move")}), @GamlAnnotations.arg(name="recompute_path", type=3, optional=true, doc={@GamlAnnotations.doc(value="if false, the path is not recompute even if the graph is modified (by default: true)")}), @GamlAnnotations.arg(name="return_path", type=3, optional=true, doc={@GamlAnnotations.doc(value="if true, return the path followed (by default: false)")}), @GamlAnnotations.arg(name="move_weights", type=10, optional=true, doc={@GamlAnnotations.doc(value="Weights used for the moving.")})}, doc={@GamlAnnotations.doc(value="moves the agent towards the target passed in the arguments.", returns="optional: the path followed by the agent.", examples={@GamlAnnotations.example(value="do goto target: (one_of road).location speed: speed * 2 on: road_network;")})})
    public IPath primGoto(IScope iScope) throws GamaRuntimeException {
        IModifiableContainer iModifiableContainer;
        ITopology iTopology;
        IValue iValue;
        Object object;
        IAgent iAgent = this.getCurrentAgent(iScope);
        GamaPoint gamaPoint = iAgent.getLocation().copy(iScope);
        double d = this.computeDistance(iScope, iAgent);
        IShape iShape = this.computeTarget(iScope, iAgent);
        Boolean bl = iScope.hasArg("return_path") ? (Boolean)iScope.getArg("return_path", 0) : false;
        IModifiableContainer iModifiableContainer2 = null;
        Set set = iScope.getArg("on", 0);
        if (set instanceof IShape && ((IShape)((Object)set)).isLine()) {
            object = set;
        } else {
            if (set instanceof ISpecies) {
                iModifiableContainer2 = ((ISpecies)((Object)set)).listValue(iScope, Types.AGENT, false);
            } else if (set instanceof IList) {
                iModifiableContainer2 = GamaListFactory.create(Types.AGENT);
                iValue = (IList)((Object)set);
                if (!iValue.isEmpty() && iValue.get(0) instanceof IAgent) {
                    iModifiableContainer2.addAll(iValue);
                    set = ((IAgent)iValue.get(0)).getSpecies();
                }
            } else if (set instanceof IMap) {
                iModifiableContainer2 = GamaMapFactory.wrap(Types.AGENT, Types.NO_TYPE, (IMap)((Object)set));
                set = ((IAgent)((IMap)((Object)set)).getKeys().get(iScope, 0)).getSpecies();
            }
            object = Cast.asTopology(iScope, set instanceof IMap ? ((IMap)((Object)set)).keySet() : set);
        }
        if (iModifiableContainer2 != null && iModifiableContainer2.isEmpty(iScope)) {
            iModifiableContainer2 = null;
        }
        iValue = object instanceof IShape ? (IShape)object : null;
        ITopology iTopology2 = iTopology = object instanceof ITopology ? (ITopology)object : iScope.getTopology();
        if (iShape == null || iTopology == null) {
            this.notMoving(iAgent);
            if (bl.booleanValue()) {
                return PathFactory.newInstance(iScope, iTopology, gamaPoint, gamaPoint, GamaListFactory.EMPTY_LIST, false);
            }
            return null;
        }
        if (iTopology instanceof GridTopology) {
            iShape = ((GamaSpatialMatrix)iTopology.getPlaces()).getAgentAt(iShape.getLocation()).getLocation();
        }
        if (gamaPoint.equals(iShape.getLocation())) {
            this.notMoving(iAgent);
            if (bl.booleanValue()) {
                return PathFactory.newInstance(iScope, iTopology, gamaPoint, gamaPoint, GamaListFactory.EMPTY_LIST, false);
            }
            return null;
        }
        Boolean bl2 = (Boolean)iScope.getArg("recompute_path", 0);
        if (bl2 == null) {
            bl2 = true;
        }
        GamaPath gamaPath = (GamaPath)iAgent.getAttribute("current_path");
        if (bl2.booleanValue() && iTopology instanceof GridTopology) {
            iAgent.setAttribute("current_path", null);
            gamaPath = null;
        }
        if (gamaPath == null || gamaPath.getTopology(iScope) != null && !gamaPath.getTopology(iScope).equals(iTopology) || !((IShape)gamaPath.getEndVertex()).getLocation().equals(iShape.getLocation()) || !((IShape)gamaPath.getStartVertex()).getLocation().equals(gamaPoint.getLocation())) {
            if (iValue != null) {
                iModifiableContainer = GamaListFactory.create(Types.GEOMETRY);
                iModifiableContainer.add(iValue);
                gamaPath = new GamaSpatialPath(gamaPoint.getGeometry(), iShape, (IList<? extends IShape>)iModifiableContainer, true);
            } else if (iTopology instanceof GridTopology) {
                if (iModifiableContainer2 instanceof IList) {
                    gamaPath = ((GridTopology)iTopology).pathBetween(iScope, (IShape)gamaPoint, iShape, (IList)iModifiableContainer2);
                } else if (iModifiableContainer2 instanceof IMap) {
                    gamaPath = ((GridTopology)iTopology).pathBetween(iScope, (IShape)gamaPoint, iShape, (IMap)iModifiableContainer2);
                }
            } else {
                gamaPath = iTopology.pathBetween(iScope, iAgent, iShape);
            }
        } else if (iTopology instanceof GraphTopology && (((GraphTopology)iTopology).getPlaces() != gamaPath.getGraph() || bl2.booleanValue() && ((GraphTopology)iTopology).getPlaces().getPathComputer().getVersion() != gamaPath.getGraphVersion())) {
            gamaPath = iTopology.pathBetween(iScope, iAgent, iShape);
        }
        if (gamaPath == null) {
            this.notMoving(iAgent);
            if (bl.booleanValue()) {
                return PathFactory.newInstance(iScope, iTopology, gamaPoint, gamaPoint, GamaListFactory.create(Types.GEOMETRY), false);
            }
            return null;
        }
        iModifiableContainer = (IMap)this.computeMoveWeights(iScope);
        if (bl.booleanValue()) {
            IPath iPath = this.moveToNextLocAlongPath(iScope, iAgent, gamaPath, d, (IMap)iModifiableContainer);
            if (iPath == null) {
                return PathFactory.newInstance(iScope, iTopology, gamaPoint, gamaPoint, GamaListFactory.create(Types.GEOMETRY), false);
            }
            return iPath;
        }
        this.moveToNextLocAlongPathSimplified(iScope, iAgent, gamaPath, d, (IMap)iModifiableContainer);
        return null;
    }

    private void notMoving(IAgent iAgent) {
        MovingSkill.setRealSpeed(iAgent, 0.0);
        iAgent.setAttribute("current_edge", null);
        iAgent.setAttribute("current_path", null);
    }

    protected IList initMoveAlongPath3D(IAgent iAgent, IPath iPath, GamaPoint gamaPoint) {
        int n;
        Object object;
        GamaPoint gamaPoint2 = gamaPoint.copy(GAMA.getRuntimeScope());
        IList iList = GamaListFactory.create();
        Integer n2 = 0;
        Integer n3 = 1;
        Integer n4 = 1;
        Object object2 = null;
        IList<IShape> iList2 = iPath.getEdgeGeometry();
        if (iPath.isVisitor(iAgent)) {
            n2 = iPath.indexOf(iAgent);
            n3 = iPath.indexSegmentOf(iAgent);
        } else {
            if (iList2.isEmpty()) {
                return null;
            }
            iPath.acceptVisitor(iAgent);
            double d = Double.MAX_VALUE;
            int n5 = 0;
            for (IShape iShape : iList2) {
                object = GeometryUtils.getPointsOf(iShape);
                n = 0;
                GamaPoint[] gamaPointArray = object;
                int n6 = ((GamaPoint[])object).length;
                int n7 = 0;
                while (n7 < n6) {
                    GamaPoint gamaPoint3 = gamaPointArray[n7];
                    double d2 = gamaPoint3.euclidianDistanceTo(gamaPoint);
                    if (d2 < d) {
                        gamaPoint2 = gamaPoint3;
                        d = d2;
                        n2 = n5;
                        n3 = n + 1;
                        if (d == 0.0) break;
                    }
                    ++n;
                    ++n7;
                }
                if (d == 0.0) break;
                ++n5;
            }
        }
        GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(iList2.lastValue(GAMA.getRuntimeScope()));
        int n8 = 0;
        double d = Double.MAX_VALUE;
        GamaPoint gamaPoint4 = ((IShape)iPath.getEndVertex()).getLocation();
        GamaPoint[] gamaPointArray2 = gamaPointArray;
        int n9 = gamaPointArray.length;
        n = 0;
        while (n < n9) {
            object = gamaPointArray2[n];
            double d3 = ((GamaPoint)object).euclidianDistanceTo(gamaPoint4);
            if (d3 < d) {
                d = d3;
                n4 = n8;
                object2 = object;
                if (d == 0.0) break;
            }
            ++n8;
            ++n;
        }
        iList.add(n2);
        iList.add(n3);
        iList.add(n4);
        iList.add(gamaPoint2);
        iList.add(object2);
        return iList;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected IList initMoveAlongPath(IAgent iAgent, IPath iPath, GamaPoint gamaPoint) {
        GamaPoint gamaPoint3 = gamaPoint;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Collector.AsList asList = Collector.getList();){
            Integer n3 = 0;
            Integer n2 = 1;
            Integer n = 0;
            GamaPoint gamaPoint2 = null;
            IList<IShape> iList = iPath.getEdgeGeometry();
            if (iList.isEmpty()) {
                return null;
            }
            int n4 = iList.size();
            if (iPath.getGraph() == null && n4 == 1 && ((IShape)iList.get(0)).getInnerGeometry().getNumPoints() == 2) {
                n3 = 0;
                n2 = 0;
                n = 0;
                gamaPoint2 = ((IShape)iPath.getEndVertex()).getLocation();
                iPath.acceptVisitor(iAgent);
            } else {
                double d;
                Object object;
                Object object2;
                if (iPath.isVisitor(iAgent)) {
                    n3 = iPath.indexOf(iAgent);
                    n2 = iPath.indexSegmentOf(iAgent);
                } else {
                    iPath.acceptVisitor(iAgent);
                    double d2 = Double.MAX_VALUE;
                    object2 = null;
                    int n5 = 0;
                    while (n5 < n4) {
                        object2 = (Object[])iList.get(n5);
                        double d3 = Distance.pointToSegment((Coordinate)gamaPoint3, (Coordinate)GeometryUtils.getFirstPointOf((IShape)object2), (Coordinate)GeometryUtils.getLastPointOf((IShape)object2));
                        if (d3 < d2) {
                            d2 = d3;
                            n3 = n5;
                        }
                        ++n5;
                    }
                    object2 = (IShape)iList.get(n3);
                    object = GeometryUtils.getPointsOf((IShape)object2);
                    if (ArrayUtils.contains((Object[])object, (Object)gamaPoint3)) {
                        gamaPoint3 = new GamaPoint(gamaPoint3);
                        n2 = ArrayUtils.indexOf((Object[])object, (Object)gamaPoint3) + 1;
                    } else {
                        gamaPoint3 = SpatialPunctal._closest_point_to(gamaPoint3, (IShape)object2);
                        if (((Object[])object).length >= 3) {
                            d2 = Double.MAX_VALUE;
                            int n6 = ((Object[])object).length;
                            int n7 = 0;
                            while (n7 < n6 - 1) {
                                d = Distance.pointToSegment((Coordinate)gamaPoint3, (Coordinate)object[n7], (Coordinate)object[n7 + 1]);
                                if (d < d2) {
                                    d2 = d;
                                    n2 = n7 + 1;
                                    gamaPoint3.z = ((GamaPoint)object[n7]).z + (((GamaPoint)object[n7 + 1]).z - ((GamaPoint)object[n7]).z) * gamaPoint3.distance((Coordinate)object[n7]) / object[n7].distance((Coordinate)object[n7 + 1]);
                                }
                                ++n7;
                            }
                        } else if (((Object[])object).length >= 2) {
                            Object object3 = object[0];
                            Object object4 = object[1];
                            gamaPoint3.z = ((GamaPoint)object3).getZ() + (((GamaPoint)object4).z - ((GamaPoint)object3).z) * gamaPoint3.distance((Coordinate)object3) / object2.getPerimeter();
                        } else {
                            gamaPoint3.z = ((GamaPoint)object[0]).z;
                        }
                    }
                }
                IShape iShape = (IShape)iList.get(n4 - 1);
                GamaPoint gamaPoint4 = ((IShape)iPath.getEndVertex()).getLocation();
                object2 = GeometryUtils.getPointsOf(iShape);
                if (ArrayUtils.contains((Object[])object2, (Object)gamaPoint4)) {
                    gamaPoint2 = new GamaPoint(gamaPoint4);
                    n = ArrayUtils.indexOf((Object[])object2, (Object)gamaPoint4) + 1;
                } else {
                    gamaPoint2 = SpatialPunctal._closest_point_to(gamaPoint4, iShape);
                    n = 1;
                    if (((Object[])object2).length >= 3) {
                        double d4 = Double.MAX_VALUE;
                        int n8 = 0;
                        while (n8 < ((Object[])object2).length - 1) {
                            d = Distance.pointToSegment((Coordinate)gamaPoint2, (Coordinate)object2[n8], (Coordinate)object2[n8 + 1]);
                            if (d < d4) {
                                d4 = d;
                                n = n8 + 1;
                                gamaPoint2.z = ((GamaPoint)object2[n8]).z + (((GamaPoint)object2[n8 + 1]).z - ((GamaPoint)object2[n8]).z) * gamaPoint2.distance3D((Coordinate)object2[n8]) / object2[n8].distance3D((Coordinate)object2[n8 + 1]);
                            }
                            ++n8;
                        }
                    } else {
                        object = object2[0];
                        Object object5 = object2[1];
                        gamaPoint2.z = ((GamaPoint)object).getZ() + (((GamaPoint)object5).getZ() - ((GamaPoint)object).getZ()) * gamaPoint2.distance3D((Coordinate)object) / iShape.getPerimeter();
                    }
                }
            }
            asList.add(n3);
            asList.add(n2);
            asList.add(n);
            asList.add(gamaPoint3);
            asList.add(gamaPoint2);
            return asList.items();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected IList initMoveAlongPath(IScope iScope, IAgent iAgent, GamaSpatialGraph gamaSpatialGraph, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = gamaPoint;
        Throwable throwable = null;
        Object var7_8 = null;
        try (Collector.AsList asList = Collector.getList();){
            Integer n3 = 0;
            Integer n2 = 1;
            Integer n = 0;
            IList iList = gamaSpatialGraph.getEdges();
            if (iList.isEmpty()) {
                return null;
            }
            int n4 = iList.size();
            if (n4 == 1 && ((IShape)iList.get(0)).getInnerGeometry().getNumPoints() == 2) {
                n3 = 0;
                n2 = 1;
            } else {
                IShape iShape = null;
                n3 = (Integer)iAgent.getAttribute("index_on_path");
                n2 = (Integer)iAgent.getAttribute("index_on_path_segment");
                n = (Integer)iAgent.getAttribute("reverse");
                if (n3 == null || n2 == null) {
                    double d;
                    Object object;
                    Object[] objectArray;
                    double d2;
                    n = iScope.getRandom().between(0, 1);
                    boolean bl = gamaSpatialGraph.edgeSet().size() > 1000;
                    double d3 = d2 = bl ? Math.sqrt(iScope.getSimulation().getArea()) / (double)gamaSpatialGraph.edgeSet().size() * 100.0 : -1.0;
                    if (gamaSpatialGraph.isAgentEdge()) {
                        objectArray = In.edgesOf(gamaSpatialGraph);
                        if (bl && !(object = iScope.getSimulation().getTopology().getNeighborsOf(iScope, gamaPoint2, d2, (IAgentFilter)objectArray)).isEmpty()) {
                            double d4 = Double.MAX_VALUE;
                            Iterator<IAgent> iterator = object.iterator();
                            while (iterator.hasNext()) {
                                IAgent iAgent2 = iterator.next();
                                double d5 = gamaPoint2.euclidianDistanceTo(iAgent2);
                                if (!(d5 < d4)) continue;
                                iShape = iAgent2;
                                d4 = d5;
                            }
                        }
                        if (iShape == null) {
                            iShape = iScope.getSimulation().getTopology().getAgentClosestTo(iScope, gamaPoint2, (IAgentFilter)objectArray);
                        }
                        n3 = iList.indexOf(iShape);
                    } else {
                        double d6 = Double.MAX_VALUE;
                        int n5 = 0;
                        while (n5 < n4) {
                            iShape = (IShape)iList.get(n5);
                            d = iShape.euclidianDistanceTo(gamaPoint2);
                            if (d < d6) {
                                d6 = d;
                                n3 = n5;
                            }
                            ++n5;
                        }
                        iShape = (IShape)iList.get(n3);
                    }
                    objectArray = GeometryUtils.getPointsOf(iShape);
                    if (ArrayUtils.contains((Object[])objectArray, (Object)gamaPoint2)) {
                        gamaPoint2 = new GamaPoint(gamaPoint2);
                        n2 = ArrayUtils.indexOf((Object[])objectArray, (Object)gamaPoint2) + 1;
                    } else {
                        gamaPoint2 = SpatialPunctal._closest_point_to(gamaPoint2, iShape);
                        if (objectArray.length >= 3) {
                            object = Double.MAX_VALUE;
                            int n6 = 0;
                            while (n6 < objectArray.length - 1) {
                                d = Distance.pointToSegment((Coordinate)gamaPoint2, (Coordinate)objectArray[n6], (Coordinate)objectArray[n6 + 1]);
                                if (d < (Double)object) {
                                    object = d;
                                    n2 = n6 + 1;
                                    gamaPoint2.z = ((GamaPoint)objectArray[n6]).z + (((GamaPoint)objectArray[n6 + 1]).z - ((GamaPoint)objectArray[n6]).z) * gamaPoint2.distance3D((Coordinate)objectArray[n6]) / objectArray[n6].distance3D((Coordinate)objectArray[n6 + 1]);
                                }
                                ++n6;
                            }
                        } else {
                            n2 = 1;
                            gamaPoint2.z = ((GamaPoint)objectArray[0]).getZ() + (((GamaPoint)objectArray[1]).z - ((GamaPoint)objectArray[0]).z) * gamaPoint2.distance3D((Coordinate)objectArray[0]) / iShape.getPerimeter();
                        }
                    }
                }
            }
            asList.add(n3);
            asList.add(n2);
            asList.add(n);
            return asList.items();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void moveToNextLocAlongPathSimplified(IScope iScope, IAgent iAgent, GamaSpatialGraph gamaSpatialGraph, double d, IMap iMap) {
        GamaPoint gamaPoint = iAgent.getLocation().copy(iScope);
        IList iList = this.initMoveAlongPath(iScope, iAgent, gamaSpatialGraph, gamaPoint);
        if (iList == null) {
            return;
        }
        int n = (Integer)iList.get(0);
        int n2 = (Integer)iList.get(1);
        int n3 = (Integer)iList.get(2);
        IShape iShape = (IShape)gamaSpatialGraph.getEdges().get(n);
        double d2 = d;
        double d3 = 0.0;
        double d4 = 0.0;
        while (true) {
            int n4;
            Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
            if (!gamaSpatialGraph.isDirected() && n3 == 1) {
                int n5 = coordinateArray.length;
                Coordinate[] coordinateArray2 = new Coordinate[n5];
                n4 = 0;
                while (n4 < coordinateArray.length) {
                    coordinateArray2[n4] = coordinateArray[n5 - 1 - n4];
                    ++n4;
                }
                coordinateArray = coordinateArray2;
            }
            double d5 = gamaSpatialGraph.getEdgeWeight(iShape) / iShape.getGeometry().getPerimeter();
            n4 = n2;
            while (n4 < coordinateArray.length) {
                GamaPoint gamaPoint2 = new GamaPoint(coordinateArray[n4]);
                double d6 = gamaPoint2.distance3D(gamaPoint);
                double d7 = d5 * d6;
                d4 = SpatialRelations.towards(iScope, gamaPoint, gamaPoint2);
                if (d2 < d7) {
                    double d8 = d2 / d7;
                    d3 += d6 * d8;
                    double d9 = gamaPoint.x + d8 * (gamaPoint2.x - gamaPoint.x);
                    double d10 = gamaPoint.y + d8 * (gamaPoint2.y - gamaPoint.y);
                    double d11 = gamaPoint.z + d8 * (gamaPoint2.z - gamaPoint.z);
                    gamaPoint.setLocation(d9, d10, d11);
                    d2 = 0.0;
                    break;
                }
                if (d2 <= d7) {
                    gamaPoint = gamaPoint2;
                    d3 += d6;
                    d2 = 0.0;
                    if (n2 < coordinateArray.length - 1) {
                        ++n2;
                        break;
                    }
                    n2 = 1;
                    break;
                }
                gamaPoint = gamaPoint2;
                d3 += d6;
                d2 -= d7;
                ++n2;
                if (n4 == coordinateArray.length - 1) {
                    ArrayList arrayList;
                    IShape iShape2 = (IShape)gamaSpatialGraph.getEdgeTarget(iShape);
                    if (!gamaSpatialGraph.isDirected() && !iShape2.getLocation().equals(gamaPoint)) {
                        iShape2 = (IShape)gamaSpatialGraph.getEdgeSource(iShape);
                    }
                    if ((arrayList = new ArrayList(gamaSpatialGraph.isDirected() ? gamaSpatialGraph.outgoingEdgesOf(iShape2) : gamaSpatialGraph.edgesOf(iShape2))).isEmpty()) {
                        d2 = 0.0;
                        break;
                    }
                    if (arrayList.size() == 1) {
                        iShape = (IShape)arrayList.get(0);
                    }
                    if (arrayList.size() > 1) {
                        if (iMap == null || iMap.isEmpty()) {
                            iShape = (IShape)arrayList.get(iScope.getRandom().between(0, arrayList.size() - 1));
                        } else {
                            IList iList2 = GamaListFactory.create(Types.FLOAT);
                            for (IShape iShape3 : arrayList) {
                                Double d12 = (Double)iMap.get(iShape3);
                                iList2.add(d12 == null ? 0.0 : d12);
                            }
                            iShape = (IShape)arrayList.get(Random.opRndChoice(iScope, iList2));
                        }
                    }
                    n = gamaSpatialGraph.getEdges().indexOf(iShape);
                    if (!gamaSpatialGraph.isDirected()) {
                        n3 = gamaPoint.equals(gamaSpatialGraph.getEdgeSource(iShape)) ? 0 : 1;
                    }
                    n2 = 0;
                }
                ++n4;
            }
            if (d2 == 0.0) break;
            n2 = 1;
        }
        iAgent.setAttribute("real_speed", d3 / iScope.getClock().getStepInSeconds());
        iAgent.setAttribute("index_on_path", n);
        this.setCurrentEdge(iAgent, gamaSpatialGraph);
        iAgent.setAttribute("index_on_path_segment", n2);
        iAgent.setAttribute("reverse", n3);
        this.setLocation(iAgent, gamaPoint);
        this.setHeading(iAgent, d4);
    }

    private void moveToNextLocAlongPathSimplified(IScope iScope, IAgent iAgent, IPath iPath, double d, IMap iMap) {
        IList iList;
        Object object = iAgent.getLocation().copy(iScope);
        IList iList2 = iList = ((GamaSpatialPath)iPath).isThreeD() ? this.initMoveAlongPath3D(iAgent, iPath, (GamaPoint)object) : this.initMoveAlongPath(iAgent, iPath, (GamaPoint)object);
        if (iList == null) {
            return;
        }
        int n = (Integer)iList.get(0);
        int n2 = (Integer)iList.get(1);
        int n3 = (Integer)iList.get(2);
        object = (GamaPoint)iList.get(3);
        GamaPoint gamaPoint = (GamaPoint)iList.get(4);
        IList<IShape> iList3 = iPath.getEdgeGeometry();
        double d2 = 0.0;
        int n4 = iList3.size();
        double d3 = d;
        GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)iPath.getGraph();
        double d4 = 0.0;
        int n5 = n;
        while (n5 < n4) {
            Object object2;
            double d5;
            IShape iShape = (IShape)iList3.get(n5);
            GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(iShape);
            if (iMap == null) {
                d5 = this.computeWeigth(gamaSpatialGraph, iPath, iShape);
            } else {
                IShape iShape2 = iPath.getRealObject(iShape);
                object2 = iShape2 == null ? null : Double.valueOf((Double)iMap.get(iShape2) / iShape2.getGeometry().getPerimeter());
                d5 = object2 == null ? this.computeWeigth(gamaSpatialGraph, iPath, iShape) : ((Double)object2).doubleValue();
            }
            int n6 = n2;
            while (n6 < gamaPointArray.length) {
                object2 = null;
                object2 = n5 == n4 - 1 && n6 == n3 ? gamaPoint : new GamaPoint(gamaPointArray[n6]);
                double d6 = object2.distance3D((Coordinate)object);
                double d7 = d5 * d6;
                d2 = SpatialRelations.towards(iScope, (IShape)object, (IShape)object2);
                if (d3 < d7) {
                    double d8 = d3 / d7;
                    double d9 = ((GamaPoint)object).x + d8 * (((GamaPoint)object2).x - ((GamaPoint)object).x);
                    double d10 = ((GamaPoint)object).y + d8 * (((GamaPoint)object2).y - ((GamaPoint)object).y);
                    double d11 = ((GamaPoint)object).z + d8 * (((GamaPoint)object2).z - ((GamaPoint)object).z);
                    d4 += d6 * d8;
                    ((GamaPoint)object).setLocation(d9, d10, d11);
                    d3 = 0.0;
                    break;
                }
                if (d3 <= d7) {
                    object = object2;
                    d3 = 0.0;
                    d4 += d6;
                    if (n2 < gamaPointArray.length - 1) {
                        ++n2;
                        break;
                    }
                    if (n < n4 - 1) {
                        ++n;
                    }
                    n2 = 1;
                    break;
                }
                object = object2;
                d4 += d6;
                d3 -= d7;
                if (n5 == n4 - 1 && n6 == n3) break;
                ++n2;
                ++n6;
            }
            if (d3 == 0.0) break;
            n2 = 1;
            if (n < n4 - 1) {
                ++n;
            }
            ++n5;
        }
        if (((GamaPoint)object).equals(gamaPoint)) {
            object = Cast.asPoint(iScope, iPath.getEndVertex());
            ++n;
        }
        iPath.setIndexSegementOf(iAgent, n2);
        iPath.setIndexOf(iAgent, n);
        iAgent.setAttribute("real_speed", d4 / iScope.getClock().getStepInSeconds());
        this.setCurrentEdge(iAgent, iPath);
        this.setLocation(iAgent, (GamaPoint)object);
        this.setHeading(iAgent, d2);
        iPath.setSource(iAgent.getLocation());
    }

    protected double computeWeigth(IGraph iGraph, IPath iPath, IShape iShape) {
        if (iGraph == null) {
            return 1.0;
        }
        IShape iShape2 = iPath.getRealObject(iShape);
        return iShape2 == null ? 1.0 : iGraph.getEdgeWeight(iShape2) / iShape2.getGeometry().getPerimeter();
    }

    private IPath moveToNextLocAlongPath(IScope iScope, IAgent iAgent, IPath iPath, double d, IMap iMap) {
        IList iList;
        GamaPoint gamaPoint = iAgent.getLocation().copy(iScope);
        Object object = iAgent.getLocation().copy(iScope);
        IList iList2 = iList = ((GamaSpatialPath)iPath).isThreeD() ? this.initMoveAlongPath3D(iAgent, iPath, (GamaPoint)object) : this.initMoveAlongPath(iAgent, iPath, (GamaPoint)object);
        if (iList == null) {
            return null;
        }
        IList<IShape> iList3 = GamaListFactory.create(Types.GEOMETRY);
        IMap iMap2 = GamaMapFactory.createUnordered();
        int n = (Integer)iList.get(0);
        int n2 = (Integer)iList.get(1);
        int n3 = (Integer)iList.get(2);
        object = (GamaPoint)iList.get(3);
        GamaPoint gamaPoint2 = (GamaPoint)iList.get(4);
        IList<IShape> iList4 = iPath.getEdgeGeometry();
        int n4 = iList4.size();
        double d2 = d;
        double d3 = 0.0;
        double d4 = 0.0;
        GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)iPath.getGraph();
        int n5 = n;
        while (n5 < n4) {
            Object object2;
            double d5;
            IShape iShape = (IShape)iList4.get(n5);
            Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
            if (iMap == null) {
                d5 = this.computeWeigth(gamaSpatialGraph, iPath, iShape);
            } else {
                IShape iShape2 = iPath.getRealObject(iShape);
                object2 = iShape2 == null ? null : Double.valueOf((Double)iMap.get(iShape2) / iShape2.getGeometry().getPerimeter());
                d5 = object2 == null ? this.computeWeigth(gamaSpatialGraph, iPath, iShape) : ((Double)object2).doubleValue();
            }
            int n6 = n2;
            while (n6 < coordinateArray.length) {
                IAgent iAgent2;
                IShape iShape3;
                object2 = null;
                object2 = n5 == n4 - 1 && n6 == n3 ? gamaPoint2 : new GamaPoint(coordinateArray[n6]);
                double d6 = object2.distance3D((Coordinate)object);
                double d7 = d5 * d6;
                d4 = SpatialRelations.towards(iScope, (IShape)object, (IShape)object2);
                if (d2 < d7) {
                    IAgent iAgent3;
                    iShape3 = ((GamaPoint)object).copy(iScope);
                    double d8 = d2 / d7;
                    d3 += d6 * d8;
                    double d9 = ((GamaPoint)object).x + d8 * (((GamaPoint)object2).x - ((GamaPoint)object).x);
                    double d10 = ((GamaPoint)object).y + d8 * (((GamaPoint)object2).y - ((GamaPoint)object).y);
                    double d11 = ((GamaPoint)object).z + d8 * (((GamaPoint)object2).z - ((GamaPoint)object).z);
                    ((GamaPoint)object).setLocation(d9, d10, d11);
                    d2 = 0.0;
                    IShape iShape4 = GamaGeometryType.buildLine(iShape3, (IShape)object);
                    IShape iShape5 = iPath.getRealObject(iShape);
                    if (iShape5 != null && (iAgent3 = iShape5.getAgent()) != null) {
                        iMap2.put(iShape4, iAgent3);
                    }
                    iList3.add(iShape4);
                    break;
                }
                if (d2 <= d7) {
                    IAgent iAgent4;
                    d3 += d6;
                    iShape3 = GamaGeometryType.buildLine((IShape)object, (IShape)object2);
                    if (iPath.getRealObject(iShape) != null && (iAgent4 = iPath.getRealObject(iShape).getAgent()) != null) {
                        iMap2.put(iShape3, iAgent4);
                    }
                    iList3.add(iShape3);
                    object = object2;
                    d2 = 0.0;
                    if (n2 < coordinateArray.length - 1) {
                        ++n2;
                        break;
                    }
                    if (n < n4 - 1) {
                        ++n;
                    }
                    n2 = 1;
                    break;
                }
                d3 += d6;
                iShape3 = GamaGeometryType.buildLine((IShape)object, (IShape)object2);
                IShape iShape6 = iPath.getRealObject(iShape);
                if (iShape6 != null && (iAgent2 = iShape6.getAgent()) != null) {
                    iMap2.put(iShape3, iAgent2);
                }
                iList3.add(iShape3);
                object = object2;
                d2 -= d7;
                if (n5 == n4 - 1 && n6 == n3) break;
                ++n2;
                ++n6;
            }
            if (d2 == 0.0) break;
            n2 = 1;
            if (n < n4 - 1) {
                ++n;
            }
            ++n5;
        }
        if (((GamaPoint)object).equals(gamaPoint2)) {
            object = Cast.asPoint(iScope, iPath.getEndVertex());
            ++n;
        }
        iPath.setIndexSegementOf(iAgent, n2);
        iPath.setIndexOf(iAgent, n);
        this.setCurrentEdge(iAgent, iPath);
        this.setLocation(iAgent, (GamaPoint)object);
        iPath.setSource(((GamaPoint)object).copy(iScope));
        iAgent.setAttribute("real_speed", d3 / iScope.getClock().getStepInSeconds());
        if (iList3.isEmpty()) {
            return null;
        }
        GamaSpatialPath gamaSpatialPath = PathFactory.newInstance(iScope, iAgent.getTopology(), gamaPoint, (IShape)object, iList3, false);
        gamaSpatialPath.setRealObjects(iMap2);
        this.setHeading(iAgent, d4);
        return gamaSpatialPath;
    }

    protected GamaPoint computeLocationForward(IScope iScope, double d, GamaPoint gamaPoint, IShape iShape) {
        IList<IShape> iList = GamaListFactory.create(Types.POINT);
        iList.add(iScope.getAgent().getLocation(iScope));
        iList.add(gamaPoint);
        IShape iShape2 = SpatialCreation.line(iScope, iList);
        if (iShape2 == null) {
            return this.getCurrentAgent(iScope).getLocation(iScope);
        }
        if (iShape.covers(iShape2)) {
            return gamaPoint;
        }
        GamaPoint gamaPoint2 = (GamaPoint)SpatialPunctal.closest_points_with(iShape2, iShape.getExteriorRing(iScope)).get(0);
        if (gamaPoint2 != null && gamaPoint2.intersects(iShape)) {
            return gamaPoint2;
        }
        return this.getCurrentAgent(iScope).getLocation(iScope);
    }
}

