/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sampling;

import gama.core.kernel.batch.exploration.sampling.SamplingUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;

public class OrthogonalSampling
extends SamplingUtils {
    public static final int DEFAULT_ITERATION = 5;

    private static List<Double> buildCut(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = 0;
        while (n2 < n + 1) {
            arrayList.add((double)n2 / (double)n);
            ++n2;
        }
        return arrayList;
    }

    private static List<Map<String, Double>> buildU(int n, int n2, List<String> list, Random random) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n3 = 0;
        while (n3 < n) {
            LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
            int n4 = 0;
            while (n4 < n2) {
                linkedHashMap.put(list.get(n4), random.nextDouble());
                ++n4;
            }
            arrayList.add(linkedHashMap);
            ++n3;
        }
        return arrayList;
    }

    private static List<Double> buildA(int n, List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        arrayList.remove(list.size() - 1);
        return arrayList;
    }

    private static List<Double> buildB(int n, List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        arrayList.remove(0);
        return arrayList;
    }

    private static List<Map<String, Double>> changeValueSample(int n, List<String> list, List<Map<String, Double>> list2, List<Double> list3, List<Double> list4) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n2 = 0;
        while (n2 < n) {
            LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
            int n3 = 0;
            while (n3 < list.size()) {
                Double d = list2.get(n2).get(list.get(n3)) * (list4.get(n2) - list3.get(n2)) + list3.get(n2);
                linkedHashMap.put(list.get(n3), d);
                ++n3;
            }
            arrayList.add(linkedHashMap);
            ++n2;
        }
        return arrayList;
    }

    private static List<Map<String, Double>> transformMapListToListMap(Map<String, List<Double>> map, List<String> list) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n = 0;
        while (n < map.get(list.get(0)).size()) {
            LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
            int n2 = 0;
            while (n2 < list.size()) {
                linkedHashMap.put(list.get(n2), map.get(list.get(n2)).get(n));
                ++n2;
            }
            arrayList.add(linkedHashMap);
            ++n;
        }
        return arrayList;
    }

    private static Map<String, List<Double>> transformListMapToMapList(List<Map<String, Double>> list, List<String> list2) {
        HashMap<String, List<Double>> hashMap = new HashMap<String, List<Double>>();
        int n = 0;
        while (n < list2.size()) {
            ArrayList arrayList = new ArrayList();
            int n2 = n;
            list.forEach(map -> arrayList.add((Double)map.get(list2.get(n2))));
            hashMap.put(list2.get(n), arrayList);
            ++n;
        }
        return hashMap;
    }

    private static List<Map<String, Double>> shuffle(List<Map<String, Double>> list, int n, List<String> list2) {
        Map<String, List<Double>> map = OrthogonalSampling.transformListMapToMapList(list, list2);
        LinkedHashMap<String, List<Double>> linkedHashMap = new LinkedHashMap<String, List<Double>>();
        int n2 = 0;
        while (n2 < map.size()) {
            List<Double> list3 = map.get(list2.get(n2));
            Collections.shuffle(list3);
            linkedHashMap.put(list2.get(n2), list3);
            ++n2;
        }
        List<Map<String, Double>> list4 = OrthogonalSampling.transformMapListToListMap(linkedHashMap, list2);
        return list4;
    }

    private static List<Double> computeSpatialDistance(List<Map<String, Double>> list, List<String> list2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < list.size()) {
            Map<String, Double> map = list.get(n);
            int n2 = n + 1;
            while (n2 < list.size()) {
                Map<String, Double> map2 = list.get(n2);
                double d = 0.0;
                int n3 = 0;
                while (n3 < map.size()) {
                    d += Math.pow(map.get(list2.get(n3)) - map2.get(list2.get(n3)), 2.0);
                    ++n3;
                }
                d = Math.sqrt(d);
                arrayList.add(d);
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private static Double findMin(List<Double> list) {
        AtomicReference<Double> atomicReference = new AtomicReference<Double>((Double)Double.MAX_VALUE);
        list.forEach(d -> {
            if (d < (Double)atomicReference.get()) {
                atomicReference.set((Double)d);
            }
        });
        return atomicReference.get();
    }

    private static List<Map<String, Double>> generate(int n, int n2, int n3, List<String> list, Random random) {
        double d = 0.0;
        List<Map<String, Double>> list2 = new ArrayList<Map<String, Double>>();
        int n4 = 0;
        while (n4 < n3) {
            List<Double> list3;
            List<Double> list4;
            List<Double> list5 = OrthogonalSampling.buildCut(n2);
            List<Map<String, Double>> list6 = OrthogonalSampling.buildU(n2, n, list, random);
            List<Map<String, Double>> list7 = OrthogonalSampling.changeValueSample(n2, list, list6, list4 = OrthogonalSampling.buildA(n2, list5), list3 = OrthogonalSampling.buildB(n2, list5));
            List<Map<String, Double>> list8 = OrthogonalSampling.shuffle(list7, n2, list);
            List<Double> list9 = OrthogonalSampling.computeSpatialDistance(list8, list);
            double d2 = OrthogonalSampling.findMin(list9);
            if (d < d2) {
                d = d2;
                list2 = list8;
            }
            ++n4;
        }
        return list2;
    }

    public static List<ParametersSet> orthogonalSamples(int n, int n2, List<IParameter.Batch> list, Random random, IScope iScope) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        while (n3 < list.size()) {
            arrayList.add(list.get(n3).getName());
            ++n3;
        }
        List<Map<String, Double>> list2 = OrthogonalSampling.generate(arrayList.size(), n, n2, arrayList, random);
        return OrthogonalSampling.buildParametersSetfromSample(iScope, list, list2);
    }
}

