/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.model;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.model.IModel;
import gama.core.outputs.AbstractOutputManager;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.species.GamlSpecies;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.test.TestStatement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="version", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="The version of this model")}), @GamlAnnotations.facet(name="author", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="The author of the model")}), @GamlAnnotations.facet(name="pragma", type={10}, index=4, of=5, optional=true, internal=true, doc={@GamlAnnotations.doc(value="For internal use only")}), @GamlAnnotations.facet(name="torus", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether the model will be based on a toroidal environment or not")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="The name of the model")}), @GamlAnnotations.facet(name="parent", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="Whether this model inherits from another one or not (must be in the same project and folder)")}), @GamlAnnotations.facet(name="skills", type={5}, optional=true, doc={@GamlAnnotations.doc(value="The list of skills attached to this model")}), @GamlAnnotations.facet(name="control", type={22}, optional=true, doc={@GamlAnnotations.doc(value="The control architecture attached to this model")}), @GamlAnnotations.facet(name="frequency", type={1}, optional=true, doc={@GamlAnnotations.doc(value="Specifies how often the model (e.g. every x cycles) will be asked to execute")}), @GamlAnnotations.facet(name="schedules", type={16}, of=11, doc={@GamlAnnotations.doc(value="A container of agents (a species, a dynamic list, or a combination of species and containers) , which represents which agents will be actually scheduled when the population is scheduled for execution. For instance, 'species a schedules: (10 among a)' will result in a population that schedules only 10 of its own agents every cycle. 'species b schedules: []' will prevent the agents of 'b' to be scheduled. Note that the scope of agents covered here can be larger than the population, which allows to build complex scheduling controls; for instance, defining 'global schedules: [] {...} species b schedules: []; species c schedules: b + world; ' allows to simulate a model where the agents of b are scheduled first, followed by the world, without even having to create an instance of c.")}, optional=true), @GamlAnnotations.facet(name="topology", type={18}, optional=true, doc={@GamlAnnotations.doc(value="The topology of this model. Can be used to specify boundaries (although it is preferred to set the shape attribute).")})}, omissible="name")
@GamlAnnotations.doc(value="A model is a species that is used to specify the 'world' of all the agents in the model. The corresponding population is hosted by experiments and accessible by the keyword 'simulations' (or 'simulation' to get the most recently created one)")
public class GamlModelSpecies
extends GamlSpecies
implements IModel {
    protected final Map<String, IExperimentPlan> experiments = GamaMapFactory.create();
    protected final Map<String, IExperimentPlan> titledExperiments = GamaMapFactory.create();
    protected Map<String, ISpecies> allSpecies;
    static Predicate<IStatement> isTest = iStatement -> iStatement instanceof TestStatement;

    public GamlModelSpecies(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
    }

    @Override
    public ModelDescription getDescription() {
        return (ModelDescription)this.description;
    }

    @Override
    public Collection<String> getImportedPaths() {
        return this.getDescription().getAlternatePaths();
    }

    @Override
    public String getWorkingPath() {
        return this.getDescription().getModelFolderPath();
    }

    @Override
    public String getFilePath() {
        return this.getDescription().getModelFilePath();
    }

    @Override
    public String getProjectPath() {
        return this.getDescription().getModelProjectPath();
    }

    protected void addExperiment(IExperimentPlan iExperimentPlan) {
        if (iExperimentPlan == null) {
            return;
        }
        this.experiments.put(iExperimentPlan.getName(), iExperimentPlan);
        this.titledExperiments.put(iExperimentPlan.getFacet("title").literalValue(), iExperimentPlan);
        iExperimentPlan.setModel(this);
    }

    @Override
    public IExperimentPlan getExperiment(String string) {
        IExperimentPlan iExperimentPlan = this.experiments.get(string);
        if (iExperimentPlan == null && (iExperimentPlan = this.titledExperiments.get(string)) == null && StringUtils.isNumeric((CharSequence)string)) {
            int n = Integer.parseInt(string);
            ArrayList<String> arrayList = new ArrayList<String>(this.experiments.keySet());
            if (arrayList.size() > 0) {
                iExperimentPlan = this.getExperiment((String)arrayList.get(n));
            }
        }
        return iExperimentPlan;
    }

    @Override
    public Iterable<IExperimentPlan> getExperiments() {
        return this.experiments.values();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IExperimentPlan iExperimentPlan : this.experiments.values()) {
            iExperimentPlan.dispose();
        }
        this.experiments.clear();
        this.titledExperiments.clear();
        if (this.allSpecies != null) {
            this.allSpecies.clear();
        }
    }

    @Override
    public ISpecies getSpecies(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getName())) {
            return this;
        }
        if ("model".equals(string)) {
            return GamaMetaModel.INSTANCE.getAbstractModelSpecies();
        }
        if ("agent".equals(string)) {
            return GamaMetaModel.INSTANCE.getAbstractAgentSpecies();
        }
        ISpecies iSpecies = this.getAllSpecies().get(string);
        if (iSpecies == null && (iSpecies = this.getExperiment(string)) == null) {
            for (Map.Entry<String, ISpecies> entry : this.getAllSpecies().entrySet()) {
                ISpecies iSpecies2 = entry.getValue();
                if (!(iSpecies2 instanceof GamlModelSpecies) || (iSpecies = ((GamlModelSpecies)iSpecies2).getExperiment(string)) == null) continue;
                return iSpecies;
            }
        }
        return iSpecies;
    }

    @Override
    public ISpecies getSpecies(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getName())) {
            return this;
        }
        IExperimentPlan iExperimentPlan = this.getExperiment(string);
        if (iExperimentPlan == null) {
            for (Map.Entry<String, ISpecies> entry : this.getAllSpecies().entrySet()) {
                ISpecies iSpecies = entry.getValue();
                if (!(iSpecies instanceof GamlModelSpecies) || !string2.equals(iSpecies.getName()) || (iExperimentPlan = ((GamlModelSpecies)iSpecies).getExperiment(string)) == null) continue;
                return iExperimentPlan;
            }
        }
        return this.getSpecies(string);
    }

    @Override
    public Map<String, ISpecies> getAllSpecies() {
        if (this.allSpecies == null) {
            this.allSpecies = GamaMapFactory.create();
            ArrayDeque<ISpecies> arrayDeque = new ArrayDeque<ISpecies>();
            arrayDeque.push(this);
            while (!arrayDeque.isEmpty()) {
                ISpecies iSpecies = (ISpecies)arrayDeque.pop();
                this.allSpecies.put(iSpecies.getName(), iSpecies);
                IList<ISpecies> iList = iSpecies.getMicroSpecies();
                for (ISpecies iSpecies2 : iList) {
                    if (!iSpecies2.getMacroSpecies().equals(iSpecies)) continue;
                    arrayDeque.push(iSpecies2);
                }
            }
        }
        return this.allSpecies;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<IExperimentPlan> arrayList2 = new ArrayList<IExperimentPlan>();
        Iterator<? extends ISymbol> object2 = iterable.iterator();
        while (object2.hasNext()) {
            ISymbol iSymbol = object2.next();
            if (iSymbol instanceof IExperimentPlan) {
                arrayList2.add((IExperimentPlan)iSymbol);
                object2.remove();
                continue;
            }
            if (!(iSymbol instanceof AbstractOutputManager)) continue;
            arrayList.add(iSymbol);
            object2.remove();
        }
        super.setChildren(iterable);
        for (IExperimentPlan iExperimentPlan : arrayList2) {
            this.addExperiment(iExperimentPlan);
            iExperimentPlan.setChildren(arrayList);
        }
    }

    @Override
    public List<TestStatement> getAllTests() {
        ArrayList<TestStatement> arrayList = new ArrayList<TestStatement>();
        Consumer<IStatement> consumer = iStatement -> {
            if (iStatement instanceof TestStatement) {
                arrayList.add((TestStatement)iStatement);
            }
        };
        this.getAllSpecies().values().forEach(iSpecies -> iSpecies.getBehaviors().forEach(consumer));
        return arrayList;
    }
}

