/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.MinimalAgent;
import gama.core.metamodel.agent.SerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.MetaPopulation;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.species.ISpecies;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GamlAgent
extends MinimalAgent
implements IMacroAgent {
    protected IMap<String, IPopulation<? extends IAgent>> externMicroPopulations;
    protected IPopulation<? extends IAgent>[] microPopulations;
    static final IPopulation<? extends IAgent>[] NO_POP = new IPopulation[0];

    public GamlAgent(IPopulation<? extends IAgent> iPopulation, int n) {
        super(iPopulation, n);
    }

    public GamlAgent(IPopulation<? extends IAgent> iPopulation, int n, IShape iShape) {
        super(iPopulation, n, iShape);
    }

    private Boolean isPopulation(String string) {
        IVariable iVariable = this.getSpecies().getVar(string);
        if (iVariable == null) {
            return false;
        }
        return iVariable.isMicroPopulation();
    }

    @Override
    public IPopulation<? extends IAgent>[] getMicroPopulations() {
        if (this.microPopulations == null) {
            ArrayList arrayList = new ArrayList();
            this.forEachAttribute((string, object) -> {
                if (this.isPopulation((String)string).booleanValue()) {
                    arrayList.add((IPopulation)object);
                }
                return true;
            });
            this.microPopulations = arrayList.toArray(new IPopulation[arrayList.size()]);
            if (this.microPopulations.length == 0) {
                this.microPopulations = NO_POP;
            } else {
                Arrays.sort(this.microPopulations, (iPopulation, iPopulation2) -> iPopulation.isGrid() ? (iPopulation2.isGrid() ? 0 : 1) : (iPopulation2.isGrid() ? -1 : 0));
            }
        }
        return this.microPopulations;
    }

    @Override
    protected boolean initSubPopulations(IScope iScope) {
        IPopulation<? extends IAgent>[] iPopulationArray = this.getMicroPopulations();
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPopulation<? extends IAgent> iPopulation = iPopulationArray[n2];
            if (!iScope.init(iPopulation).passed()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected boolean stepSubPopulations(IScope iScope) {
        IPopulation<? extends IAgent>[] iPopulationArray = this.getMicroPopulations();
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPopulation<? extends IAgent> iPopulation = iPopulationArray[n2];
            if (!iScope.step(iPopulation).passed()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     * Loose catch block
     */
    @Override
    public IList<IAgent> captureMicroAgents(IScope iScope, ISpecies iSpecies, IList<IAgent> iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty() || iSpecies == null || !this.getSpecies().getMicroSpecies().contains(iSpecies)) {
            return GamaListFactory.EMPTY_LIST;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Collection collection;
            Collector.AsList asList;
            Collector.AsList asList2;
            block19: {
                block18: {
                    IContainer.Addressable addressable2;
                    asList2 = Collector.getList();
                    asList = Collector.getList();
                    for (IContainer.Addressable addressable2 : iList.iterable(iScope)) {
                        if (!this.canCapture((IAgent)addressable2, iSpecies)) continue;
                        asList2.add(addressable2);
                    }
                    addressable2 = this.getPopulationFor(iSpecies);
                    for (Object object : asList2) {
                        SerialisedAgent serialisedAgent = SerialisedAgent.of((IAgent)object, true);
                        object.dispose();
                        asList.add(serialisedAgent.restoreInto(iScope, (IPopulation<? extends IAgent>)addressable2));
                    }
                    collection = asList.items();
                    if (asList == null) break block18;
                    asList.close();
                }
                if (asList2 == null) break block19;
                asList2.close();
            }
            return collection;
            {
                catch (Throwable throwable2) {
                    try {
                        if (asList != null) {
                            asList.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (asList2 != null) {
                            asList2.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public IAgent captureMicroAgent(IScope iScope, ISpecies iSpecies, IAgent iAgent) throws GamaRuntimeException {
        if (this.canCapture(iAgent, iSpecies)) {
            IPopulation<? extends IAgent> iPopulation = this.getMicroPopulation(iSpecies);
            SerialisedAgent serialisedAgent = SerialisedAgent.of(iAgent, true);
            iAgent.dispose();
            return serialisedAgent.restoreInto(iScope, iPopulation);
        }
        return null;
    }

    @Override
    public IList<IAgent> releaseMicroAgents(IScope iScope, IList<IAgent> iList) throws GamaRuntimeException {
        IList<IAgent> iList2 = GamaListFactory.create(Types.AGENT);
        for (IAgent iAgent : iList.iterable(iScope)) {
            SerialisedAgent serialisedAgent = SerialisedAgent.of(iAgent, true);
            IPopulation<? extends IAgent> iPopulation = iAgent.getPopulationFor(iAgent.getSpecies().getParentSpecies());
            iAgent.dispose();
            iList2.add(serialisedAgent.restoreInto(iScope, iPopulation));
        }
        return iList2;
    }

    @Override
    public IList<IAgent> migrateMicroAgents(IScope iScope, IList<IAgent> iList, ISpecies iSpecies) {
        IList<IAgent> iList2 = GamaListFactory.create(Types.AGENT);
        for (IAgent addressable2 : iList.iterable(iScope)) {
            if (!addressable2.getSpecies().isPeer(iSpecies)) continue;
            iList2.add(addressable2);
        }
        IList<IAgent> iList3 = GamaListFactory.create(Types.AGENT);
        if (!iList2.isEmpty()) {
            IPopulation<? extends IAgent> iPopulation = this.getPopulationFor(iSpecies);
            for (IAgent iAgent : iList2) {
                SerialisedAgent serialisedAgent = SerialisedAgent.of(iAgent, true);
                iAgent.dispose();
                iList3.add(serialisedAgent.restoreInto(iScope, iPopulation));
            }
        }
        return iList3;
    }

    @Override
    public IList<IAgent> migrateMicroAgents(IScope iScope, ISpecies iSpecies, ISpecies iSpecies2) {
        IPopulation<? extends IAgent> iPopulation = this.getPopulationFor(iSpecies);
        IPopulation<? extends IAgent> iPopulation2 = this.getPopulationFor(iSpecies2);
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        while (!iPopulation.isEmpty()) {
            IAgent iAgent = (IAgent)iPopulation.get(0);
            SerialisedAgent serialisedAgent = SerialisedAgent.of(iAgent, true);
            iAgent.dispose();
            iList.add(serialisedAgent.restoreInto(iScope, iPopulation2));
        }
        return iList;
    }

    @Override
    public void initializeMicroPopulation(IScope iScope, String string) {
        ISpecies iSpecies = this.getModel().getSpecies(string);
        IPopulation iPopulation = iScope.getPopulationFactory().createPopulation(iScope, this, iSpecies);
        this.registerMicropopulation(iScope, iSpecies, iPopulation);
    }

    protected void registerMicropopulation(IScope iScope, ISpecies iSpecies, IPopulation<? extends IAgent> iPopulation) {
        this.setAttribute(iSpecies.getName(), iPopulation);
        iPopulation.initializeFor(iScope);
    }

    @Override
    public void dispose() {
        IPopulation<? extends IAgent> iPopulation;
        IPopulation<? extends IAgent>[] iPopulationArray;
        if (this.dead) {
            return;
        }
        IPopulation<? extends IAgent>[] iPopulationArray2 = iPopulationArray = this.getMicroPopulations();
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            iPopulation = iPopulationArray2[n2];
            iPopulation.dispose();
            ++n2;
        }
        iPopulation = this.getAttribute("attached_graph");
        if (iPopulation instanceof GamaGraph) {
            ((GamaGraph)((Object)iPopulation)).disposeVertex(this);
        }
        super.dispose();
    }

    @Override
    public synchronized IPopulation<? extends IAgent> getMicroPopulation(String string) {
        Object object = this.getAttribute(string);
        if (object instanceof IPopulation) {
            return (IPopulation)object;
        }
        return null;
    }

    @Override
    public IPopulation<? extends IAgent> getMicroPopulation(ISpecies iSpecies) {
        Object object = this.getAttribute(iSpecies.getName());
        return object instanceof IPopulation ? (IPopulation)object : null;
    }

    @Override
    public boolean hasMembers() {
        if (this.dead()) {
            return false;
        }
        IPopulation<? extends IAgent>[] iPopulationArray = this.getMicroPopulations();
        int n = iPopulationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPopulation<? extends IAgent> iPopulation = iPopulationArray[n2];
            if (iPopulation.size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IContainer<?, IAgent> getMembers(IScope iScope) {
        if (this.dead()) {
            return GamaListFactory.EMPTY_LIST;
        }
        return new MetaPopulation(this.getMicroPopulations());
    }

    @Override
    public void setMembers(IList<IAgent> iList) {
    }

    @Override
    public int getMembersSize(IScope iScope) {
        return this.getMembers(iScope).length(iScope);
    }

    @Override
    public void setAgents(IList<IAgent> iList) {
    }

    @Override
    public IList<IAgent> getAgents(IScope iScope) {
        if (!this.hasMembers()) {
            return GamaListFactory.EMPTY_LIST;
        }
        IContainer<?, IAgent> iContainer = this.getMembers(iScope);
        IList<IAgent> iList = GamaListFactory.create(Types.AGENT);
        iList.addAll(iContainer.listValue(iScope, Types.NO_TYPE, false));
        for (IAgent iAgent : iContainer.iterable(iScope)) {
            if (!(iAgent instanceof IMacroAgent)) continue;
            iList.addAll(((IMacroAgent)iAgent).getAgents(iScope));
        }
        return iList;
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(ISpecies iSpecies) {
        ModelDescription modelDescription = iSpecies.getDescription().getModelDescription();
        ModelDescription modelDescription2 = this.getModel().getDescription();
        IPopulation<? extends IAgent> iPopulation = null;
        if (modelDescription2.getMicroModel(modelDescription.getAlias()) == null) {
            iPopulation = this.getMicroPopulation(iSpecies);
            if (iPopulation == null && this.getHost() != null) {
                iPopulation = this.getHost().getPopulationFor(iSpecies);
            }
        } else {
            iPopulation = this.getSimulation().getExternMicroPopulationFor(modelDescription.getAlias() + "." + iSpecies.getName());
        }
        return iPopulation;
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(String string) {
        IPopulation<? extends IAgent> iPopulation = this.getMicroPopulation(string);
        if (iPopulation == null && this.getHost() != null) {
            return this.getHost().getPopulationFor(string);
        }
        return iPopulation;
    }

    @Override
    public boolean canCapture(IAgent iAgent, ISpecies iSpecies) {
        if (iAgent == null || iAgent.dead() || iSpecies == null || !this.getSpecies().containMicroSpecies(iSpecies)) {
            return false;
        }
        if (this.getMacroAgents().contains(iAgent)) {
            return false;
        }
        return !this.equals(iAgent.getHost());
    }

    @Override
    public void addExternMicroPopulation(String string, IPopulation<? extends IAgent> iPopulation) {
        if (this.externMicroPopulations == null) {
            this.externMicroPopulations = GamaMapFactory.create(Types.STRING, Types.LIST.of(Types.AGENT));
        }
        this.externMicroPopulations.put(string, iPopulation);
    }

    @Override
    public IPopulation<? extends IAgent> getExternMicroPopulationFor(String string) {
        if (this.externMicroPopulations != null) {
            return (IPopulation)this.externMicroPopulations.get(string);
        }
        return null;
    }
}

