/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.shape;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public abstract class GamaProxyGeometry
implements IShape,
Cloneable {
    GamaPoint absoluteLocation;

    public GamaProxyGeometry(GamaPoint gamaPoint) {
        this.setLocation(gamaPoint);
    }

    public IType getGamlType() {
        return Types.GEOMETRY;
    }

    @Override
    public GamaPoint setLocation(GamaPoint gamaPoint) {
        this.absoluteLocation = gamaPoint;
        return gamaPoint;
    }

    @Override
    public GamaPoint getLocation() {
        return this.absoluteLocation;
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return SHAPE_WRITER.write(this.getInnerGeometry());
    }

    protected abstract IShape getReferenceGeometry();

    @Override
    public IShape copy(IScope iScope) throws GamaRuntimeException {
        return GamaShapeFactory.createFrom(this);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getReferenceGeometry().serializeToGaml(bl) + " at_location " + this.absoluteLocation.serializeToGaml(bl);
    }

    public IMap<String, Object> getAttributes(boolean bl) {
        return null;
    }

    @Override
    public IAgent getAgent() {
        return null;
    }

    @Override
    public void setAgent(IAgent iAgent) {
    }

    @Override
    public IShape getGeometry() {
        return this;
    }

    @Override
    public void setGeometry(IShape iShape) {
    }

    @Override
    public boolean isPoint() {
        return this.getReferenceGeometry().isPoint();
    }

    @Override
    public boolean isLine() {
        return this.getReferenceGeometry().isLine();
    }

    @Override
    public Geometry getInnerGeometry() {
        Geometry geometry = this.getReferenceGeometry().getInnerGeometry().copy();
        GeometryUtils.translate(geometry, this.getReferenceGeometry().getLocation(), this.getLocation());
        return geometry;
    }

    @Override
    public Envelope3D getEnvelope() {
        Envelope3D envelope3D = this.getReferenceGeometry().getEnvelope();
        GamaPoint gamaPoint = this.getLocation();
        GamaPoint gamaPoint2 = this.getReferenceGeometry().getLocation();
        double d = gamaPoint.getX() - gamaPoint2.getX();
        double d2 = gamaPoint.getY() - gamaPoint2.getY();
        double d3 = gamaPoint.getZ() - gamaPoint2.getZ();
        envelope3D.translate(d, d2, d3);
        return envelope3D;
    }

    @Override
    public boolean covers(IShape iShape) {
        return this.getInnerGeometry().covers(iShape.getInnerGeometry());
    }

    @Override
    public boolean crosses(IShape iShape) {
        return this.getInnerGeometry().crosses(iShape.getInnerGeometry());
    }

    @Override
    public double euclidianDistanceTo(IShape iShape) {
        if (this.isPoint() && iShape.isPoint()) {
            return iShape.getLocation().euclidianDistanceTo(this.getLocation());
        }
        return this.getInnerGeometry().distance(iShape.getInnerGeometry());
    }

    @Override
    public double euclidianDistanceTo(GamaPoint gamaPoint) {
        if (this.isPoint()) {
            return gamaPoint.euclidianDistanceTo(this.getLocation());
        }
        return this.getInnerGeometry().distance(gamaPoint.getInnerGeometry());
    }

    @Override
    public boolean intersects(IShape iShape) {
        return this.getInnerGeometry().intersects(iShape.getInnerGeometry());
    }

    @Override
    public boolean touches(IShape iShape) {
        return this.getInnerGeometry().touches(iShape.getInnerGeometry());
    }

    @Override
    public boolean partiallyOverlaps(IShape iShape) {
        return this.getInnerGeometry().overlaps(iShape.getInnerGeometry());
    }

    @Override
    public double getPerimeter() {
        return this.getReferenceGeometry().getPerimeter();
    }

    @Override
    public void setInnerGeometry(Geometry geometry) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public IShape.Type getGeometricalType() {
        return this.getReferenceGeometry().getGeometricalType();
    }

    @Override
    public IList<GamaPoint> getPoints() {
        Coordinate[] coordinateArray;
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        Coordinate[] coordinateArray2 = coordinateArray = this.getInnerGeometry().getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray2[n2];
            iList.add(new GamaPoint(coordinate));
            ++n2;
        }
        return iList;
    }

    @Override
    public void setDepth(double d) {
    }

    @Override
    public Double getArea() {
        return this.getReferenceGeometry().getArea();
    }

    @Override
    public Double getVolume() {
        return this.getReferenceGeometry().getVolume();
    }

    @Override
    public IList<GamaShape> getHoles() {
        IList<GamaShape> iList = GamaListFactory.create(Types.GEOMETRY);
        Geometry geometry = this.getInnerGeometry();
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            int n = polygon.getNumInteriorRing();
            int n2 = 0;
            while (n2 < n) {
                iList.add(GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPolygon(polygon.getInteriorRingN(n2).getCoordinates())));
                ++n2;
            }
        }
        return iList;
    }

    @Override
    public GamaPoint getCentroid() {
        return this.absoluteLocation;
    }

    @Override
    public GamaShape getExteriorRing(IScope iScope) {
        return this.getReferenceGeometry().getExteriorRing(iScope).translatedTo(iScope, this.absoluteLocation);
    }

    @Override
    public Double getWidth() {
        return this.getReferenceGeometry().getWidth();
    }

    @Override
    public Double getHeight() {
        return this.getReferenceGeometry().getHeight();
    }

    @Override
    public Double getDepth() {
        return this.getReferenceGeometry().getDepth();
    }

    @Override
    public GamaShape getGeometricEnvelope() {
        return GamaShapeFactory.createFrom((Geometry)this.getEnvelope().toGeometry());
    }
}

