/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.collect.Iterators;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class GamaListArrayWrapper<E>
extends AbstractList<E>
implements IList<E>,
RandomAccess {
    private final E[] a;
    private final IContainerType type;

    GamaListArrayWrapper(E[] EArray, IType iType) {
        this.a = Objects.requireNonNull(EArray);
        this.type = Types.LIST.of(iType);
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.a.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IList)) {
            return false;
        }
        return GamaListFactory.equals(this, (IList)object);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(this.a, n, TArray.getClass());
        }
        System.arraycopy(this.a, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public E get(int n) {
        return this.a[n];
    }

    @Override
    public E set(int n, E e) {
        E e2 = this.a[n];
        this.a[n] = e;
        return e2;
    }

    @Override
    public int indexOf(Object object) {
        E[] EArray = this.a;
        if (object == null) {
            int n = 0;
            while (n < EArray.length) {
                if (EArray[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < EArray.length) {
                if (object.equals(EArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.a, 16);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        E[] EArray = this.a;
        int n = this.a.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            consumer.accept(e);
            ++n2;
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        E[] EArray = this.a;
        int n = 0;
        while (n < EArray.length) {
            EArray[n] = unaryOperator.apply(EArray[n]);
            ++n;
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        Arrays.sort(this.a, comparator);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return this.type;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.forArray((Object[])this.a);
    }
}

