/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGisFile;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.statements.Facets;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gce.arcgrid.ArcGridReader;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;

@GamlAnnotations.file(name="grid", extensions={"asc", "tif"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"grid", "asc", "tif", "file"}, doc={@GamlAnnotations.doc(value="Represents .asc or .tif files that contain grid descriptions")})
public class GamaGridFile
extends GamaGisFile
implements IFieldMatrixProvider {
    transient GridCoverage2D coverage;
    GamaFloatMatrix ascData;
    Double[] ascInfo;
    public int nbBands;
    public int numRows;
    public int numCols;
    IShape geom;
    Number noData = Double.MAX_VALUE;
    GeneralEnvelope genv;
    Records records;

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\");", isExecutable=false)})
    public GamaGridFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file, but without converting it into shapes. Only a matrix of float values is created", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\", false);", isExecutable=false)})
    public GamaGridFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file specifying the coordinates system code, as an int (epsg code)", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\", 32648);", isExecutable=false)})
    public GamaGridFile(IScope iScope, String string, Integer n) throws GamaRuntimeException {
        super(iScope, string, n);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file specifying the coordinates system code (epg,...,), as a string ", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\",\"EPSG:32648\");", isExecutable=false)})
    public GamaGridFile(IScope iScope, String string, String string2) {
        super(iScope, string, string2);
    }

    @GamlAnnotations.doc(value="This allows to build a writable grid file from the values of a field", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.tif\",my_field); save f;", isExecutable=false)})
    public GamaGridFile(IScope iScope, String string, GamaField gamaField) {
        super(iScope, string, false);
        this.setWritable(iScope, true);
        this.createCoverage(iScope, gamaField);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    private void createCoverage(IScope iScope) {
        if (this.coverage == null) {
            File file2 = this.getFile(iScope);
            file2.setReadable(true);
            InputStream inputStream = null;
            try {
                inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
            try {
                this.privateCreateCoverage(iScope, inputStream);
            }
            catch (Exception exception) {
                String string = this.getName(iScope);
                if (this.isTiff(iScope)) {
                    throw GamaRuntimeException.error("The format of " + string + " seems incorrect: " + exception.getMessage(), iScope);
                }
                this.customAscReader(iScope);
            }
        }
    }

    private Double doubleVal(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length == 1) {
            stringArray = string.split("t");
        }
        if (stringArray.length > 1) {
            return Double.valueOf(stringArray[stringArray.length - 1]);
        }
        return null;
    }

    private Integer intVal(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length == 1) {
            stringArray = string.split("t");
        }
        if (stringArray.length > 1) {
            return Integer.valueOf(stringArray[stringArray.length - 1]);
        }
        return null;
    }

    private void customAscReader(IScope iScope) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Scanner scanner = new Scanner(this.getFile(iScope));){
                boolean bl = false;
                Integer n = null;
                Integer n2 = null;
                Double d = null;
                Double d2 = null;
                Double d3 = null;
                Double d4 = null;
                Double d5 = null;
                Double d6 = null;
                Double d7 = null;
                this.ascInfo = new Double[4];
                int n3 = 0;
                while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    string = string.toLowerCase();
                    if (!bl) {
                        if (d5 == null && string.contains("dx")) {
                            this.ascInfo[0] = d5 = this.doubleVal(string);
                        } else if (d6 == null && string.contains("dy")) {
                            this.ascInfo[1] = d6 = this.doubleVal(string);
                        } else if (n == null && string.contains("ncols")) {
                            n = this.intVal(string);
                        } else if (n2 == null && string.contains("nrows")) {
                            n2 = this.intVal(string);
                        } else if (d7 == null && (string.contains("nodata") || string.contains("nodata_value"))) {
                            d7 = this.doubleVal(string);
                        } else if (d == null && d3 == null && string.contains("xllcorner")) {
                            this.ascInfo[2] = d = this.doubleVal(string);
                        } else if (d2 == null && d4 == null && string.contains("yllcorner")) {
                            d2 = this.doubleVal(string);
                        } else if (d == null && d3 == null && string.contains("xllcorner")) {
                            d3 = this.doubleVal(string);
                        } else if (d2 == null && d4 == null && string.contains("yllcorner")) {
                            d4 = this.doubleVal(string);
                        } else if (string.replace(" ", "").length() > 0) {
                            if (n == null || n == 0 || n2 == null || n2 == 0) {
                                throw GamaRuntimeException.error("The format of " + this.getName(iScope) + " is not correct. Error: NCOLS and NROWS have to be defined", iScope);
                            }
                            if (d3 != null && d5 != null) {
                                this.ascInfo[2] = d = Double.valueOf(d3 - (double)n.intValue() * d5 / 2.0);
                            }
                            if (d4 != null && d6 != null) {
                                d2 = d4 - (double)n2.intValue() * d6 / 2.0;
                            }
                            if (d2 != null && d6 != null) {
                                this.ascInfo[3] = d2 + (double)n2.intValue() * d6;
                            }
                            this.ascData = new GamaFloatMatrix(n, n2);
                            if (this.noData != null) {
                                this.noData = d7;
                            }
                            double d8 = d == null ? 0.0 : d;
                            double d9 = d2 == null ? 0.0 : d2;
                            Envelope3D envelope3D = Envelope3D.of(d8, d9, d8 + (double)n.intValue() * (d5 == null ? 0.0 : d5), this.ascInfo[3], 0.0, 0.0);
                            this.computeProjection(iScope, envelope3D);
                            this.numRows = n2;
                            this.numCols = n;
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    String[] stringArray = string.split(" ");
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        this.ascData.set(iScope, n4, n3, Double.valueOf(stringArray[n4]));
                        ++n4;
                    }
                    ++n3;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw GamaRuntimeException.error("The format of " + this.getName(iScope) + " is not correct. Error: " + fileNotFoundException.getMessage(), iScope);
        }
    }

    private void createCoverage(IScope iScope, GamaField gamaField) {
        boolean bl = iScope.getSimulation().getProjectionFactory().getWorld() == null;
        int n = gamaField.numCols;
        int n2 = gamaField.numRows;
        double d = bl ? 0.0 : iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinX();
        double d2 = bl ? 0.0 : iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getMinY();
        float[][] fArray = new float[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                fArray[n3][n4] = gamaField.get(iScope, n4, n3).floatValue();
                ++n4;
            }
            ++n3;
        }
        double d3 = iScope.getSimulation().getEnvelope().getWidth();
        double d4 = iScope.getSimulation().getEnvelope().getHeight();
        Envelope2D envelope2D = new Envelope2D(ProjectionFactory.getTargetCRSOrDefault(iScope), d, d2, d3, d4);
        this.coverage = new GridCoverageFactory().create((CharSequence)"data", fArray, (Envelope)envelope2D);
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
        if (!this.writable || this.coverage == null) {
            return;
        }
        try {
            ArcGridWriter arcGridWriter;
            File file2 = this.getFile(iScope);
            file2.setWritable(true);
            if (this.isTiff(iScope)) {
                GeoTiffFormat geoTiffFormat = new GeoTiffFormat();
                arcGridWriter = geoTiffFormat.getWriter((Object)file2);
            } else {
                arcGridWriter = new ArcGridWriter((Object)file2);
            }
            arcGridWriter.write((GridCoverage)this.coverage, null);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    private void privateCreateCoverage(IScope iScope, InputStream inputStream) throws DataSourceException, IOException {
        ArcGridReader arcGridReader = null;
        try {
            CoordinateReferenceSystem coordinateReferenceSystem = this.getExistingCRS(iScope);
            if (this.isTiff(iScope)) {
                arcGridReader = coordinateReferenceSystem == null ? new GeoTiffReader((Object)this.getFile(iScope)) : new GeoTiffReader((Object)this.getFile(iScope), new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)coordinateReferenceSystem));
                this.noData = ((GeoTiffReader)arcGridReader).getMetadata().getNoData();
            } else {
                arcGridReader = coordinateReferenceSystem == null ? new ArcGridReader((Object)inputStream) : new ArcGridReader((Object)inputStream, new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)coordinateReferenceSystem));
            }
            this.genv = arcGridReader.getOriginalEnvelope();
            Envelope3D envelope3D = Envelope3D.of(this.genv.getMinimum(0), this.genv.getMaximum(0), this.genv.getMinimum(1), this.genv.getMaximum(1), 0.0, 0.0);
            this.computeProjection(iScope, envelope3D);
            this.numRows = arcGridReader.getOriginalGridRange().getHigh(1) + 1;
            this.numCols = arcGridReader.getOriginalGridRange().getHigh(0) + 1;
            this.coverage = arcGridReader.read(null);
        }
        finally {
            if (arcGridReader != null) {
                arcGridReader.dispose();
            }
            iScope.getGui().getStatus().endTask("Opening file " + this.getName(iScope), "status/status.download");
        }
    }

    private double[] getValue(IScope iScope, Double d, Double d2, int n, int n2) {
        if (this.coverage != null) {
            return this.coverage.evaluate((DirectPosition)new DirectPosition2D(d.doubleValue(), d2.doubleValue()), null);
        }
        double[] dArray = new double[]{this.ascData.get(iScope, n, n2)};
        return dArray;
    }

    void read(IScope iScope, boolean bl, boolean bl2) {
        try {
            Envelope3D envelope3D;
            String string = "Reading file " + this.getName(iScope);
            iScope.getGui().getStatus().beginTask(string, "status/status.download");
            Envelope3D envelope3D2 = envelope3D = this.gis == null ? iScope.getSimulation().getEnvelope() : this.gis.getProjectedEnvelope();
            if (this.gis != null && !(this.gis.getInitialCRS(iScope) instanceof ProjectedCRS)) {
                GAMA.reportError(iScope, GamaRuntimeException.warning("Try to project a grid -" + this.originalPath + "-  that is not projected. Projection of grids can lead to errors in the cell coordinates. ", iScope), false);
            }
            double d = envelope3D.getHeight() / (double)this.numRows;
            double d2 = envelope3D.getWidth() / (double)this.numCols;
            IList iList = GamaListFactory.create(Types.GEOMETRY);
            double d3 = envelope3D.getMinX();
            double d4 = envelope3D.getMinY();
            double d5 = envelope3D.getMaxY();
            double d6 = envelope3D.getMaxX();
            iList.add(new GamaPoint(d3, d4));
            iList.add(new GamaPoint(d6, d4));
            iList.add(new GamaPoint(d6, d5));
            iList.add(new GamaPoint(d3, d5));
            iList.add((IShape)iList.get(0));
            this.geom = GamaGeometryType.buildPolygon(iList);
            if (!bl) {
                return;
            }
            try {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11 = d2 / 2.0;
                double d12 = d / 2.0;
                if (this.genv != null) {
                    d10 = this.genv.getSpan(1) / (double)this.numRows;
                    d9 = this.genv.getSpan(0) / (double)this.numCols;
                    d8 = this.genv.getMinimum(0);
                    d7 = this.genv.getMaximum(1);
                } else {
                    d10 = this.ascInfo[1];
                    d9 = this.ascInfo[0];
                    d8 = this.ascInfo[2];
                    d7 = this.ascInfo[3];
                }
                double d13 = d9 / 2.0;
                double d14 = d10 / 2.0;
                if (this.records == null) {
                    Object object;
                    this.records = new Records();
                    this.records.x = new double[this.numRows * this.numCols];
                    this.records.y = new double[this.numRows * this.numCols];
                    this.records.bands.add(new double[this.numRows * this.numCols]);
                    int n = 0;
                    int n2 = this.numRows * this.numCols;
                    while (n < n2) {
                        int n3;
                        iScope.getGui().getStatus().setTaskCompletion(string, (double)n / (double)n2);
                        int n4 = n / this.numCols;
                        int n5 = n - n4 * this.numCols;
                        this.records.x[n] = d3 + (double)n5 * d2 + d11;
                        this.records.y[n] = d5 - ((double)n4 * d + d12);
                        object = this.getValue(iScope, d8 + (double)n5 * d9 + d13, d7 - ((double)n4 * d10 + d14), n5, n4);
                        this.nbBands = ((Object)object).length;
                        if (n == 0 && ((Object)object).length > 1) {
                            n3 = 0;
                            while (n3 < ((Object)object).length - 1) {
                                this.records.bands.add(new double[this.numRows * this.numCols]);
                                ++n3;
                            }
                        }
                        n3 = 0;
                        while (n3 < ((Object)object).length) {
                            this.records.bands.get((int)n3)[n] = (double)object[n3];
                            ++n3;
                        }
                        ++n;
                    }
                    if (bl2) {
                        n = 0;
                        n2 = this.numRows * this.numCols;
                        while (n < n2) {
                            this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
                            GamaPoint gamaPoint = new GamaPoint(this.records.x[n], this.records.y[n]);
                            GamaShape gamaShape = (GamaShape)GamaGeometryType.buildRectangle(d2, d, gamaPoint);
                            gamaShape = this.gis == null ? GamaShapeFactory.createFrom(gamaShape.getInnerGeometry()) : GamaShapeFactory.createFrom(this.gis.transform(gamaShape.getInnerGeometry()));
                            object = GamaListFactory.create(iScope, (IType)Types.FLOAT, new Double[0]);
                            this.records.fill(n, (IList<Double>)object);
                            gamaShape.setAttribute("grid_value", object.get(0));
                            gamaShape.setAttribute("bands", object);
                            ((IList)this.getBuffer()).add(gamaShape);
                            ++n;
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw GamaRuntimeException.error("The format of " + this.getName(iScope) + " is not correct. Error: " + exception.getMessage(), iScope);
            }
        }
        finally {
            iScope.getGui().getStatus().endTask("Reading file " + this.getName(iScope), "status/status.download");
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        if (this.gis == null) {
            this.createCoverage(iScope);
        }
        return this.gis.getProjectedEnvelope();
    }

    @Override
    protected void fillBuffer(IScope iScope) {
        if (this.getBuffer() != null) {
            return;
        }
        this.createCoverage(iScope);
        this.read(iScope, true, true);
    }

    public int getNbRows(IScope iScope) {
        this.createCoverage(iScope);
        return this.numRows;
    }

    public boolean isTiff(IScope iScope) {
        return this.getExtension(iScope).startsWith("tif");
    }

    @Override
    public IShape getGeometry(IScope iScope) {
        this.createCoverage(iScope);
        this.read(iScope, false, false);
        return this.geom;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected CoordinateReferenceSystem getOwnCRS(IScope var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void invalidateContents() {
        super.invalidateContents();
        if (this.coverage != null) {
            this.coverage.dispose(true);
        }
        this.coverage = null;
    }

    public Double valueOf(IScope iScope, GamaPoint gamaPoint) {
        return this.valueOf(iScope, gamaPoint.getX(), gamaPoint.getY());
    }

    public Double valueOf(IScope iScope, double d, double d2) {
        if (this.getBuffer() == null) {
            this.fillBuffer(iScope);
        }
        Object object = null;
        try {
            object = this.coverage.evaluate((DirectPosition)new DirectPosition2D(d, d2));
        }
        catch (Exception exception) {
            object = this.noData.doubleValue();
        }
        boolean bl = object instanceof double[];
        boolean bl2 = object instanceof int[];
        boolean bl3 = object instanceof byte[];
        boolean bl4 = object instanceof long[];
        boolean bl5 = object instanceof float[];
        Double d3 = null;
        if (bl) {
            double[] dArray = (double[])object;
            d3 = dArray[0];
        } else if (bl2) {
            int[] nArray = (int[])object;
            d3 = nArray[0];
        } else if (bl4) {
            long[] lArray = (long[])object;
            d3 = lArray[0];
        } else if (bl5) {
            float[] fArray = (float[])object;
            d3 = fArray[0];
        } else if (bl3) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 3) {
                int n = byArray[0] < 0 ? 256 + byArray[0] : byArray[0];
                int n2 = byArray[0] < 0 ? 256 + byArray[1] : byArray[1];
                int n3 = byArray[0] < 0 ? 256 + byArray[2] : byArray[2];
                d3 = (double)(n + n2 + n3) / 3.0;
            } else {
                d3 = ((byte[])object)[0];
            }
        }
        return d3;
    }

    @Override
    public int length(IScope iScope) {
        this.createCoverage(iScope);
        return this.numRows * this.numCols;
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        return null;
    }

    @Override
    public double getNoData(IScope iScope) {
        return this.noData == null ? Double.MAX_VALUE : this.noData.doubleValue();
    }

    @Override
    public int getRows(IScope iScope) {
        this.createCoverage(iScope);
        return this.numRows;
    }

    @Override
    public int getCols(IScope iScope) {
        this.createCoverage(iScope);
        return this.numCols;
    }

    @Override
    public int getBandsNumber(IScope iScope) {
        this.createCoverage(iScope);
        return this.nbBands;
    }

    @Override
    public double[] getBand(IScope iScope, int n) {
        this.createCoverage(iScope);
        this.read(iScope, true, false);
        return Arrays.copyOf(this.records.bands.get(n), this.length(iScope));
    }

    @Override
    protected IMatrix _matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        this.getContents(iScope);
        return new GamaField(iScope, this);
    }

    static class Records {
        double[] x;
        double[] y;
        final List<double[]> bands = new ArrayList<double[]>();

        Records() {
        }

        public void fill(int n, IList<Double> iList) {
            for (double[] dArray : this.bands) {
                iList.add(dArray[n]);
            }
        }
    }
}

