/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.types;

import gama.annotations.precompiler.GamlProperties;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.util.ICollector;
import gama.dev.DEBUG;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;

public class SpeciesConstantExpression
extends ConstantExpression {
    final String origin;
    final String alias;
    final boolean belongsToAMicroModel;

    static {
        DEBUG.ON();
    }

    public SpeciesConstantExpression(String string, IType iType, IDescription iDescription) {
        super(string, iType);
        this.origin = iDescription.getModelDescription().getName();
        this.alias = iDescription.getModelDescription().getAlias();
        this.belongsToAMicroModel = this.alias != null && !this.alias.isEmpty();
    }

    @Override
    public Object _value(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        if (iAgent != null) {
            if (!this.belongsToAMicroModel) {
                IPopulation<? extends IAgent> iPopulation = iAgent.getPopulationFor((String)this.value);
                if (iPopulation != null) {
                    return iPopulation.getSpecies();
                }
                return iScope.getModel().getSpecies((String)this.value);
            }
            IPopulation<? extends IAgent> iPopulation = iScope.getRoot().getExternMicroPopulationFor(this.alias + "." + String.valueOf(this.value));
            if (iPopulation != null) {
                return iPopulation.getSpecies();
            }
            return iScope.getModel().getSpecies((String)this.value, this.origin);
        }
        return null;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return (String)this.value;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc("");
        this.getGamlType().getContentType().getSpecies().documentThis(regularDoc);
        return regularDoc;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        SpeciesDescription speciesDescription = this.getGamlType().getContentType().getSpecies();
        if (speciesDescription != null) {
            gamlProperties.put("plugins", speciesDescription.getDefiningPlugin());
            if (speciesDescription.isBuiltIn()) {
                gamlProperties.put("species", (String)this.value);
            }
        }
    }

    @Override
    public boolean isContextIndependant() {
        return false;
    }

    @Override
    public boolean isAllowedInParameters() {
        return true;
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        if (speciesDescription.hasAttribute(this.value.toString())) {
            iCollector2.add(speciesDescription.getAttribute(this.value.toString()));
        }
    }
}

