/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.AgentLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Set;

public class AgentLayer
extends AbstractLayer {
    protected final IMap<IAgent, Rectangle2D> shapes = GamaMapFactory.createUnordered();
    protected static final Rectangle2D DUMMY_RECT = new Rectangle2D.Double();

    public AgentLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    protected void fillShapes(IScope iScope) {
        this.shapes.clear();
        Object object = ((AgentLayerStatement)this.definition).getAgentsExpr().value(iScope);
        Iterable<Object> iterable = Collections.EMPTY_LIST;
        if (object instanceof ISpecies) {
            iterable = ((ISpecies)object).iterable(iScope);
        } else if (object instanceof IList) {
            iterable = (IList)object;
        }
        for (IAgent iAgent : iterable) {
            this.shapes.put(iAgent, DUMMY_RECT);
        }
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
        if (iGraphicsScope == null || iGraphicsScope.interrupted()) {
            return;
        }
        this.fillShapes(iGraphicsScope);
        String string = ((AgentLayerStatement)this.definition).getAspectName();
        this.shapes.entrySet().forEach(entry -> {
            IAgent iAgent = (IAgent)entry.getKey();
            IExecutable iExecutable = null;
            if (iAgent != null) {
                ExecutionResult executionResult;
                Object object;
                if (iAgent == iGraphicsScope.getGui().getHighlightedAgent()) {
                    iExecutable = iAgent.getSpecies().getAspect("highlighted");
                } else {
                    iExecutable = ((AgentLayerStatement)this.definition).getAspect();
                    if (iExecutable == null) {
                        iExecutable = iAgent.getSpecies().getAspect(string);
                    }
                }
                if (iExecutable == null) {
                    iExecutable = AspectStatement.DEFAULT_ASPECT;
                }
                if ((object = (executionResult = iGraphicsScope.execute(iExecutable, iAgent, null)).getValue()) instanceof Rectangle2D) {
                    entry.setValue((Rectangle2D)object);
                }
            }
        });
    }

    @Override
    public IList<? extends IAgent> getAgentsForMenu(IScope iScope) {
        return GamaListFactory.wrap(Types.AGENT, this.shapes.keySet());
    }

    @Override
    public Set<IAgent> collectAgentsAt(int n, int n2, IDisplaySurface iDisplaySurface) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setFrameFromCenter(n, n2, (double)n + 2.5, (double)n2 + 2.5);
            this.shapes.forEachPair((iAgent, rectangle2D2) -> {
                if (rectangle2D2.intersects(double_)) {
                    asOrderedSet.add(iAgent);
                }
                return true;
            });
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Rectangle2D focusOn(IShape iShape, IDisplaySurface iDisplaySurface) {
        Rectangle2D rectangle2D;
        if (iShape instanceof IAgent && (rectangle2D = (Rectangle2D)this.shapes.get(iShape)) != null) {
            return rectangle2D;
        }
        return super.focusOn(iShape, iDisplaySurface);
    }

    @Override
    public String getType() {
        return "Agents layer";
    }
}

