/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer.")}), @GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="above", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Can be used to specify a 'minimal' value under which the render will not render the cells with this value")}), @GamlAnnotations.facet(name="no_data", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Can be used to specify a 'no_data' value, forcing the renderer to not render the cells with this value. If not specified, that value will be searched in the field to display")}), @GamlAnnotations.facet(name="scale", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Represents the z-scaling factor, which allows to scale all values of the field. ")}), @GamlAnnotations.facet(name="size", type={7, 2}, optional=true, doc={@GamlAnnotations.doc(value="Represents the extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions. This latter possibility allows to limit the height of the field. If only a flat value is provided, it is considered implicitly as the z maximal amplitude (or z scaling factor if < 1)")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="border", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the color to draw lines (borders of cells)")}), @GamlAnnotations.facet(name="wireframe", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true displays the field in wireframe using the lines color")}), @GamlAnnotations.facet(name="smooth", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="Applies a simple convolution (box filter) to smooth out the terrain produced by this field. If true, one pass is done with a simple 3x3 kernel. Otherwise, the user can specify the number of successive passes (up to 4). Specifying 0 is equivalent to passing false")}), @GamlAnnotations.facet(name="source", type={12, 8, 14}, optional=false, doc={@GamlAnnotations.doc(value="Allows to specify the elevation/value of each cell by passing a grid, a raster, image or csv file or directly a matrix of int/float. The dimensions of the field are those of the file or matrix.")}), @GamlAnnotations.facet(name="texture", type={12}, optional=true, doc={@GamlAnnotations.doc(value="A file  containing the texture image to be applied to the field. If not specified, the field will be displayed either in color or grayscale, depending on the other facets. Supersedes both `grayscale` and `color`")}), @GamlAnnotations.facet(name="grayscale", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true, paints each cell with a value of grey depending on its value. Supersedes 'color' if it is defined (it is actually equivalent to passing '#gray' to `color:`). False by default")}), @GamlAnnotations.facet(name="color", type={6, 5, 10}, optional=true, doc={@GamlAnnotations.doc(value="displays the field using the given color or colors. When a simple color is provided, paints each cell with this color, with a brightness depending on the value of the cell.When a list of colors is provided, they are used in a cyclic manner to color each cell, independently from their value. When this list is casted to a `palette` (using the corresponding operator), it is used to color each cell based on its value (with interpolation between the colors). When a `gradient` (see the corresponding operator) is passed, the interpolation between the two extreme colors is computed by GAMA.When a `scale` (see the corresponding operator) is passed, cells are colored depending on where their value fits in the scale, with no interpolation")}), @GamlAnnotations.facet(name="triangulation", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specifies wether the cells of th field will be triangulated: if it is false, they will be displayed as horizontal squares at a given elevation, whereas if it is true, cells will be triangulated and linked to neighbors in order to have a continuous surface (false by default)")}), @GamlAnnotations.facet(name="text", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specify whether the value that represents the elevation is displayed on each cell (false by default)")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the display of the species is refreshed. (true by default, but should be deactivated if the field is static)")})}, omissible="source")
@GamlAnnotations.doc(value="Allows the modeler to display in an optimized way a field of values, optionally using elevation. Useful for displaying DEMs, for instance, without having to load them into a grid. Can be fed with a matrix of int/float, a grid, a csv/raster/image file and supports many visualisation options", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   field a_filename lines: #black position: { 0.5, 0 } size: {0.5,0.5} triangulated: true texture: anothe_file;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "grid", "event", "graphics", "image", "overlay", "species_layer"})
public class MeshLayerStatement
extends AbstractLayerStatement {
    public MeshLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        this.setName(this.getFacet("source").literalValue());
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return ILayerStatement.LayerType.MESH;
    }

    @Override
    public boolean _step(IScope iScope) throws GamaRuntimeException {
        return true;
    }
}

