/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import com.google.common.base.Objects;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterables;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;

public class GamaListCollectionWrapper<E>
extends ForwardingCollection<E>
implements IList<E> {
    final Collection<E> wrapped;
    final IContainerType type;

    GamaListCollectionWrapper(Collection<E> collection, IType iType) {
        this.type = Types.LIST.of(iType);
        this.wrapped = collection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IList)) {
            return false;
        }
        return GamaListFactory.equals(this, (IList)object);
    }

    @Override
    public IContainerType<?> getGamlType() {
        return this.type;
    }

    protected Collection<E> delegate() {
        return this.wrapped;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).addAll(n, collection);
        }
        return this.addAll(collection);
    }

    @Override
    public E get(int n) {
        if (n > this.size() - 1) {
            return null;
        }
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).get(n);
        }
        return (E)Iterables.get(this.wrapped, (int)n);
    }

    @Override
    public E set(int n, E e) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).set(n, e);
        }
        E e2 = this.get(n);
        if (this.add(e)) {
            return e2;
        }
        return null;
    }

    @Override
    public void add(int n, E e) {
        if (this.wrapped instanceof List) {
            ((List)this.wrapped).add(n, e);
        } else {
            this.add(e);
        }
    }

    @Override
    public E remove(int n) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).remove(n);
        }
        E e = this.get(n);
        if (this.remove(e)) {
            return e;
        }
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return Iterables.indexOf(this.wrapped, object2 -> Objects.equal((Object)object, (Object)object2));
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).lastIndexOf(object);
        }
        return new ArrayList<E>(this.wrapped).lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).listIterator();
        }
        return new ArrayList<E>(this.wrapped).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).listIterator(n);
        }
        return new ArrayList<E>(this.wrapped).listIterator(n);
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (this.wrapped instanceof List) {
            return ((List)this.wrapped).subList(n, n2);
        }
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.wrapped.spliterator();
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }
}

