/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import one.util.streamex.StreamEx;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="dimension", type=7, doc={@GamlAnnotations.doc(value="Returns the dimension (columns x rows) of the receiver matrix")}), @GamlAnnotations.variable(name="rows", type=1, doc={@GamlAnnotations.doc(value="Returns the number of rows of the receiver matrix")}), @GamlAnnotations.variable(name="columns", type=1, doc={@GamlAnnotations.doc(value="Returns the number of columns of the receiver matrix")})})
public interface IMatrix<T>
extends IModifiableContainer<GamaPoint, T, GamaPoint, T>,
IAddressableContainer<GamaPoint, T, GamaPoint, T>,
IFieldMatrixProvider {
    public static final String DIMENSION = "dimension";
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";

    @Override
    @GamlAnnotations.getter(value="rows")
    public int getRows(IScope var1);

    @Override
    @GamlAnnotations.getter(value="columns")
    public int getCols(IScope var1);

    @Override
    default public double[] getBand(IScope iScope, int n) {
        if (n == 0) {
            return this.getFieldData(iScope);
        }
        return null;
    }

    @Override
    public double[] getFieldData(IScope var1);

    @GamlAnnotations.getter(value="dimension")
    public GamaPoint getDimensions();

    @GamlAnnotations.operator(value={"rows_list"}, can_be_const=true, content_type=5, content_type_content_type=-299, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="returns a list of the rows of the matrix, with each row as a list of elements", examples={@GamlAnnotations.example(value="rows_list(matrix([[\"el11\",\"el12\",\"el13\"],[\"el21\",\"el22\",\"el23\"],[\"el31\",\"el32\",\"el33\"]]))", equals="[[\"el11\",\"el21\",\"el31\"],[\"el12\",\"el22\",\"el32\"],[\"el13\",\"el23\",\"el33\"]]")}, see={"columns_list"})
    public IList<IList<T>> getRowsList();

    @GamlAnnotations.operator(value={"columns_list"}, can_be_const=true, content_type=5, content_type_content_type=-299, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="returns a list of the columns of the matrix, with each column as a list of elements", examples={@GamlAnnotations.example(value="columns_list(matrix([[\"el11\",\"el12\",\"el13\"],[\"el21\",\"el22\",\"el23\"],[\"el31\",\"el32\",\"el33\"]]))", equals="[[\"el11\",\"el12\",\"el13\"],[\"el21\",\"el22\",\"el23\"],[\"el31\",\"el32\",\"el33\"]]")}, see={"rows_list"})
    public IList<IList<T>> getColumnsList();

    @GamlAnnotations.operator(value={"row_at"}, content_type=-299, can_be_const=true, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="returns the row at a num_line (right-hand operand)", examples={@GamlAnnotations.example(value="matrix([[\"el11\",\"el12\",\"el13\"],[\"el21\",\"el22\",\"el23\"],[\"el31\",\"el32\",\"el33\"]]) row_at 2", equals="[\"el13\",\"el23\",\"el33\"]")}, see={"column_at", "columns_list"})
    public IList<T> getRow(Integer var1);

    @GamlAnnotations.operator(value={"column_at"}, content_type=-299, can_be_const=true, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="returns the column at a num_col (right-hand operand)", examples={@GamlAnnotations.example(value="matrix([[\"el11\",\"el12\",\"el13\"],[\"el21\",\"el22\",\"el23\"],[\"el31\",\"el32\",\"el33\"]]) column_at 2", equals="[\"el31\",\"el32\",\"el33\"]")}, see={"row_at", "rows_list"})
    public IList<T> getColumn(Integer var1);

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(value="Returns a matrix containing the addition of  the elements of two matrices in argument ")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) + matrix([[1,2],[3,4]]) = matrix([[2,4],[6,8]])")
    public IMatrix plus(IScope var1, IMatrix var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(value="Multiplies the two matrices operands")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) * matrix([[1,2],[3,4]]) = matrix([[1,4],[9,16]]) ")
    public IMatrix times(IScope var1, IMatrix var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(value="Divides the two matrices operands")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) / matrix([[1,2],[3,4]]) = matrix([[1,1],[1,1]])")
    public IMatrix divides(IScope var1, IMatrix var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Performs a subtraction between the two matrix operands")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) - matrix([[1,2],[3,4]]) = matrix([[0,0],[0,0]])")
    public IMatrix minus(IScope var1, IMatrix var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Performs a multiplication between the matrix operand and the float operand")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) * 2.5 = matrix([[2.5,5.0],[7.5,10]])")
    public IMatrix times(Double var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(value="Performs a multiplication between the two matrix operands")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) * 2 = matrix([[2,4],[6,8]])")
    public IMatrix times(Integer var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Divides all the elements of the matrix operand by the float operand")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) / 2.5 = matrix([[0.4,0.8],[1.2,1.6]])")
    public IMatrix divides(Double var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"/"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Divides all the elements of the matrix operand by the integer operand")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) / 2 = matrix([[0.5,1],[1.5,2]])")
    public IMatrix divides(Integer var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Adds the float operand to all the elements in the matrix")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) + 22.5 = matrix([[23.5,24.5],[25.5,26.5]])")
    public IMatrix plus(Double var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Adds the int operand to all the elements in the matrix")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) + 2 = matrix([[3,4],[5,6]])")
    public IMatrix plus(Integer var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Subtracts the float operand from all the elements in the matrix")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) - 1.5 = matrix([[-0.5,0.5],[1.5,2.5]])")
    public IMatrix minus(Double var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(value="Subtracts the int operand from all the elements in the matrix")})
    @GamlAnnotations.test(value="matrix([[1,2],[3,4]]) - 1 = matrix([[0,1],[2,3]])")
    public IMatrix minus(Integer var1) throws GamaRuntimeException;

    public T get(IScope var1, int var2, int var3);

    public void set(IScope var1, int var2, int var3, Object var4) throws GamaRuntimeException;

    @Override
    public StreamEx<T> stream(IScope var1);

    @Override
    default public boolean containsKey(IScope iScope, Object object) {
        if (object instanceof GamaPoint) {
            GamaPoint gamaPoint = (GamaPoint)object;
            return gamaPoint.x >= 0.0 && gamaPoint.y >= 0.0 && gamaPoint.x < (double)this.getCols(iScope) && gamaPoint.y < (double)this.getRows(iScope);
        }
        return false;
    }

    public Object remove(IScope var1, int var2, int var3) throws GamaRuntimeException;

    public void shuffleWith(RandomUtils var1);

    @Override
    public IMatrix copy(IScope var1) throws GamaRuntimeException;

    public IMatrix copy(IScope var1, GamaPoint var2, boolean var3);

    public IMatrix<T> reverse(IScope var1) throws GamaRuntimeException;

    @Override
    default public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "cols", this.getCols(null), ROWS, this.getRows(null), "contents", this.listValue(null, this.getGamlType().getContentType(), false));
    }
}

