/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gama.dev.DEBUG;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import one.util.streamex.IntStreamEx;
import org.eclipse.emf.ecore.EObject;

public class ConstantExpressionDescription
extends ConstantExpression
implements IExpressionDescription {
    static final int MIN_INT = -1000;
    static final int MAX_INT = 1000;
    static final ConstantExpressionDescription[] INT_DESCRIPTIONS;
    static final Cache<Object, ConstantExpressionDescription> CACHE;
    public static final ConstantExpressionDescription NULL_EXPR_DESCRIPTION;
    public static final ConstantExpressionDescription TRUE_EXPR_DESCRIPTION;
    public static final ConstantExpressionDescription FALSE_EXPR_DESCRIPTION;

    static {
        DEBUG.OFF();
        INT_DESCRIPTIONS = (ConstantExpressionDescription[])IntStreamEx.range((int)-1000, (int)1000).mapToObj(n -> new ConstantExpressionDescription(n, Types.INT)).toArray(ConstantExpressionDescription.class);
        CACHE = CacheBuilder.newBuilder().maximumSize(5000L).build();
        NULL_EXPR_DESCRIPTION = new ConstantExpressionDescription(null);
        TRUE_EXPR_DESCRIPTION = new ConstantExpressionDescription(true);
        FALSE_EXPR_DESCRIPTION = new ConstantExpressionDescription(false);
    }

    public static ConstantExpressionDescription create(Object object) {
        if (object == null) {
            return NULL_EXPR_DESCRIPTION;
        }
        try {
            return (ConstantExpressionDescription)CACHE.get(object, () -> new ConstantExpressionDescription(object));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static ConstantExpressionDescription createNoCache(Object object) {
        if (object == null) {
            return NULL_EXPR_DESCRIPTION;
        }
        return new ConstantExpressionDescription(object);
    }

    public static ConstantExpressionDescription create(Integer n) {
        if (n >= -1000 && n < 1000) {
            return INT_DESCRIPTIONS[n - -1000];
        }
        try {
            return (ConstantExpressionDescription)CACHE.get((Object)n, () -> new ConstantExpressionDescription(n, Types.INT));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static ConstantExpressionDescription create(Double d) {
        try {
            return (ConstantExpressionDescription)CACHE.get((Object)d, () -> new ConstantExpressionDescription(d, Types.FLOAT));
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    public static ConstantExpressionDescription create(Boolean bl) {
        return bl != false ? TRUE_EXPR_DESCRIPTION : FALSE_EXPR_DESCRIPTION;
    }

    private ConstantExpressionDescription(Object object) {
        this(object, GamaType.of(object));
    }

    private ConstantExpressionDescription(Object object, IType<?> iType) {
        super(object, iType);
    }

    @Override
    public boolean isConst() {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IExpression compile(IDescription iDescription) {
        return this;
    }

    @Override
    public void setExpression(IExpression iExpression) {
    }

    @Override
    public IExpressionDescription cleanCopy() {
        return this;
    }

    @Override
    public IType<?> getDenotedType(IDescription iDescription) {
        return iDescription.getTypeNamed(this.literalValue());
    }

    @Override
    public IExpression getExpression() {
        return this;
    }

    @Override
    public IExpressionDescription compileAsLabel() {
        return LabelExpressionDescription.create(this.literalValue());
    }

    @Override
    public boolean equalsString(String string) {
        return this.literalValue().equals(string);
    }

    @Override
    public EObject getTarget() {
        return null;
    }

    @Override
    public void setTarget(EObject eObject) {
    }

    public Set<String> getStrings(IDescription iDescription, boolean bl) {
        return Collections.EMPTY_SET;
    }

    @Override
    public IType<?> getGamlType() {
        return this.type;
    }
}

